unit UninstProgressDlg;

{
  Inno Setup
  Copyright (C) 1998-2000 Jordan Russell
  For conditions of distribution and use, see LICENSE.TXT.

  Uninstaller's progress window
}

interface

uses
  Windows;

procedure CreateUninstProgressDlg (const Title, AppName: String);
procedure UpdateProgressDlg (Progress, Range: Integer);

var
  ProgressDlg: HWND;
  ProgressDlgUpdateTimerExpired: Boolean;
  ProgressDlgCloseTimerExpired: Boolean;

implementation

{$R *.RES}

uses
  Messages, CommCtrl, SysUtils, Msgs, MsgIDs, WinDlgs;

const
  IDC_BODYLABEL                 = 1000;
  IDC_PROGRESS                  = 1001;

var
  LastRange: Integer;

type
  PDlgData = ^TDlgData;
  TDlgData = record
    Title, AppName: String;
  end;

function DialogProc (hwndDlg: HWND; uMsg: UINT; wParam: WPARAM; lParam: LPARAM): BOOL;
stdcall;
begin
  Result := False;
  case uMsg of
    WM_INITDIALOG: begin
        if Lo(GetVersion) < 4 then
          { NT 3.x doesn't recognize the DS_CENTER dialog style }
          CenterWnd (hwndDlg);
        SetWindowText (hwndDlg, PChar(PDlgData(lParam).Title));
        SetDlgItemText (hwndDlg, IDC_BODYLABEL,
          PChar(FmtSetupMessage(msgUninstallStatusLabel, [PDlgData(lParam).AppName])));
        { Kill the close button }
        DeleteMenu (GetSystemMenu(hwndDlg, False), SC_CLOSE, MF_BYCOMMAND);
        SetTimer (hwndDlg, 98, 125, nil);
        SetTimer (hwndDlg, 99, 1000, nil);
        Result := True;
      end;
    WM_QUERYENDSESSION: begin
        { Prevent the user from logging off or shutting down during uninstallation }
        SetWindowLong (hwndDlg, DWL_MSGRESULT, 0);  { return 'False' }
        Result := True;
      end;
    WM_TIMER: begin
        case wParam of
          98: ProgressDlgUpdateTimerExpired := True;
          99: begin
                KillTimer (hwndDlg, 99);
                ProgressDlgCloseTimerExpired := True;
              end;
        end;
      end;
  end;
end;

procedure CreateUninstProgressDlg (const Title, AppName: String);
var
  Data: TDlgData;
begin
  LastRange := -1;
  ProgressDlgUpdateTimerExpired := False;
  ProgressDlgCloseTimerExpired := False;

  InitCommonControls;  { the dialog contains a progress bar control }
  Data.Title := Title;
  Data.AppName := AppName;
  ProgressDlg := CreateDialogWithFont(HInstance, 'UNINSTPROGRESSDLG', 0,
    @DialogProc, LPARAM(@Data));
  ShowWindow (ProgressDlg, SW_SHOW);
end;

procedure UpdateProgressDlg (Progress, Range: Integer);
begin
  if Range <> LastRange then begin
    SendDlgItemMessage (ProgressDlg, IDC_PROGRESS, PBM_SETRANGE, 0,
      MAKELPARAM(0, Range));
    LastRange := Range;
  end;
  SendDlgItemMessage (ProgressDlg, IDC_PROGRESS, PBM_SETPOS, Progress, 0);
end;

end.
