unit WinDlgs;

{
  Inno Setup
  Copyright (C) 1998-2000 Jordan Russell
  For conditions of distribution and use, see LICENSE.TXT.

  Functions used by non-VCL dialogs
}

interface

uses
  Windows;

procedure CenterWnd (const Wnd: HWND);
function CreateDialogWithFont (hInstance: HINST; lpTemplateName: PChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND;
function DialogBoxWithFont (hInstance: HINST; lpTemplateName: PChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer;

implementation

uses
  Msgs, MsgIDs;

procedure CenterWnd (const Wnd: HWND);
var
  R: TRect;
  SW, SH, W, H: Integer;
begin
  SW := GetSystemMetrics(SM_CXSCREEN);
  SH := GetSystemMetrics(SM_CYSCREEN);
  GetWindowRect (Wnd, R);
  W := R.Right - R.Left;
  H := R.Bottom - R.Top;
  R.Left := (SW - W) div 2;
  if R.Left < 0 then R.Left := 0;
  R.Top := (SH - H) div 2;
  if R.Top < 0 then R.Top := 0;
  MoveWindow (Wnd, R.Left, R.Top, W, H, True);
end;

type
  TDialogParamFunc = function(hInstance: HINST; const lpTemplate: TDlgTemplate;
    hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer;
    stdcall;

function InternalDialogWithFont (hInstance: HINST; lpTemplateName: PChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM;
  Func: TDialogParamFunc): HWND;
var
  FontName: String;
  FontSize: Integer;
  ResInfo: HRSRC;
  ResData: HGLOBAL;
  Size: DWORD;
  PR: Pointer;
  P, P2, P3: Pointer;
  I, Offset, OldLength, NewLength: Integer;
  NewFontName: array[0..LF_FACESIZE-1] of WideChar;
begin
  Result := 0;
  FontName := 'MS Sans Serif';
  FontSize := 8;
  ExtractFontNameSize (SetupMessages[msg_DialogFont], FontName, FontSize);
  { Copy FontName to a wide character array, and null-terminate it }
  NewFontName[MultiByteToWideChar(CP_ACP, 0, PChar(FontName), Length(FontName),
    NewFontName, (SizeOf(NewFontName)-1) div SizeOf(WideChar))] := #0;
  ResInfo := FindResource(hInstance, lpTemplateName, RT_DIALOG);
  if ResInfo = 0 then
    Exit;
  Size := SizeofResource(hInstance, ResInfo);
  GetMem (P, Size + (LF_FACESIZE * SizeOf(WideChar)));
  try
    ResData := LoadResource(hInstance, ResInfo);
    if ResData = 0 then
      Exit;
    PR := LockResource(ResData);
    if PR = nil then
      Exit;
    Move (PR^, P^, Size);
    P2 := P;
    if PDlgTemplate(P2).style and DS_SETFONT <> 0 then begin
      Inc (Cardinal(P2), SizeOf(TDlgTemplate));
      { Skip past variable-length character arrays for menu name, class name, title }
      for I := 0 to 2 do
        Inc (Cardinal(P2), (lstrlenW(P2) + 1) * SizeOf(WideChar));
      { Set font size }
      Word(P2^) := FontSize;
      Inc (Cardinal(P2), SizeOf(Word));
      { Set font name }
      OldLength := lstrlenW(P2);
      NewLength := lstrlenW(NewFontName);
      Offset := NewLength - OldLength;
      if Offset <> 0 then begin
        { Shift the stuff after the font name if the length of the font name is
          changing }
        if Odd(Offset) then begin  { must keep it on a DWORD boundary }
          if Offset < 0 then
            Dec (Offset)
          else
            Inc (Offset);
        end;
        Cardinal(P3) := Cardinal(P2) + (Cardinal(OldLength) * SizeOf(WideChar));
        { ^ start Moving at the null terminator at the end of the current font name }
        Move (P3^, Pointer(Cardinal(P3) + (Cardinal(Offset) * SizeOf(WideChar)))^,
          Size - (Cardinal(P3) - Cardinal(P)));
      end;
      Move (NewFontName, P2^, (NewLength + 1) * SizeOf(WideChar));
    end;
    Result := Func(hInstance, PDlgTemplate(P)^, hWndParent, lpDialogFunc, dwInitParam);
  finally
    FreeMem (P);
  end;
end;

function CreateDialogWithFont (hInstance: HINST; lpTemplateName: PChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): HWND;
begin
  Integer(Result) := InternalDialogWithFont(hInstance, lpTemplateName,
    hWndParent, lpDialogFunc, dwInitParam, @CreateDialogIndirectParam);
end;

function DialogBoxWithFont (hInstance: HINST; lpTemplateName: PChar;
  hWndParent: HWND; lpDialogFunc: TFNDlgProc; dwInitParam: LPARAM): Integer;
begin
  Result := InternalDialogWithFont(hInstance, lpTemplateName,
    hWndParent, lpDialogFunc, dwInitParam, DialogBoxIndirectParam);
end;

end.
