/*
 * Decompiled with CFR 0.152.
 */
package test.sig.dss;

import gnu.crypto.sig.dss.DSSKeyPairGenerator;
import gnu.crypto.sig.dss.DSSKeyPairRawCodec;
import gnu.crypto.sig.dss.DSSPrivateKey;
import gnu.crypto.sig.dss.DSSPublicKey;
import gnu.crypto.sig.dss.DSSSignature;
import gnu.crypto.sig.dss.DSSSignatureRawCodec;
import java.lang.constant.Constable;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfDSSCodec
extends TestCase {
    private DSSKeyPairGenerator kpg = new DSSKeyPairGenerator();
    private KeyPair kp;
    static /* synthetic */ Class class$test$sig$dss$TestOfDSSCodec;

    public TestOfDSSCodec(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfDSSCodec.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$sig$dss$TestOfDSSCodec == null ? (class$test$sig$dss$TestOfDSSCodec = TestOfDSSCodec.class$("test.sig.dss.TestOfDSSCodec")) : class$test$sig$dss$TestOfDSSCodec);
    }

    public void testKeyPairRawCodec() {
        byte[] pk1;
        DSAPublicKey pubK = (DSAPublicKey)this.kp.getPublic();
        DSAPrivateKey secK = (DSAPrivateKey)this.kp.getPrivate();
        try {
            pk1 = ((DSSPublicKey)pubK).getEncoded(0);
            Assert.fail((String)"Succeeded with unknown format ID");
        }
        catch (IllegalArgumentException x) {
            Assert.assertTrue((String)"Recognised unknown format ID", (boolean)true);
        }
        pk1 = ((DSSPublicKey)pubK).getEncoded(1);
        byte[] pk2 = ((DSSPrivateKey)secK).getEncoded(1);
        DSSKeyPairRawCodec codec = new DSSKeyPairRawCodec();
        PublicKey newPubK = codec.decodePublicKey(pk1);
        PrivateKey newSecK = codec.decodePrivateKey(pk2);
        Assert.assertTrue((String)"DSS public key Raw encoder/decoder test", (boolean)pubK.equals(newPubK));
        Assert.assertTrue((String)"DSS private key Raw encoder/decoder test", (boolean)secK.equals(newSecK));
    }

    public void testSignatureRawCodec() {
        DSAPublicKey publicK = (DSAPublicKey)this.kp.getPublic();
        DSAPrivateKey privateK = (DSAPrivateKey)this.kp.getPrivate();
        DSSSignature alice = new DSSSignature();
        DSSSignature bob = (DSSSignature)alice.clone();
        byte[] message = "1 if by land, 2 if by sea...".getBytes();
        HashMap<String, DSAKey> map = new HashMap<String, DSAKey>();
        map.put("gnu.crypto.sig.private.key", privateK);
        alice.setupSign(map);
        alice.update(message, 0, message.length);
        Object signature = alice.sign();
        DSSSignatureRawCodec codec = new DSSSignatureRawCodec();
        byte[] encodedSignature = codec.encodeSignature(signature);
        Object decodedSignature = codec.decodeSignature(encodedSignature);
        map.put("gnu.crypto.sig.public.key", publicK);
        bob.setupVerify(map);
        bob.update(message, 0, message.length);
        Assert.assertTrue((String)"Signature Raw encoder/decoder test", (boolean)bob.verify(decodedSignature));
    }

    protected void setUp() {
        HashMap<String, Constable> map = new HashMap<String, Constable>();
        map.put("gnu.crypto.dss.L", new Integer(512));
        map.put("gnu.crypto.dss.use.defaults", new Boolean(false));
        this.kpg.setup(map);
        this.kp = this.kpg.generate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

