/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.dss;

import gnu.crypto.sig.dss.DSSKey;
import gnu.crypto.sig.dss.DSSKeyPairRawCodec;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;

public class DSSPublicKey
extends DSSKey
implements PublicKey,
DSAPublicKey {
    private final BigInteger y;

    public DSSPublicKey(BigInteger p, BigInteger q, BigInteger g, BigInteger y) {
        super(p, q, g);
        this.y = y;
    }

    public static DSSPublicKey valueOf(byte[] k) {
        if (k[0] == 71 && k[1] == 83 && k[2] == 68 && k[3] == 66) {
            DSSKeyPairRawCodec codec = new DSSKeyPairRawCodec();
            return (DSSPublicKey)codec.decodePublicKey(k);
        }
        throw new IllegalArgumentException("magic");
    }

    public BigInteger getY() {
        return this.y;
    }

    public byte[] getEncoded() {
        return this.getEncoded(1);
    }

    public byte[] getEncoded(int format) {
        byte[] result;
        switch (format) {
            case 1: {
                result = new DSSKeyPairRawCodec().encodePublicKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("format");
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DSAPublicKey)) {
            return false;
        }
        DSAPublicKey that = (DSAPublicKey)obj;
        return super.equals(that) && this.y.equals(that.getY());
    }
}

