/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.tool;

import gnu.crypto.cipher.CipherFactory;
import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.util.Util;
import java.security.InvalidKeyException;
import java.util.HashMap;

public class NessieCipherTVEmitter {
    private NessieCipherTVEmitter() {
    }

    public static final void main(String[] args) {
        try {
            IBlockCipher cipher = CipherFactory.getInstance(args[0]);
            int keySize = cipher.defaultKeySize() * 8;
            if (args.length > 1) {
                keySize = Integer.parseInt(args[1]);
            }
            long time = -System.currentTimeMillis();
            NessieCipherTVEmitter.set1(cipher, keySize);
            NessieCipherTVEmitter.set2(cipher, keySize);
            NessieCipherTVEmitter.set3(cipher, keySize);
            NessieCipherTVEmitter.set4(cipher, keySize);
            System.out.println();
            System.out.println("End of test vectors");
            System.out.println();
            System.out.println("*** Tests lasted " + (time += System.currentTimeMillis()) + " ms...");
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
        }
    }

    private static void set1(IBlockCipher cipher, int keySize) throws InvalidKeyException {
        int kl = keySize / 8;
        int bl = cipher.defaultBlockSize();
        byte[] k = new byte[kl];
        byte[] p = new byte[bl];
        byte[] c = new byte[bl];
        byte[] d = new byte[bl];
        System.out.println("Test vectors -- set 1");
        System.out.println("=====================");
        System.out.println();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        int i = 0;
        while (i < keySize) {
            String s = "   " + String.valueOf(i);
            s = s.substring(s.length() - 3);
            System.out.println("Set 1, vector#" + s + ":");
            int b = i / 8;
            int bit = i % 8;
            k[b] = (byte)(128 >>> bit);
            System.out.println("                      key=" + Util.toString(k));
            map.put("gnu.crypto.cipher.key.material", k);
            cipher.init(map);
            System.out.println("                    plain=" + Util.toString(p));
            cipher.encryptBlock(p, 0, c, 0);
            System.out.println("                   cipher=" + Util.toString(c));
            cipher.decryptBlock(c, 0, d, 0);
            System.out.println("                decrypted=" + Util.toString(d));
            if (!Util.areEqual(p, d)) {
                throw new RuntimeException("Symmetric operation failure...");
            }
            int j = 1;
            while (j < 100) {
                cipher.encryptBlock(c, 0, c, 0);
                ++j;
            }
            System.out.println("       Iterated 100 times=" + Util.toString(c));
            j = 100;
            while (j < 1000) {
                cipher.encryptBlock(c, 0, c, 0);
                ++j;
            }
            System.out.println("      Iterated 1000 times=" + Util.toString(c));
            System.out.println();
            k[b] = 0;
            cipher.reset();
            ++i;
        }
    }

    private static void set2(IBlockCipher cipher, int keySize) throws InvalidKeyException {
        int kl = keySize / 8;
        int bl = cipher.defaultBlockSize();
        byte[] k = new byte[kl];
        byte[] p = new byte[bl];
        byte[] c = new byte[bl];
        byte[] d = new byte[bl];
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("gnu.crypto.cipher.key.material", k);
        cipher.init(map);
        System.out.println("Test vectors -- set 2");
        System.out.println("=====================");
        System.out.println();
        int i = 0;
        while (i < 8 * bl) {
            String s = "   " + String.valueOf(i);
            s = s.substring(s.length() - 3);
            System.out.println("Set 2, vector#" + s + ":");
            System.out.println("                      key=" + Util.toString(k));
            int b = i / 8;
            int bit = i % 8;
            p[b] = (byte)(128 >>> bit);
            System.out.println("                    plain=" + Util.toString(p));
            cipher.encryptBlock(p, 0, c, 0);
            System.out.println("                   cipher=" + Util.toString(c));
            cipher.decryptBlock(c, 0, d, 0);
            System.out.println("                decrypted=" + Util.toString(d));
            if (!Util.areEqual(p, d)) {
                throw new RuntimeException("Symmetric operation failure...");
            }
            int j = 1;
            while (j < 100) {
                cipher.encryptBlock(c, 0, c, 0);
                ++j;
            }
            System.out.println("       Iterated 100 times=" + Util.toString(c));
            j = 100;
            while (j < 1000) {
                cipher.encryptBlock(c, 0, c, 0);
                ++j;
            }
            System.out.println("      Iterated 1000 times=" + Util.toString(c));
            System.out.println();
            p[b] = 0;
            ++i;
        }
    }

    private static void set3(IBlockCipher cipher, int keySize) throws InvalidKeyException {
        int kl = keySize / 8;
        int bl = cipher.defaultBlockSize();
        byte[] k = new byte[kl];
        byte[] p = new byte[bl];
        byte[] c = new byte[bl];
        byte[] d = new byte[bl];
        System.out.println("Test vectors -- set 3");
        System.out.println("=====================");
        System.out.println();
        cipher.reset();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        int i = 0;
        while (i < 256) {
            String s = "   " + String.valueOf(i);
            s = s.substring(s.length() - 3);
            System.out.println("Set 3, vector#" + s + ":");
            int j = 0;
            while (j < bl) {
                k[j] = (byte)i;
                p[j] = (byte)i;
                ++j;
            }
            while (j < kl) {
                k[j] = (byte)i;
                ++j;
            }
            map.put("gnu.crypto.cipher.key.material", k);
            cipher.init(map);
            System.out.println("                      key=" + Util.toString(k));
            System.out.println("                    plain=" + Util.toString(p));
            cipher.encryptBlock(p, 0, c, 0);
            System.out.println("                   cipher=" + Util.toString(c));
            cipher.decryptBlock(c, 0, d, 0);
            System.out.println("                decrypted=" + Util.toString(d));
            if (!Util.areEqual(p, d)) {
                throw new RuntimeException("Symmetric operation failure...");
            }
            j = 1;
            while (j < 100) {
                cipher.encryptBlock(c, 0, c, 0);
                ++j;
            }
            System.out.println("       Iterated 100 times=" + Util.toString(c));
            j = 100;
            while (j < 1000) {
                cipher.encryptBlock(c, 0, c, 0);
                ++j;
            }
            System.out.println("      Iterated 1000 times=" + Util.toString(c));
            System.out.println();
            cipher.reset();
            ++i;
        }
    }

    private static void set4(IBlockCipher cipher, int keySize) throws InvalidKeyException {
        String dummy = System.getProperty("TORTURE");
        if (dummy == null) {
            return;
        }
        int kl = keySize / 8;
        int bl = cipher.defaultBlockSize();
        byte[] k = new byte[kl];
        byte[] p = new byte[bl];
        System.out.println("Test vectors -- set 4");
        System.out.println("=====================");
        System.out.println();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        int i = 0;
        while (i < 4) {
            System.out.println("Set 4, vector#  " + String.valueOf(i) + ":");
            int j = 0;
            while (j < bl) {
                k[j] = (byte)i;
                p[j] = (byte)i;
                ++j;
            }
            while (j < kl) {
                k[j] = (byte)i;
                ++j;
            }
            System.out.println("                      key=" + Util.toString(k));
            System.out.println("                    plain=" + Util.toString(p));
            int x = i;
            j = 0;
            while (j < 100000000) {
                int t = 0;
                while (t < kl) {
                    k[t] = (byte)x;
                    ++t;
                }
                map.put("gnu.crypto.cipher.key.material", k);
                cipher.init(map);
                cipher.encryptBlock(p, 0, p, 0);
                cipher.reset();
                x = p[bl - 1] & 0xFF;
                ++j;
            }
            System.out.println("      Iterated 10^8 times=" + Util.toString(p));
            System.out.println();
            ++i;
        }
    }
}

