/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.sig.rsa;

import gnu.crypto.sig.rsa.RSAKeyPairGenerator;
import gnu.crypto.sig.rsa.RSAPSSSignature;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.security.Key;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;

public class TestOfRSAPSSSignature
implements Testlet {
    private RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
    private RSAPublicKey publicK;
    private RSAPrivateKey privateK;
    private RSAPSSSignature alice;
    private RSAPSSSignature bob;
    private byte[] message;

    public void test(TestHarness harness) {
        this.testSigWithDefaults(harness);
        this.testSigWithShaSalt16(harness);
        this.testSigWithRipeMD160Salt8(harness);
    }

    public void testSigWithDefaults(TestHarness harness) {
        harness.checkPoint("TestOfRSAPSSSignature.testSigWithDefaults");
        try {
            this.setUp();
            this.alice = new RSAPSSSignature();
            this.bob = (RSAPSSSignature)this.alice.clone();
            this.message = "1 if by land, 2 if by sea...".getBytes();
            HashMap<String, Key> map = new HashMap<String, Key>();
            map.put("gnu.crypto.sig.private.key", this.privateK);
            this.alice.setupSign(map);
            this.alice.update(this.message, 0, this.message.length);
            Object signature = this.alice.sign();
            map.put("gnu.crypto.sig.public.key", this.publicK);
            this.bob.setupVerify(map);
            this.bob.update(this.message, 0, this.message.length);
            harness.check(this.bob.verify(signature));
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRSAPSSSignature.testSigWithDefaults");
        }
    }

    public void testSigWithShaSalt16(TestHarness harness) {
        harness.checkPoint("TestOfRSAPSSSignature.testSigWithShaSalt16");
        try {
            this.setUp();
            this.alice = new RSAPSSSignature("sha1", 16);
            this.bob = (RSAPSSSignature)this.alice.clone();
            this.message = "Que du magnifique...".getBytes();
            HashMap<String, Key> map = new HashMap<String, Key>();
            map.put("gnu.crypto.sig.private.key", this.privateK);
            this.alice.setupSign(map);
            this.alice.update(this.message, 0, this.message.length);
            Object signature = this.alice.sign();
            map.put("gnu.crypto.sig.public.key", this.publicK);
            this.bob.setupVerify(map);
            this.bob.update(this.message, 0, this.message.length);
            harness.check(this.bob.verify(signature));
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRSAPSSSignature.testSigWithShaSalt16");
        }
    }

    public void testSigWithRipeMD160Salt8(TestHarness harness) {
        harness.checkPoint("TestOfRSAPSSSignature.testSigWithRipeMD160Salt8");
        try {
            this.setUp();
            this.alice = new RSAPSSSignature("ripemd160", 8);
            this.bob = (RSAPSSSignature)this.alice.clone();
            this.message = "abcdefghijklmnopqrstuvwxyz0123456789".getBytes();
            HashMap<String, Key> map = new HashMap<String, Key>();
            map.put("gnu.crypto.sig.private.key", this.privateK);
            this.alice.setupSign(map);
            this.alice.update(this.message, 0, this.message.length);
            Object signature = this.alice.sign();
            map.put("gnu.crypto.sig.public.key", this.publicK);
            this.bob.setupVerify(map);
            this.bob.update(this.message, 0, this.message.length);
            harness.check(this.bob.verify(signature));
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRSAPSSSignature.testSigWithRipeMD160Salt8");
        }
    }

    private void setUp() {
        this.kpg.setup(new HashMap());
        KeyPair kp = this.kpg.generate();
        this.publicK = (RSAPublicKey)kp.getPublic();
        this.privateK = (RSAPrivateKey)kp.getPrivate();
    }
}

