/* wptProgressDlg.cpp - Support for the GPG progress status
 *	Copyright (C) 2003, 2004, 2005 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <commctrl.h>

#include "../resource.h"
#include "wptGPG.h"
#include "wptTypes.h"
#include "wptCommonCtl.h"
#include "wptW32API.h"
#include "wptContext.h"
#include "wptVersion.h"

static HWND progress_dlg = NULL;

static BOOL CALLBACK
progress_dlg_proc (HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam)
{
    static progress_filter_s * pfx = NULL;

    switch (msg) {
    case WM_INITDIALOG:
	pfx = (struct progress_filter_s *)lparam;
	if (!pfx)
	    BUG (0);
	progress_dlg = dlg;
	pfx->dlg = dlg;
	SendDlgItemMessage (dlg, IDC_PROGRESS_BAR, PBM_SETRANGE, 0, MAKELPARAM (0, 100));
	SetDlgItemInt (pfx->dlg, IDC_PROGRESS_TOTAL, pfx->total, FALSE);
	SetDlgItemInt (pfx->dlg, IDC_PROGRESS_CURR, pfx->curr, FALSE);
	SetDlgItemText (pfx->dlg, IDC_PROGRESS_WHAT, pfx->what);
	center_window2 (dlg, HWND_TOPMOST);
	center_window (dlg);
	SetForegroundWindow (dlg);
	return TRUE;
    }
    return FALSE;
} /* progress_dlg_proc */


static DWORD WINAPI 
progress_cb_thread (void * opaque)
{
    struct progress_filter_s * pfx = (struct progress_filter_s *)opaque;

    DialogBoxParam (glob_hinst, (LPCTSTR)IDD_WINPT_PROGRESS, 
		    opaque? pfx->hwnd : GetActiveWindow (),
		    progress_dlg_proc, (LPARAM)opaque);
    return TRUE;
} /* progress_cb_thread */


void
progress_cleanup (progress_filter_s * pfx)
{
    EndDialog (progress_dlg, TRUE);
    if (!pfx)
	return;
    if (pfx->dlg) {
	EndDialog (pfx->dlg, TRUE); 
	pfx->dlg = NULL;
    }
    if (pfx->thread_hd) {
	CloseHandle (pfx->thread_hd); 
	pfx->thread_hd = NULL;
    }
    pfx->curr = 0;
    pfx->total = 0;
    pfx->error = 0;
    memset (pfx, 0, sizeof *pfx); /*XXX: does this really work? */
}


void
progress_callback (void * opaque, const char * what, int type, unsigned off, unsigned max)
{
    struct progress_filter_s * pfx = (struct progress_filter_s *)opaque;
    DWORD tid;

    if (!pfx || pfx->error)
	return;
    pfx->curr = off;
    pfx->total = max;
    pfx->what = what;
    if (!off && !pfx->thread_hd) {
	pfx->thread_hd = CreateThread (NULL, 0, progress_cb_thread, (void *)pfx, 0, &tid);
	if (!pfx->thread_hd) {
	    msg_box (NULL, _("Could not create progress thread."), _("WinPT"), MB_ERR);
	    pfx->error = 1;
	    return;
	}
    }
    else if (pfx->dlg) {
	size_t n = pfx->curr * 100 / pfx->total;
	SendDlgItemMessage (pfx->dlg, IDC_PROGRESS_BAR, PBM_SETPOS, (WPARAM)n, 0);
	SetDlgItemInt (pfx->dlg, IDC_PROGRESS_CURR, pfx->curr, FALSE);
    }
    if (off >= max)
	progress_cleanup (pfx);
} /* progress_callback */
