---
title: Огляд коду
x-toc-enable: true
...

If you wish to submit patches, you can. Submit them, using the instructions
provided in the following sections:

репозиторії Canoeboot
===================

Інформацію про те, хто працює над canoeboot і хто керує проектом, можна
знайти на [who.uk.md](who.uk.md)

Проект `canoeboot` має 3 основні сховища Git:

* Система побудови: <https://codeberg.org/canoeboot/cbmk>
* Веб-сайт (+документація): <https://codeberg.org/canoeboot/cbwww>
* Зображення (для веб-сайта): <https://codeberg.org/canoeboot/cbwww-img>

Розробка canoeboot виконується за допомогою системи контролю версій Git.
Зверніться до [офіційної документації Git](https://git-scm.com/doc), якщо ви не
знаєте, як користуватися Git.

cbmk (canoeboot-make)
---------------------

Це основна система збирання в canoeboot. Можна сказати, що `cbmk` *це*
canoeboot! Завантажте репозиторій Git:

	git clone https://codeberg.org/canoeboot/cbmk

Команда `git`, показана вище, завантажить систему збірки canoeboot `cbmk`.
Потім ви можете перейти до цього так:

	cd cbmk

Внесіть будь-які зміни, які забажаєте, або просто побудуйте. Щоб отримати вказівки щодо
збирання `cbmk`, зверніться до [інструкцій зі збирання](docs/build/index.uk.md).

Інформація про саму систему збірки та про те, як вона працює, доступна в
[посібнику обслуговування cbmk](docs/maintain/).

cbwww та cbwww-img
-------------------

*Весь* веб-сайт і документація canoeboot розміщені в репозиторії Git.
Завантажте так:

	git clone https://codeberg.org/canoeboot/cbwww

Зображення розміщені на <https://av.canoeboot.org/> і доступні в окремому
сховищі:

	git clone https://codeberg.org/canoeboot/cbwww-img

Вносьте будь-які зміни, які забажаєте. Дивіться нотатки нижче про те, як надсилати виправлення.

Весь веб-сайт написаний у Markdown, зокрема його версія Pandoc.
Статичні сторінки HTML створюються за допомогою [Untitled](https://untitled.vimuser.org/).
Лія Роу, засновниця canoeboot, також є засновницею проекту генератор статичних сайтів
Untitled.

Якщо хочете, ви можете налаштувати локальний HTTP-сервер і створити власну локальну
версію веб-сайту. Зауважте, що зображення все одно будуть посилатися на ті, що
розміщені на <https://av.canoeboot.org/>, тому будь-які зображення, які ви додаєте до `cbwww-img`
не відображатимуться на вашому локальному сайті `cbwww`, якщо ви зробите, щоб посилання на зображення (для
зображень, які ви додаєте) посилались на `av.canoeboot.org`. Однак необхідно, щоб такі
зображення розміщувалися на av.canoeboot.org.

Тому, якщо ви бажаєте додати зображення на веб-сайт, надішліть їх також до
репозиторію `cbwww-img`, із посиланням на них
<https://av.canoeboot.org/шлях/до/вашого/нового/зображення/в/cbwww-img> для кожного з них.
Коли його буде поєднано на веб-сайті canoeboot, ваші зображення з'являться в реальному часі.

Якщо додаєте світлину, стисніть її для веб розповсюдження. Світлинам варто бути приблизно
800px завширшки, і зазвичай менше 100Кбайт розміром:

По-перше, зменшіть масштаб вашого зображення до приблизно 800px завширшки, використовуючи вашу улюблену
програму маніпуляції зображенням. Наприклад, з `imagemagick` ви можете зробити
наступне (переконайтесь, що зображення не є вже меншим або еквівалентним, ніж віддано перевагу).

        convert original.jpg -resize 600000@ -quality 70% web.jpg

Вам варто завжди виконувати `jpegoptim` на jpg зображеннях перед їх поданням.
Воно вирізає безкорисні метадані та оптимізує *без втрат* їх більше, розумно
переорганізовуючи таблиці Гаффмана, що використані в них.

        jpegoptim -s --all-progressive web.jpg

Якщо зображення є (штриховим) малюнком, векторній графіці віддається перевага в порівнянні з бітовою картою.
Таким чином, якщо можливо, зберігайте їх як SVG. Їх легко модифікувати,
і точно зробить роботу перекладачів легше так само.

Зображенням PNG варто бути оптимізованими з `zopfli` (він так само без втрат).
Наприклад, це зменшило логотип завантаження Canoeboot з приблизно 11k до 3k:

        zopflipng -ym image.png image.png

Для цілей розробки ви можете спочатку створити локальні посилання на зображення, а
потім налаштувати URL-адреси, коли надсилатимете документацію/патчі веб-сайту.

На веб-сайті Untitled є інструкції щодо налаштування локальної версії
веб-сайту. Завантажте untitled, і в своєму каталозі `untitled` створіть каталог
під назвою `www/`, потім увійдіть у каталог www і клонуйте сховище `cbwww`
там. Налаштуйте локальний HTTP-сервер відповідним чином.

Знову ж таки, інструкції для цього доступні на веб-сайті Untitled.

Ім'я не вимагається
-----------------

Внески, які ви робите, реєструються публічно в репозиторії Git, доступ
до якого мають всі. Це включає ім'я та електронну адресу
учасника.

У Git для імені автора та електронної адреси вам не потрібно використовувати
ідентифікаційні дані. Ви можете використовувати `canoeboot Contributor`, а свою електронну адресу можна
вказати як contributor@canoeboot.org. Вам дозволено це робити, якщо
ви бажаєте зберегти конфіденційність. Ми віримо в конфіденційність. Якщо ви вирішите залишитися
анонімними, ми врахуємо це.

Звичайно, ви можете використовувати будь-яке ім'я та/або адресу електронної пошти.

З юридичної точки зору всі авторські права є автоматичними відповідно до Бернської конвенції
міжнародного авторського права. Немає значення, яке ім'я, чи дійсно ви навіть
заявляєте про авторське право (але ми вимагаємо наявності певного
ліцензування авторського права - докладніше про це на цій же сторінці).

Якщо ви використовуєте інше ім'я та адресу електронної пошти у своїх комітах/патчах, то
маєте бути досить анонімним. використовуйте
[git log](https://git-scm.com/book/en/v2/Git-Basics-Viewing-the-Commit-History)
та [git show](https://git-scm.com/docs/git-show), щоб підтвердити це перед тим, як ви
надсилаєте зміни до загальнодоступного сховища Git.

Надсилайте виправлення
------------

Створіть обліковий запис на <https://codeberg.org/> і перейдіть (увійшовши в систему) до
репозиторію, над яким ви хочете працювати. Натисніть *Fork*, і у вашому обліковому записі,
ви матимете власне сховище canoeboot. Клонуйте свій репозиторій, внесіть у нього
будь-які зміни, а потім надішліть їх у свій репозиторій у своєму обліковому
записі на NotABug. Ви також можете зробити це на новій гілці, якщо хочете.

У своєму обліковому записі Codeberg, ви можете перейти до офіційного репозиторія canoeboot
і надіслати запит на отримання. Принцип роботи подібний до інших популярних веб-платформ
Git, якими люди користуються сьогодні.

Ви можете відправити свої патчі туди. Крім того, ви можете увійти на
IRC-канал canoeboot і повідомити канал, які виправлення ви хочете бути переглянутими, якщо у вас
є власне сховище Git з виправленнями.

Після того, як ви подасте Pull Request, розробники canoeboot отримають сповіщення
електронною поштою. Якщо ви не отримаєте достатньо швидкої відповіді від проекту, ви
також можете повідомити проект через канал `#canoeboot` на Libera Chat.

Інший спосіб подати виправлення - це напряму надіслати Лії Роу електронною поштою:
[leah@canoeboot.org](mailto:leah@canoeboot.org) - це адреса електронної пошти проекту Лії.

Однак, для прозорості процесу перевірки коду, ми рекомендуємо на даний момент
використовувати Codeberg.

Дзеркала Git
============

Дзеркала cbmk.git
----------------

Репозиторій `cbmk` містить автоматизовану систему побудови Canoeboot, що
створює випуски Canoeboot (включаючи зібрані образи ROM).

Ви можете виконати `git clone` на будь-якому з цих посилань (посилання є також доступними для натискання,
для перегляду змін в вашому веб-браузері):

* <https://git.sr.ht/~canoeboot/cbmk>
* <https://git.disroot.org/canoeboot/cbmk>
* <https://gitea.treehouse.systems/canoeboot/cbmk>
* <https://0xacab.org/canoeboot/cbmk/>
* <https://framagit.org/canoeboot/canoeboot>
* <https://gitlab.com/canoeboot/cbmk>
* <https://notabug.org/canoeboot/cbmk>

дзеркало cbwww.git
----------------

Репозиторій `cbwww` містить файли Markdown (варіант pandoc), для використання
з [генератором статичних сайтів Untitled](https://untitled.vimuser.org/); це те,
що Canoeboot використовує для надання веб-сторінок HTML, *включаючи* сторінку, яку ви
читаєте прямо зараз!

Ви можете виконати `git clone` на цих посиланнях, та/або натиснути для перегляду змін в вашому
веб-браузері. Дивіться:

* <https://git.sr.ht/~canoeboot/cbwww>
* <https://git.disroot.org/canoeboot/cbwww>
* <https://gitea.treehouse.systems/canoeboot/cbwww>
* <https://0xacab.org/canoeboot/cbwww>
* <https://framagit.org/canoeboot/cbwww/>
* <https://gitlab.com/canoeboot/cbwww>
* <https://notabug.org/canoeboot/cbwww>

дзеркало cbwww-img.git
----------------

Ви можете виконати `git clone` на цих посиланнях, та/або натиснути для перегляду змін в вашому
веб-браузері. Дивіться:

* <https://git.sr.ht/~canoeboot/cbwww-img>
* <https://git.disroot.org/canoeboot/cbwww-img>
* <https://gitea.treehouse.systems/canoeboot/cbwww-img>
* <https://0xacab.org/canoeboot/cbwww-img>
* <https://framagit.org/canoeboot/cbwww-img/>
* <https://gitlab.com/canoeboot/cbwww-img>
* <https://notabug.org/canoeboot/cbwww-img>
