---
title: Libreboot GRUB payload documentation
x-toc-enable: true
...

GRUB already has excellent
documentation, but there are aspects of libreboot that deserve special
treatment. Libreboot provides the option to boot GRUB directly, running on
bare metal (instead of using BIOS or UEFI services).

Boot Linux from GRUB
--------------------

[The Linux section](../linux/) also has libreboot-specific guides for
dealing with Linux distributions when using GRUB directly, in this
setup. [A similar section exists for BSD operating systems](../bsd/)

GRUB keyboard layouts
---------------------

It is possible to use *any* keymap in GRUB.

### Custom keyboard layout

Keymaps are stored in `config/grub/keymap/`

You can use the `ckbcomp` program to generate a keymap, based on Xorg keymap
files:

	ckbcomp fr > frazerty

When you build GRUB from source, you can use the `grub-mklayout` program to
create a special keymap file for GRUB. [Learn how to build GRUB](../build/)

Te compile GRUB, in lbmk, do this:

	./mk -b grub default

Other GRUB trees are available, but the `default` one will do for now.

When you've built GRUB, using `lbmk` (libreboot build system), take your kepmap
file (generated by ckbcomp) and run it through `grub-mklayout` like so:

	cat frazerty | ./src/grub/default/grub-mklayout -o frazerty.gkb

Place the newly created `.gkb` file under `config/grub/keymap` in lbmk. When
you build libreboot, a ROM image with GRUB payload and your newly created
keymap will be available under the `bin/` directory.
[Learn how to build libreboot ROM images](../build/)

Many keymaps exist in the libreboot build system, but sometimes you must
manually tweak the file created by `ckbcomp`, adjusting the scan codes in that
file, before converting to a GRUB keymap file. Therefore, it would be unwise to
automatically add all keymaps in GRUB.

If you've added a keymap to lbmk, and it works,
[please submit a patch!](../../git.md)
