---
title: Install Libreboot on HP EliteBook 8560w
x-toc-enable: true
...

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](ivy_has_common.md), OR
YOU MAY BRICK YOUR MACHINE!! - Please click the link and follow the instructions
there, before flashing. For posterity,
[here is the link again](ivy_has_common.md).**

<div class="specs">
<center>
<img tabindex=1 alt="HP EliteBook 8560w" class="p" src="https://av.libreboot.org/hp8560w/hp8560w.webp" /><span class="f"><img src="https://av.libreboot.org/hp8560w/hp8560w.webp" /></span>
</center>

| ***Specifications***       |                                                |
|----------------------------|------------------------------------------------|
| **Manufacturer**           | HP                                             |
| **Name**                   | EliteBook 8560w                                |
| **Variants**               | EliteBook 8560w                                |
| **Released**               | 2011                                           |
| **Chipset**                | Intel QM67                                     |
| **CPU**                    | Intel Sandy Bridge (socketed)                  |
| **Graphics**               | MXM-A (3.0), socketed                          |
| **Display**                | 15.6" 1600x900 or 1920x1080 LCD                |
| **Memory**                 | Two or four slots, max 8GB/slot
                               (16GB or 32GB), DDR3/SODIMM                    |
| **Architecture**           | x86_64                                         |
| **EC**                     | SMSC KBC1126, proprietary (in main boot flash) |
| **Original boot firmware** | HP UEFI firmware                               |
| **Intel ME/AMD PSP**       | Present. Can be disabled with me_cleaner.      |
| **Flash chip**             | SOIC-8 8MiB (64Mbit)                           |


```
W+: Works without vendor firmware;
N: Doesn't work;
W*: Works with vendor firmware;
U: Untested;
P+: Partially works;
P*: Partially works with vendor firmware
```

| ***Features***                                    |    |
|---------------------------------------------------|----|
| **Internal flashing with original boot firmware** | N  |
| **Display**                                       | W* |
| **Audio**                                         | W+ |
| **RAM Init**                                      | W+ |
| **External output**                               | W+ |
| **Display brightness**                            | W+ |

| ***Payloads supported***  |           |
|---------------------------|-----------|
| **GRUB**                  | Works     |
| **SeaBIOS**               | Works     |
| **SeaBIOS with GRUB**     | Works     |
</div>

Open source BIOS/UEFI firmware
-------------------------

These next sections will teach you how to install Libreboot, on your
HP EliteBook 8560w laptop motherboard.
Libreboot is a [Free Software](https://writefreesoftware.org/learn) project
that replaces proprietary BIOS/UEFI firmware.

Vendor manual [here](https://web.archive.org/web/20240629174138/https://h10032.www1.hp.com/ctg/Manual/c03424153.pdf). 

**Unavailable in Libreboot 20240126 or earlier. You must [compile from
source](../build/), or use a release newer than 20240126.**

This is a beastly 15" Sandy Bridge mobile workstation from HP.

**Wi-Fi does not work. It shows correctly in lspci, but stays hard blocked.**

### GPU

This laptop has upgradeable GPU: it has a socketed MXM-A 3.0 card. So far,
only Quadro 1000M and 2000M (which shipped with the laptop originally) have
been tested with Libreboot.

These laptops shipped with eDP and LVDS panels. If you choose to upgrade the
graphics card, make sure it is compatible with the panel you have. Use the
following command to check:

	xrandr

Or if using Wayland:

	wlr-randr

If you have "LVDS-1 connected", your GPU upgrade needs to support LVDS.
According to [this forum thread](https://forums.macrumors.com/threads/2011-imac-graphics-card-upgrade.1596614/),
AMD's 1st gen GCN cards are the newest and most powerful to support LVDS.
If you have an eDP panel, you should be able to use newer cards than that.

As long as the card has an onboard VBIOS, Libreboot will execute it and
everything *should* work. **However, this is currently untested.**

### Build ROM image from source

The build target, when building from source, is thus:

	./mk -b coreboot hp8560w_8mb

Installation
------------

### Insert binary files

If you're using a release ROM, please ensure that you've inserted extra firmware
required refer to the [guide](../install/ivy_has_common.md) for that. (failure
to adhere to this advice will result in a bricked machine)

### Set MAC address

This platform uses an Intel Flash Descriptor, and defines an Intel GbE NVM
region. As such, release/build ROMs will contain the same MAC address. To
change the MAC address, please read [nvmutil documentation](../install/nvmutil.md).

### Flash a ROM image (software)

If you're already running Libreboot, and you don't have flash protection
turned on, [internal flashing](../install/) is possible.

### Flash a ROM image (hardware)

**REMOVE all power sources like battery, charger and so on, before doing this.
This is to prevent short circuiting and power surges while flashing.**

Remove the bottom cover. The SOIC-8 flash chip is next to the memory slot 2.
You need to cut away a small piece of the clear plastic protection material
to get to the chip.

![](https://av.libreboot.org/hp8560w/hp8560w_chip.webp)

For information about programming the chip, please refer to [25xx NOR flash
instructions](../install/spi.md).
