---
title: Lenovo ThinkPad X200 / X200s / X200 Tablet'e Libreboot Kurulumu
x-toc-enable: true
...

<div class="specs">
<center>
<img tabindex=1 alt="ThinkPad X200" class="p" src="https://av.libreboot.org/x200/disassembly/0019.jpg" /><span class="f"><img src="https://av.libreboot.org/x200/disassembly/0019.jpg" /></span>
</center>

| ***Özellikler***          |                                                |
|---------------------------|------------------------------------------------|
| **Üretici**              | Lenovo                                         |
| **Model**                 | ThinkPad X200/X200S/X200 Tablet                |
| **Çıkış Tarihi**         | Temmuz/Eylül 2009                             |
| **Yonga Seti**           | Intel Cantiga GM45                             |
| **İşlemci**              | Intel Core 2 Duo (Penryn ailesi)               |
| **Ekran Kartı**          | Intel GMA X4500MHD                             |
| **Ekran**                | 1280x800/1440x900 TFT                          |
| **Bellek**               | 1,2,3 veya 4GB (Resmi olmayan şekilde 8GB'a kadar yükseltilebilir) |
| **Mimari**               | x86\_64                                        |
| **EC**                   | Tescilli                                       |
| **Orijinal önyükleme yazılımı** | LenovoBIOS                             |
| **Intel ME/AMD PSP**     | Mevcut. Tamamen devre dışı bırakılabilir.      |
| **Flash yongası**        | SOIC-8/SOIC-16/WSON-8 4MiB/8MiB (16MiB'a yükseltilebilir) |

```
W+: Üretici yazılımı olmadan çalışır; 
N: Çalışmaz; 
W*: Üretici yazılımı ile çalışır; 
U: Test edilmedi; 
P+: Kısmen çalışır; 
P*: Üretici yazılımı ile kısmen çalışır
```

| ***Özellikler*** |                                       |
|------------------|---------------------------------------|
| **Orijinal önyükleme yazılımı ile dahili flaşlama** | N  |
| **Ekran**                                            | W+ |
| **Ses**                                              | W+ |
| **RAM Başlatma**                                     | W+ |
| **Harici çıkış**                                     | W+ |
| **Ekran parlaklığı**                                 | P+ |

| ***Desteklenen Yükleyiciler*** |           |
|--------------------------------|-----------|
| **GRUB**                       | Çalışıyor |
| **SeaBIOS**                    | Çalışıyor |
| **SeaBIOS ve GRUB**           | Çalışıyor |
</div>

Açık kaynak BIOS/UEFI yazılımı
-------------------------

Bu belge, Lenovo ThinkPad X200, X200s veya X200 Tablet dizüstü bilgisayar anakartınıza
Libreboot'u nasıl kuracağınızı öğretecektir. Libreboot, tescilli BIOS/UEFI yazılımının
yerini alan bir [Özgür Yazılım](https://writefreesoftware.org/learn) projesidir.

Tüm X200 dizüstü bilgisayarların uyumlu olduğuna inanılmaktadır. X200S ve X200
Tablet de [yapılandırmaya bağlı olarak](#x200s) çalışacaktır.

X200 anakartını X201 kasasına takmak mümkün olabilir, ancak bu henüz libreboot
projesi tarafından test edilmemiştir. Aynı durum X200S ve X201S arasında da
geçerli olabilir; bu da test edilmemiştir. *Büyük olasılıkla doğrudur.*

X200 için iki olası flash yonga boyutu vardır: 4MiB (32Mbit) veya 8MiB (64Mbit).
Bu, avuç içi desteğinin altındaki flash yongasının türüne göre belirlenebilir:
4MiB SOIC-8, 8MiB SOIC-16'dır.

*X200 dizüstü bilgisayarlar, libreboot'u flaşlamadan önce ME (ve bazen ek olarak AMT)
ile birlikte gelir. libreboot, değiştirilmiş bir tanımlayıcı kullanarak bunu devre
dışı bırakır ve kaldırır.*

Flaşlama talimatları [../install/\#flashprog](../install/#flashprog) adresinde
bulunabilir.

**NOT: Libreboot, 27 Ocak 2024 itibariyle artık [flashprog](https://flashprog.org/wiki/Flashprog)
kullanmaktadır; bu, flashrom'un bir çatallamasıdır. Bunun nedeni
[Libreboot 20240225 sürümünde](../../news/libreboot20240225.md#flashprog-now-used-instead-of-flashrom)
açıklanmıştır.**

Dell Latitude E6400
-------------------

**Henüz bir X200 satın almadıysanız: [Dell Latitude E6400](../install/latitude.md)
flaşlaması çok daha kolaydır; sökme işlemi gerekmez, Dell BIOS'tan Libreboot'a
tamamen yazılım üzerinden flaşlanabilir. Aynı donanım neslidir (GM45), aynı
işlemciler, video işlemci vb. ile.**

EC güncellemesi {#ecupdate}
---------------------

En son EC yazılımı sürümüne güncellemeniz önerilir. [EC yazılımı](../../faq.md#ec-embedded-controller-firmware)
libreboot'tan ayrıdır, bu yüzden biz aslında bunu sağlamıyoruz, ancak hala
Lenovo BIOS kullanıyorsanız, hem BIOS hem de EC sürümünü güncelleyecek olan
Lenovo BIOS güncelleme yardımcı programını çalıştırabilirsiniz. Bakınız:

-   [../install/#flashprog](../install/#flashprog)
-   <http://www.thinkwiki.org/wiki/BIOS_update_without_optical_disk>
-   [X200, X200s, X200si BIOS Güncellemesi](http://pcsupport.lenovo.com/au/en/products/laptops-and-netbooks/thinkpad-x-series-laptops/thinkpad-x200/downloads/ds015007)
-   [X200t BIOS Güncellemesi](http://pcsupport.lenovo.com/au/en/products/laptops-and-netbooks/thinkpad-x-series-tablet-laptops/thinkpad-x200-tablet/downloads/ds018814)

NOT: Bu işlem yalnızca Lenovo BIOS kullanırken yapılabilir. libreboot çalışırken
EC yazılımını nasıl güncelleyeceğiniz bilinmemektedir. libreboot yalnızca BIOS
yazılımının yerini alır, EC'nin değil.

Güncellenmiş EC yazılımının daha iyi pil yönetimi gibi birçok avantajı vardır.

Pil Geri Çağırma {#batteryrecall}
------------------------------

[21 Nisan 2015'te Lenovo, X200 ve X200S'in de dahil olduğu bazı ThinkPad modellerinde
bulunan Lenovo pillerinin geri çağırma kapsamını genişletti.](https://pcsupport.lenovo.com/cr/en/solutions/hf004122)
Etkilenip etkilenmediğinizi öğrenmek için [bu Lenovo aracını kullanın.](https://lenovobattery2014.orderz.com/)
Lenovo, geri çağrılan modellerin sahiplerinin "sistemi kapatmasını, pili çıkarmasını
ve ThinkPad'i yalnızca AC adaptörü ve güç kablosunu takarak çalıştırmasını" öneriyor.
Pil doğrulamasının ardından Lenovo, geri çağrılan pilleri ücretsiz olarak değiştirecektir.
X200/X200s için pil değiştirme talimatları [bu sayfada](https://pcsupport.lenovo.com/cr/en/parts/pd003507/)
bulunabilir.

LCD uyumluluk listesi {#lcd_supported_list}
----------------------

LCD panel listesi (X200 panelleri burada listelenmiştir):
<http://www.thinkwiki.org/wiki/TFT_display>

X200, X200S ve X200 Tablet için tüm LCD panellerin çalıştığı bilinmektedir.

### AFFS/IPS paneller {#ips}

#### X200

<https://github.com/bibanon/Coreboot-ThinkPads/wiki/ThinkPad-X200> adresinden
uyarlanmıştır.

TN ve IPS paneller arasındaki fark için wikipedia'ya bakın. IPS'ler normal bir
TN'den çok daha iyi renk/kontrasta sahiptir ve genellikle iyi görüş açılarına
sahip olacaktır.

Bunlar X200 tabletten geliyor gibi görünüyor. Üzerinde cam dokunmatik ekran
koruması olmayan bir tane bulmanız gerekiyor (ancak bunu çıkarmak mümkün
olabilir). Ayrıca üzerinde sayısallaştırıcı olmamalıdır (yine, sayısallaştırıcıyı
çıkarmak mümkün olabilir).

-   BOE-Hydis HV121WX4-120, HV121WX4-110 veya HV121WX4-100 - ucuz sayılır,
    bulmak zor olabilir

-   Samsung LTN121AP02-001 - yaygın olarak bulunur, ucuz

*X200'ünüzde LED arkadan aydınlatmalı bir panel varsa, CCFL panellerle uyumlu
bir invertör ve kablo demeti de almanız gerekir. Hangi panel tipine sahip
olduğunuzu görmek için [\#led\_howtotell](#led_howtotell) bölümüne bakın.
İnvertör/kablo gerekiyorsa, parça numaraları şunlardır: bluetooth ve kamera
bağlantıları ile CCFL LVDS kablosu için 44C9909 ve invertör için 42W8009
veya 42W8010.*

Bunların parlak ve mat versiyonları vardır. Mat, yansıma önleyici anlamına
gelir ki bu istediğiniz şeydir (bu yazarın görüşüne göre).

Ekranın nasıl değiştirileceği için HMM'ye (donanım bakım kılavuzu) bakın.

Kaynaklar:

-   [ThinkPad Forums - X200'de Mat AFFS Panel](http://forum.thinkpads.com/viewtopic.php?f=2&t=84941)
-   [ThinkPad Forums - X200 AFFS Modifikasyonu için Parçalar](http://forum.thinkpads.com/viewtopic.php?p=660662#p660662)
-   [ThinkWiki.de - X200 Ekran Değişimi](http://thinkwiki.de/X200_Displayumbau)

#### X200S

<http://forum.thinkpads.com/viewtopic.php?p=618928#p618928> X200S ekranlarının/
montajlarının daha ince olduğunu açıklıyor. Kapağın tamamını normal bir X200/X201'den
gelen bir kapakla değiştirmeniz gerekiyor.

### LED mi CCFL mi olduğunu nasıl anlarım? {#led_howtotell}

Bazı X200'lerde LCD panellerinde CCFL arka aydınlatma, bazılarında LED arka
aydınlatma vardır. Bu aynı zamanda invertörlerin de değişeceği anlamına gelir,
bu yüzden paneli ve/veya invertörü değiştirirken dikkatli olmalısınız. (CCFL
invertör yüksek voltajlıdır ve LED arkadan aydınlatmalı bir paneli tahrip eder).

CCFL'ler cıva içerir. CCFL arka aydınlatmalı bir X200 (doğru invertörle LED'e
değiştirilmemişse. Tedarikçinize danışın!) şunu söyleyecektir: *"Bu ürün Lityum
İyon Pil, Lityum Pil ve cıva içeren bir lamba içerir; yerel, eyalet veya federal
yasalara göre bertaraf edin"* (LED arkadan aydınlatmalı bir panele sahip olan
farklı bir şey söyleyecektir).

Kurulum notları
------------------

Lenovo BIOS çalışıyorsa [harici flaşlama](spi.md) gereklidir.

Bu kılavuz, ThinkPad X200'lerinde hala orijinal Lenovo BIOS'u bulunan ve
libreboot isteyenler içindir. Bu kılavuz ayrıca X200'ünüzü bozarsanız,
kurtarmanın nasıl yapılacağını bilmek için de (uyarlanarak) takip edilebilir.

Orijinal Lenovo yazılımı çalışıyorsa, flash yongasına erişebilmek için klavyeyi
ve avuç içi desteğini çıkarmanız gerekecektir; yonga avuç içi desteğinin hemen
altındadır. Ardından harici bir SPI programlayıcı bağlayacak ve pil çıkarılmış
durumdayken kapalıyken yongayı harici olarak yeniden flaşlayacaksınız.

NOT: Bu kılavuz yalnızca normal X200 için geçerlidir. X200S ve X200 Tablet
flaşlaması için lütfen libreboot.org'da bulunan diğer kılavuzları okuyun.

### Flash yonga boyutu

Flash yonga modelini ve boyutunu öğrenmek için x200'de bu komutu çalıştırın:

	flashprog -p internal

### MAC adresi

[mac\_address.md](mac_address.md) dosyasına bakın.

### Prosedür

Bu bölüm X200 içindir. Bu, X200S veya X200 Tablet için geçerli değildir
(bu sistemler için, flash yongası kartın diğer tarafında olduğundan anakartı
tamamen çıkarmanız gerekir).

Bu vidaları çıkarın:\
![](https://av.libreboot.org/x200/disassembly/0003.jpg)

Klavyeyi nazikçe ekrana doğru itin, ardından kaldırın ve isteğe bağlı olarak
karttan bağlantısını kesin:\
![](https://av.libreboot.org/x200/disassembly/0004.jpg)
![](https://av.libreboot.org/x200/disassembly/0005.jpg)

Parmak izi okuyucusunun kablosunu çıkarın ve ardından avuç içi desteğini
sol ve sağ tarafından kaldırarak yukarı çekin:\
![](https://av.libreboot.org/x200/disassembly/0006.1.jpg)
![](https://av.libreboot.org/x200/disassembly/0006.jpg)

Bu, hem SOIC-8 hem de SOIC-16 için flash yongasının konumunu gösterir:\
![](https://av.libreboot.org/x200/x200_soic16.jpg)
![](https://av.libreboot.org/x200/x200_soic8.jpg)

Flash yongasının bir kısmını örten bandı kaldırın ve ardından klipsi bağlayın:\
![](https://av.libreboot.org/x200/disassembly/0008.jpg)

Artık libreboot'u kurmaya hazır olmalısınız.

[SPI programlama talimatlarına](spi.md) bakın.

İşiniz bittiğinde, sistemi tekrar bir araya getirin. Önyükleme yapmazsa, bu
platformda (coreboot'ta) raminit çok güvenilmez olduğu için diğer RAM modüllerini
deneyin. 