% Libreboot 20241206 released! ThinkPad T480 added. Plus U-Boot UEFI on x86. Fixes for OptiPlex 3050 Micro.
% Leah Rowe
% 6 December 2024

A corresponding [Canoeboot 20241207](https://canoeboot.org/news/canoeboot20241207.html)
release is also available.

Today's Libreboot 20241206 revision is a *stable release*, whereas the previous
testing release was Libreboot 20241008, and the previous stable release was
Libreboot 20240612. A new *revision* release became available on 5 January 2025,
namely Libreboot 20241206, 8th revision.

**UPDATE (revision release), 6 January 2025:\
The latest *revision* is the *8th revision*, released on 6 January 2025. This
has replaced the release archives for the original release revisions,
under the same `stable/20241206/` directory on release mirrors. See:**

**[Libreboot 20241206 revision 8 announcement](libreboot20241206rev8.md)**

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](../docs/install/ivy_has_common.md), OR
YOU MAY BRICK YOUR MACHINE!! - Please click the link and follow the instructions
there, before flashing. For posterity,
[here is the link again](../docs/install/ivy_has_common.md).**

Open source BIOS/UEFI firmware
----------------------------

<img tabindex=1 class="r" src="https://av.libreboot.org/t480/t480.jpg" /><span class="f"><img src="https://av.libreboot.org/t480/t480.jpg" /></span>

Libreboot is a free/open source BIOS/UEFI replacement on x86 and ARM, providing
boot firmware that initialises the hardware in your computer, to then load an
operating system (e.g. Linux/BSD). It is specifically
a *[coreboot distribution](../docs/maintain/)*,
in the same way that Debian is a Linux distribution. It provides an automated
build system to produce coreboot ROM images with a variety of payloads such as
GRUB or SeaBIOS, with regular well-tested releases to make coreboot as easy
to use as possible for non-technical users. From a project management perspective,
this works in *exactly* the same way as a Linux distro, providing a source-based
package manager (called lbmk) which patches sources and compiles coreboot images.
It makes use of [coreboot](https://www.coreboot.org/) for hardware initialisation,
and then a payload such as [SeaBIOS](https://www.seabios.org/SeaBIOS)
or GRUB to boot your operating
system; on ARM(chromebooks), we provide *U-Boot* (as a coreboot payload).

### U-Boot UEFI payload on x86\_64

For Libreboot 20241206, today's release, U-Boot is *also* provided as an
optional coreboot payload on x86 machines. This provides a sensible UEFI
implementation, useful for booting Linux/BSD systems more easily. More
information available on the [U-Boot x86 page](../docs/uboot/uboot-x86.md).

<img tabindex=1 class="r" src="https://av.vimuser.org/uboot.png" /><span class="f"><img src="https://av.vimuser.org/uboot.png" /></span>

This means that you can have a UEFI boot environment, even on machines where
the original vendor firmware never supported it. For example, the ThinkPad X200
runs U-Boot virtually bug-free, and it can boot Linux distros via U-Boot's UEFI
implementation; that machine could not originally do UEFI.

This page lists all changes made since the *Libreboot 20241008* release. Since
Libreboot 20241206 is a stable release, there has been a more conservative focus
on fixing bugs and in general polishing, though several interesting features
have been added, in addition to numerous new motherboards.

Summarised list of changes
-------------------------

### Board support

The following boards have been added since the Libreboot 20241008 release:

* **[Lenovo ThinkPad T480](../docs/install/t480.md)** support, implemented by
  Mate Kukri with testing and hardware logs provided by Leah Rowe. - You can also
  [buy T480 with Libreboot pre-installed](https://minifree.org/product/libreboot-t480/)
* **[Lenovo ThinkPad T480S](../docs/install/t480.md)** support, implemented by
  Mate Kukri with testing and hardware logs provided by Leah Rowe. - You can also
  [buy T480s with Libreboot pre-installed](https://minifree.org/product/libreboot-t480/)
* **[Dell OptiPlex 780 USFF](../docs/install/dell780.md)** support, implemented
  by Nicholas Chin with testing and hardware logs provided by Lorenzo Aloe.
* **[Dell OptiPlex 780 MT](../docs/install/dell780.md)** support, implemented by
  Nicholas Chin with testing and hardware logs provided by Lorenzo Aloe.

### Revision updates

In descending order from latest changes to earliest changes:

* Updated to Mate Kukri's rewritten release of `deguard`, which now works
  generally for any MEv11-based board, whereas the previous version contained
  hacky hardcoded logic for only the Dell OptiPlex 3050 Micro. In this Libreboot
  release, deguard supports the 3050, but also the ThinkPad T480 and T480S,
  providing machine-specific ME configurations for each motherboard. Mate's new
  deguard implementation essentially does the same thing as Intel's FITC tool,
  though with a much more terse and minimalist design. It could be expanded for
  many other things in the future, related to Intel ME.
* Updated U-Boot to v2024.10 release on ARM64 - and also added this revision
  for x86 coreboot payloads, to provide UEFI on 64-bit x86 machines. The ARM64
  coreboot payload is maintained by Alper Nebi Yasak, and the x86 coreboot
  payload is principally maintained by Simon Glass.
* Updated the Dell OptiPlex 3050 Micro port to use a newer coreboot revision,
  which includes a fix adding PWM fan control, among other things. NOTE: This
  was later obsoleted, because OptiPlex 3050 Micro support was merged upstream
  and Libreboot switched to the upstream revision instead of Gerrit.
* Updated SeaBIOS to latest revision as of 17 October 2024.
* Bumped flashrom to revision d128a0a, which includes a fix for Macronix flash
  chips on ThinkPad W500 whereby it had previously used incorrect erase commands.

### Feature changes

In descending order from latest changes to earliest changes:

* Implemented an auto-boot timeout on U-Boot payloads, for both ARM and x86.
  This is implemented in the bootflow menu, so that the system will auto-boot
  what is found after a few seconds. Previously, the user had to press enter,
  making headless operation impractical. If the countdown is interrupted with
  a keypress, it is disabled until the next reboot. The current countdown
  delay is 8 seconds, though the U-Boot patch sets a default of 30, which
  Libreboot then overrides via defconfig option.
* `rom.sh`: Support creating SeaUBoot payload setups. This is where SeaBIOS
  loads U-Boot from SeaBIOS first, unless interrupted by the ESC menu, whereby
  the user can select an alternative option, such as direct device booting from
  SeaBIOS, or the GRUB payload instead. This was done, to mitigate potential
  instability in U-Boot, since U-Boot is much more heavily tested so it provides
  a sensible fallback just in case. This could also be regarded as a preventative
  bug fix, from the perspective of a user.
* Experimental U-Boot payload on both 32- and 64-bit x86 setups. The 64-bit
  payload is chainloaded from SeaBIOS and the 32-bit one from GRUB. This is
  useful for booting BSD systems; for example, GPT partitioned OpenBSD can be
  booted with U-Boot, whereas the SeaBIOS payload would require MBR partitioning.
* Imported Riku Viitanen's `int` tool, which was used for debugging MXM
  handling on the HP EliteBook 8560w port; the MXM is a data section provided
  by the system BIOS on mobile systems that use MXM graphics cards. The data
  describes ports, power management and so on. This was needed to make MXM cards
  work reliably.
* Imported Riku Viitanen's `gpio-scripts` fork, which parses inteltool output
  for providing GPIO configuration on new coreboot ports; note that from Skylake
  onward, `intelp2m` is used instead, but Libreboot does not directly import
  the `intelp2m` utility (it is included via coreboot instead).
* Imported Riku Viitanen's `mxmdump` utility, for extracting MXM configuration
  on mobile graphics cards. This was used when implementing MXM support on
  the HP EliteBook 8560w.

### Configuration changes

In descending order from the latest changes to the earliest changes:

* Disabled U-Boot on ThinkPad T480, because it's currently buggy there; more
  boards will have U-Boot tweaks made to them, in subsequent hotfixes to
  the Libreboot 20241206 release, and hotfixes to U-Boot itself are also likely,
  since U-Boot still requires a lot more testing. U-Boot does work quite well
  on a number of tested motherboards; if yours works, or doesn't work, please get
  in touch with the Libreboot project, so that a tally can be kept.
* Added Libreboot branding/versioning to the U-Boot bootflow menu, showing
  the Libreboot logo instead of the U-Boot one, and with a purple background
  colour in the console, matching the style used by Libreboot.
* U-Boot (ARM): Alper Nebi Yasak enabled USE with a preboot command at startup.
  This is so that USB keyboards and external disks can be used during the
  boot process; this would have been previously enabled much later in the boot
  process.
* Enabled the coreboot serial console on these targets: Thinkpad X60, HP
  Elite 8200 SFF, HP EliteBook 8460p, HP EliteBook 8560w.
* Enabled U-Boot x86 payload on almost every coreboot board; basically, all
  of the ones with a native coreboot framebuffer (libgfxinit).
* Removed `coreboot/dell7` (for 3050 Micro) and merged it into a new
  tree, `coreboot/next` instead, which was (for this release) later updated to
  the latest coreboot revision from a few days prior to the release. The `next`
  branch contains OptiPlex 780 ports and the Kaby Lake machines such as
  OptiPlex 3050 Micro or ThinkPad T480/T480S.
* Removed the FSP submodule from `coreboot/default`, because it's currently
  used in `coreboot/next` instead (for Kaby Lake machines).
* Enabled support in coreboot, on Dell OptiPlex 3050 Micro, for Coffee Lake CPUs.
  With a special pin mod (currently untested as of 6 December 2024), Kaby Lake
  machines can make use of 8th-gen Coffee Lake CPUs, which offer greater
  performance and power efficiency.

### Bug fixes

The following bug fixes have been merged (in descending order from the latest
changes to the earliest changes):

* `script/trees`: Reset the PATH environmental variable per target, to what it
  was when the script was first called. This is because PATH is manipulated
  when dealing with crossgcc, exporting it prior to running a given build
  process, if the current project/target enables cross compilation. This bug
  didn't cause any issues in practise, so this is a preventative bug fix,
  because projects that use the crossgcc compiler all set `xarch` properly,
  and none of the projects that aren't cross compiled use special prefixes
  in their toolchain references, at least as of 6 December 2024.
* Add U-Boot first, on x86 coreboot targets, even though it doesn't execute
  first, because U-Boot has to be inserted at a specific offset. This avoids
  potential overlap errors in cbfstool, if it were to be added later on. This
  bug didn't cause any issues in practise, so it is theoretical in nature and
  therefore a preventative bug fix.
* `rom.sh`: Removed redundant shebang, which didn't technically cause any
  problems, but it's technically a bug since this is not provided as a main
  script, and must never be executed directly, instead only to be executed by
  other scripts.
* Added missing `openssl-devel-engine` to Fedora 41 build dependencies.
* U-Boot: Merged an x86 patch from Simon Glass, that makes U-Boot skip clearing
  the VESA display an startup, since this is already done by the VESA driver.
  In some cases, you may want to keep what was previously on the screen, like
  for logos and such. We currently do not use U-Boot on VESA setups in Libreboot,
  as of 6 December 2024.
* U-Boot: Merged an x86 patch from Simon Glass, that makes U-Boot silently
  disable serial console output, where one is not available; previously, it
  would crash if one wasn't available, on x86 machines.
* `script/trees`: Unset the `CROSS_COMPILE` environmental variable, to fix an
  issue whereby projects that honour it might be wrongly cross compiled where
  a previous export of that variable was made; for example, setting it on
  arm64 U-Boot and then compiling x86 U-Boot, where the latter currently relies
  on the host's x86\_64 toolchain, on an x86\_64 host.
* Enabled the legacy 8254 timer on Dell OptiPlex 3050 Micro, to work around a
  hanging bug in SeaBIOS. This board was previously GRUB only, but now once again
  uses a more flexible SeaGRUB setup like other motherboards do. The static option
  table was also disabled.
* Merged a patch from Nicholas Chin, that tells the MEC5035 EC to send a correct
  shutdown signal to the operating system when the power button is pressed.
  Prior to this fix, pressing the power button on Dell Latitude laptops would
  result in the system turning off, but the OS would be unaware of this fact
  so file systems (for example) would not be cleanly unmounted.
* Merged a patch from Mate Kukri, fixing PWM fan controls on the Dell OptiPlex
  3050 Micro. Previously, the fans always ran at a very low speed even under
  stress conditions, leading to over-heating; the system now runs reliably.
* Removed end slashes in repository links within `config/git`, because of
  how caching works in Libreboot; fewer projects now fail to cache, making
  the download process more redundant and fault tolerant at build time when
  downloading upstream sources.
* `vendor.sh`: Don't use the `x_` wrapper for handling errors while changing
  GbE MAC addresses, because a file path is provided as argument, and the `x_`
  wrapper currently does not handle globbing; instead, the `$err` function is
  used for returning error status.
* `vendor.sh`: Properly handle error status when returning from deguard's
  RUNME script (**This change was later obsoleted when deguard was rewritten,
  and Libreboot imported the newly rewritten version - the new code and handling
  of it is much more robust**)
* Added missing `python3-devel` to Fedora 40 build dependencies.

### General code cleanup

In descending order from the latest changes to the earliest changes:

* Removed unnecessary coreboot submodule configs, for trees that no
  longer exist such as `coreboot/haswell` or `coreboot/dell7`.
* Removed the following unnecessary coreboot patches in the default tree:
  VRAM patches (VRAM allocation is dynamic in modern OSes, so the fixed higher
  size merely wastes system RAM needlessly on Intel GPUs when not a lot of VRAM
  is needed). Removed redundancy patches for coreboot's buildgcc download logic,
  because lbmk now handles this outside of coreboot.

Git log
-------

This log is relative to Libreboot 20241008:

```
* 07983c1d882 Revert "Revert "disable u-boot on thinkpad t480"" 
* 19ec440a6f7 Revert "disable u-boot on thinkpad t480" 
* 99513c3bf67 add patch from mkukri fixing t480 sata 
* cd9baca5d66 disable u-boot on thinkpad t480 
* 8065b9842b5 remove the purple patch on arm64 u-boot 
*   5cc91d8e40a Merge pull request 'u-boot: Use bootflow menu by default for ARM64 boards' (#254) from alpernebbi/lbmk:u-boot-arm64-bootflow-menu into master 
|\  
| * f26752fd854 u-boot: Use bootflow menu by default for ARM64 boards 
* | bef2890233e i made u-boot purple 
|/  
* 965f9bd0335 Add bootflow/branding patches to arm64 U-Boot too 
* 44e6a0c0905 Add libreboot branding/version to U-Boot bootflow 
* c038b653ac1 Add auto-boot timeout for U-Boot's bootflow menu 
* 7a6e47c24fe 8-sec auto-boot timeout for U-Boot's bootflow menu 
* 90850eb859c fix board name for coreboot/dell7010sff 
* 8314fbc67eb add /dump/ to .gitignore 
* efebfa992b6 Revert "trees: Allow using a custom clean command" 
* 5b4c9158e5a trees: Allow using a custom clean command 
* b95a411a364 Add SPD support for onboard ThinkPad T480S RAM 
* 046529abd98 Disable m2 caddy hotplug on T480S 
* 9dc3c86ae37 vendor.sh: Remove T480 VGA ROM download handling 
* 33efe45b149 Enable legacy 8254 timer on ThinkPad T480 
* cde9594aab5 libgfxinit on Thinkpad T480 
* c1b73269726 NEW MAINBOARD: ThinkPad T480S 
* 264928c6cde NEW MAINBOARD: ThinkPad T480 
*   597b45fdbd5 Merge pull request 'Update U-Boot to v2024.10' (#253) from alpernebbi/lbmk:uboot-v2024.10 into master 
|\  
| * 3dd77b33a72 u-boot: Enable USB with a preboot command 
| * ba772eb6acd u-boot: Update ARM64 boards to v2024.10 
* | 28d8dc93a52 vendor.sh: Use the new deguard for 3050micro 
* | 7f6e47d27c6 trees: reset PATH per-target 
|/  
* f4b6aeea281 rom.sh: Add U-Boot before SeaBIOS and GRUB (x86) 
* 7014b303f98 rom.sh: Remove unnecessary shebang 
*   a3accd39a06 Merge pull request 'config/deps/fedora41: Add openssl-devel-engine to dependency list' (#251) from mkukri/lbmk:master into master 
|\  
| * 98c5e436282 config/deps/fedora41: Add openssl-devel-engine to dependency list 
|/  
* ef7db205463 e6400nvidia: Disable U-Boot 
* eea9fc40975 rom.sh: unset displaymode on normal initmode 
* f312e6026f9 rom.sh: Don't build U-Boot on normal initmode 
* 587d588fe4c rom.sh: Don't build txtmode U-Boot images 
* 7d1fd1cc6a1 rom.sh: Support SeaUBoot for 64-bit x86 U-Boot 
* 02e66ae01ae U-Boot x86: Avoid clearing the VESA display 
* 32dced8cd83 disable U-Boot for now on HP EliteBook 8560w 
* a68b468964d enable serial debug on HP EliteBook 8460p 
* b79bd736e70 enable serial debug on hp elite 8200 sff 
* b109617752f enable the serial console on thinkpad x60 
* 0c7fb21a062 enable the serial console on thinkpad t60 
* eb14a176bc8 Only boot 32-bit u-boot from grub, 64 from seabios 
* 279e69172f7 make the u-boot grub menuentry more useful 
* fdbdf0449b3 Re-enable U-Boot x86 on real motherboards 
* b549d1e5f38 u-boot x86 serial/ns16550: disable UART as needed 
* eba73c778a8 Disable U-Boot x86 except on Qemu 
* 4bc6ca545e7 fix U-Boot hotkey mention in grub.cfg 
* 6d629a8496c Update x86 U-Boot to v2024.10 (was v2024.07) 
* 709bbebdcf2 grub.cfg: mark U-Boot as experimental in the menu 
* 637c0a1521a trees: unset CROSS_COMPILE per target 
* f13819386bf Enable x86 U-Boot payload on every x86 board 
* 747b6514eaf Add U-Boot x86_64 payload 
* 3bf3ef557e4 add arm-none-eabi-gcc-cs-c++ to fedora dependency 
* 2deab8572db clean up the coreboot submodules 
* 9abddb82b92 Bump coreboot/next and merge coreboot/dell7 
* 8c4cacba27c data/coreboot: add missing variable 
* cdd8cb9086f coreboot/default: remove unnecessary module 
* c0017c73578 Experimental U-Boot payload (32-bit dtb, U-Boot) 
* 14b4838d495 coreboot/default: Re-base all patches 
* 67c92889a86 NEW MAINBOARD: Dell OptiPlex 780 USFF 
* 38006cb2bc0 coreboot/dell3050micro: enable coffeelake CPUs 
* 97054498e94 NEW MAINBOARD: Dell OptiPlex 780 MT 
* f3170fb06eb coreboot/dell7: add missing ifdtool nuke patch 
* 19795bf980e re-update seabios to latest revision 
* 9bdec645a30 3050micro: Re-enable SeaGRUB 
*   6c78942290d Merge pull request 'config/coreboot/default: Update MEC5035 patches' (#244) from nic3-14159/lbmk:mec5035-updates into master 
|\  
| * b257662e55c config/coreboot/default: Update MEC5035 patches 
* | 237fa1e3c18 3050micro: don't set static option table 
* | d1743d1f647 3050micro: Use alt century byte +legacy 8254 timer 
* | c56f6987139 Use SeaBIOS 1.16.3 and enable debugging 
* | d8ac9d53b66 Switch Dell 3050 Micro to newer coreboot revision 
|/  
* 99a88ebfa20 Update dell 3050 patch to patch 15 (pwm fix) 
* 3f63c6d12f6 rom.sh: remove unnecessary logic from copyps1bios 
* 56495c61e6c use redundant mirrors for recent utils imports 
* 38d37a340fb remove end slashes on repos in config/git/ 
* 6eb2e98c0f0 import Riku's int tool 
* 441d21dc134 import Riku's gpio-scripts 
* e8957b0833a import Riku's mxmdump utility 
* 91a26ec3611 bump seabios 
* 34f851742e1 vendor.sh: Don't use x_ for image MAC address mod 
* c7a3a607f3d bump flashprog revision to d128a0a 
* 3b92b7b7236 vendor.sh: Handle error status on RUNME.sh 
* 147e0343416 dependencies/fedora40: add python3-devel 
```

This accounts for 79 changes made, relative to Libreboot 20241008. Many changes
were intentionally delayed because this is to be a stable release. A lot of new
work will now go into the next testing release, which is scheduled for the
latter part of January 2025 or early February 2025.

If you spot any issues in the Libreboot 20241206 release, please do get in
contact with the Libreboot project. We appreciate any and all help. Thank you
for reading, and have a wonderful day!

Revisions
=========

Several revisions have been made to this release, since the original release.
With stable releases, it's normal to make such revisions, when critical bugs
are discovered, or desirable changes are otherwise identified.

When these changes are made, the release is re-compiled, with the newly amended
binaries and sources re-uploaded, replacing what was there before. Individual
patch files are also provided, so that you can (using them as reference) revert
the source archive back to previous revisions.

Please see: [Libreboot 20241206 release revisions](libreboot20241206.Revisions.md)

Many revisions are planned in the run-up to next year's stable release ETA Summer
of 2025. In particular, there is much work that still needs to be done on the
U-Boot payloads (x86 and ARM64).
