% Libreboot 25.04 "Corny Calamity" released!
% Leah Rowe
% 30 April 2025

A corresponding [Canoeboot 25.04](https://canoeboot.org/news/canoeboot2504.html)
release is also available.

Today's Libreboot 25.04 revision is a *testing release*, whereas the previous
stable release was Libreboot 20241206. The codename for this release
is *Corny Calamity*. This is the first release to have a codename, and it is
using YY.MM format for the version number for the first time. Older releases
used YYYYMMDD as release dates.

<img tabindex=1 class="r" src="https://av.libreboot.org/t480/t480.jpg" /><span class="f"><img src="https://av.libreboot.org/t480/t480.jpg" /></span>

This release was built on the latest Debian 12.10 Bookworm release, as of
this day. It was also build-tested successfully on Debian Sid as of this
day, *with the experimental repository enabled and lbmk dependencies installed
from the experimental repository, including the recent GCC 15 toolchain*.
It was also tested on Fedora 42. Many fixes were made, so that it builds on the
most bleeding edge distros, and all the popular stable distros.

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](../docs/install/ivy_has_common.md), OR
YOU MAY BRICK YOUR MACHINE!! - Please click the link and follow the instructions
there, before flashing. For posterity,
[here is the link again](../docs/install/ivy_has_common.md).**

New schedule and version numbers
-------------------------------

This change in version release scheme was previously reported in the news
post announcing Libreboot's new [formal release schedule](schedule.md). As per
that article, the next stable release will be Libreboot 25.06, in June 2025.

Regarding the changelog
--------------------

A lot has happened since Libreboot 20241206, released in December 2024. Although
several revisions were made to that release in recent months, *this* new
release changelog is relative to the *original* December 2024 release, so some
of these changes were also included in 20241206 revision releases.

Open source BIOS/UEFI firmware
----------------------------

<img tabindex=1 class="r" src="https://av.libreboot.org/hp9470m/grub.jpg" /><span class="f"><img src="https://av.libreboot.org/hp9470m/grub.jpg" /></span>

Libreboot is a free/open source BIOS/UEFI replacement on x86 and ARM, providing
boot firmware that initialises the hardware in your computer, to then load an
operating system (e.g. Linux/BSD). It is specifically
a *[coreboot distribution](../docs/maintain/)*,
in the same way that Debian is a Linux distribution. It provides an automated
build system to produce coreboot ROM images with a variety of payloads such as
GRUB or SeaBIOS, with regular well-tested releases to make coreboot as easy
to use as possible for non-technical users. From a project management perspective,
this works in *exactly* the same way as a Linux distro, providing a source-based
package manager (called lbmk) which patches sources and compiles coreboot images.
It makes use of [coreboot](https://www.coreboot.org/) for hardware initialisation,
and then a payload such as [SeaBIOS](https://www.seabios.org/SeaBIOS)
or GRUB to boot your operating
system; on ARM(chromebooks) and certain x86 mainboards, we provide *U-Boot* (as
a coreboot payload), which provides a lightweight UEFI implementation..

Summarised list of changes
-------------------------

### Board support

The following boards have been added since the Libreboot 20241206 release:

* Acer Q45T-AM support added (similar to G43T-AM3 mainboard)

G43T-AM3 and Q45T-AM were also changed to a descriptor-based setup, with
full GbE region and correct 4MB ROM size, so for example ethernet should
work fine now.

### Revision updates

<img tabindex=1 class="r" src="https://av.libreboot.org/thinkpadcollection/thinkpadcollection1-min.jpg" /><span class="f"><img src="https://av.libreboot.org/thinkpadcollection/thinkpadcollection1-min.jpg" /></span>

In descending order from latest changes to earliest changes:

* Bump SeaBIOS to to rev 9029a010, 4 March 2025
* Updated Untitled to newer LBSSG repository.
* Bump flashprog to rev e060018 (1 March 2025)
* Bump U-Boot on ARM64 boards to U-Boot v2025.04. Patching courtesy of
  Alper Nebi Yasak.
* Bump uefitool to rev a072527, 26 Apr 2025 to fix CMake compatibility issue
  since CMake 4 no longer supports version 3.5, whereas the old uefitool had
  an earlier version as the minimum supported. This fixed a minor build error.
* Merged coreboot/next with coreboot/default
* Bump coreboot/next to rev c247f62749b as of 20 April 2025
* Bump coreboot/default to rev c247f62749b as of 20 April 2025
* Bump GRUB to rev a4da71daf (20 April 2025)
* Bump flashprog to revision eb2c041 (14 Nov 2024).

The GRUB revision includes a number of critical CVE fixes, and regression
fixes, that were also included in Libreboot 20241206 rev11.

The NASM version was updated to version 2.16.03 on coreboot/fam15h, to prevent
build errors, instead of fixing the old NASM 2.14.02. Tested on Debian Sid
Experimental, with GCC15-based toolchain, and on Fedora 42.

PICO support: Reverted to the old pico serprog/sdk repositories used
in Libreboot 20240612. This is temporary, because pico2 support is currently
broken, so this release only has pico1 support, when dealing with Rpi Pico
devices. Upstream pico-serprog works fine on pico2, so this will be fixed
in and re-updated again in a future revision release. The pico2 update images
were retroactively removed from the 20241206 release on rsync.

A patch from upstream was backported to the old pico-sdk version, so that it
builds correctly on newer GCC15 (tested on Debian Sid with "Experimental"
packages enabled).

### Licensing

<img tabindex=1 class="r" src="https://av.libreboot.org/hp8460p/hp8460p.webp" /><span class="f"><img src="https://av.libreboot.org/hp8460p/hp8460p.webp" /></span>

* Added SPDX license headers to almost every configuration file in lbmk.

### Security

These can be considered bug fixes, but these are special fixes that are of
massive concern to users.

* Merged *73* critical CVE fixes into the GNU GRUB source code, from upstream.
* Stricter use of pledge and unveil in the nvmutil source code.
* *Much* safer `./mk inject`. It used to be that the tarballs were extracted
  and files inserted into the extracted images, but the tarballs were left
  unmodified; many users thought then that they should extract the tarball
  and flash that, which lead to bricks. And it was easy to flash uninjected
  images, where files (e.g. Intel ME) are needed, so now ROM images are padded
  by one byte, to prevent flashing, and the user is strongly reminded to
  inject files first; upon running the `./mk inject` commands, these images
  are then safe to flash.
* Fix globbing issues in lbmk by double-quoting variables everywhere, and
  generally making sure that certain characters are escaped properly when
  necessary. To reduce the chance of bad commands being run by mistake or
  intentionally.
* Removed auto-confirm on `./mk dependencies` commands, to mitigate the risk
  of a buggy package manager on the user's distro possibly removing many
  packages. Now the user must confirm their choice, e.g. when a conflict
  occurs, instead of the package manager already deciding for the user.
* ThinkPad T480 / OptiPlex 3050: Disable HyperThreading/SMT by default, for
  security, to reduce the attack vector of certain speculative execution-based
  exploits.

### Feature changes

<img tabindex=1 class="r" src="https://av.libreboot.org/hp8200sff/grub_open.jpg" /><span class="f"><img src="https://av.libreboot.org/hp8200sff/grub_open.jpg" /></span>

In descending order from latest changes to earliest changes:

* `init.sh`: More verbose error info, on non-zero exits.
* `util/nvmutil`: Within each 4KB part, only handle 4KB, even if the block
  size is bigger. This means using less memory, and modification of anything
  past 4KB is not required.
* `util/nvmutil`: Support 16KB and 128KB GbE files, in addition to the
  usual 8KB files. The size is based on the block size of the flash you use.
* Added non-root USB3 hub support to GRUB on the xHCI implementation, courtesy
  of a patch from Nitrokey.
* GRUB: Scan LUKS inside *every* LVM, to support the uncommon use case where
  LUKS is inside LVM, instead of LVM inside LUKS. It is theoretically possible,
  even if ill advised.
* GRUB: Scan *every* LVM device, where available, as a fallback at boot time
  when all else fails.
* Release ROMs prefixed with a "DO NOT FLASH" warning and padded by one byte,
  where vendor files are required. The `./mk inject` commands remove this
  prefix/padding, after vendor files are inserted and checksums verified.
* Better detecting of whether vendor files are needed, and confirmation to
  the user while running `./mk inject` commands.
* Allow restoring the default MAC address on `./mk inject` commands, by using
  the `setmac restore` arguments.
* Randomise the MAC address by default, where applicable, when running
  the `./mk inject` commands, because lots of users previously flashed without
  changing it, so lots of users had generic MAC addresses.
  The `setmac keep` argument prevents this from happening, where desired.
* `include/vendor.sh`: More user-friendly debug messages, for the user to
  know what's going on.
* `util/nvmutil`: Add uninstall command to the Makefile
* `util/nvmutil`: Add distclean command to the Makefile
* `util/nvmutil`: Nicer hexdump display, similar to `hexdump -C`.
* Support a `re` argument in `./mk dependencies` Fedora commands, for
  re-installation of packages as desired.
* Support `--reinstall` in the `./mk dependencies debian` command, when the
  user wants to re-install dependencies.
* Put temporary `PATH` directory in the normal `XBMK_CACHE` directory, and
  clear it whenever a new parent instance of the build system is executed.
  This is used for the GCC/GNAT matched symlinks, for example, or the python
  symlink created at startup.
* Pico 2 support briefly added, but was a bit buggy for now, so it's removed
  in this release, and was retroactively removed in rsync for the
  Libreboot 20241206 release; this will be re-added in a future release.
* Added GRUB-first payload setups as an option, but not enabled by default.
  The user can add `payload_grubsea="y"` in the `target.cfg` file for a given
  mainboard.
* Support automatically downloading Lenovo ThunderBolt firmware for the
  ThinkPad T480, automatically padding it for installation. This update fixes
  a charging bug that affected some earlier launch models.
* Insert GRUB backgrounds in CBFS instead of GRUB memdisk, which makes
  GRUB background images easier to replace.

### Configuration changes

<img tabindex=1 class="r" src="https://av.libreboot.org/rpi_pico/soic16_x200.webp" /><span class="f"><img src="https://av.libreboot.org/rpi_pico/soic16_x200.webp" /></span>

In descending order from the latest changes to the earliest changes:

* T480/3050micro: Removed the `fsp` targets, because we only need
  the `vfsp` targets.
* Added `gnutls-devel` to Fedora 41 dependencies.
* Added `libx86` to Arch dependencies, needed for the `int` utility.
* Added `less` to Arch dependencies, because it's needed for certain commands
  e.g. git commands.
* GRUB: Use the codeberg mirror first, to mitigate GNU mirrors often being
  slow or rate limited, e.g. for gnulib downloads.
* fedora41/dependencies: add libuuid-devel
* Added `uuid-devel` to fedora41 dependencies
* flashprog: Disable `-Werror` to prevent minor warnings being treated as errors.

### Bug fixes

<img tabindex=1 class="r" src="https://av.libreboot.org/rpi/wson8/0003.jpg" /><span class="f"><img src="https://av.libreboot.org/rpi/wson8/0003.jpg" /></span>

The following bug fixes have been merged (in descending order from the latest
changes to the earliest changes):

* coreboot (all trees): Added patch fixing GMP build errors on modern
  GCC15 hostcc.
* coreboot (all trees): Fixed building of crossgcc with newer GCC15. Patches
  courtesy of Alper Nebi Yasak.
* coreboot (all trees): Added a patch to fix building coreboot utils with
  newer GCC15.
* dependencies/debian: Fixed the libusb package name for newer Debian releases,
  courtesy of Alper Nebi Yasak.
* SeaBIOS: Fixed `malloc_fn` function pointers in the `romfile` patch, courtesy
  of Alper Nebi Yasak. Fix build errors on GCC 15.
* `include/lib.sh`: Force use of System Python e.g. `/usr/bin/python`, when
  a python venv is detected. This prevents the build system from hanging.
* coreboot `g43t_am3`: Fixed the `data.vbt` path.
* Alper Nebi Yasak fixed the Python 2/3 detection in some edge cases when
  the `python` command is python2.
* `include/lib.sh` (later `init.sh`): Do root check *first*, right after
  the dependencies check, whereas it previously did the python check before
  checking for root user.
* lbmk: Don't use TMPDIR directly, use another variable containing its value,
  and make sure it doesn't get changed wrongly. This reduces the possibility
  of accidentally leaving old tmp files laying around.
* `include/lib.sh`: `tar` commands now return an exit with error, if a fault
  occurs, whereas it didn't before, due to piped output. This is done
  using the `x_` wrapper on tar commands, to provide error exits.
* `mk`: function `check_project_hashes` now returns an error, if the sha512sum
  command fails. It previously didn't, due to piped outputs. It's now mitigated
  by using `x_` on piped commands, for error exits.
* Forking of lbmk parent instance to child instance isno longer handled by
  variables. It's been simplified, to only be based on whether TMPDIR is set,
  and it's generally more robust now in this release. The old code sometimes
  broke under certain edge cases.
* `include/vendor.sh` (later renaming to `inject.sh`): General code cleanup,
  about 100 sloc removed without reducing features.
* lbmk: Initialise `PATH` to a standard string if not set, on the parent
  instance of lbmk.
* lbmk: Use `pwd` instead of the `PWD` variable, resetting the latter safely
  as lbmk runs. This prevents lbmk from changing directory to an erroneous
  system path, if `PWD` wasn't properly set for some reason. This is a
  preventative bug fix, because no actual issue ever occured in practise.
* Much safer Python version check at lbmk startup, using data structures that
  are provided universally by all Python implementations, instead of
  relying on the output of `--version`.
* Fixed T480 backlight controls, courtesy of a patch from Mate Kukri.
* Set up Python in `PATH` when lbmk starts, to ensure that it is always
  version 3. This is checked at startup.
* `include/vendor.sh`: Prevent double-nuke, where a given tarball already had
  vendor files removed prior to release.
* `include/vendor.sh`: Allow setting a MAC address even if vendor files aren't
  needed.
* `include/vendor.sh`: Download utils even if `vcfg` is not set, in case the
  user is also setting a MAC address.
* `util/nvmutil`: Honour the `INSTALL` variable, if set by the user, otherwise
  it is set to `install` by default.
* `util/nvmutil`: Don't do `clean` when running `uninstall`.
* `util/nvmutil`: Proper DESTDIR/PREFIX handling, whereas it was not handled
  properly at all before.
* `util/nvmutil`: Only set CC/CFLAGS if unset, and use sensible defaults.
* Fixed various shellcheck errors in lbmk.
* HP EliteBook 820 G2: Fixed vendor file insertion and set `release=y`. The
  insertion of Intel MRC and refcode previously didn't pass checksum validation.
* ThinkPad T480 / OptiPlex 3050: Force power-off state upon recovery from
  power loss, otherwise the system always turns on as soon as a charger is
  plugged in. This is configured by hardcoding, due to a current lack of any
  option table on the T480.
* Debian dependencies: replace liblz4-tool with lz4 and liblz4-dev. The latter
  is also available in Debian Trixie and Sid, at this time, in addition to
  Debian Bookworm, so it works on all of them.
* U-Boot (x86): Fixed a bug since Swig 4.3.0 changed the syntax for its
  language-specific AppendOut functions. A patch from upstream was backported,
  and the patch is also compatible with older versions of Swig.
* In lbmk scripts, use `command -v` instead of `which`, to find the locations
  of certain binaries. This is a bug fix, since `which` is non-standard and
  so could break on some setups.
* Crossgcc: when building it for coreboot, fix mismatching GCC/GNAT versions
  so that they match, if multiple versions are present. This was done because
  Debain Trixie initially had GCC 14 and GNAT 13, whereas we need GNAT to build
  the Intel video init code on  many mainboards.
* T480/T480: Disable TPM2 to mitigate a hang in SeaBIOS due to buggy drivers.
* `dependencies/debian`: Fix the `python3-distutils` package, renamed it
  to `python3-distutils-extra`, which works on bookworm *and* newer, but the
  former did not.
* `git.sh`: don't initialise the `livepull` variable globally, reset it per
  target instead, to prevent some repositories from being wrongly re-cloned.
* Thinkpad T480 / Dell OptiPlex 3050: Handle FSP insertion post-release, rather
  than providing FSP images directly in release images. It is now handled by
  the `./mk inject` command, copying the reference image from coreboot and
  splitting it upp and rebasing it, to mitigate certain technicalities of
  Intel's FSP license, which otherwise permits free redistribution.
* Safer, more reliable exit when handling vendor files, because in some cases
  lbmk was leaving the `lock` file in place (erroneously).
* Safer exit when running the `./mk dependencies` commands, so that lbmk is
  more likely to exit, because it was theoretically possible that it might
  not under certain edge cases.
* Disable nvme hotplug on Dell OptiPlex 3050 Micro, to prevent replugging in
  Linux, which would otherwise lead to possible data corruption.
* T480: Fix coreboot SPD size to 512 instead of 256 (it was already
  auto-corrected to 512 at build time, but the original configs were 256 which
  is wrong).
* Add tarballs and gpg signatures to `.gitignore`

### General code cleanup

<img tabindex=1 class="r" src="https://av.libreboot.org/rpi/wson8/0007.jpg" /><span class="f"><img src="https://av.libreboot.org/rpi/wson8/0007.jpg" /></span>

A large audit has been conducted, removing a lot of dead code in the build
system and improving the code quality considerably. Not all of such cleanup
changes are listed, because otherwise it'd overwhelm the changelog, and many
of the changes alone are quite pedantic, but together make a big change. You
can consult the Git log if you're more interested.

A lot of bloat was removed, but a *lot* of new features, especially  safety
features, were added, so the build system is *bigger*: lbmk has a sloccount
of *1507* source lines, in this release, versus 1145 in the 20241206 release.
However, this is with a slew of new features that are useful, including much
safer handling of vendor files, safer in that the risk of bricks is reduced.
This sloccount includes only the core shell scripts that comprise the build
system; there are millions of lines of code, between all the upstream sources
that lbmk imports, or otherwise depends on. lbmk is *[tiny](../docs/maintain/)*.

In descending order from the latest changes to the earliest changes:

* `init.sh`: Generally modularised it, moving separate tasks into separate
  functions, rathher than having it be one big monolith.
* `vendor.sh` was renamed to `inject.sh`, so that future changes can be
  in better sync between lbmk and cbmk on this file, because the cbmk version
  has the MAC address changer (but no vendorfile handling). In the future,
  this will be split so that `vendor.sh` exists again, containing only the
  vendorfile handling, and `inject.sh` will only handle MAC addresses.
* `init.sh`: Several variables were moved out of this file and elsewwhere in
  lbmk.
* Moved the `singletree` function to `git.sh` instead of `lib.sh`
* Moved the `cbfs` function from `lib.sh` to `rom.sh`.
* `include/lib.sh`: Use a more top-down function order, more clear, and it was
  split into an extra file `init.sh` that does the most basic lbmk initialisation
  at startup, whereas what remains in `lib.sh` really are generic library
  functions used throughout lbmk.
* `include/git.sh`: Removed unused crossgcc linking feature, because we don't
  use it anymore (coreboot trees have their own crossgcc and never link to
  another these days). Libreboot used to have many more coreboot trees, some
  of which re-used crossgcc from another tree. Similarly, the accompanying
  variable `tree_depend` is no longer handled. The `xtree` variable is still
  handled, because projects like U-Boot use that to configure crossgcc.
* include/vendor.sh: Removed unnecessary check against the ROM image size.
  Generally simplified the processing of release images.
* include/git.sh`: Removed many redundant functions, merging several of them.
* `include/mrc.sh`: Fixed a bad print, making proper use of a string inside
  a printf statement.
* Simplified many file checks in lbmk, by using the `e` function.
* Removed a bunch of useless `eval` commands in general, throughout lbmk,
  making the code much cleaner.
* lbmk: the `x_` function is now used much more aggressively, for error
  handling, simplifying error handling in lbmk overall.
* `mk` main script: Merged the `trees` script with it, so now it's all one
  script. The `mk` script is now the only executable script in lbmk.
* `mk` (main script): The `roms` command is removed (legacy / obsolete).
* The version/versiondate files are now dotfiles, to hide during operation.
* `include/lib.sh`: Hardcoded projectname/projectsite variables, instead
  of storing them in a file.
* `trees` script: Unified handling of flags (same string used in error output),
  to ensure that error(usage) messages always match.
* `trees` script (later merged into `mk`): Removed a lot of old bloat.
* `util/nvmutil`: Make the checksum word position a define. Generally cleaned
  up a lot of code to make it clearer for the reader. Added more verbose
  messages to the user, confirming things such as how much was read or written
  on the user's file system. Various miscallaneous bug fixes (edge cases that
  were unlikely to ever be triggered).
* `util/nvmutil`: More efficient use of memory when handling files.
* `util/nvmutil`: Much cleaner handling of user input.
* `util/nvmutil: More granular MAC address parsing errors, easy for debugging.
* `util/nvmutil`: Make the Gbe Checksum a define, for readibility.
* `util/nvmutil`: Obey the 79-character-per-line limit, as per lbmk coding
  style.
* `util/nvmutil`: Tidied up several pledge calls
* Removed use of several unnecessary subshells and `eval` statements in lbmk.
* `trees`: Later, the GCC/GNAT matching feature was rewritten to work both ways,
  where an older GCC was matched to GNAT and vice versa, whereas it previously
  only went one way. `gcc` and `gnat` are manipulated in `PATH` to ensure that
  the user has a consistent version of both.
* `path.sh` later merged into the `trees` script (which later merged
  into the main `mk` script). This `path.sh` is what contained the first
  implementation of the GNAT/GCC version matching feature.
* `path.sh`: Remove unnecessary shebang, and the same on other `include/`
  scripts. NOTE: `path.sh` was later merged into `lib.sh`, which then became
  split into `init.sh` in later changes (see above).
* Removed legacy build system commands e.g. `./build` and `./update`; now
  only the newer `./mk` commands are supported. This and the change below was
  briefly reverted, for the 20241206 revisions, but then re-introduced in
  preparation for this Libreboot 25.04 release.
* Removed the deprecated `./vendor` command; now only `./mk` commands are
  used. The `./mk -d coreboot target` commands are used, for downloading
  vendor files.
* Removed unused patch that was for the original deguard implementation,
  prior to Mate Kukri's re-write of it.

Git log
-------

This log is relative to Libreboot 20241206:

```
* 4f77125066d coreboot/fam15h: update submodule for nasm 
* 0f2202554ab coreboot/fam15h: update nasm to 2.16.03 
* 2009c26f0aa serprog: Remove pico2 support for the time being 
* a08b8d94fc5 seabios: bump to rev 9029a010, 4 March 2025 
* 342eca6f3d1 update untitled 
* b0a6d4711a3 coreboot413: add alper's fix to cbfstool for gcc15 
* 628ae867c9a flashprog: bump to rev e060018 (1 March 2025) 
* 5e96db5a2b4 further gcc-15 fix for gmp on -std=23 
* 9a9cd26b2d5 coreboot/default and fam15h: gmp fix, gcc15 hostcc 
* 80007223c85 lib.sh: Provide printf for mktarball 
*   a16c483e5fd Merge pull request 'coreboot: fam15h: Add patches to fix build with GCC 15 as host compiler' (#318) from alpernebbi/lbmk:coreboot-fam15h-gcc15 into master 
|\  
| * 685685ab0e4 coreboot: fam15h: Add patches to fix build with GCC 15 as host compiler 
|/  
*   02110f2bc1d Merge pull request 'coreboot: Add patch to fix build with GCC 15 as host compiler' (#317) from alpernebbi/lbmk:coreboot-gcc15-nonstring into master 
|\  
| * 5ad1de3931a coreboot: Add patch to fix build with GCC 15 as host compiler 
|/  
*   9e7bceb7fa9 Merge pull request 'seabios: Fix malloc_fn function pointer in romfile patch' (#313) from alpernebbi/lbmk:seabios-romfile-malloc-fptr into master 
|\  
| * 35c853f8b33 seabios: Fix malloc_fn function pointer in romfile patch 
* |   686e136f150 Merge pull request 'dependencies/debian: Fix libusb package name' (#315) from alpernebbi/lbmk:debian-libusb-dependency into master 
|\ \  
| * | 6f120f01588 dependencies/debian: Fix libusb package name 
| |/  
* / d8b0e749983 init.sh: fix yet another double quote for dotfiles 
|/  
*   780844112ae Merge pull request 'Update U-Boot to v2025.10' (#305) from alpernebbi/lbmk:uboot-v2025.04 into master 
|\  
| * 1265927ca38 u-boot: gru: Disable INIT_SP_RELATIVE 
| * 5bea1fade9a u-boot: arm64: Expand our modified defconfigs to full configs 
| * fd56d8ada13 u-boot: arm64: Merge our modifications into new defconfigs 
| * ed9ddd7415f u-boot: arm64: Add new upstream defconfigs 
| * b1fa44858cb u-boot: arm64: Rebase to v2025.04 
| * 976fc6890ae u-boot: arm64: Save our modifications to the upstream defconfigs 
| * 418570a6172 u-boot: arm64: Turn configs into defconfigs 
|/  
* 093a86d9c09 init.sh: don't use eval to read version files 
* 3045079947b init.sh: use backslash for dotfiles in eval 
* da108d1c045 mk: Don't run mkhelpers if mode is set 
* 71a58a38ab4 mk: condense main() again 
* f3882b9bf21 init.sh: make git name/email error more useful 
* 9cebda333d5 init.sh: move git name/mail check to xbmk_git_init 
* ea081adc4ca init.sh: tidy up the git name/email check 
* 3292bded692 mk: make main() more readable 
* 97a5e3d15ed mk: move git check to init.sh xbmk_set_version 
* 11cd952060d init.sh: tidy up xbmk_init() 
* f6c5c8d396d mk: move git_init to init.sh 
* ec1c92238cc init.sh: minor cleanup 
* e009f09e7fa init.sh: clean up setvars 
* 9ec72153408 init.sh setvars: make err a printf for eval 
* 18ad654a1f7 init.sh: merge xbmk_child_init with xbmk_init 
* 15268202478 init.sh: split xbmk_child_init into functions 
* 0280cd4c0e7 init.sh: move parent fork to new function 
* a0e1d42ff74 init.sh: Provide more complete error info 
* a8f0623efbb update uefitool to rev a072527, 26 Apr 2025 
* c698972130f rename include/vendor.sh to inject.sh 
* 24e488aae56 lib.sh: move _ua to the xbmkget function 
* 6779d3f9915 move variables out of init.sh to others 
* 848159fa0eb lib.sh: rename vendor_checksum 
* 1de77c6558c lib.sh: move singletree() to git.sh 
* 703fe444312 lib.sh: move cbfs() to rom.sh 
* b57952e90d2 re-split include/init.sh to lib.sh 
* 8ecb62c6628 rename include/lib.sh to init.sh 
* ce4381169fa lib.sh: introduce more top-down function order 
* 15b64cfebe8 mk/git.sh: remove tree_depend variable 
* 9b8179c0e5d git.sh: remove unused xgcc linking feature 
* 4624c6e536c mk: remove unused variables (ser/xp) 
* aba5b3a3532 mk: simplify main() 
* 0ab7c6ff9cf lib.sh: use realpath to get sys python on venv 
* 8edea026c58 lib.sh: Force use of System Python to prevent hang 
* b1b964fa5c3 lib.sh: further condense the python check 
* 9543a325acb lib.sh: further simplify the python check 
* 9baabed7186 lib.sh: condense the python check 
* 0c5c5ffc873 lib.sh: simplify mk() 
* 83022b6ba83 lib.sh: simplify cbfs() 
* 13ad839691d lib.sh: simplify the python check 
* b1ea4165754 mk: remove mkhelp() and use x_() instead 
* 4cf64e59ed0 mk: simplify handling of trees() 
* d0581914c74 coreboot/hp8300cmt: purge xhci_overcurrent_mapping 
* cb52fc4ba82 Fix VBT path on HP Elite desktops 
* 2bee87cfc26 lib.sh: add missing copyright year 
* 4b7ab403c65 ifd/q45t_am: unlock regions by default 
* 564155277ea coreboot/g43t_am3: use ifd-based setup 
* 0ddd1963751 coreboot/q45t_am3: use ifd-based setup 
* 3b2d933842a coreboot/default: add missing submodules 
* a10d81399c7 NEW MAINBOARD: Acer Q45T-AM (G43T-AM3 variant) 
* d114e0a765c mk: don't print confirmation of git pkg.cfg 
* f59c24f12aa coreboot/g43t_am3: fix data.vbt path 
* 21020fa319a add missing config/data/coreboot/0 
*   2b4629d790b Merge pull request 'lib.sh: Fix python3 detection when 'python' is python2' (#290) from alpernebbi/lbmk:python3-detection-fix into master 
|\  
| * a18d287a81e lib.sh: Fix python3 detection when 'python' is python2 
|/  
* c7569a67145 coreboot/next: merge with coreboot/default 
* 762c7ff43eb coreboot/default: Update, c247f62749b (8 Feb 2025) 
* 86e7aa80c51 Update the GRUB revisions 
* 8d57bf6009e Revert "git.sh: minor cleanup" 
* a2898771f6e lib.sh: perform root check even earlier 
* 779f6003421 lib.sh: tidy up opening logic (put it together) 
* bac4be99c20 lib.sh: do root check before python check 
* e63d8dd20d9 git.sh: minor cleanup 
* 11078508a25 lib.sh: simplify mktarball() 
* 087bbedc5f8 vendor.sh: tidy up vendor_download() 
* e11fd52d958 mk: tidy up check_gnu_path() 
* 3442f4278ed mk: simplify check_project_hashes() 
* 6b6a0fa607c lib.sh: fix missing s/TMPDIR/xbmktmp 
* e07a2adb130 lbmk: don't handle TMPDIR directly 
* 9d3b52cd1d2 rom.sh: minor cleanup 
* b4402c54258 vendor.sh: yet even more code cleanup 
* fe5bdc7633d vendor.sh: even more cleanup 
* fcedb17a9a1 vendor.sh: more cleanup 
* 4e2b59ed3ff vendor.sh: minor cleanup 
* a3acf4c3f95 vendor.sh: simplify process_release_roms 
* 30213a96883 vendor.sh: remove unnecessary check 
* 38df7275f12 git.sh: remove unnecessary comment 
* f5891fb6991 git.sh: remove link_crossgcc() 
* a685654b90f git.sh: remove move_repo() 
* e4aa62f79a8 git.sh: remove prep_submodule() 
* 2839feb9e43 git.sh: make git_prep command clearer 
* 410fa702c9c mrc.sh: Make proper use of variable inside printf 
* 075902c3ea7 simplify a few file checks 
* b2255425eba rom.sh: remove unnecessary check 
* 39640d76a75 lbmk: minor cleanup 
* c8dc701f3eb lib.sh mktarball: stricter tar error handling 
* 58a53d7046f vendor.sh: don't err on bruteforce me extract 
* 958fa34832a mk check_project_hashes: handle error on sha512sum 
* 8b4b069e3f6 vendor.sh: remove unnecessary xchanged="y" 
* 166dbb04c92 vendor.sh: set need_files="n" if skipping patch 
* e90657cc734 vendor.sh: Don't handle vendor files if not needed 
* 2e10a45fa36 Revert "lib.sh: use eval for the command in x_" 
* 738d4bb6b6d lib.sh: fix bad eval writing resized file 
* eb9e5d2d5d4 lib.sh: fix bad eval writing version/versiondate 
* 3bfdecdc75b lib.sh: use eval for the command in x_ 
* 4fa3bb9e5b1 mk: use eval to run mkhelp commands 
* 9b3635718a8 mk: tidy up the switch/case block in main() 
* 0c381028abc mk: tidier error handling 
* 023f9cf0498 lib.sh: tidy up the error handling 
* cb3253befb9 rom.sh: tidy up error handling 
* 7af46721bcb vendor.sh: tidy up error handling 
* 04ebb3b91a0 vendor.sh: tidy up decat_fspfd() 
* 0c87fdf96ad git.sh: clean up fetch_project() 
* 9eb8856b3c5 mk: Remove unnecessary argument checks on trees() 
* 52f3d54116f vendor.sh: properly call err_ in fail_inject 
* c4c6692b761 remove xbmk_parent, handle forking in lib.sh 
* fd5431db05d lib.sh: define x_ right after err_ 
* 972681a127b mk: minor cleanup 
* b41cd39b686 lib.sh: minor cleanup 
* 49939502648 mrc.sh: minor cleanup 
* c158d82298b rom.sh: minor cleanup 
* cb36248c8c0 vendor.sh: tidy up check_release() 
* 409cab39c56 vendor.sh: tidy up vendor_inject() 
* 12b1623e473 vendor.sh: tidy up readcfg() 
* 0d85f061e2e vendor.sh: tidy up patch_release_roms() 
* 61f20141028 vendor.sh: tidy up process_release_roms() 
* 5901f36e49d vendor.sh: tidy up patch_rom() 
* 082930ce0e7 vendor.sh: tidy up inject() 
* e1f91f30372 vendor.sh: tidy up modify_mac_addresses() 
* 3181ac50126 script/trees: merge with mk and delete script/ 
* 3d03dd1a507 mk: remove the legacy "roms" command 
* f0c629dcc6c lib.sh: write version/versiondate to dotfiles 
* 23b942c83e9 lib.sh: hardcode projectname/projectsite 
* a03bb793aea remove update/vendor symlinks 
* d7f80ebe71e move build to mk 
* 57d58527fd0 trees: unify the execution of mkhelper commands 
* e5262da4be7 trees: tidy up configure_project() 
* 51798278397 build: make coreboot building an else in "roms" 
* c189257888a trees: don't build dependencies if dry=":" 
* 115a66fddd3 trees: unified handling of flags 
* 3ea633cc791 trees: simplified handling of badhash/do_make 
* 9be40e94a2b trees: don't set mode on ./mk -b 
* 67ad7c2635c trees: don't set mod on ./mk -d 
* 24448948419 trees: don't initialise mode to "all" 
* 97c50a39a60 trees: clean up some comments 
* cfb14fd8dd8 vendor.sh: simplified readkconfig() 
* 5b697b93a2d lib.sh: double-quote pwd to prevent globbing 
* 5a0a24f5559 lbmk: unified PWD handling (work directory) 
* a25a29cfbb7 lib.sh: initialise PATH if it's unset 
* 1022abf6991 move XBMKPATH to include/lib.sh 
* 0764c969a29 lbmk: use pwd util, not PWD environmental variable 
* f98b9b01107 clean up a few semicolons in the build system 
* 8ccb61cc718 trees: err if first argument is not a flag 
* 947c3e1a176 trees: err if no argument given 
* edbbde0b12d trees: set dry=":" on ./mk -f 
* 33bb0ecf764 trees: clean up initialisation of the dry variable 
* c7636ff1dfc trees: initialise mode to "all", not "" 
* d0bd12631a6 trees: don't abuse the mode variable on -f 
* c4cd876c609 trees: Add missing flag to error output 
* 5ebcae5235f lbmk: minor code formatting cleanup 
* 70cef71dbab grub/xhci: Remove unused patch 
* 3f14a470a2e remove _fsp targets (keep _vfsp) 
* d7312260e7e util/nvmutil: remove excessive comments 
* e348ea0381a Bump GRUB revision to add 73 security patches 
*   4b228c11f9f Merge pull request 'Update pico-serprog revision' (#271) from Riku_V/lbmk:master into master 
|\  
| * a8359e30b27 Update pico-serprog revision 
|/  
* d2cb954933b util/nvmutil: Fix bad error messages on R/W 
* e1e515bd22a util/nvmutil: hardened pledge on help output 
*   ada057a865c Merge pull request 'Simplify the README' (#269) from runxiyu/lbmk:readme-simplification into master 
|\  
| * 9ced146b47c README.md: Use newlines instead of bulleted list for docs/support links 
| * 266122592cd README.md: Use the EFF's page on Right to Repair 
| * e36aa8c5a5c README.md: Vastly simplify it 
| * c17f4381ce5 README.md: Mention SeaBIOS and U-Boot instead of Tianocore as payloads 
|/  
*   47eb049cb47 Merge pull request 'deps/arch: genisoimage belongs to cdrtools' (#267) from runxiyu/lbmk:master into master 
|\  
| * fa9a0df2458 deps/arch: genisoimage belongs to cdrtools 
|/  
* a98490573be util/nvmutil: only set mac_updated at the end 
* 6b9cf09ca21 restore old x230 gbe file 
* 8a435355135 util/nvmutil: Fix bad comparison 
* a65a0c2f963 util/nvmutil: allow ./nvm gbe MAC 
* 96356ce94f6 util/nvmutil: move "e" to swap() 
* b1d8975959d util/nvmutil: Only read up to 4KB on larger gbe 
* 6821659bcb2 util/nvmutil: fix minor mistake (line break) 
* 3bb7520f6d9 util/nvmutil: do setmac if only filename given 
* d94b274fd9f vendor.sh: don't error if grep -v fails 
* 6ebdd3c72ba vendor.sh: Don't show gbe filename on inject 
* a08748a9eda util/nvmutil: don't say write not needed if errno 
* 6841a351ebc util/nvmutil: print dump *after* modification 
* da0a6c216cf util/nvmutil: verbosely print the written MAC 
* db5879c6b5a util/nvmutil: minor cleanup in cmd_dump 
* bd7215d1eb7 util/nvmutil: show nvm words written on writeGbe 
* c70117c79c4 util/nvmutil: clean up readonly check on writeGbe 
* cf5a63e65ca util/nvmutil: Remove useless gbeFileChanged var 
* 83601aa524b util/nvmutil: reset errno if any MAC updated 
* 3e86bf5ce25 util/nvmutil: reset errno when writing a MAC 
* bcf53cc2cc0 util/nvmutil: show total number of bytes read 
* c91cc329cf8 util/nvmutil: rename tbw/bw to tnw/nw 
* 90607108330 util/nvmutil: err if bytes read lower than nf 
* c72f699d368 util/nvmutil: err if fewer bytes written 
* d666f67ebe5 util/nvmutil: Show bytes written in writeGbe 
* b2d6393ed5f util/nvmutil swap(): ensure that no overflow occurs 
* 063fef14d34 util/nvmutil: make swap() a bit clearer 
* fd1bbdc96cb util/nvmutil: make 0x3f checksum position a define 
* 5ddf7f251d6 util/nvmutil: make 128 (nvm area) a define 
* 8850acc7da6 util/nvmutil swap(): Only handle the nvm area 
* 49506a88328 util/nvmutil: move write checks to writeGbe 
* 948377b0e7e util/nvmutil: make cmd_swap its own function again 
* 6e134c9f4bf util/nvmutil: minor cleanup 
* 98e105ac4f1 util/nvmutil: allocate less memory for setchecksum 
* 52e8ea57f7b util/nvmutil: Further reduce memory usage 
* 7a7d356824e util/nvmutil: Remove unnecessary buf16 variable 
* cdf23975bc1 util/nvmutil: Only allocate needed memory for file 
* ed45da9cae5 util/nvmutil: Remove unnecessary buffer 
* ec3148dc3b5 util/nvmutil: Show specific error for bad cmd argc 
* 073420d3056 util/nvmutil: cleaner argument handling 
* a6c18734e70 util/nvmutil: extreme pledge/unveil hardening 
* deb307eaf63 util/nvmutil: more minor cleanup 
* c14eccaf153 util/nvmutil: more granular MAC parsing errors 
* 88fb9cc90ea util/nvmutil: more cleanup 
* 5aaf27f80c3 remove errant comment in nvmutil 
* c829b45c17c util/nvmutil: support 16kb and 128kb gbe files 
* a98ca5bf65c util/nvmutil: Prevent unveil allowing dir access 
* 68c32034a00 typo: nvme should say nvm in nvmutil.c 
* c944c2bbac7 util/nvmutil: General code cleanup 
* 8c65e64e398 snip 
* f666652fe15 snip 
* 64d3c7b5150 grub/xhci: Add xHCI non-root-hub fixes from Nitrokey 
* 7bf0d4c2ed5 add gnults-devel to fedora 41 dependencies 
* 66d084e7f7c grub.cfg: scan luks *inside lvm* 
* 5a3b0dab966 grub.cfg: Scan *every* LVM device 
* 3c9f4be76f6 Libreboot 20241206, 8th revision 
* d4cc94d6b44 rom.sh: don't run mkpicotool on dry builds 
* de6d2f556f1 pico-sdk: Import picotool as a dependency 
* 4210ee68ea2 lib.sh: Much safer python version check 
* 8c7ba6131cc coreboot/next uprev: Fix T480 backlight keys 
* 411fb697dfc set up python in PATH, ensuring that it is python3 
* e8336bcc3ca vendor.sh: Proper semantics on prefix file names 
* 63f45782638 vendor.sh: Confirm if need_files=n 
* 13b06ae130f vendor.sh: Allow restoring the default GbE file 
* ab8feff92e0 vendor.sh: set random MAC address *by default* 
* 0ceaa01d45d vendor.sh: add clarification to nogbe warning 
* 4d5caf1dcfc vendor.sh: check that the vcfg file exists 
* fc4ee88e167 vendor.sh: error out if nuking failed 
* 8819a93d89b add line break, part 3 
* 8ce1a00f517 add line break, part 2 
* bc2c14e76a8 add line break 
* c762850311a vendor.sh: prevent double-nuke 
* 68299ad05ca vendor.sh: much more verbose errors/confirmation 
* b8e6d12f3d9 add libx86 to arch dependencies 
* cf8ad497b4e vendor.sh: Remove unnecessary return 
* c858099b359 vendor.sh: Download utils even if vcfg unset 
* ce16856a242 vendor.sh: Allow setmac if vendorfiles not needed 
* 4b51787d078 add less to arch dependencies 
* 8bd028ec153 lib.sh: Set python after dependencies 
* 44b6df7c24c update my copyright years on modified scripts 
* 818f3d630c2 vendor.sh: Don't error if vcfg is unset 
* 432a1a5bca7 lib.sh: Fix unescaped quotes in chkvars() 
* a73b0fd910a Revert "fix more unescaped quotes in eval" 
* ec6bcc1fba5 fix more unescaped quotes in eval 
* 5284f20b981 fix ./mk dependencies build issue 
* d825f9a9683 rom.sh: Remove errant GRUB modules check 
* 4149f3dc81a submodule/grub: use codeberg for 1st gnulib mirror 
* 0305975e705 util/nvmutil: Update AUTHORS and COPYING files 
* 20b192e13bd util/nvmutil: Describe nvmutil in help output 
* d1ca21628cb util/nvmutil: Remove the correct binary on uninstall 
* e63fe256dfc util/spkmodem-recv: More correct Makefile 
* efd50ee548b util/nvmutil: Honour the INSTALL variable 
* 8008838abbc util/nvmutil: Don't clean when doing uninstall 
* 982f257f58a util/nvmutil: Proper DESTDIR/PREFIX handling 
* 3f85ae5f853 util/nvmutil: Set CC and CFLAGS only if unset 
* 2c7b9fb9412 util/nvmutil: Capitalise BABA 
* 57f9906f6d1 util/nvmutil: Add uninstall to Makefile 
* 4defe2c6085 util/nvmutil: Add distclean to Makefile 
* 033e4cd9d50 util/nvmutil: Make the GbE checksum a define 
* 874317c4e59 util/nvmutil: nicer hexdump display 
* a338e585eed util/nvmutil: show the correct hexdump order 
* b032e483ef1 lib.sh mktarball: cleaner if statement 
* 0cf58c22734 fix lbmk shellcheck errors 
* 8276560cc99 lib.sh and rom.sh: update my header 
* 08e86d2218c vendor.sh inject: reset err upon return 
* 41275d699ca vendor.sh: MUCH, MUCH, MUCH safer ./mk inject 
* ed7293494e3 util/nvmutil: Obey the 79-character per line limit 
* 637b5e36fd2 util/nvmutil: Tidy up copyright header 
* cd28db883e2 vendor.sh: fix comment 
* 57971ceb227 util/nvmutil: Fix another straggler 
* 15b37b2a1ab util/nvmutil: Tidy up pledge calls 
* e8799310db2 hp820g2: fix vendorfile inject and set release=y 
* f9ab082ec19 fedora41/dependencies: add libuuid-devel 
* 661591f9f0b add uuid-devel to fedora41 dependencies 
* 1a46c047386 support ./mk dependencies fedora reinstall 
* d58d63569f1 fix missing semicolon in grub nvme patch 
* 95ea3293df5 bump seabios to rev 1602647f1 (7 November 2024) 
* 6d7e6c361b3 Bump GRUB revision to 6811f6f09 (26 November 2024) 
* 09a01477df6 t480/3050micro: force power off post power failure 
* d344cd95eac flashprog: Disable -Werror 
* dc95e912bfe bump flashprog to revision eb2c041 (14 Nov 2024) 
* 27c8c1c16ba replace liblz4-tool with lz4 and liblz4-dev 
* d3a732a64db lib.sh dependencies: support --reinstall argument 
* 466ada423dd move xbmkpath to XBMK_CACHE/ 
* b0a23840327 Revert "Remove legacy update/vendor commands" 
* 3d7dd4aa9fe Fix U-Boot build issue with Swig 4.3.0 
* 0c810747469 use command -v instead of which 
* 6c7e3ce2d6e trees: remove unnecessary subshell 
* ad137eae89d trees: only symlink host gcc/gnat to build xgcc 
* cfb6de94c33 trees: correction on check_gnu_path 
* ec2f0716662 trees: match gcc/gnat versions both ways 
* f64b5996279 Merge path.sh into script/trees 
* 295463d281e path.sh: Further cleanup 
* 5b24e0a5a96 path.sh: More thorough gcc/gnat version check 
* 7849a075886 path.sh: minor cleanup 
* 17168a87dbf path.sh: remove unnecessary shebang 
* e565df94fd7 Fix globbing issue in lbmk 
* c80cc0a00b6 remove auto-confirm on distro dependencies 
* 01fc65a0a9d Mitigate Debian Trixie/Sid GCC/GNAT version mismatch 
* 424b0c7103b t480/3050micro: disable hyperthreading 
* 603105f3b4e t480/t480s: Disable TPM2 to mitigate SeaBIOS lag 
* 754bd1e6ca3 rom.sh: Name pico directory serprog_pico 
* db22308eba5 add 2024 to Riku's copyright header on rom.sh 
*   4fa5f696db8 Merge pull request 'rp2530' (#258) from Riku_V/lbmk:rp2530 into master 
|\  
| * a5e0360992d pico-sdk: update to 2.1.0 
| * e2f8cc7f3ee pico-serprog: enable building for multiple pico chips 
|/  
* ccc2b4d589f add spdx headers to dependencies configs 
* a3969701e6b dependencies/debian: fix debian sid 
* 8f370cb60d9 add spdx headers to various config files 
* d591ea4c5dc git.sh: don't initialise livepull globally 
* b5da9feba3b vendor.sh: Print useful message on ./mk inject 
* 12c6259cb2f vendor.sh: Handle FSP insertion post-release 
* 78132051462 Remove legacy update/vendor commands 
* 07037561bd6 lbmk: remove use of deprecated ./vendor command 
* 5d1f1823067 vendor.sh: Safer exit when vendorfiles not needed 
* a18175a5df9 data/deguard: Remove unused patch 
* ee8f53b96ff lib.sh: Safer exit from ./mk dependencies 
* a8b35c88cf1 remove geteltorito and mtools from lbmk 
* 1dd32ea5487 rom.sh: support grub-first setups 
* f7801ef4770 vendor.sh: delete old tb.bin first, just in case 
* 02cbf8a729d vendor.sh: make TBFW pad size configurable 
* 9884e5ed1b0 T480/T480S: Support fetching ThunderBolt firmware 
* 36b42dd1c11 also de-rainbow the u-boot menu 
* eafc82028a4 Revert "use rainbow deer on the grub background" 
* 44969c73bd2 rom.sh: insert grub background in cbfs not memdisk 
* 401efb24b22 use rainbow deer on the grub background 
* dc27cb91784 add some scripts to .gitignore 
* 3b6b283eabe disable 3050micro nvme hotplug 
* c2023921893 fix t480 spd size (512, not 256) 
* da527459b68 add tarballs and signatures to gitignore 
* b910424b5df fix another very stupid mistake 
* e3b77b132e6 fix the stupidest bug ever 
```

This is nearly *400* changes!

Revision releases
-----------------

When certain bugs are found, releases may be re-built and re-uploaded. When
this happens, the original release is replaced with a *revision release*.

### 25.04rev1 (1 May 2025)

A minor issue was found with AHCI initialisation on the ThinkPad T420, caused
by one of the seven new SeaBIOS patches merged in the release. The seven patches
are largely optional and inconsequential changes, for Libreboot users anyway,
so they have been reverted.

The AHCI bug was was caused on ThinkPad T420 by a patch that *resets* the
state of the AHCI controller, before enabling it, in SeaBIOS. This patch was
written by the author, to make SeaBIOS's AHCI driver work in CSM mode.

For this revision release, that patch is removed, but in Libreboot's master
branch, the SeaBIOS revision is once again up to date, including the seven
recently imported commits, but that version patches SeaBIOS to only apply
the change to AHCI behaviour if SeaBIOS is running as a CSM.

This `25.04rev1` release also contains a missing config for text-mode startup
on the ThinkPad T420.

It is possible that this AHCI issue may have been caused on other mainboards,
but we currently do not know. It is better to assume that all mainboards were
affected, so you should update to the rev1 release if you had the
original 25.04 release.

This revision release was committed to the `25.04_branch` branch, and any
further revision releases will be in the same branch.
