% August 2023: New coreboot, SeaBIOS and GRUB revisions in Libreboot (testers needed!)
% Leah Rowe
% 6 August 2023

Testing needed. I've already tested this update on a few boards myself, but the
more the merrier! I'm planning a new Libreboot release some time in the next
eight weeks or so; could be sooner, or could be a bit later. ETA somewhere
between late August to late September (perhaps early October) of this year; the
most recent stable release of Libreboot came out on 25 June 2023.

To receive these updates, you must use Git for now. See:
[how to download Libreboot from Git](../git.md)

Introduction
--------------

### SeaBIOS and GRUB updates

For *all* motherboards that provide GRUB or SeaBIOS revisions, new versions of
these payloads are now used in Libreboot, as implemented by these patches:

* GRUB is now on version 2.12-rc1 from 10 July 2023, where previously it was on
  a revision from 14 February 2023. Patch:
  <https://browse.libreboot.org/lbmk.git/commit/?id=27ee975e8676fa14d536219fb827cd64dfb5dc74>
* SeaBIOS is now on a revision from 30 May 2023, where previously it was on
  a 20 January 2023 revision. Patch:
  <https://browse.libreboot.org/lbmk.git/commit/?id=cb8bf380e9e4ab065f597b9ea643897caa4b6ccb>

### Coreboot update

The `default` cbtree is now based upon coreboot from 2 August 2023, where
previously it was based upon coreboot from 17 February 2023. Patch:
<https://browse.libreboot.org/lbmk.git/commit/?id=705149a3e089fb99e671a47b0acd3a30378dd659>

Of note: the HP 8300 USDT port is merged upstream, and included in this revision,
so Libreboot's patch for it is no longer needed, and has been removed (Libreboot
previously supported this board out of tree, but now it uses the upstream code).

This update affects the following build targets, in Libreboot's `lbmk` which is
the [automated build system](../docs/maintain/) used to produce releases:

`d510mo_16mb`, `d510mo`, `e6400_4mb`, `g43t-am3_16mb`, `g43t-am3`,
`ga-g41m-es2l`, `hp2560p_8mb`, `hp2570p_16mb`, `hp8200sff_4mb`, `hp8200sff_8mb`,
`hp8300usdt_16mb`, `hp9470m_16mb`, `macbook11_16mb`, `macbook11`,
`macbook21_16mb`, `macbook21`, `qemu_arm64_12mb`, `qemu_x86_12mb`, `r400_16mb`,
`r400_4mb`, `r400_8mb`, `r500_4mb`, `t400_16mb`, `t400_4mb`, `t400_8mb`,
`t420_8mb`, `t420s_8mb`, `t430_12mb`, `t440pmrc_12mb`, `t500_16mb`, `t500_4mb`,
`t500_8mb`, `t520_8mb`, `t530_12mb`, `t60_16mb_intelgpu`, `t60_intelgpu`,
`w500_16mb`, `w500_4mb`, `w500_8mb`, `w530_12mb`, `w541mrc_12mb`, `x200_16mb`,
`x200_4mb`, `x200_8mb`, `x220_8mb`, `x230_12mb`, `x230_16mb`, `x230edp_12mb`,
`x230t_12mb`, `x230t_16mb`, `x301_16mb`, `x301_4mb`, `x301_8mb`, `x60_16mb` and
`x60`.

This *only* affects the `default` coreboot tree used in Libreboot; the `haswell`
tree (libre MRC on T440p/W541), `cros` (gru chromebooks) and `fam15h` trees used
on KGPE-D16/KCMA-D8/KFSN4-DRE have not yet been updated.

Testing needed!
---------------

I want to get as much testing done now as possible, ready for the next release,
which will still be marked as a testing release anyway; the next stable release
is a long way off, as much new work is planned for Libreboot.

### Apply to become a tester

If you wish to provide such testing, please read the following page:

[Apply to become board maintainer/tester for Libreboot](../docs/maintain/testing.html)

If you can get coreboot logs, those will be useful. Email them to me or submit
them attached in issue reports on the bug tracker; if you have any issues, we
need to know. Coreboot tends to audit very carefully and updates are usually
smooth, but testing is one of Libreboot's main purposes, to provide stable
releases based on coreboot.

### How to download

To receive these updates, you must use Git for now. See:
[how to download Libreboot from Git](../git.md)

### Build from source

This update, since it is not yet available pre-compiled in a release, must be
compiled from source. See:

[How to compile Libreboot from source](../docs/build)

