/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.plugins.ide.idea.model.FilePath;
import org.gradle.plugins.ide.idea.model.ModuleLibrary;
import org.gradle.plugins.ide.idea.model.Path;

public class SingleEntryModuleLibrary
extends ModuleLibrary {
    private ModuleVersionIdentifier moduleVersion;

    public SingleEntryModuleLibrary(FilePath library, Set<FilePath> javadoc, Set<FilePath> source, String scope) {
        super(Collections.singletonList(library), javadoc, source, Lists.newArrayList(), scope);
    }

    public SingleEntryModuleLibrary(FilePath library, @Nullable FilePath javadoc, @Nullable FilePath source, String scope) {
        super(Collections.singletonList(library), (Collection<? extends Path>)(javadoc != null ? Collections.singletonList(javadoc) : Lists.newArrayList()), (Collection<? extends Path>)(source != null ? Collections.singletonList(source) : Lists.newArrayList()), Sets.newLinkedHashSet(), scope);
    }

    public SingleEntryModuleLibrary(FilePath library, String scope) {
        this(library, Sets.newLinkedHashSet(), Sets.newLinkedHashSet(), scope);
    }

    @Nullable
    public ModuleVersionIdentifier getModuleVersion() {
        return this.moduleVersion;
    }

    public void setModuleVersion(@Nullable ModuleVersionIdentifier moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    public File getLibraryFile() {
        return ((FilePath)this.getClasses().iterator().next()).getFile();
    }

    public File getJavadocFile() {
        if (this.getJavadoc().size() > 0) {
            return ((FilePath)this.getJavadoc().iterator().next()).getFile();
        }
        return null;
    }

    public File getSourceFile() {
        if (this.getSources().size() > 0) {
            return ((FilePath)this.getSources().iterator().next()).getFile();
        }
        return null;
    }
}

