/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\rR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "closureBuilders", "", "Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "getClassClosure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getClosure", "getFunctionClosure", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ClosureBuilder", "ClosureCollectorVisitor", "ir.backend.common"})
public final class ClosureAnnotator {
    private final Map<IrDeclaration, ClosureBuilder> closureBuilders;

    @NotNull
    public final Closure getFunctionClosure(@NotNull IrFunction declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        return this.getClosure(declaration);
    }

    @NotNull
    public final Closure getClassClosure(@NotNull IrClass declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        return this.getClosure(declaration);
    }

    private final Closure getClosure(IrDeclaration declaration) {
        Iterable $receiver$iv = this.closureBuilders.values();
        for (Object element$iv : $receiver$iv) {
            ClosureBuilder it = (ClosureBuilder)element$iv;
            it.setProcessed(false);
        }
        Map<IrDeclaration, ClosureBuilder> map2 = this.closureBuilders;
        ClosureBuilder closureBuilder = map2.get(declaration);
        if (closureBuilder == null) {
            throw (Throwable)((Object)new AssertionError((Object)"No closure builder for passed descriptor."));
        }
        return closureBuilder.buildClosure();
    }

    public ClosureAnnotator(@NotNull IrDeclaration declaration) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        ClosureAnnotator closureAnnotator = this;
        closureAnnotator.closureBuilders = map2 = (Map)new LinkedHashMap();
        IrElementVisitorVoidKt.acceptChildrenVoid(declaration, new ClosureCollectorVisitor());
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "", "owner", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)V", "capturedValues", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "getCapturedValues", "()Ljava/util/Set;", "declaredValues", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "includes", "getOwner", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "processed", "", "getProcessed", "()Z", "setProcessed", "(Z)V", "buildClosure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "declareVariable", "", "valueDeclaration", "include", "includingBuilder", "isExternal", "seeVariable", "value", "ir.backend.common"})
    private static final class ClosureBuilder {
        @NotNull
        private final Set<IrValueSymbol> capturedValues;
        private final Set<IrValueDeclaration> declaredValues;
        private final Set<ClosureBuilder> includes;
        private boolean processed;
        @NotNull
        private final IrDeclaration owner;

        @NotNull
        public final Set<IrValueSymbol> getCapturedValues() {
            return this.capturedValues;
        }

        public final boolean getProcessed() {
            return this.processed;
        }

        public final void setProcessed(boolean bl) {
            this.processed = bl;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Closure buildClosure() {
            Set set;
            Set $receiver = set = (Set)new LinkedHashSet();
            $receiver.addAll((Collection)this.capturedValues);
            Set result2 = set;
            Iterable $receiver$iv = this.includes;
            for (Object element$iv : $receiver$iv) {
                void $receiver$iv2;
                ClosureBuilder builder = (ClosureBuilder)element$iv;
                if (builder.processed) continue;
                builder.processed = true;
                Iterable iterable = builder.buildClosure().getCapturedValues();
                Collection destination$iv = result2;
                for (Object element$iv2 : $receiver$iv2) {
                    IrValueSymbol it = (IrValueSymbol)element$iv2;
                    if (!this.isExternal(it.getOwner())) continue;
                    destination$iv.add(element$iv2);
                }
            }
            return new Closure(CollectionsKt.toList((Iterable)result2));
        }

        public final void include(@NotNull ClosureBuilder includingBuilder) {
            Intrinsics.checkParameterIsNotNull((Object)includingBuilder, (String)"includingBuilder");
            this.includes.add(includingBuilder);
        }

        public final void declareVariable(@Nullable IrValueDeclaration valueDeclaration) {
            if (valueDeclaration != null) {
                this.declaredValues.add(valueDeclaration);
            }
        }

        public final void seeVariable(@NotNull IrValueSymbol value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            if (this.isExternal(value.getOwner())) {
                this.capturedValues.add(value);
            }
        }

        public final boolean isExternal(@NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkParameterIsNotNull((Object)valueDeclaration, (String)"valueDeclaration");
            return !this.declaredValues.contains(valueDeclaration);
        }

        @NotNull
        public final IrDeclaration getOwner() {
            return this.owner;
        }

        public ClosureBuilder(@NotNull IrDeclaration owner) {
            Set set;
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            this.owner = owner;
            ClosureBuilder closureBuilder = this;
            closureBuilder.capturedValues = set = (Set)new LinkedHashSet();
            closureBuilder = this;
            closureBuilder.declaredValues = set = (Set)new LinkedHashSet();
            closureBuilder = this;
            closureBuilder.includes = set = (Set)new LinkedHashSet();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\f\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020&H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureCollectorVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "(Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator;)V", "closuresStack", "", "Lorg/jetbrains/kotlin/backend/common/lower/ClosureAnnotator$ClosureBuilder;", "getClosuresStack", "()Ljava/util/List;", "includeInParent", "", "builder", "processMemberAccess", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitCatch", "aCatch", "Lorg/jetbrains/kotlin/ir/expressions/IrCatch;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitLocalDelegatedProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitVariableAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrValueAccessExpression;", "ir.backend.common"})
    private final class ClosureCollectorVisitor
    implements IrElementVisitorVoid {
        @NotNull
        private final List<ClosureBuilder> closuresStack;

        @NotNull
        public final List<ClosureBuilder> getClosuresStack() {
            return this.closuresStack;
        }

        public final void includeInParent(@NotNull ClosureBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            ClosureBuilder parentBuilder = UtilsKt.peek(this.closuresStack);
            if (parentBuilder != null && !(parentBuilder.getOwner() instanceof IrFunction)) {
                parentBuilder.include(builder);
            }
        }

        @Override
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration) {
            Object v1;
            Object object;
            ClosureBuilder closureBuilder;
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                closureBuilder = new ClosureBuilder(declaration);
                object = ClosureAnnotator.this.closureBuilders;
                ClosureBuilder closureBuilder2 = closureBuilder;
                object.put(declaration, closureBuilder2);
                closureBuilder.declareVariable(declaration.getThisReceiver());
                if (declaration.isInner()) {
                    IrDeclarationParent irDeclarationParent = declaration.getParent();
                    if (irDeclarationParent == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                    }
                    closureBuilder.declareVariable(((IrClass)irDeclarationParent).getThisReceiver());
                    this.includeInParent(closureBuilder);
                }
                Iterable $receiver$iv = declaration.getDeclarations();
                for (Object element$iv : $receiver$iv) {
                    IrDeclaration it = (IrDeclaration)element$iv;
                    if (!(it instanceof IrConstructor && ((IrConstructor)it).isPrimary())) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            IrDeclaration irDeclaration = v1;
            if (irDeclaration != null) {
                Object it;
                Object object2 = it = (object = irDeclaration);
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrConstructor");
                }
                IrConstructor constructor = (IrConstructor)object2;
                Iterable $receiver$iv = constructor.getValueParameters();
                for (Object element$iv : $receiver$iv) {
                    IrValueParameter v2 = (IrValueParameter)element$iv;
                    closureBuilder.declareVariable(v2);
                }
            }
            UtilsKt.push(this.closuresStack, closureBuilder);
            IrElementVisitorVoidKt.acceptChildrenVoid(declaration, this);
            UtilsKt.pop(this.closuresStack);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration) {
            Object it;
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            ClosureBuilder closureBuilder = new ClosureBuilder(declaration);
            Map map2 = ClosureAnnotator.this.closureBuilders;
            ClosureBuilder closureBuilder2 = closureBuilder;
            map2.put(declaration, closureBuilder2);
            Iterable $receiver$iv = declaration.getValueParameters();
            for (Object element$iv : $receiver$iv) {
                it = (IrValueParameter)element$iv;
                closureBuilder.declareVariable((IrValueDeclaration)it);
            }
            closureBuilder.declareVariable(declaration.getDispatchReceiverParameter());
            closureBuilder.declareVariable(declaration.getExtensionReceiverParameter());
            if (declaration instanceof IrConstructor) {
                ClosureBuilder classBuilder2;
                IrDeclarationParent irDeclarationParent = declaration.getParent();
                if (irDeclarationParent == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                }
                IrClass constructedClass = (IrClass)irDeclarationParent;
                closureBuilder.declareVariable(constructedClass.getThisReceiver());
                ClosureBuilder closureBuilder3 = classBuilder2 = UtilsKt.peek(this.closuresStack);
                if (closureBuilder3 != null) {
                    ClosureBuilder closureBuilder4 = closureBuilder3;
                    it = closureBuilder4;
                    boolean bl = Intrinsics.areEqual((Object)classBuilder2.getOwner(), (Object)constructedClass);
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    closureBuilder.include(classBuilder2);
                }
            }
            UtilsKt.push(this.closuresStack, closureBuilder);
            IrElementVisitorVoidKt.acceptChildrenVoid(declaration, this);
            UtilsKt.pop(this.closuresStack);
            this.includeInParent(closureBuilder);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
                IrExpression irExpression = declaration.getDelegate().getInitializer();
                if (irExpression == null) break block0;
                IrElementVisitorVoidKt.acceptVoid(irExpression, this);
            }
        }

        @Override
        public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            ClosureBuilder closureBuilder = UtilsKt.peek(this.closuresStack);
            if (closureBuilder != null) {
                closureBuilder.seeVariable(expression2.getSymbol());
            }
            IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            ClosureBuilder closureBuilder = UtilsKt.peek(this.closuresStack);
            if (closureBuilder != null) {
                closureBuilder.declareVariable(declaration);
            }
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch) {
            Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
            ClosureBuilder closureBuilder = UtilsKt.peek(this.closuresStack);
            if (closureBuilder != null) {
                closureBuilder.declareVariable(aCatch.getCatchParameter());
            }
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoidKt.acceptChildrenVoid(expression2, this);
            this.processMemberAccess((IrDeclaration)expression2.getSymbol().getOwner());
        }

        @Override
        public void visitCall(@NotNull IrCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoidKt.acceptChildrenVoid(expression2, this);
            this.processMemberAccess(expression2.getSymbol().getOwner());
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoidKt.acceptChildrenVoid(expression2, this);
            this.processMemberAccess((IrDeclaration)expression2.getSymbol().getOwner());
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoidKt.acceptChildrenVoid(expression2, this);
            this.processMemberAccess(expression2.getSymbol().getOwner());
        }

        private final void processMemberAccess(IrDeclaration declaration) {
            block2: {
                ClosureBuilder builder;
                if (!DescriptorUtils.isLocal(declaration.getDescriptor())) break block2;
                ClosureBuilder closureBuilder = builder = (ClosureBuilder)ClosureAnnotator.this.closureBuilders.get(declaration);
                if (closureBuilder != null) {
                    ClosureBuilder closureBuilder2;
                    ClosureBuilder it = closureBuilder2 = closureBuilder;
                    ClosureBuilder closureBuilder3 = UtilsKt.peek(this.closuresStack);
                    if (closureBuilder3 != null) {
                        closureBuilder3.include(builder);
                    }
                }
            }
        }

        public ClosureCollectorVisitor() {
            List list2;
            ClosureCollectorVisitor closureCollectorVisitor = this;
            closureCollectorVisitor.closuresStack = list2 = (List)new ArrayList();
        }

        @Override
        public void visitElement(@NotNull IrElement element, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
        }

        @Override
        public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
        }

        @Override
        public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
        }

        @Override
        public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
        }

        @Override
        public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
        }

        @Override
        public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
            IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
        }

        @Override
        public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
        }

        @Override
        public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
        }

        @Override
        public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
        }

        @Override
        public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
        }

        @Override
        public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
        }

        @Override
        public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body);
        }

        @Override
        public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body, data);
        }

        @Override
        public void visitBody(@NotNull IrBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body);
        }

        @Override
        public void visitBody(@NotNull IrBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitBody(this, body, data);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
        }

        @Override
        public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
        }

        @Override
        public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
        }

        @Override
        public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
        }

        @Override
        public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
        }

        @Override
        public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
        }

        @Override
        public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2) {
            Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
        }

        @Override
        public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
        }

        @Override
        public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
        }

        @Override
        public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
        }

        @Override
        public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
            IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
        }

        @Override
        public void visitDeclaration(@NotNull IrDeclaration declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
        }

        @Override
        public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
        }

        @Override
        public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
        }

        @Override
        public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
            IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
        }

        @Override
        public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
        }

        @Override
        public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
        }

        @Override
        public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
        }

        @Override
        public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
        }

        @Override
        public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body);
        }

        @Override
        public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body, data);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
        }

        @Override
        public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
        }

        @Override
        public void visitField(@NotNull IrField declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
        }

        @Override
        public void visitField(@NotNull IrField declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
        }

        @Override
        public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
        }

        @Override
        public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
        }

        @Override
        public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
        }

        @Override
        public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
        }

        @Override
        public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
        }

        @Override
        public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
        }

        @Override
        public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
        }

        @Override
        public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
        }

        @Override
        public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
        }

        @Override
        public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
        }

        @Override
        public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
        }

        @Override
        public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
        }

        @Override
        public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
        }

        @Override
        public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
        }

        @Override
        public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
        }

        @Override
        public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
        }

        @Override
        public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
        }

        @Override
        public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
        }

        @Override
        public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
        }

        @Override
        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
        }

        @Override
        public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread) {
            Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
        }

        @Override
        public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
            IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
        }

        @Override
        public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
        }

        @Override
        public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
        }

        @Override
        public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body);
        }

        @Override
        public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
            IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body, data);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
        }

        @Override
        public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry) {
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
        }

        @Override
        public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
            IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
        }

        @Override
        public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
        }

        @Override
        public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
        }

        @Override
        public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
        }

        @Override
        public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
        }

        @Override
        public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
        }

        @Override
        public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
        }

        @Override
        public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
        }

        @Override
        public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull((Object)loop2, (String)"loop");
            IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
        }
    }
}

