/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameBinding;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.inline.util.collectors.InstanceCollector;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0002\u001a \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u001a\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000f\u001a,\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0003\"\b\b\u0000\u0010\u0015*\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u00172\u0006\u0010\u000e\u001a\u00020\u000f\u001a \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u001a \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001a0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u001a\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001a0\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a&\u0010\u001b\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u001c0\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u001a\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020\u0004\u001a\u0010\u0010#\u001a\u0004\u0018\u00010\n2\u0006\u0010$\u001a\u00020%\u001a\u001c\u0010&\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0002\u001a\u0010\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010(\u001a\u00020)\u001a\u0016\u0010*\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0\t*\u00020\u000f\u001a\u0010\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u001a\u001a\u0010\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011*\u00020\u001a\u00a8\u0006/"}, d2={"appendArguments", "", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "collectAccessors", "", "", "Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "fragments", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "collectDefinedNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "collectDefinedNamesInAllScopes", "collectInstances", "T", "klass", "Ljava/lang/Class;", "collectNameBindings", "collectNamedFunctions", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "collectNamedFunctionsAndMetadata", "Lkotlin/Pair;", "collectNamedFunctionsAndWrappers", "collectNamedFunctionsOrMetadata", "collectReferencedNames", "collectUsedNames", "extractFunction", "expression", "extractImportTag", "jsVar", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "extractImportTagImpl", "getImportTag", "jsVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "collectBreakContinueTargets", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "collectFreeVariables", "collectLocalVariables", "js.translator"})
public final class CollectUtilsKt {
    @NotNull
    public static final Set<JsName> collectReferencedNames(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set $references;

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull((Object)nameRef, (String)"nameRef");
                super.visitNameRef(nameRef);
                JsName name = nameRef.getName();
                if (name != null) {
                    Collection collection = this.$references;
                    collection.add(name);
                }
            }
            {
                this.$references = $captured_local_variable$0;
            }
        }.accept(scope);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectUsedNames(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set $references;

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull((Object)nameRef, (String)"nameRef");
                super.visitNameRef(nameRef);
                JsName name = nameRef.getName();
                if (name != null && nameRef.getQualifier() == null) {
                    this.$references.add(name);
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Collection collection = this.$references;
                Iterable iterable = CollectUtilsKt.collectFreeVariables(x);
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
            {
                this.$references = $captured_local_variable$0;
            }
        }.accept(scope);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectDefinedNames(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Set names2 = new LinkedHashSet();
        new RecursiveJsVisitor(names2){
            final /* synthetic */ Set $names;

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
                Collection collection = this.$names;
                JsName jsName = x.getName();
                collection.add(jsName);
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                JsName name;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"x.expression");
                JsExpression expression2 = jsExpression;
                if (expression2 instanceof JsFunction && (name = ((JsFunction)expression2).getName()) != null) {
                    Collection collection = this.$names;
                    collection.add(name);
                }
                super.visitExpressionStatement(x);
            }

            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Collection collection = this.$names;
                JsParameter jsParameter = x.getParameter();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsParameter, (String)"x.parameter");
                JsName jsName = jsParameter.getName();
                collection.add(jsName);
                super.visitCatch(x);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            }
            {
                this.$names = $captured_local_variable$0;
            }
        }.accept(scope);
        return names2;
    }

    @NotNull
    public static final Set<JsName> collectDefinedNamesInAllScopes(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Set names2 = new LinkedHashSet();
        new RecursiveJsVisitor(names2){
            final /* synthetic */ Set $names;

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                super.visit(x);
                Collection collection = this.$names;
                JsName jsName = x.getName();
                collection.add(jsName);
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction(@NotNull JsFunction x) {
                void $receiver$iv$iv;
                Iterable<E> iterable;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                super.visitFunction(x);
                JsName jsName = x.getName();
                if (jsName != null) {
                    object = jsName;
                    JsName it = object;
                    iterable = this.$names;
                    iterable.add(it);
                }
                object = this.$names;
                List<JsParameter> list2 = x.getParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"x.parameters");
                Iterable $receiver$iv = list2;
                iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    JsParameter jsParameter = (JsParameter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    void v2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                    JsName jsName2 = v2.getName();
                    collection.add(jsName2);
                }
                Iterable iterable2 = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)object, (Iterable)iterable2);
            }
            {
                this.$names = $captured_local_variable$0;
            }
        }.accept(scope);
        return names2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectFreeVariables(@NotNull JsFunction $receiver) {
        void var3_4;
        Collection<JsName> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        JsBlock jsBlock = $receiver.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"body");
        Set<JsName> set = CollectUtilsKt.collectUsedNames(jsBlock);
        JsBlock jsBlock2 = $receiver.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock2, (String)"body");
        Set set2 = SetsKt.minus(set, (Iterable)CollectUtilsKt.collectDefinedNames(jsBlock2));
        List<JsParameter> list2 = $receiver.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parameters");
        Iterable iterable = list2;
        Set set3 = set2;
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            void v5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
            JsName jsName = v5.getName();
            collection.add(jsName);
        }
        collection = (List)var3_4;
        return SetsKt.minus((Set)set3, (Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectLocalVariables(@NotNull JsFunction $receiver) {
        void var3_4;
        Collection<JsName> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        JsBlock jsBlock = $receiver.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"body");
        Set<JsName> set = CollectUtilsKt.collectDefinedNames(jsBlock);
        List<JsParameter> list2 = $receiver.getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"parameters");
        Iterable iterable = list2;
        Set<JsName> set2 = set;
        void var2_3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            void v3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            JsName jsName = v3.getName();
            collection.add(jsName);
        }
        collection = (List)var3_4;
        return SetsKt.plus(set2, (Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<JsName, JsFunction> collectNamedFunctions(@NotNull JsNode scope) {
        void $receiver$iv$iv;
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map2 = $receiver$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(scope);
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map4 = map3;
            JsFunction jsFunction = ((FunctionWithWrapper)((Pair)it.getValue()).getFirst()).getFunction();
            map4.put(k2, jsFunction);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<JsName, JsExpression> collectNamedFunctionsOrMetadata(@NotNull JsNode scope) {
        void $receiver$iv$iv;
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map2 = $receiver$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(scope);
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map4 = map3;
            JsExpression jsExpression = (JsExpression)((Pair)it.getValue()).getSecond();
            map4.put(k2, jsExpression);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final Map<JsName, JsFunction> collectNamedFunctions(@NotNull List<? extends JsProgramFragment> fragments2) {
        Intrinsics.checkParameterIsNotNull(fragments2, (String)"fragments");
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment jsProgramFragment : fragments2) {
            Map map2 = result2;
            JsGlobalBlock jsGlobalBlock = jsProgramFragment.getDeclarationBlock();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsGlobalBlock, (String)"fragment.declarationBlock");
            Map<JsName, JsFunction> map3 = CollectUtilsKt.collectNamedFunctions(jsGlobalBlock);
            map2.putAll(map3);
            map2 = result2;
            JsGlobalBlock jsGlobalBlock2 = jsProgramFragment.getInitializerBlock();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsGlobalBlock2, (String)"fragment.initializerBlock");
            map3 = CollectUtilsKt.collectNamedFunctions(jsGlobalBlock2);
            map2.putAll(map3);
        }
        return result2;
    }

    @NotNull
    public static final Map<JsName, FunctionWithWrapper> collectNamedFunctionsAndWrappers(@NotNull List<? extends JsProgramFragment> fragments2) {
        Intrinsics.checkParameterIsNotNull(fragments2, (String)"fragments");
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment jsProgramFragment : fragments2) {
            FunctionWithWrapper functionWithWrapper;
            Map.Entry it;
            Map map2;
            Object k;
            Object k2;
            Map.Entry it$iv$iv;
            Map map3;
            Map $receiver$iv$iv;
            Map $receiver$iv;
            Map map4 = result2;
            JsGlobalBlock jsGlobalBlock = jsProgramFragment.getDeclarationBlock();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsGlobalBlock, (String)"fragment.declarationBlock");
            Map map5 = $receiver$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(jsGlobalBlock);
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
            Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map3 = destination$iv$iv;
                k2 = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = k2;
                map2 = map3;
                functionWithWrapper = (FunctionWithWrapper)((Pair)it.getValue()).getFirst();
                map2.put(k, functionWithWrapper);
            }
            $receiver$iv = destination$iv$iv;
            map4.putAll($receiver$iv);
            map4 = result2;
            JsGlobalBlock jsGlobalBlock2 = jsProgramFragment.getInitializerBlock();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsGlobalBlock2, (String)"fragment.initializerBlock");
            $receiver$iv$iv = $receiver$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(jsGlobalBlock2);
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
            $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map3 = destination$iv$iv;
                k2 = it$iv$iv.getKey();
                it = (Map.Entry)element$iv$iv$iv;
                k = k2;
                map2 = map3;
                functionWithWrapper = (FunctionWithWrapper)((Pair)it.getValue()).getFirst();
                map2.put(k, functionWithWrapper);
            }
            Map map6 = destination$iv$iv;
            map4.putAll(map6);
        }
        return result2;
    }

    @NotNull
    public static final Map<JsName, Pair<FunctionWithWrapper, JsExpression>> collectNamedFunctionsAndMetadata(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Map namedFunctions = new LinkedHashMap();
        scope.accept(new RecursiveJsVisitor(namedFunctions){
            final /* synthetic */ Map $namedFunctions;

            /*
             * WARNING - void declaration
             */
            public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(x);
                if (assignment != null) {
                    JsName name;
                    void left;
                    Pair<JsExpression, JsExpression> pair = assignment;
                    JsExpression jsExpression = (JsExpression)pair.component1();
                    JsExpression right = (JsExpression)pair.component2();
                    if (left instanceof JsNameRef && (name = ((JsNameRef)left).getName()) != null) {
                        JsExpression jsExpression2 = right;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression2, (String)"right");
                        FunctionWithWrapper functionWithWrapper = CollectUtilsKt.extractFunction(jsExpression2);
                        if (functionWithWrapper != null) {
                            FunctionWithWrapper functionWithWrapper2;
                            FunctionWithWrapper $function_wrapper = functionWithWrapper2 = functionWithWrapper;
                            JsFunction function2 = $function_wrapper.component1();
                            JsBlock wrapper = $function_wrapper.component2();
                            Map map2 = this.$namedFunctions;
                            JsName jsName = name;
                            Pair pair2 = new Pair((Object)new FunctionWithWrapper(function2, wrapper), (Object)right);
                            map2.put(jsName, pair2);
                        }
                    }
                }
                super.visitBinaryExpression(x);
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsExpression initializer2 = x.getInitExpression();
                JsName name = x.getName();
                if (initializer2 != null && name != null) {
                    FunctionWithWrapper functionWithWrapper = CollectUtilsKt.extractFunction(initializer2);
                    if (functionWithWrapper != null) {
                        FunctionWithWrapper functionWithWrapper2;
                        FunctionWithWrapper function2 = functionWithWrapper2 = functionWithWrapper;
                        Map map2 = this.$namedFunctions;
                        JsName jsName = name;
                        Pair pair = new Pair((Object)function2, (Object)initializer2);
                        map2.put(jsName, pair);
                    }
                }
                super.visit(x);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsName name = x.getName();
                if (name != null) {
                    Map map2 = this.$namedFunctions;
                    Pair pair = new Pair((Object)new FunctionWithWrapper(x, null), (Object)x);
                    map2.put(name, pair);
                }
                super.visitFunction(x);
            }
            {
                this.$namedFunctions = $captured_local_variable$0;
            }
        });
        return namedFunctions;
    }

    @NotNull
    public static final Map<String, FunctionWithWrapper> collectAccessors(@NotNull JsNode scope) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        HashMap accessors = new HashMap();
        scope.accept(new RecursiveJsVisitor(accessors){
            final /* synthetic */ HashMap $accessors;

            public void visitInvocation(@NotNull JsInvocation invocation) {
                Intrinsics.checkParameterIsNotNull((Object)invocation, (String)"invocation");
                InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(invocation);
                if (inlineMetadata != null) {
                    InlineMetadata inlineMetadata2;
                    InlineMetadata it = inlineMetadata2 = inlineMetadata;
                    Map map2 = this.$accessors;
                    String string = it.getTag().getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.tag.value");
                    String string2 = string;
                    FunctionWithWrapper functionWithWrapper = it.getFunction();
                    map2.put(string2, functionWithWrapper);
                }
                super.visitInvocation(invocation);
            }
            {
                this.$accessors = $captured_local_variable$0;
            }
        });
        return accessors;
    }

    @NotNull
    public static final Map<String, FunctionWithWrapper> collectAccessors(@NotNull List<? extends JsProgramFragment> fragments2) {
        Intrinsics.checkParameterIsNotNull(fragments2, (String)"fragments");
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment jsProgramFragment : fragments2) {
            Map map2 = result2;
            JsGlobalBlock jsGlobalBlock = jsProgramFragment.getDeclarationBlock();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsGlobalBlock, (String)"fragment.declarationBlock");
            Map<String, FunctionWithWrapper> map3 = CollectUtilsKt.collectAccessors(jsGlobalBlock);
            map2.putAll(map3);
        }
        return result2;
    }

    @NotNull
    public static final Map<JsName, String> collectNameBindings(@NotNull List<? extends JsProgramFragment> fragments2) {
        Intrinsics.checkParameterIsNotNull(fragments2, (String)"fragments");
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment jsProgramFragment : fragments2) {
            for (JsNameBinding binding : jsProgramFragment.getNameBindings()) {
                Map map2 = result2;
                JsName jsName = binding.getName();
                String string = binding.getKey();
                map2.put(jsName, string);
            }
        }
        return result2;
    }

    @Nullable
    public static final FunctionWithWrapper extractFunction(@NotNull JsExpression expression2) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsFunction) {
            object = new FunctionWithWrapper((JsFunction)expression2, null);
        } else {
            object = InlineMetadata.Companion.decompose(expression2);
            if (object == null || (object = ((InlineMetadata)object).getFunction()) == null) {
                object = InlineMetadata.Companion.tryExtractFunction(expression2);
            }
        }
        return object;
    }

    @NotNull
    public static final <T extends JsNode> List<T> collectInstances(@NotNull Class<T> klass2, @NotNull JsNode scope) {
        InstanceCollector<JsNode> instanceCollector;
        Intrinsics.checkParameterIsNotNull(klass2, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        InstanceCollector<JsNode> $receiver = instanceCollector = new InstanceCollector<JsNode>(klass2, false);
        $receiver.accept(scope);
        return $receiver.getCollected();
    }

    @NotNull
    public static final Map<JsContinue, JsStatement> collectBreakContinueTargets(@NotNull JsNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Map targets = new LinkedHashMap();
        $receiver.accept(new RecursiveJsVisitor(targets){
            @Nullable
            private JsStatement defaultBreakTarget;
            @NotNull
            private Map<JsName, JsStatement> breakTargets;
            @Nullable
            private JsStatement defaultContinueTarget;
            @NotNull
            private Map<JsName, JsStatement> continueTargets;
            final /* synthetic */ Map $targets;

            @Nullable
            public final JsStatement getDefaultBreakTarget() {
                return this.defaultBreakTarget;
            }

            public final void setDefaultBreakTarget(@Nullable JsStatement jsStatement) {
                this.defaultBreakTarget = jsStatement;
            }

            @NotNull
            public final Map<JsName, JsStatement> getBreakTargets() {
                return this.breakTargets;
            }

            public final void setBreakTargets(@NotNull Map<JsName, JsStatement> map2) {
                Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
                this.breakTargets = map2;
            }

            @Nullable
            public final JsStatement getDefaultContinueTarget() {
                return this.defaultContinueTarget;
            }

            public final void setDefaultContinueTarget(@Nullable JsStatement jsStatement) {
                this.defaultContinueTarget = jsStatement;
            }

            @NotNull
            public final Map<JsName, JsStatement> getContinueTargets() {
                return this.continueTargets;
            }

            public final void setContinueTargets(@NotNull Map<JsName, JsStatement> map2) {
                Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
                this.continueTargets = map2;
            }

            public void visitLabel(@NotNull JsLabel x) {
                JsStatement inner;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsStatement jsStatement = inner = x.getStatement();
                if (jsStatement instanceof JsDoWhile) {
                    JsStatement jsStatement2 = ((JsDoWhile)inner).getBody();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement2, (String)"inner.body");
                    this.handleLoop(inner, jsStatement2, x.getName());
                } else if (jsStatement instanceof JsWhile) {
                    JsStatement jsStatement3 = ((JsWhile)inner).getBody();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement3, (String)"inner.body");
                    this.handleLoop(inner, jsStatement3, x.getName());
                } else if (jsStatement instanceof JsFor) {
                    JsStatement jsStatement4 = ((JsFor)inner).getBody();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement4, (String)"inner.body");
                    this.handleLoop(inner, jsStatement4, x.getName());
                } else if (jsStatement instanceof JsSwitch) {
                    this.handleSwitch((JsSwitch)inner, x.getName());
                } else {
                    JsName jsName = x.getName();
                    JsStatement jsStatement5 = x.getStatement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement5, (String)"x.statement");
                    this.withBreakAndContinue(jsName, jsStatement5, null, (Function0<Unit>)((Function0)new Function0<Unit>(this, inner){
                        final /* synthetic */ collectBreakContinueTargets.1 this$0;
                        final /* synthetic */ JsStatement $inner;

                        public final void invoke() {
                            this.this$0.accept((JsNode)this.$inner);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$inner = jsStatement;
                            super(0);
                        }
                    }));
                }
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement2, (String)"x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement2, (String)"x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visitFor(@NotNull JsFor x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement2, (String)"x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visit(@NotNull JsSwitch x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                this.handleSwitch(x, null);
            }

            private final void handleSwitch(JsSwitch statement2, JsName label) {
                collectBreakContinueTargets.1.withBreakAndContinue$default(this, label, statement2, null, (Function0)new Function0<Unit>(this, statement2){
                    final /* synthetic */ collectBreakContinueTargets.1 this$0;
                    final /* synthetic */ JsSwitch $statement;

                    public final void invoke() {
                        List<JsSwitchMember> list2 = this.$statement.getCases();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"statement.cases");
                        Iterable $receiver$iv = list2;
                        for (T element$iv : $receiver$iv) {
                            JsSwitchMember it = (JsSwitchMember)element$iv;
                            this.this$0.accept((JsNode)it);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$statement = jsSwitch;
                        super(0);
                    }
                }, 4, null);
            }

            private final void handleLoop(JsStatement loop2, JsStatement body, JsName label) {
                this.withBreakAndContinue(label, loop2, loop2, (Function0<Unit>)((Function0)new Function0<Unit>(this, body){
                    final /* synthetic */ collectBreakContinueTargets.1 this$0;
                    final /* synthetic */ JsStatement $body;

                    public final void invoke() {
                        this.$body.accept(this.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$body = jsStatement;
                        super(0);
                    }
                }));
            }

            public void visitBreak(@NotNull JsBreak x) {
                JsStatement jsStatement;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsNameRef jsNameRef = x.getLabel();
                JsName targetLabel = jsNameRef != null ? jsNameRef.getName() : null;
                Map map2 = this.$targets;
                if (targetLabel == null) {
                    jsStatement = this.defaultBreakTarget;
                    if (jsStatement == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    JsStatement jsStatement2 = this.breakTargets.get(targetLabel);
                    if (jsStatement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    jsStatement = jsStatement2;
                }
                JsStatement jsStatement3 = jsStatement;
                map2.put(x, jsStatement3);
            }

            public void visitContinue(@NotNull JsContinue x) {
                JsStatement jsStatement;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsNameRef jsNameRef = x.getLabel();
                JsName targetLabel = jsNameRef != null ? jsNameRef.getName() : null;
                Map map2 = this.$targets;
                if (targetLabel == null) {
                    jsStatement = this.defaultContinueTarget;
                    if (jsStatement == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    JsStatement jsStatement2 = this.continueTargets.get(targetLabel);
                    if (jsStatement2 == null) {
                        Intrinsics.throwNpe();
                    }
                    jsStatement = jsStatement2;
                }
                JsStatement jsStatement3 = jsStatement;
                map2.put(x, jsStatement3);
            }

            /*
             * WARNING - void declaration
             */
            private final void withBreakAndContinue(JsName label, JsStatement breakTargetStatement, JsStatement continueTargetStatement, Function0<Unit> action) {
                JsStatement jsStatement;
                JsStatement oldDefaultBreakTarget = this.defaultBreakTarget;
                JsStatement oldDefaultContinueTarget = this.defaultContinueTarget;
                Object object = label != null ? new Pair((Object)this.breakTargets.get(label), (Object)this.continueTargets.get(label)) : new Pair(null, null);
                JsStatement jsStatement2 = (JsStatement)object.component1();
                JsStatement oldContinueTarget = (JsStatement)object.component2();
                this.defaultBreakTarget = breakTargetStatement;
                if (label != null) {
                    object = this.breakTargets;
                    jsStatement = breakTargetStatement;
                    object.put(label, jsStatement);
                    object = this.continueTargets;
                    jsStatement = continueTargetStatement;
                    object.put(label, jsStatement);
                }
                if (continueTargetStatement != null) {
                    this.defaultContinueTarget = continueTargetStatement;
                }
                action.invoke();
                this.defaultBreakTarget = oldDefaultBreakTarget;
                this.defaultContinueTarget = oldDefaultContinueTarget;
                if (label != null) {
                    void oldBreakTarget;
                    object = this.breakTargets;
                    jsStatement = oldBreakTarget;
                    object.put(label, jsStatement);
                    object = this.continueTargets;
                    jsStatement = oldContinueTarget;
                    object.put(label, jsStatement);
                }
            }

            static /* synthetic */ void withBreakAndContinue$default(collectBreakContinueTargets.1 var0, JsName jsName, JsStatement jsStatement, JsStatement jsStatement2, Function0 function0, int n, Object object) {
                if ((n & 4) != 0) {
                    jsStatement2 = null;
                }
                var0.withBreakAndContinue(jsName, jsStatement, jsStatement2, (Function0<Unit>)function0);
            }
            {
                Map map2;
                this.$targets = $captured_local_variable$0;
                collectBreakContinueTargets.1 var2_2 = this;
                var2_2.breakTargets = map2 = (Map)new LinkedHashMap<K, V>();
                var2_2 = this;
                var2_2.continueTargets = map2 = (Map)new LinkedHashMap<K, V>();
            }
        });
        return targets;
    }

    @Nullable
    public static final String getImportTag(@NotNull JsVars jsVars) {
        Intrinsics.checkParameterIsNotNull((Object)jsVars, (String)"jsVars");
        if (jsVars.getVars().size() == 1) {
            JsVars.JsVar jsVar;
            JsVars.JsVar jsVar2 = jsVar = jsVars.getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsVar2, (String)"jsVar");
            JsName jsName = jsVar2.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"jsVar.name");
            if (MetadataProperties.getImported(jsName)) {
                return CollectUtilsKt.extractImportTag(jsVar);
            }
        }
        return null;
    }

    @Nullable
    public static final String extractImportTag(@NotNull JsVars.JsVar jsVar) {
        Intrinsics.checkParameterIsNotNull((Object)jsVar, (String)"jsVar");
        JsExpression jsExpression = jsVar.getInitExpression();
        if (jsExpression == null) {
            return null;
        }
        JsExpression initExpression = jsExpression;
        StringBuilder sb = new StringBuilder();
        if (initExpression instanceof JsInvocation || initExpression instanceof JsNew) {
            sb.append(jsVar.getName().toString()).append(":");
        }
        return CollectUtilsKt.extractImportTagImpl(initExpression, sb) ? sb.toString() : null;
    }

    private static final boolean extractImportTagImpl(JsExpression expression2, StringBuilder sb) {
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsNameRef) {
            JsExpression nameRef = expression2;
            if (((JsNameRef)nameRef).getQualifier() != null) {
                JsExpression jsExpression2 = ((JsNameRef)nameRef).getQualifier();
                if (jsExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression2, (String)"nameRef.qualifier!!");
                if (!CollectUtilsKt.extractImportTagImpl(jsExpression2, sb)) {
                    return false;
                }
                sb.append('.');
            }
            sb.append(JsToStringGenerationVisitor.javaScriptString(((JsNameRef)nameRef).getIdent()));
            return true;
        }
        if (jsExpression instanceof JsArrayAccess) {
            JsExpression arrayAccess = expression2;
            JsExpression jsExpression3 = ((JsArrayAccess)arrayAccess).getArrayExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression3, (String)"arrayAccess.arrayExpression");
            if (!CollectUtilsKt.extractImportTagImpl(jsExpression3, sb)) {
                return false;
            }
            sb.append(".");
            JsExpression jsExpression4 = ((JsArrayAccess)arrayAccess).getIndexExpression();
            if (!(jsExpression4 instanceof JsStringLiteral)) {
                jsExpression4 = null;
            }
            JsStringLiteral jsStringLiteral = (JsStringLiteral)jsExpression4;
            if (jsStringLiteral == null) {
                return false;
            }
            JsStringLiteral stringLiteral = jsStringLiteral;
            sb.append(JsToStringGenerationVisitor.javaScriptString(stringLiteral.getValue()));
            return true;
        }
        if (jsExpression instanceof JsInvocation) {
            JsExpression invocation = expression2;
            JsExpression jsExpression5 = ((JsInvocation)invocation).getQualifier();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression5, (String)"invocation.qualifier");
            if (!CollectUtilsKt.extractImportTagImpl(jsExpression5, sb)) {
                return false;
            }
            List<JsExpression> list2 = ((JsInvocation)invocation).getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"invocation.arguments");
            return CollectUtilsKt.appendArguments(list2, sb);
        }
        if (jsExpression instanceof JsNew) {
            JsExpression newExpr = expression2;
            JsExpression jsExpression6 = ((JsNew)newExpr).getConstructorExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression6, (String)"newExpr.constructorExpression");
            if (!CollectUtilsKt.extractImportTagImpl(jsExpression6, sb)) {
                return false;
            }
            List<JsExpression> list3 = ((JsNew)newExpr).getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"newExpr.arguments");
            return CollectUtilsKt.appendArguments(list3, sb);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean appendArguments(List<? extends JsExpression> arguments2, StringBuilder sb) {
        Iterable $receiver$iv = arguments2;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void arg;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            JsExpression jsExpression = (JsExpression)item$iv;
            int index2 = n2;
            if (!(arg instanceof JsIntLiteral)) {
                return false;
            }
            sb.append(index2 == 0 ? "(" : ",");
            sb.append(((JsIntLiteral)arg).value);
        }
        sb.append(")");
        return true;
    }
}

