#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dbus
version:              1.2.21
visibility:           public
id:                   dbus-1.2.21-1Mhv7gxXB5gE1sUNj8D17N
key:                  dbus-1.2.21-1Mhv7gxXB5gE1sUNj8D17N
license:              Apache-2.0
maintainer:           Andrey Sverdlichenko <blaze@ruddy.ru>
author:               John Millikin <john@john-millikin.com>
stability:            experimental
homepage:             https://github.com/rblaze/haskell-dbus#readme
synopsis:             A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.

    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.

    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.

    Example: connect to the session bus, and get a list of active names.

    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;

    import Data.List (sort)
    import DBus
    import DBus.Client

    main = do
    &#x20;   client <- connectSession
    &#x20;
    &#x20;   -- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;
    &#x20;   -- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   -- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;
    &#x20;   -- Print each name on a line, sorted so reserved names are below
    &#x20;   -- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @

    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver

category:             Network, Desktop
abi:                  e1d82e22247eb2ada46affc09a38af0e
exposed:              True
exposed-modules:
    DBus DBus.Client DBus.Generation DBus.Internal.Address
    DBus.Internal.Message DBus.Internal.Types DBus.Internal.Wire
    DBus.Introspection DBus.Introspection.Parse
    DBus.Introspection.Render DBus.Introspection.Types DBus.Socket
    DBus.TH DBus.Transport

import-dirs:          /usr/lib/ghc-8.10.5/site-local/dbus-1.2.21
library-dirs:         /usr/lib/ghc-8.10.5/site-local/dbus-1.2.21
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/dbus-1.2.21
hs-libraries:         HSdbus-1.2.21-1Mhv7gxXB5gE1sUNj8D17N
depends:
    base-4.14.2.0 bytestring-0.10.12.0
    cereal-0.5.8.1-4r85zOZIbEW4fo8WFnBuTl
    conduit-1.3.4.1-1BtK5bRX29l4VANueOokSq containers-0.6.4.1
    deepseq-1.4.4.0 exceptions-0.10.4 filepath-1.4.2.1
    lens-5.0.1-7XUkI0pM5Tr3OUSblTWRuC
    network-3.1.2.2-DhUKX0ZpAd35HJ7CPbrOZd parsec-3.1.14.0
    random-1.2.0-BSVdQCE475yEKcUUPfL4ub
    split-0.2.3.4-6NNts3pcZSB6Io5fuJ9m3X template-haskell-2.16.0.0
    text-1.2.4.1 th-lift-0.8.2-A94jWiBJfaQF1v2Vq9YgsH
    transformers-0.5.6.2 unix-2.7.2.2
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp
    xml-conduit-1.9.1.1-L1pCoL9JnDFGTAxLHuUUoF
    xml-types-0.3.8-Gz3On8Uo3JN2rSYUSThjSo

haddock-interfaces:   /usr/share/doc/haskell-dbus/html/dbus.haddock
haddock-html:         /usr/share/doc/haskell-dbus/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

