/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import java.util.function.BiConsumer;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public final class ObjectParserHelper<Value, Context> {
    public void declareRawObject(AbstractObjectParser<Value, Context> parser, BiConsumer<Value, BytesReference> consumer, ParseField field) {
        CheckedFunction bytesParser = p -> {
            try (XContentBuilder builder = JsonXContent.contentBuilder();){
                builder.copyCurrentStructure(p);
                BytesReference bytesReference = BytesReference.bytes(builder);
                return bytesReference;
            }
        };
        parser.declareField(consumer, bytesParser, field, ObjectParser.ValueType.OBJECT);
    }
}

