/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.NonExtensible;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.internal.Cast;
import org.gradle.internal.extensibility.NoConventionMapping;
import org.gradle.internal.instantiation.ClassGenerationException;
import org.gradle.internal.instantiation.ClassGenerator;
import org.gradle.internal.instantiation.InjectAnnotationHandler;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.ClassDetails;
import org.gradle.internal.reflect.ClassInspector;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaPropertyReflectionUtil;
import org.gradle.internal.reflect.MethodSet;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.internal.reflect.PropertyDetails;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;

abstract class AbstractClassGenerator
implements ClassGenerator {
    private static final Map<Object, Map<Class<?>, CachedClass>> GENERATED_CLASSES = new HashMap();
    private static final Lock CACHE_LOCK = new ReentrantLock();
    private final ImmutableSet<Class<? extends Annotation>> disabledAnnotations;
    private final ImmutableSet<Class<? extends Annotation>> enabledAnnotations;

    public AbstractClassGenerator(Collection<? extends InjectAnnotationHandler> allKnownAnnotations, Collection<Class<? extends Annotation>> enabledAnnotations) {
        this.enabledAnnotations = ImmutableSet.copyOf(enabledAnnotations);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (InjectAnnotationHandler injectAnnotationHandler : allKnownAnnotations) {
            if (enabledAnnotations.contains(injectAnnotationHandler.getAnnotation())) continue;
            builder.add(injectAnnotationHandler.getAnnotation());
        }
        this.disabledAnnotations = builder.build();
    }

    @Override
    public <T> ClassGenerator.GeneratedClass<? extends T> generate(Class<T> type) {
        CACHE_LOCK.lock();
        try {
            ClassGenerator.GeneratedClass generatedClass = (ClassGenerator.GeneratedClass)Cast.uncheckedCast(this.generateUnderLock(type));
            return generatedClass;
        }
        finally {
            CACHE_LOCK.unlock();
        }
    }

    private ClassGenerator.GeneratedClass<?> generateUnderLock(Class<?> type) {
        Class<?> subclass;
        GeneratedClassImpl wrapper;
        CachedClass generatedClass;
        Map<Class<?>, CachedClass> cache = GENERATED_CLASSES.get(this.key());
        if (cache == null) {
            cache = new WeakHashMap();
            GENERATED_CLASSES.put(this.key(), cache);
        }
        if ((generatedClass = cache.get(type)) != null && (wrapper = generatedClass.asWrapper()) != null) {
            return wrapper;
        }
        ServicesPropertyHandler servicesHandler = new ServicesPropertyHandler();
        InjectAnnotationPropertyHandler injectionHandler = new InjectAnnotationPropertyHandler();
        PropertyTypePropertyHandler propertyTypedHandler = new PropertyTypePropertyHandler();
        AbstractPropertyHandler abstractPropertyHandler = new AbstractPropertyHandler();
        ExtensibleTypePropertyHandler extensibleTypeHandler = new ExtensibleTypePropertyHandler();
        DslMixInPropertyType dslMixInHandler = new DslMixInPropertyType(extensibleTypeHandler);
        ArrayList<ClassGenerationHandler> handlers = new ArrayList<ClassGenerationHandler>(5 + this.enabledAnnotations.size() + this.disabledAnnotations.size());
        handlers.add(extensibleTypeHandler);
        handlers.add(dslMixInHandler);
        handlers.add(propertyTypedHandler);
        handlers.add(servicesHandler);
        handlers.add(abstractPropertyHandler);
        for (Class annotation : this.enabledAnnotations) {
            handlers.add(new CustomInjectAnnotationPropertyHandler(annotation));
        }
        handlers.add(injectionHandler);
        ArrayList<ClassValidator> validators = new ArrayList<ClassValidator>(1 + this.disabledAnnotations.size());
        for (Class annotation : this.disabledAnnotations) {
            validators.add(new DisabledAnnotationValidator(annotation));
        }
        validators.add(new InjectionAnnotationValidator((Set<Class<? extends Annotation>>)this.enabledAnnotations));
        try {
            ClassInspectionVisitor inspectionVisitor = this.start(type);
            this.inspectType(type, validators, handlers, extensibleTypeHandler);
            for (ClassGenerationHandler handler : handlers) {
                handler.applyTo(inspectionVisitor);
            }
            ClassGenerationVisitor generationVisitor = inspectionVisitor.builder();
            for (ClassGenerationHandler handler : handlers) {
                handler.applyTo(generationVisitor);
            }
            if (type.isInterface()) {
                generationVisitor.addDefaultConstructor();
            } else {
                for (Constructor<?> constructor : type.getConstructors()) {
                    generationVisitor.addConstructor(constructor);
                }
            }
            subclass = generationVisitor.generate();
        }
        catch (ClassGenerationException e) {
            throw e;
        }
        catch (Throwable e) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Could not generate a decorated class for ");
            formatter.appendType(type);
            formatter.append((CharSequence)".");
            throw new ClassGenerationException(formatter.toString(), e);
        }
        List<Class<?>> injectedServices = injectionHandler.getInjectedServices();
        CachedClass cachedClass = new CachedClass(subclass, injectedServices);
        cache.put(type, cachedClass);
        cache.put(subclass, cachedClass);
        return cachedClass.asWrapper();
    }

    protected abstract Object key();

    protected abstract ClassInspectionVisitor start(Class<?> var1);

    protected abstract <T> T newInstance(Constructor<T> var1, ServiceLookup var2, Instantiator var3, Object[] var4) throws InvocationTargetException, IllegalAccessException, InstantiationException;

    /*
     * WARNING - void declaration
     */
    private void inspectType(Class<?> type, List<ClassValidator> validators, List<ClassGenerationHandler> propertyHandlers, UnclaimedPropertyHandler unclaimedHandler) {
        ClassDetails classDetails = ClassInspector.inspect(type);
        ClassMetaData classMetaData = new ClassMetaData();
        this.assembleProperties(classDetails, classMetaData);
        for (ClassGenerationHandler classGenerationHandler : propertyHandlers) {
            classGenerationHandler.startType(type);
        }
        for (Method method : classDetails.getAllMethods()) {
            for (ClassValidator classValidator : validators) {
                classValidator.validateMethod(method, PropertyAccessorType.of(method));
            }
        }
        for (PropertyDetails propertyDetails : classDetails.getProperties()) {
            void var10_20;
            PropertyMetaData propertyMetaData = classMetaData.property(propertyDetails.getName());
            for (ClassGenerationHandler propertyHandler : propertyHandlers) {
                propertyHandler.visitProperty(propertyMetaData);
            }
            Object var10_19 = null;
            for (ClassGenerationHandler propertyHandler : propertyHandlers) {
                if (!propertyHandler.claimProperty(propertyMetaData)) continue;
                if (var10_20 == null) {
                    ClassGenerationHandler classGenerationHandler = propertyHandler;
                    continue;
                }
                propertyHandler.ambiguous(propertyMetaData);
                break;
            }
            if (var10_20 != null) continue;
            unclaimedHandler.unclaimed(propertyMetaData);
            for (Method method : propertyDetails.getGetters()) {
                this.assertNotAbstract(type, method);
            }
            for (Method method : propertyDetails.getSetters()) {
                this.assertNotAbstract(type, method);
            }
            for (Method method : propertyMetaData.setMethods) {
                this.assertNotAbstract(type, method);
            }
        }
        for (Method method : classDetails.getInstanceMethods()) {
            this.assertNotAbstract(type, method);
            for (ClassGenerationHandler classGenerationHandler : propertyHandlers) {
                classGenerationHandler.visitInstanceMethod(method);
            }
        }
    }

    private void assembleProperties(ClassDetails classDetails, ClassMetaData classMetaData) {
        for (PropertyDetails propertyDetails : classDetails.getProperties()) {
            PropertyMetaData propertyMetaData = classMetaData.property(propertyDetails.getName());
            for (Method method : propertyDetails.getGetters()) {
                propertyMetaData.addGetter(method);
            }
            for (Method method : propertyDetails.getSetters()) {
                propertyMetaData.addSetter(method);
            }
        }
        for (Method method : classDetails.getInstanceMethods()) {
            PropertyMetaData propertyMetaData;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1 || (propertyMetaData = classMetaData.getProperty(method.getName())) == null) continue;
            propertyMetaData.addSetMethod(method);
        }
    }

    private void assertNotAbstract(Class<?> type, Method method) {
        if (Modifier.isAbstract(type.getModifiers()) && Modifier.isAbstract(method.getModifiers())) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Cannot have abstract method ");
            formatter.appendMethod(method);
            formatter.append((CharSequence)".");
            throw new IllegalArgumentException(formatter.toString());
        }
    }

    protected static interface ClassGenerationVisitor {
        public void addConstructor(Constructor<?> var1);

        public void addDefaultConstructor();

        public void mixInDynamicAware();

        public void mixInConventionAware();

        public void mixInGroovyObject();

        public void addDynamicMethods();

        public void addExtensionsProperty();

        public void applyServiceInjectionToProperty(PropertyMetaData var1);

        public void applyServiceInjectionToGetter(PropertyMetaData var1, Method var2);

        public void applyServiceInjectionToSetter(PropertyMetaData var1, Method var2);

        public void applyServiceInjectionToGetter(PropertyMetaData var1, Class<? extends Annotation> var2, Method var3);

        public void applyServiceInjectionToSetter(PropertyMetaData var1, Class<? extends Annotation> var2, Method var3);

        public void applyManagedStateToProperty(PropertyMetaData var1);

        public void applyManagedStateToGetter(PropertyMetaData var1, Method var2);

        public void applyManagedStateToSetter(PropertyMetaData var1, Method var2);

        public void applyConventionMappingToProperty(PropertyMetaData var1);

        public void applyConventionMappingToGetter(PropertyMetaData var1, Method var2);

        public void applyConventionMappingToSetter(PropertyMetaData var1, Method var2);

        public void applyConventionMappingToSetMethod(PropertyMetaData var1, Method var2);

        public void addSetMethod(PropertyMetaData var1, Method var2);

        public void addActionMethod(Method var1);

        public void addPropertySetters(PropertyMetaData var1, Method var2);

        public Class<?> generate() throws Exception;
    }

    protected static interface ClassInspectionVisitor {
        public void mixInExtensible();

        public void mixInConventionAware();

        public void providesOwnDynamicObjectImplementation();

        public void providesOwnServicesImplementation();

        public void mixInServiceInjection();

        public ClassGenerationVisitor builder();
    }

    private static class DisabledAnnotationValidator
    implements ClassValidator {
        private final Class<? extends Annotation> annotation;

        public DisabledAnnotationValidator(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Override
        public void validateMethod(Method method, PropertyAccessorType accessorType) {
            if (method.getAnnotation(this.annotation) != null) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation(this.annotation);
                formatter.append((CharSequence)" annotation on method ");
                formatter.appendMethod(method);
                formatter.append((CharSequence)".");
                throw new IllegalArgumentException(formatter.toString());
            }
        }
    }

    private static class CustomInjectAnnotationPropertyHandler
    extends AbstractInjectedPropertyHandler {
        public CustomInjectAnnotationPropertyHandler(Class<? extends Annotation> injectAnnotation) {
            super(injectAnnotation);
        }

        @Override
        public void applyTo(ClassGenerationVisitor visitor) {
            for (PropertyMetaData property : this.serviceInjectionProperties) {
                visitor.applyServiceInjectionToProperty(property);
                for (Method getter : property.getOverridableGetters()) {
                    visitor.applyServiceInjectionToGetter(property, this.annotation, getter);
                }
                for (Method setter : property.getOverridableSetters()) {
                    visitor.applyServiceInjectionToSetter(property, this.annotation, setter);
                }
            }
        }
    }

    private static class InjectAnnotationPropertyHandler
    extends AbstractInjectedPropertyHandler {
        public InjectAnnotationPropertyHandler() {
            super(Inject.class);
        }

        @Override
        public void applyTo(ClassGenerationVisitor visitor) {
            for (PropertyMetaData property : this.serviceInjectionProperties) {
                visitor.applyServiceInjectionToProperty(property);
                for (Method getter : property.getOverridableGetters()) {
                    visitor.applyServiceInjectionToGetter(property, getter);
                }
                for (Method setter : property.getOverridableSetters()) {
                    visitor.applyServiceInjectionToSetter(property, setter);
                }
            }
        }
    }

    private static abstract class AbstractInjectedPropertyHandler
    extends ClassGenerationHandler {
        final Class<? extends Annotation> annotation;
        final List<PropertyMetaData> serviceInjectionProperties = new ArrayList<PropertyMetaData>();

        public AbstractInjectedPropertyHandler(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        @Override
        public boolean claimProperty(PropertyMetaData property) {
            for (Method method : property.getters) {
                if (method.getAnnotation(this.annotation) == null) continue;
                this.serviceInjectionProperties.add(property);
                return true;
            }
            return false;
        }

        @Override
        void ambiguous(PropertyMetaData property) {
            for (Method method : property.getters) {
                if (method.getAnnotation(this.annotation) == null) continue;
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation(this.annotation);
                formatter.append((CharSequence)" annotation on method ");
                formatter.appendMethod(method);
                formatter.append((CharSequence)".");
                throw new IllegalArgumentException(formatter.toString());
            }
            super.ambiguous(property);
        }

        @Override
        void applyTo(ClassInspectionVisitor visitor) {
            if (!this.serviceInjectionProperties.isEmpty()) {
                visitor.mixInServiceInjection();
            }
        }

        public List<Class<?>> getInjectedServices() {
            ImmutableList.Builder services = ImmutableList.builderWithExpectedSize((int)this.serviceInjectionProperties.size());
            for (PropertyMetaData property : this.serviceInjectionProperties) {
                services.add(property.getType());
            }
            return services.build();
        }
    }

    private static class ServicesPropertyHandler
    extends ClassGenerationHandler {
        private boolean hasServicesProperty;

        private ServicesPropertyHandler() {
        }

        @Override
        public boolean claimProperty(PropertyMetaData property) {
            if (property.getName().equals("services") && property.isReadable() && ServiceRegistry.class.isAssignableFrom(property.getType())) {
                this.hasServicesProperty = true;
                return true;
            }
            return false;
        }

        @Override
        void applyTo(ClassInspectionVisitor visitor) {
            if (this.hasServicesProperty) {
                visitor.providesOwnServicesImplementation();
            }
        }
    }

    private static class InjectionAnnotationValidator
    implements ClassValidator {
        private final Set<Class<? extends Annotation>> annotationTypes;

        InjectionAnnotationValidator(Set<Class<? extends Annotation>> annotationTypes) {
            this.annotationTypes = annotationTypes;
        }

        @Override
        public void validateMethod(Method method, PropertyAccessorType accessorType) {
            ArrayList<Class<? extends Annotation>> matches = new ArrayList<Class<? extends Annotation>>();
            this.validateMethod(method, accessorType, Inject.class, matches);
            for (Class<? extends Annotation> annotationType : this.annotationTypes) {
                this.validateMethod(method, accessorType, annotationType, matches);
            }
            if (matches.size() > 1) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation((Class)matches.get(0));
                formatter.append((CharSequence)" and ");
                formatter.appendAnnotation((Class)matches.get(1));
                formatter.append((CharSequence)" annotations together on method ");
                formatter.appendMethod(method);
                formatter.append((CharSequence)".");
                throw new IllegalArgumentException(formatter.toString());
            }
        }

        private void validateMethod(Method method, PropertyAccessorType accessorType, Class<? extends Annotation> annotationType, List<Class<? extends Annotation>> matches) {
            if (method.getAnnotation(annotationType) == null) {
                return;
            }
            matches.add(annotationType);
            if (Modifier.isStatic(method.getModifiers())) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation(annotationType);
                formatter.append((CharSequence)" annotation on method ");
                formatter.appendMethod(method);
                formatter.append((CharSequence)" as it is static.");
                throw new IllegalArgumentException(formatter.toString());
            }
            if (accessorType != PropertyAccessorType.GET_GETTER) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation(annotationType);
                formatter.append((CharSequence)" annotation on method ");
                formatter.appendMethod(method);
                formatter.append((CharSequence)" as it is not a property getter.");
                throw new IllegalArgumentException(formatter.toString());
            }
            if (Modifier.isFinal(method.getModifiers())) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation(annotationType);
                formatter.append((CharSequence)" annotation on method ");
                formatter.appendMethod(method);
                formatter.append((CharSequence)" as it is final.");
                throw new IllegalArgumentException(formatter.toString());
            }
            if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isProtected(method.getModifiers())) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Cannot use ");
                formatter.appendAnnotation(annotationType);
                formatter.append((CharSequence)" annotation on method ");
                formatter.appendMethod(method);
                formatter.append((CharSequence)" as it is not public or protected.");
                throw new IllegalArgumentException(formatter.toString());
            }
        }
    }

    private static class PropertyTypePropertyHandler
    extends ClassGenerationHandler {
        private final List<PropertyMetaData> propertyTyped = new ArrayList<PropertyMetaData>();

        private PropertyTypePropertyHandler() {
        }

        @Override
        boolean claimProperty(PropertyMetaData property) {
            if (property.isReadable() && this.isModelProperty(property)) {
                this.propertyTyped.add(property);
                return true;
            }
            return false;
        }

        @Override
        void applyTo(ClassGenerationVisitor visitor) {
            for (PropertyMetaData property : this.propertyTyped) {
                visitor.addPropertySetters(property, property.mainGetter);
            }
        }

        private boolean isModelProperty(PropertyMetaData property) {
            return Property.class.isAssignableFrom(property.getType()) || HasMultipleValues.class.isAssignableFrom(property.getType()) || MapProperty.class.isAssignableFrom(property.getType());
        }
    }

    private static class AbstractPropertyHandler
    extends ClassGenerationHandler {
        private final List<PropertyMetaData> properties = new ArrayList<PropertyMetaData>();

        private AbstractPropertyHandler() {
        }

        @Override
        boolean claimProperty(PropertyMetaData property) {
            for (Method getter : property.getters) {
                if (Modifier.isAbstract(getter.getModifiers())) continue;
                return false;
            }
            for (Method setter : property.setters) {
                if (Modifier.isAbstract(setter.getModifiers())) continue;
                return false;
            }
            if (property.setters.isEmpty()) {
                return false;
            }
            this.properties.add(property);
            return true;
        }

        @Override
        void applyTo(ClassGenerationVisitor visitor) {
            for (PropertyMetaData property : this.properties) {
                visitor.applyManagedStateToProperty(property);
                for (Method getter : property.getters) {
                    visitor.applyManagedStateToGetter(property, getter);
                }
                for (Method setter : property.setters) {
                    visitor.applyManagedStateToSetter(property, setter);
                }
            }
        }
    }

    private static class ExtensibleTypePropertyHandler
    extends ClassGenerationHandler
    implements UnclaimedPropertyHandler {
        private Class<?> type;
        private Class<?> noMappingClass;
        private boolean conventionAware;
        private boolean extensible;
        private boolean hasExtensionAwareImplementation;
        private final List<PropertyMetaData> conventionProperties = new ArrayList<PropertyMetaData>();

        private ExtensibleTypePropertyHandler() {
        }

        @Override
        void startType(Class<?> type) {
            this.type = type;
            this.extensible = JavaPropertyReflectionUtil.getAnnotation(type, NonExtensible.class) == null;
            this.noMappingClass = Object.class;
            for (Class<?> c = type; c != null && this.noMappingClass == Object.class; c = c.getSuperclass()) {
                if (c.getAnnotation(NoConventionMapping.class) == null) continue;
                this.noMappingClass = c;
            }
            this.conventionAware = this.extensible && this.noMappingClass != type;
        }

        @Override
        boolean claimProperty(PropertyMetaData property) {
            if (this.extensible) {
                if (property.getName().equals("extensions")) {
                    for (Method getter : property.getOverridableGetters()) {
                        if (!Modifier.isAbstract(getter.getModifiers())) continue;
                        return true;
                    }
                    this.hasExtensionAwareImplementation = true;
                    return true;
                }
                if (property.getName().equals("conventionMapping") || property.getName().equals("convention")) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void unclaimed(PropertyMetaData property) {
            for (Method getter : property.getOverridableGetters()) {
                if (getter.getDeclaringClass().isAssignableFrom(this.noMappingClass)) continue;
                this.conventionProperties.add(property);
                break;
            }
        }

        @Override
        void applyTo(ClassInspectionVisitor visitor) {
            if (this.extensible) {
                visitor.mixInExtensible();
            }
            if (this.conventionAware) {
                visitor.mixInConventionAware();
            }
        }

        @Override
        void applyTo(ClassGenerationVisitor visitor) {
            if (this.extensible && !this.hasExtensionAwareImplementation) {
                visitor.addExtensionsProperty();
            }
            if (this.conventionAware && !IConventionAware.class.isAssignableFrom(this.type)) {
                visitor.mixInConventionAware();
            }
            for (PropertyMetaData property : this.conventionProperties) {
                visitor.applyConventionMappingToProperty(property);
                for (Method getter : property.getOverridableGetters()) {
                    visitor.applyConventionMappingToGetter(property, getter);
                }
                for (Method setter : property.getOverridableSetters()) {
                    visitor.applyConventionMappingToSetter(property, setter);
                }
            }
        }
    }

    private static class DslMixInPropertyType
    extends ClassGenerationHandler {
        private final ExtensibleTypePropertyHandler extensibleTypeHandler;
        private boolean providesOwnDynamicObject;
        private boolean needDynamicAware;
        private boolean needGroovyObject;
        private final List<PropertyMetaData> mutableProperties = new ArrayList<PropertyMetaData>();
        private final MethodSet actionMethods = new MethodSet();
        private final SetMultimap<String, Method> closureMethods = LinkedHashMultimap.create();

        public DslMixInPropertyType(ExtensibleTypePropertyHandler extensibleTypeHandler) {
            this.extensibleTypeHandler = extensibleTypeHandler;
        }

        @Override
        void startType(Class<?> type) {
            this.needDynamicAware = !DynamicObjectAware.class.isAssignableFrom(type);
            this.needGroovyObject = !GroovyObject.class.isAssignableFrom(type);
        }

        @Override
        void visitProperty(PropertyMetaData property) {
            if (property.setters.isEmpty()) {
                return;
            }
            if (Iterable.class.isAssignableFrom(property.getType())) {
                return;
            }
            this.mutableProperties.add(property);
        }

        @Override
        boolean claimProperty(PropertyMetaData property) {
            if (property.getName().equals("asDynamicObject")) {
                this.providesOwnDynamicObject = true;
                return true;
            }
            return false;
        }

        @Override
        public void visitInstanceMethod(Method method) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length > 0 && parameterTypes[parameterTypes.length - 1].equals(Action.class)) {
                this.actionMethods.add(method);
            } else if (parameterTypes.length > 0 && parameterTypes[parameterTypes.length - 1].equals(Closure.class)) {
                this.closureMethods.put((Object)method.getName(), (Object)method);
            }
        }

        @Override
        void applyTo(ClassInspectionVisitor visitor) {
            if (this.providesOwnDynamicObject) {
                visitor.providesOwnDynamicObjectImplementation();
            }
        }

        @Override
        void applyTo(ClassGenerationVisitor visitor) {
            if (this.needDynamicAware) {
                visitor.mixInDynamicAware();
            }
            if (this.needGroovyObject) {
                visitor.mixInGroovyObject();
            }
            visitor.addDynamicMethods();
            this.addMissingClosureOverloads(visitor);
            this.addSetMethods(visitor);
        }

        private void addSetMethods(ClassGenerationVisitor visitor) {
            for (PropertyMetaData property : this.mutableProperties) {
                if (property.setMethods.isEmpty()) {
                    for (Method setter : property.setters) {
                        visitor.addSetMethod(property, setter);
                    }
                    continue;
                }
                if (!this.extensibleTypeHandler.conventionProperties.contains(property)) continue;
                for (Method setMethod : property.setMethods) {
                    visitor.applyConventionMappingToSetMethod(property, setMethod);
                }
            }
        }

        private void addMissingClosureOverloads(ClassGenerationVisitor visitor) {
            for (Method method : this.actionMethods) {
                Method overload = this.findClosureOverload(method, this.closureMethods.get((Object)method.getName()));
                if (overload != null) continue;
                visitor.addActionMethod(method);
            }
        }

        @Nullable
        private Method findClosureOverload(Method method, Collection<Method> candidates) {
            for (Method candidate : candidates) {
                if (candidate.getParameterTypes().length != method.getParameterTypes().length) continue;
                boolean matches = true;
                for (int i = 0; matches && i < candidate.getParameterTypes().length - 1; ++i) {
                    if (candidate.getParameterTypes()[i].equals(method.getParameterTypes()[i])) continue;
                    matches = false;
                }
                if (!matches) continue;
                return candidate;
            }
            return null;
        }
    }

    private static interface UnclaimedPropertyHandler {
        public void unclaimed(PropertyMetaData var1);
    }

    private static class ClassGenerationHandler {
        private ClassGenerationHandler() {
        }

        void startType(Class<?> type) {
        }

        void visitInstanceMethod(Method method) {
        }

        void visitProperty(PropertyMetaData property) {
        }

        boolean claimProperty(PropertyMetaData property) {
            return false;
        }

        void ambiguous(PropertyMetaData property) {
            throw new UnsupportedOperationException("Multiple matches for " + property.getName());
        }

        void applyTo(ClassInspectionVisitor visitor) {
        }

        void applyTo(ClassGenerationVisitor visitor) {
        }
    }

    private static interface ClassValidator {
        public void validateMethod(Method var1, PropertyAccessorType var2);
    }

    protected static class PropertyMetaData {
        private final String name;
        private final List<Method> getters = new ArrayList<Method>();
        private final List<Method> overridableGetters = new ArrayList<Method>();
        private final List<Method> overridableSetters = new ArrayList<Method>();
        private final List<Method> setters = new ArrayList<Method>();
        private final List<Method> setMethods = new ArrayList<Method>();
        private Method mainGetter;

        private PropertyMetaData(String name) {
            this.name = name;
        }

        public String toString() {
            return "[property " + this.name + "]";
        }

        public String getName() {
            return this.name;
        }

        public boolean isReadable() {
            return this.mainGetter != null;
        }

        public Iterable<Method> getOverridableGetters() {
            return this.overridableGetters;
        }

        public Iterable<Method> getOverridableSetters() {
            return this.overridableSetters;
        }

        public Class<?> getType() {
            if (this.mainGetter != null) {
                return this.mainGetter.getReturnType();
            }
            return this.setters.get(0).getParameterTypes()[0];
        }

        public Type getGenericType() {
            if (this.mainGetter != null) {
                return this.mainGetter.getGenericReturnType();
            }
            return this.setters.get(0).getGenericParameterTypes()[0];
        }

        public void addGetter(Method method) {
            if (!Modifier.isFinal(method.getModifiers()) && !method.isBridge()) {
                this.overridableGetters.add(method);
            }
            this.getters.add(method);
            if (this.mainGetter == null) {
                this.mainGetter = method;
            } else if (this.mainGetter.isBridge() && !method.isBridge()) {
                this.mainGetter = method;
            }
        }

        public void addSetter(Method method) {
            for (Method setter : this.setters) {
                if (!setter.getParameterTypes()[0].equals(method.getParameterTypes()[0])) continue;
                return;
            }
            this.setters.add(method);
            if (!Modifier.isFinal(method.getModifiers()) && !method.isBridge()) {
                this.overridableSetters.add(method);
            }
        }

        public void addSetMethod(Method method) {
            this.setMethods.add(method);
        }
    }

    private static class ClassMetaData {
        private final Map<String, PropertyMetaData> properties = new LinkedHashMap<String, PropertyMetaData>();

        private ClassMetaData() {
        }

        @Nullable
        public PropertyMetaData getProperty(String name) {
            return this.properties.get(name);
        }

        public PropertyMetaData property(String name) {
            PropertyMetaData property = this.properties.get(name);
            if (property == null) {
                property = new PropertyMetaData(name);
                this.properties.put(name, property);
            }
            return property;
        }
    }

    private class CachedClass {
        private final WeakReference<Class<?>> generatedClass;
        private final WeakReference<Class<?>> outerType;
        private final List<Class<?>> injectedServices;

        CachedClass(Class<?> generatedClass, List<Class<?>> injectedServices) {
            this.generatedClass = new WeakReference(generatedClass);
            this.injectedServices = injectedServices;
            Class<?> enclosingClass = generatedClass.getSuperclass().getEnclosingClass();
            this.outerType = enclosingClass != null && !Modifier.isStatic(generatedClass.getSuperclass().getModifiers()) ? new WeakReference(enclosingClass) : null;
        }

        @Nullable
        public GeneratedClassImpl asWrapper() {
            Class generatedClass = (Class)this.generatedClass.get();
            if (generatedClass == null) {
                return null;
            }
            return new GeneratedClassImpl(generatedClass, this.outerType != null ? (Class)this.outerType.get() : null, this.injectedServices);
        }
    }

    private class GeneratedClassImpl
    implements ClassGenerator.GeneratedClass<Object> {
        private final Class<?> generatedClass;
        private final Class<?> outerType;
        private final List<Class<?>> injectedServices;
        private final List<ClassGenerator.GeneratedConstructor<Object>> constructors;

        public GeneratedClassImpl(@Nullable Class<?> generatedClass, Class<?> outerType, List<Class<?>> injectedServices) {
            this.generatedClass = generatedClass;
            this.outerType = outerType;
            this.injectedServices = injectedServices;
            ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)generatedClass.getDeclaredConstructors().length);
            for (Constructor<?> constructor : generatedClass.getDeclaredConstructors()) {
                builder.add((Object)new GeneratedConstructorImpl(constructor));
            }
            this.constructors = builder.build();
        }

        @Override
        public Class<Object> getGeneratedClass() {
            return (Class)Cast.uncheckedCast(this.generatedClass);
        }

        @Override
        @Nullable
        public Class<?> getOuterType() {
            return this.outerType;
        }

        @Override
        public List<ClassGenerator.GeneratedConstructor<Object>> getConstructors() {
            return this.constructors;
        }

        private class GeneratedConstructorImpl
        implements ClassGenerator.GeneratedConstructor<Object> {
            private final Constructor<?> constructor;

            public GeneratedConstructorImpl(Constructor<?> constructor) {
                this.constructor = constructor;
            }

            @Override
            public Object newInstance(ServiceLookup services, Instantiator nested, Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                return AbstractClassGenerator.this.newInstance(this.constructor, services, nested, params);
            }

            @Override
            public boolean requiresService(Class<?> serviceType) {
                for (Class<?> parameterType : this.constructor.getParameterTypes()) {
                    if (!parameterType.isAssignableFrom(serviceType)) continue;
                    return true;
                }
                for (Class injectedService : GeneratedClassImpl.this.injectedServices) {
                    if (!injectedService.isAssignableFrom(serviceType)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Class<?>[] getParameterTypes() {
                return this.constructor.getParameterTypes();
            }

            @Override
            public Type[] getGenericParameterTypes() {
                return this.constructor.getGenericParameterTypes();
            }

            @Override
            @Nullable
            public <S extends Annotation> S getAnnotation(Class<S> annotation) {
                return (S)this.constructor.getAnnotation(annotation);
            }

            @Override
            public int getModifiers() {
                return this.constructor.getModifiers();
            }
        }
    }
}

