/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.metadata;

import java.net.URI;
import java.util.Date;
import javax.annotation.Nullable;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;

public class DefaultExternalResourceMetaData
implements ExternalResourceMetaData {
    private final URI location;
    private final Date lastModified;
    private final long contentLength;
    private final String etag;
    private final HashValue sha1;
    private final String contentType;

    public DefaultExternalResourceMetaData(URI location, long lastModified, long contentLength) {
        this(location, lastModified > 0L ? new Date(lastModified) : null, contentLength, null, null, null);
    }

    public DefaultExternalResourceMetaData(URI location, long lastModified, long contentLength, @Nullable String contentType, @Nullable String etag, @Nullable HashValue sha1) {
        this(location, lastModified > 0L ? new Date(lastModified) : null, contentLength, contentType, etag, sha1);
    }

    public DefaultExternalResourceMetaData(URI location, @Nullable Date lastModified, long contentLength, @Nullable String contentType, @Nullable String etag, @Nullable HashValue sha1) {
        this.location = location;
        this.lastModified = lastModified;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.etag = etag;
        this.sha1 = sha1;
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    @Nullable
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.contentType;
    }

    @Override
    @Nullable
    public String getEtag() {
        return this.etag;
    }

    @Override
    @Nullable
    public HashValue getSha1() {
        return this.sha1;
    }
}

