/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution.statistics;

import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.statistics.TaskExecutionStatistics;
import org.gradle.api.tasks.TaskState;

public class TaskExecutionStatisticsEventAdapter
implements TaskExecutionListener {
    private int executedTasksCount;
    private int fromCacheTaskCount;
    private int upToDateTaskCount;

    public void beforeExecute(Task task) {
    }

    public void afterExecute(Task task, TaskState state) {
        TaskStateInternal stateInternal = (TaskStateInternal)state;
        if (stateInternal.isActionable()) {
            switch (stateInternal.getOutcome()) {
                case EXECUTED: {
                    ++this.executedTasksCount;
                    break;
                }
                case FROM_CACHE: {
                    ++this.fromCacheTaskCount;
                    break;
                }
                case UP_TO_DATE: {
                    ++this.upToDateTaskCount;
                    break;
                }
            }
        }
    }

    public TaskExecutionStatistics getStatistics() {
        return new TaskExecutionStatistics(this.executedTasksCount, this.fromCacheTaskCount, this.upToDateTaskCount);
    }
}

