/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.PropertiesTransformer;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ear.EarPlugin;
import org.gradle.plugins.ide.api.PropertiesFileContentMerger;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.eclipse.EclipseWtpPlugin;
import org.gradle.plugins.ide.eclipse.GenerateEclipseClasspath;
import org.gradle.plugins.ide.eclipse.GenerateEclipseJdt;
import org.gradle.plugins.ide.eclipse.GenerateEclipseProject;
import org.gradle.plugins.ide.eclipse.internal.AfterEvaluateHelper;
import org.gradle.plugins.ide.eclipse.internal.EclipseProjectMetadata;
import org.gradle.plugins.ide.eclipse.internal.LinkedResourcesCreator;
import org.gradle.plugins.ide.eclipse.model.BuildCommand;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseJdt;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseProject;
import org.gradle.plugins.ide.eclipse.model.Link;
import org.gradle.plugins.ide.eclipse.model.internal.EclipseJavaVersionMapper;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.IdePlugin;
import org.gradle.plugins.ide.internal.configurer.UniqueProjectNameProvider;

public class EclipsePlugin
extends IdePlugin {
    public static final String ECLIPSE_TASK_NAME = "eclipse";
    public static final String ECLIPSE_PROJECT_TASK_NAME = "eclipseProject";
    public static final String ECLIPSE_CP_TASK_NAME = "eclipseClasspath";
    public static final String ECLIPSE_JDT_TASK_NAME = "eclipseJdt";
    private final UniqueProjectNameProvider uniqueProjectNameProvider;
    private final IdeArtifactRegistry artifactRegistry;

    @Inject
    public EclipsePlugin(UniqueProjectNameProvider uniqueProjectNameProvider, IdeArtifactRegistry artifactRegistry) {
        this.uniqueProjectNameProvider = uniqueProjectNameProvider;
        this.artifactRegistry = artifactRegistry;
    }

    @Override
    protected String getLifecycleTaskName() {
        return ECLIPSE_TASK_NAME;
    }

    @Override
    protected void onApply(Project project) {
        this.getLifecycleTask().configure(EclipsePlugin.withDescription("Generates all Eclipse files."));
        this.getCleanTask().configure(EclipsePlugin.withDescription("Cleans all Eclipse files."));
        EclipseModel model = (EclipseModel)project.getExtensions().create(ECLIPSE_TASK_NAME, EclipseModel.class, new Object[0]);
        this.configureEclipseProject((ProjectInternal)project, model);
        this.configureEclipseJdt(project, model);
        this.configureEclipseClasspath(project, model);
        this.applyEclipseWtpPluginOnWebProjects(project);
        this.configureRootProjectTask(project);
    }

    private void configureRootProjectTask(Project project) {
        if (project.getGradle().getParent() == null && project.getParent() == null) {
            this.getLifecycleTask().configure((Action)new Action<Task>(){

                public void execute(Task task) {
                    task.dependsOn(new Object[]{EclipsePlugin.this.artifactRegistry.getIdeProjectFiles(EclipseProjectMetadata.class)});
                }
            });
        }
    }

    private void configureEclipseProject(final ProjectInternal project, EclipseModel model) {
        final EclipseProject projectModel = model.getProject();
        projectModel.setName(this.uniqueProjectNameProvider.getUniqueName((Project)project));
        final ConventionMapping convention = ((IConventionAware)projectModel).getConventionMapping();
        convention.map("comment", (Callable)new Callable<String>(){

            @Override
            public String call() {
                return project.getDescription();
            }
        });
        TaskProvider task = project.getTasks().register(ECLIPSE_PROJECT_TASK_NAME, GenerateEclipseProject.class, new Object[]{model.getProject()});
        task.configure((Action)new Action<GenerateEclipseProject>(){

            public void execute(GenerateEclipseProject task) {
                task.setDescription("Generates the Eclipse project file.");
                task.setInputFile(project.file((Object)".project"));
                task.setOutputFile(project.file((Object)".project"));
            }
        });
        this.addWorker((TaskProvider<? extends Task>)task, ECLIPSE_PROJECT_TASK_NAME);
        project.getPlugins().withType(JavaBasePlugin.class, (Action)new Action<JavaBasePlugin>(){

            public void execute(JavaBasePlugin javaBasePlugin) {
                if (!project.getPlugins().hasPlugin(EarPlugin.class)) {
                    projectModel.buildCommand("org.eclipse.jdt.core.javabuilder");
                }
                projectModel.natures("org.eclipse.jdt.core.javanature");
                convention.map("linkedResources", (Callable)new Callable<Set<Link>>(){

                    @Override
                    public Set<Link> call() {
                        return new LinkedResourcesCreator().links((Project)project);
                    }
                });
            }
        });
        project.getPlugins().withType(GroovyBasePlugin.class, (Action)new Action<GroovyBasePlugin>(){

            public void execute(GroovyBasePlugin groovyBasePlugin) {
                projectModel.getNatures().add(projectModel.getNatures().indexOf("org.eclipse.jdt.core.javanature"), "org.eclipse.jdt.groovy.core.groovyNature");
            }
        });
        project.getPlugins().withType(ScalaBasePlugin.class, (Action)new Action<ScalaBasePlugin>(){

            public void execute(ScalaBasePlugin scalaBasePlugin) {
                projectModel.getBuildCommands().set(Iterables.indexOf(projectModel.getBuildCommands(), (Predicate)new Predicate<BuildCommand>(){

                    public boolean apply(BuildCommand buildCommand) {
                        return buildCommand.getName().equals("org.eclipse.jdt.core.javabuilder");
                    }
                }), new BuildCommand("org.scala-ide.sdt.core.scalabuilder"));
                projectModel.getNatures().add(projectModel.getNatures().indexOf("org.eclipse.jdt.core.javanature"), "org.scala-ide.sdt.core.scalanature");
            }
        });
        this.artifactRegistry.registerIdeProject(new EclipseProjectMetadata(projectModel, project.getProjectDir(), (TaskProvider<? extends Task>)task));
    }

    private void configureEclipseClasspath(final Project project, final EclipseModel model) {
        model.setClasspath((EclipseClasspath)project.getObjects().newInstance(EclipseClasspath.class, new Object[]{project}));
        ((IConventionAware)model.getClasspath()).getConventionMapping().map("defaultOutputDir", (Callable)new Callable<File>(){

            @Override
            public File call() {
                return new File(project.getProjectDir(), "bin/default");
            }
        });
        project.getPlugins().withType(JavaBasePlugin.class, (Action)new Action<JavaBasePlugin>(){

            public void execute(JavaBasePlugin javaBasePlugin) {
                TaskProvider task = project.getTasks().register(EclipsePlugin.ECLIPSE_CP_TASK_NAME, GenerateEclipseClasspath.class, new Object[]{model.getClasspath()});
                task.configure((Action)new Action<GenerateEclipseClasspath>(){

                    public void execute(GenerateEclipseClasspath task) {
                        task.setDescription("Generates the Eclipse classpath file.");
                        task.setInputFile(project.file((Object)".classpath"));
                        task.setOutputFile(project.file((Object)".classpath"));
                    }
                });
                EclipsePlugin.this.addWorker((TaskProvider<? extends Task>)task, EclipsePlugin.ECLIPSE_CP_TASK_NAME);
                XmlTransformer xmlTransformer = new XmlTransformer();
                xmlTransformer.setIndentation("\t");
                model.getClasspath().setFile(new XmlFileContentMerger(xmlTransformer));
                model.getClasspath().setSourceSets((Iterable<SourceSet>)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets());
                AfterEvaluateHelper.afterEvaluateOrExecute(project, new Action<Project>(){

                    public void execute(Project p) {
                        LinkedHashSet containers = Sets.newLinkedHashSet();
                        containers.add("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/" + model.getJdt().getJavaRuntimeName() + "/");
                        containers.addAll(model.getClasspath().getContainers());
                        model.getClasspath().setContainers(containers);
                    }
                });
                EclipsePlugin.configureScalaDependencies(project, model);
                EclipsePlugin.configureJavaClasspath(project, (TaskProvider<GenerateEclipseClasspath>)task, model);
            }
        });
    }

    private static void configureJavaClasspath(final Project project, final TaskProvider<GenerateEclipseClasspath> task, final EclipseModel model) {
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                model.getClasspath().setPlusConfigurations(Lists.newArrayList((Object[])new Configuration[]{project.getConfigurations().getByName("compileClasspath"), project.getConfigurations().getByName("runtimeClasspath"), project.getConfigurations().getByName("testCompileClasspath"), project.getConfigurations().getByName("testRuntimeClasspath")}));
                ((IConventionAware)model.getClasspath()).getConventionMapping().map("classFolders", (Callable)new Callable<List<File>>(){

                    @Override
                    public List<File> call() {
                        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
                        return Lists.newArrayList((Iterable)Iterables.concat((Iterable)((SourceSet)sourceSets.getByName("main")).getOutput().getDirs(), (Iterable)((SourceSet)sourceSets.getByName("test")).getOutput().getDirs()));
                    }
                });
                task.configure((Action)new Action<GenerateEclipseClasspath>(){

                    public void execute(GenerateEclipseClasspath task) {
                        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
                        task.dependsOn(new Object[]{((SourceSet)sourceSets.getByName("main")).getOutput().getDirs()});
                        task.dependsOn(new Object[]{((SourceSet)sourceSets.getByName("test")).getOutput().getDirs()});
                    }
                });
            }
        });
    }

    private static void configureScalaDependencies(final Project project, final EclipseModel model) {
        project.getPlugins().withType(ScalaBasePlugin.class, (Action)new Action<ScalaBasePlugin>(){

            public void execute(ScalaBasePlugin scalaBasePlugin) {
                model.getClasspath().containers("org.scala-ide.sdt.launching.SCALA_CONTAINER");
                project.getGradle().addBuildListener((BuildListener)new BuildAdapter(){

                    public void projectsEvaluated(Gradle gradle) {
                        final ArrayList provided = Lists.newArrayList((Object[])new String[]{"scala-library", "scala-swing", "scala-dbc"});
                        Predicate<Dependency> dependencyInProvided = new Predicate<Dependency>(){

                            public boolean apply(Dependency dependency) {
                                return provided.contains(dependency.getName());
                            }
                        };
                        ArrayList dependencies = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform(model.getClasspath().getPlusConfigurations(), (Function)new Function<Configuration, Iterable<Dependency>>(){

                            public Iterable<Dependency> apply(Configuration config) {
                                return config.getAllDependencies();
                            }
                        })), (Predicate)dependencyInProvided));
                        if (!dependencies.isEmpty()) {
                            model.getClasspath().getMinusConfigurations().add(project.getConfigurations().detachedConfiguration(dependencies.toArray(new Dependency[0])));
                        }
                    }
                });
            }
        });
    }

    private void configureEclipseJdt(final Project project, final EclipseModel model) {
        project.getPlugins().withType(JavaBasePlugin.class, (Action)new Action<JavaBasePlugin>(){

            public void execute(JavaBasePlugin javaBasePlugin) {
                model.setJdt((EclipseJdt)project.getObjects().newInstance(EclipseJdt.class, new Object[]{new PropertiesFileContentMerger(new PropertiesTransformer())}));
                TaskProvider task = project.getTasks().register(EclipsePlugin.ECLIPSE_JDT_TASK_NAME, GenerateEclipseJdt.class, new Object[]{model.getJdt()});
                task.configure((Action)new Action<GenerateEclipseJdt>(){

                    public void execute(GenerateEclipseJdt task) {
                        task.setDescription("Generates the Eclipse JDT settings file.");
                        task.setOutputFile(project.file((Object)".settings/org.eclipse.jdt.core.prefs"));
                        task.setInputFile(project.file((Object)".settings/org.eclipse.jdt.core.prefs"));
                    }
                });
                EclipsePlugin.this.addWorker((TaskProvider<? extends Task>)task, EclipsePlugin.ECLIPSE_JDT_TASK_NAME);
                ConventionMapping conventionMapping = ((IConventionAware)model.getJdt()).getConventionMapping();
                conventionMapping.map("sourceCompatibility", (Callable)new Callable<JavaVersion>(){

                    @Override
                    public JavaVersion call() {
                        return ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceCompatibility();
                    }
                });
                conventionMapping.map("targetCompatibility", (Callable)new Callable<JavaVersion>(){

                    @Override
                    public JavaVersion call() {
                        return ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getTargetCompatibility();
                    }
                });
                conventionMapping.map("javaRuntimeName", (Callable)new Callable<String>(){

                    @Override
                    public String call() {
                        return EclipsePlugin.eclipseJavaRuntimeNameFor(((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getTargetCompatibility());
                    }
                });
            }
        });
    }

    private static String eclipseJavaRuntimeNameFor(JavaVersion version) {
        String eclipseJavaVersion = EclipseJavaVersionMapper.toEclipseJavaVersion(version);
        switch (version) {
            case VERSION_1_1: {
                return "JRE-1.1";
            }
            case VERSION_1_2: 
            case VERSION_1_3: 
            case VERSION_1_4: 
            case VERSION_1_5: {
                return "J2SE-" + eclipseJavaVersion;
            }
        }
        return "JavaSE-" + eclipseJavaVersion;
    }

    private void applyEclipseWtpPluginOnWebProjects(Project project) {
        Action<Plugin<Project>> action = this.createActionApplyingEclipseWtpPlugin();
        project.getPlugins().withType(WarPlugin.class, action);
        project.getPlugins().withType(EarPlugin.class, action);
    }

    private Action<Plugin<Project>> createActionApplyingEclipseWtpPlugin() {
        return new Action<Plugin<Project>>(){

            public void execute(Plugin<Project> plugin) {
                EclipsePlugin.this.project.getPluginManager().apply(EclipseWtpPlugin.class);
            }
        };
    }
}

