#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 HsYAML-aeson
version:              0.2.0.0
visibility:           public
id:                   HsYAML-aeson-0.2.0.0-AuHtmIZg1fk2OVK5b5ZE0n
key:                  HsYAML-aeson-0.2.0.0-AuHtmIZg1fk2OVK5b5ZE0n
license:              GPL-2.0-or-later
copyright:            2018-2019 Herbert Valerio Riedel
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel
synopsis:             JSON to YAML Adapter
description:
    The [YAML 1.2](https://yaml.org/spec/1.2/spec.html) format provides
    a much richer data-model and feature-set
    than the [JavaScript Object Notation (JSON)](https://tools.ietf.org/html/rfc7159) format.
    However, sometimes it'\''s desirable to ignore the extra capabilities
    and treat YAML as if it was merely a more convenient markup format
    for humans to write JSON data. To this end this module provides a
    compatibility layer atop [HsYAML](https://hackage.haskell.org/package/HsYAML)
    which allows decoding YAML documents in the more limited JSON data-model while also providing
    convenience by reusing [aeson](https://hackage.haskell.org/package/aeson)'\''s
    '\''FromJSON'\'' instances for decoding the YAML data into native Haskell data types.

category:             Text, Codec, Web, JSON, YAML
abi:                  cd22cea171bbbfaa9a55d3a070be39d1
exposed:              True
exposed-modules:      Data.YAML.Aeson
import-dirs:          /usr/lib/ghc-8.10.5/site-local/HsYAML-aeson-0.2.0.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/HsYAML-aeson-0.2.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/HsYAML-aeson-0.2.0.0
hs-libraries:         HSHsYAML-aeson-0.2.0.0-AuHtmIZg1fk2OVK5b5ZE0n
depends:
    HsYAML-0.2.1.0-9vDKmnmJIrb8rRs1JLDnYU
    aeson-1.5.6.0-IA546NaLWlLGqcowhw6tTs base-4.14.2.0
    bytestring-0.10.12.0 containers-0.6.4.1 mtl-2.2.2
    scientific-0.3.7.0-Ea1GK6jx8XDEEsfAKxwFym text-1.2.4.1
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:
    /usr/share/doc/haskell-hsyaml-aeson/html/HsYAML-aeson.haddock

haddock-html:         /usr/share/doc/haskell-hsyaml-aeson/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

