/*
* Copyright (c) 2011 Erin Catto http://box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

#include "b2Timer.h"

b2Timer::b2Timer()
{
    Reset();
}

void b2Timer::Reset()
{
	juceStartTime = juce::Time::getCurrentTime();
}

float32 b2Timer::GetMilliseconds() const
{
	return static_cast<float32> ((juce::Time::getCurrentTime() - juceStartTime).inMilliseconds());
}
