/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.jboss.as.controller.services.path.PathEntry;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.AbstractTrustManagerService;
import org.jboss.as.domain.management.security.FileKeystore;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.manager.WildFlySecurityManager;

class FileTrustManagerService
extends AbstractTrustManagerService {
    private final Supplier<PathManager> pathManagerSupplier;
    private volatile String provider;
    private volatile String path;
    private volatile String relativeTo;
    private volatile TrustManagerFactory trustManagerFactory;
    private volatile FileKeystore keyStore;

    FileTrustManagerService(Consumer<TrustManager[]> trustManagersConsumer, Supplier<PathManager> pathManagerSupplier, ExceptionSupplier<CredentialSource, Exception> credentialSourceSupplier, String provider, String path, String relativeTo, char[] keystorePassword) {
        super(trustManagersConsumer, credentialSourceSupplier, keystorePassword);
        this.pathManagerSupplier = pathManagerSupplier;
        this.provider = provider;
        this.path = path;
        this.relativeTo = relativeTo;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRelativeTo() {
        return this.relativeTo;
    }

    public void setRelativeTo(String relativeTo) {
        this.relativeTo = relativeTo;
    }

    @Override
    public void start(StartContext context) throws StartException {
        try {
            this.trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw DomainManagementLogger.ROOT_LOGGER.unableToStart(e);
        }
        String file = this.path;
        if (this.relativeTo != null) {
            PathManager pm = this.pathManagerSupplier.get();
            file = pm.resolveRelativePathEntry(file, this.relativeTo);
            pm.registerCallback(this.relativeTo, new PathManager.Callback(){

                public void pathModelEvent(PathManager.PathEventContext eventContext, String name) {
                    if (!eventContext.isResourceServiceRestartAllowed()) {
                        eventContext.reloadRequired();
                    }
                }

                public void pathEvent(PathManager.Event event, PathEntry pathEntry) {
                }
            }, new PathManager.Event[]{PathManager.Event.REMOVED, PathManager.Event.UPDATED});
        }
        this.keyStore = FileKeystore.newTrustStore(this.provider, file, this.resolvePassword());
        this.keyStore.load();
        super.start(context);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.keyStore = null;
    }

    @Override
    protected TrustManager[] createTrustManagers() throws NoSuchAlgorithmException, KeyStoreException {
        KeyStore trustStore = this.loadTrustStore();
        this.trustManagerFactory.init(trustStore);
        TrustManager[] tmpTrustManagers = this.trustManagerFactory.getTrustManagers();
        TrustManager[] trustManagers = new TrustManager[tmpTrustManagers.length];
        boolean disableDynamic = this.isDisableDynamicTrustManager();
        for (int i = 0; i < tmpTrustManagers.length; ++i) {
            trustManagers[i] = disableDynamic ? tmpTrustManagers[i] : new DelegatingTrustManager((X509TrustManager)tmpTrustManagers[i], this.keyStore);
        }
        return trustManagers;
    }

    @Override
    protected KeyStore loadTrustStore() {
        return this.keyStore.getKeyStore();
    }

    private boolean isDisableDynamicTrustManager() {
        String prop = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.as.management.security.disable-dynamic-trust-manager", (String)"false");
        return "true".equalsIgnoreCase(prop);
    }

    private class DelegatingTrustManager
    implements X509TrustManager {
        private X509TrustManager delegate;
        private final FileKeystore theTrustStore;

        private DelegatingTrustManager(X509TrustManager trustManager, FileKeystore theTrustStore) {
            this.delegate = trustManager;
            this.theTrustStore = theTrustStore;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.getDelegate().checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.getDelegate().checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.getDelegate().getAcceptedIssuers();
        }

        private synchronized X509TrustManager getDelegate() {
            if (this.theTrustStore.isModified()) {
                try {
                    this.theTrustStore.load();
                }
                catch (StartException e1) {
                    throw DomainManagementLogger.ROOT_LOGGER.unableToLoadKeyTrustFile(e1.getCause());
                }
                try {
                    TrustManager[] trustManagers;
                    FileTrustManagerService.this.trustManagerFactory.init(this.theTrustStore.getKeyStore());
                    for (TrustManager current : trustManagers = FileTrustManagerService.this.trustManagerFactory.getTrustManagers()) {
                        if (!(current instanceof X509TrustManager)) continue;
                        this.delegate = (X509TrustManager)current;
                        break;
                    }
                }
                catch (GeneralSecurityException e) {
                    throw DomainManagementLogger.ROOT_LOGGER.unableToOperateOnTrustStore(e);
                }
            }
            if (this.delegate == null) {
                throw DomainManagementLogger.ROOT_LOGGER.unableToCreateDelegateTrustManager();
            }
            return this.delegate;
        }
    }
}

