/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.saml.v2.assertion;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.picketlink.identity.federation.saml.common.CommonAssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AdviceType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.w3c.dom.Element;

public class AssertionType
extends CommonAssertionType {
    private static final long serialVersionUID = 1L;
    private Element signature;
    private final String version = "2.0";
    private AdviceType advice;
    private NameIDType issuer;
    private SubjectType subject;
    private ConditionsType conditions;
    private final Set<StatementAbstractType> statements = new LinkedHashSet<StatementAbstractType>();

    public AssertionType(String iD, XMLGregorianCalendar issueInstant) {
        super(iD, issueInstant);
    }

    public SubjectType getSubject() {
        this.checkSTSPermission();
        return this.subject;
    }

    public void setSubject(SubjectType subject) {
        this.checkSTSPermission();
        this.subject = subject;
    }

    public String getVersion() {
        return "2.0";
    }

    public AdviceType getAdvice() {
        return this.advice;
    }

    public void setAdvice(AdviceType advice) {
        this.checkSTSPermission();
        this.advice = advice;
    }

    public ConditionsType getConditions() {
        this.checkSTSPermission();
        return this.conditions;
    }

    public void setConditions(ConditionsType conditions) {
        this.checkSTSPermission();
        this.conditions = conditions;
    }

    public NameIDType getIssuer() {
        return this.issuer;
    }

    public void setIssuer(NameIDType issuer) {
        this.checkSTSPermission();
        this.issuer = issuer;
    }

    public void addStatement(StatementAbstractType statement) {
        this.checkSTSPermission();
        this.statements.add(statement);
    }

    public void addStatements(Collection<StatementAbstractType> statement) {
        this.checkSTSPermission();
        this.statements.addAll(statement);
    }

    public void addStatements(Set<StatementAbstractType> statement) {
        this.checkSTSPermission();
        this.statements.addAll(statement);
    }

    public Set<StatementAbstractType> getStatements() {
        this.checkSTSPermission();
        return Collections.unmodifiableSet(this.statements);
    }

    public Element getSignature() {
        return this.signature;
    }

    public void setSignature(Element signature) {
        this.signature = signature;
    }

    public void updateIssueInstant(XMLGregorianCalendar xg) {
        this.checkSTSPermission();
        this.issueInstant = xg;
    }

    protected void checkSTSPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("org.picketlink.sts"));
        }
    }
}

