/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.workmanager.statistics;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.connector.dynamicresource.ClearWorkManagerStatisticsHandler;
import org.jboss.as.connector.subsystems.resourceadapters.CommonAttributes;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.WorkManagerRuntimeAttributeReadHandler;
import org.jboss.as.connector.subsystems.resourceadapters.WorkManagerRuntimeAttributeWriteHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceBuilder;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.workmanager.DistributedWorkManager;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.api.workmanager.WorkManagerStatistics;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DistributedWorkManagerStatisticsService
implements Service<ManagementResourceRegistration> {
    private final ManagementResourceRegistration overrideRegistration;
    private final boolean statsEnabled;
    protected final InjectedValue<DistributedWorkManager> distributedWorkManager = new InjectedValue();

    public DistributedWorkManagerStatisticsService(ManagementResourceRegistration registration, String name, boolean statsEnabled) {
        this.overrideRegistration = registration.isAllowsOverride() ? registration.registerOverrideModel(name, new OverrideDescriptionProvider(){

            public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                return Collections.emptyMap();
            }

            public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                return Collections.emptyMap();
            }
        }) : registration;
        this.statsEnabled = statsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        DistributedWorkManagerStatisticsService distributedWorkManagerStatisticsService = this;
        synchronized (distributedWorkManagerStatisticsService) {
            DistributedWorkManager dwm = (DistributedWorkManager)this.distributedWorkManager.getValue();
            dwm.setDistributedStatisticsEnabled(this.statsEnabled);
            if (dwm.getDistributedStatistics() != null) {
                PathElement peDistributedWm = PathElement.pathElement((String)"statistics", (String)"distributed");
                ResourceBuilder resourceBuilder = ResourceBuilder.Factory.create((PathElement)peDistributedWm, (StandardResourceDescriptionResolver)new StandardResourceDescriptionResolver("statistics.workmanager", CommonAttributes.RESOURCE_NAME, CommonAttributes.class.getClassLoader()));
                ManagementResourceRegistration dwmSubRegistration = this.overrideRegistration.registerSubModel(resourceBuilder.build());
                WorkManagerRuntimeAttributeReadHandler metricHandler = new WorkManagerRuntimeAttributeReadHandler((WorkManager)dwm, (WorkManagerStatistics)dwm.getDistributedStatistics(), false);
                for (SimpleAttributeDefinition metric : Constants.WORKMANAGER_METRICS) {
                    dwmSubRegistration.registerMetric((AttributeDefinition)metric, (OperationStepHandler)metricHandler);
                }
                WorkManagerRuntimeAttributeReadHandler readHandler = new WorkManagerRuntimeAttributeReadHandler((WorkManager)dwm, (WorkManagerStatistics)dwm.getDistributedStatistics(), false);
                WorkManagerRuntimeAttributeWriteHandler writeHandler = new WorkManagerRuntimeAttributeWriteHandler((WorkManager)dwm, false, (AttributeDefinition[])Constants.DISTRIBUTED_WORKMANAGER_RW_ATTRIBUTES);
                for (SimpleAttributeDefinition attribute : Constants.DISTRIBUTED_WORKMANAGER_RW_ATTRIBUTES) {
                    dwmSubRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, (OperationStepHandler)readHandler, (OperationStepHandler)writeHandler);
                }
                dwmSubRegistration.registerOperationHandler(ClearWorkManagerStatisticsHandler.DEFINITION, (OperationStepHandler)new ClearWorkManagerStatisticsHandler((WorkManager)dwm));
            }
        }
    }

    public void stop(StopContext context) {
        PathElement peDistributedWm = PathElement.pathElement((String)"statistics", (String)"distributed");
        if (this.overrideRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peDistributedWm})) != null) {
            this.overrideRegistration.unregisterSubModel(peDistributedWm);
        }
    }

    public ManagementResourceRegistration getValue() throws IllegalStateException, IllegalArgumentException {
        return this.overrideRegistration;
    }

    public Injector<DistributedWorkManager> getDistributedWorkManagerInjector() {
        return this.distributedWorkManager;
    }
}

