/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.messaging.AddressSettingDefinition;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.BridgeDefinition;
import org.jboss.as.messaging.BroadcastGroupDefinition;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceDefinition;
import org.jboss.as.messaging.ConnectorServiceParamDefinition;
import org.jboss.as.messaging.DiscoveryGroupDefinition;
import org.jboss.as.messaging.DivertDefinition;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.GenericTransportDefinition;
import org.jboss.as.messaging.GroupingHandlerDefinition;
import org.jboss.as.messaging.HTTPAcceptorDefinition;
import org.jboss.as.messaging.HTTPConnectorDefinition;
import org.jboss.as.messaging.InVMTransportDefinition;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.PathDefinition;
import org.jboss.as.messaging.QueueDefinition;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.as.messaging.SecurityRoleDefinition;
import org.jboss.as.messaging.TransportParamDefinition;
import org.jboss.as.messaging.jms.ConnectionFactoryAttribute;
import org.jboss.as.messaging.jms.ConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.JMSQueueDefinition;
import org.jboss.as.messaging.jms.JMSTopicDefinition;
import org.jboss.as.messaging.jms.PooledConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.bridge.JMSBridgeDefinition;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class MessagingXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    static final MessagingXMLWriter INSTANCE = new MessagingXMLWriter();
    private static final char[] NEW_LINE = new char[]{'\n'};

    private MessagingXMLWriter() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        boolean first;
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (node.hasDefined("hornetq-server")) {
            ModelNode servers = node.get("hornetq-server");
            first = true;
            for (String name : servers.keys()) {
                MessagingXMLWriter.writeHornetQServer(writer, name, servers.get(name));
                if (!first) {
                    MessagingXMLWriter.writeNewLine(writer);
                    continue;
                }
                first = false;
            }
        }
        if (node.hasDefined("jms-bridge")) {
            ModelNode jmsBridges = node.get("jms-bridge");
            first = true;
            for (String name : jmsBridges.keys()) {
                this.writeJmsBridge(writer, name, jmsBridges.get(name));
                if (!first) {
                    MessagingXMLWriter.writeNewLine(writer);
                    continue;
                }
                first = false;
            }
        }
        writer.writeEndElement();
    }

    private static void writeHornetQServer(XMLExtendedStreamWriter writer, String serverName, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.HORNETQ_SERVER.getLocalName());
        if (!"default".equals(serverName)) {
            writer.writeAttribute(Attribute.NAME.getLocalName(), serverName);
        }
        for (AttributeDefinition simpleAttribute : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            simpleAttribute.marshallAsElement(node, (XMLStreamWriter)writer);
        }
        ModelNode paths = node.get("path");
        MessagingXMLWriter.writeDirectory(writer, Element.PAGING_DIRECTORY, paths);
        MessagingXMLWriter.writeDirectory(writer, Element.BINDINGS_DIRECTORY, paths);
        MessagingXMLWriter.writeDirectory(writer, Element.JOURNAL_DIRECTORY, paths);
        MessagingXMLWriter.writeDirectory(writer, Element.LARGE_MESSAGES_DIRECTORY, paths);
        MessagingXMLWriter.writeNewLine(writer);
        MessagingXMLWriter.writeConnectors(writer, node);
        MessagingXMLWriter.writeAcceptors(writer, node);
        MessagingXMLWriter.writeBroadcastGroups(writer, node.get("broadcast-group"));
        MessagingXMLWriter.writeDiscoveryGroups(writer, node.get("discovery-group"));
        MessagingXMLWriter.writeDiverts(writer, node.get("divert"));
        MessagingXMLWriter.writeQueues(writer, node.get("queue"));
        MessagingXMLWriter.writeBridges(writer, node.get("bridge"));
        MessagingXMLWriter.writeClusterConnections(writer, node.get("cluster-connection"));
        MessagingXMLWriter.writeGroupingHandler(writer, node.get("grouping-handler"));
        MessagingXMLWriter.writeSecuritySettings(writer, node.get("security-setting"));
        MessagingXMLWriter.writeAddressSettings(writer, node.get("address-setting"));
        MessagingXMLWriter.writeConnectorServices(writer, node.get("connector-service"));
        if (node.hasDefined("connection-factory") || node.hasDefined("pooled-connection-factory")) {
            boolean hasPcf;
            ModelNode cf = node.get("connection-factory");
            ModelNode pcf = node.get("pooled-connection-factory");
            boolean hasCf = cf.isDefined() && cf.keys().size() > 0;
            boolean bl = hasPcf = pcf.isDefined() && pcf.keys().size() > 0;
            if (hasCf || hasPcf) {
                writer.writeStartElement("jms-connection-factories");
                MessagingXMLWriter.writeConnectionFactories(writer, cf);
                MessagingXMLWriter.writePooledConnectionFactories(writer, pcf);
                writer.writeEndElement();
                MessagingXMLWriter.writeNewLine(writer);
            }
        }
        if (node.hasDefined("jms-queue") || node.hasDefined("jms-topic")) {
            boolean hasTopic;
            ModelNode queue = node.get("jms-queue");
            ModelNode topic = node.get("jms-topic");
            boolean hasQueue = queue.isDefined() && queue.keys().size() > 0;
            boolean bl = hasTopic = topic.isDefined() && topic.keys().size() > 0;
            if (hasQueue || hasTopic) {
                writer.writeStartElement("jms-destinations");
                MessagingXMLWriter.writeJmsQueues(writer, node.get("jms-queue"));
                MessagingXMLWriter.writeTopics(writer, node.get("jms-topic"));
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private static void writeConnectors(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined("connector") || node.hasDefined("remote-connector") || node.hasDefined("in-vm-connector")) {
            writer.writeStartElement(Element.CONNECTORS.getLocalName());
            if (node.hasDefined("http-connector")) {
                for (Property property : node.get("http-connector").asPropertyList()) {
                    writer.writeStartElement(Element.HTTP_CONNECTOR.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                    HTTPConnectorDefinition.SOCKET_BINDING.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    MessagingXMLWriter.writeTransportParam(writer, property.getValue().get("param"));
                    writer.writeEndElement();
                }
            }
            if (node.hasDefined("remote-connector")) {
                for (Property property : node.get("remote-connector").asPropertyList()) {
                    writer.writeStartElement(Element.NETTY_CONNECTOR.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                    RemoteTransportDefinition.SOCKET_BINDING.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    MessagingXMLWriter.writeTransportParam(writer, property.getValue().get("param"));
                    writer.writeEndElement();
                }
            }
            if (node.hasDefined("in-vm-connector")) {
                for (Property property : node.get("in-vm-connector").asPropertyList()) {
                    writer.writeStartElement(Element.IN_VM_CONNECTOR.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                    InVMTransportDefinition.SERVER_ID.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    MessagingXMLWriter.writeTransportParam(writer, property.getValue().get("param"));
                    writer.writeEndElement();
                }
            }
            if (node.hasDefined("connector")) {
                for (Property property : node.get("connector").asPropertyList()) {
                    writer.writeStartElement(Element.CONNECTOR.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                    GenericTransportDefinition.SOCKET_BINDING.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    MessagingXMLWriter.writeTransportParam(writer, property.getValue().get("param"));
                    CommonAttributes.FACTORY_CLASS.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            MessagingXMLWriter.writeNewLine(writer);
        }
    }

    private static void writeAcceptors(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined("acceptor") || node.hasDefined("remote-acceptor") || node.hasDefined("in-vm-acceptor")) {
            writer.writeStartElement(Element.ACCEPTORS.getLocalName());
            if (node.hasDefined("http-acceptor")) {
                for (Property property : node.get("http-acceptor").asPropertyList()) {
                    writer.writeStartElement(Element.HTTP_ACCEPTOR.getLocalName());
                    HTTPAcceptorDefinition.HTTP_LISTENER.marshallAsAttribute(property.getValue(), (XMLStreamWriter)writer);
                    MessagingXMLWriter.writeAcceptorContent(writer, property);
                    writer.writeEndElement();
                }
            }
            if (node.hasDefined("remote-acceptor")) {
                for (Property property : node.get("remote-acceptor").asPropertyList()) {
                    writer.writeStartElement(Element.NETTY_ACCEPTOR.getLocalName());
                    MessagingXMLWriter.writeAcceptorContent(writer, property);
                    writer.writeEndElement();
                }
            }
            if (node.hasDefined("in-vm-acceptor")) {
                for (Property property : node.get("in-vm-acceptor").asPropertyList()) {
                    writer.writeStartElement(Element.IN_VM_ACCEPTOR.getLocalName());
                    MessagingXMLWriter.writeAcceptorContent(writer, property);
                    writer.writeEndElement();
                }
            }
            if (node.hasDefined("acceptor")) {
                for (Property property : node.get("acceptor").asPropertyList()) {
                    writer.writeStartElement(Element.ACCEPTOR.getLocalName());
                    MessagingXMLWriter.writeAcceptorContent(writer, property);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            MessagingXMLWriter.writeNewLine(writer);
        }
    }

    private static void writeAcceptorContent(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
        ModelNode value = property.getValue();
        RemoteTransportDefinition.SOCKET_BINDING.marshallAsAttribute(value, (XMLStreamWriter)writer);
        InVMTransportDefinition.SERVER_ID.marshallAsAttribute(value, (XMLStreamWriter)writer);
        MessagingXMLWriter.writeTransportParam(writer, value.get("param"));
        CommonAttributes.FACTORY_CLASS.marshallAsElement(value, (XMLStreamWriter)writer);
    }

    private static void writeTransportParam(XMLExtendedStreamWriter writer, ModelNode param) throws XMLStreamException {
        if (param.isDefined()) {
            for (Property parameter : param.asPropertyList()) {
                writer.writeStartElement(Element.PARAM.getLocalName());
                writer.writeAttribute(Attribute.KEY.getLocalName(), parameter.getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), parameter.getValue().get(TransportParamDefinition.VALUE.getName()).asString());
                writer.writeEndElement();
            }
        }
    }

    private static void writeBroadcastGroups(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.BROADCAST_GROUPS.getLocalName());
            for (Property property : properties) {
                writer.writeStartElement(Element.BROADCAST_GROUP.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                for (AttributeDefinition attribute : BroadcastGroupDefinition.ATTRIBUTES) {
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingXMLWriter.writeNewLine(writer);
        }
    }

    private static void writeDiscoveryGroups(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.DISCOVERY_GROUPS.getLocalName());
            for (Property property : properties) {
                writer.writeStartElement(Element.DISCOVERY_GROUP.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                for (AttributeDefinition attribute : DiscoveryGroupDefinition.ATTRIBUTES) {
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingXMLWriter.writeNewLine(writer);
        }
    }

    private static void writeDiverts(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.DIVERTS.getLocalName());
            for (Property property : properties) {
                writer.writeStartElement(Element.DIVERT.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                for (AttributeDefinition attribute : DivertDefinition.ATTRIBUTES) {
                    if (CommonAttributes.FILTER == attribute) {
                        MessagingXMLWriter.writeFilter(writer, property.getValue());
                        continue;
                    }
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingXMLWriter.writeNewLine(writer);
        }
    }

    private static void writeQueues(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        if (node.asInt() > 0) {
            writer.writeStartElement(Element.CORE_QUEUES.getLocalName());
            for (String queueName : node.keys()) {
                writer.writeStartElement(Element.QUEUE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), queueName);
                ModelNode queue = node.get(queueName);
                QueueDefinition.ADDRESS.marshallAsElement(queue, (XMLStreamWriter)writer);
                MessagingXMLWriter.writeFilter(writer, queue);
                CommonAttributes.DURABLE.marshallAsElement(queue, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingXMLWriter.writeNewLine(writer);
        }
    }

    private static void writeBridges(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.BRIDGES.getLocalName());
            for (Property property : node.asPropertyList()) {
                writer.writeStartElement(Element.BRIDGE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                for (AttributeDefinition attribute : BridgeDefinition.ATTRIBUTES) {
                    if (CommonAttributes.FILTER == attribute) {
                        MessagingXMLWriter.writeFilter(writer, property.getValue());
                        continue;
                    }
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingXMLWriter.writeNewLine(writer);
        }
    }

    private static void writeClusterConnections(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.CLUSTER_CONNECTIONS.getLocalName());
            for (Property property : node.asPropertyList()) {
                writer.writeStartElement(Element.CLUSTER_CONNECTION.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                ModelNode cluster = property.getValue();
                for (AttributeDefinition attribute : ClusterConnectionDefinition.ATTRIBUTES) {
                    if (attribute == ClusterConnectionDefinition.ALLOW_DIRECT_CONNECTIONS_ONLY) continue;
                    if (attribute == ClusterConnectionDefinition.CONNECTOR_REFS) {
                        if (attribute.isMarshallable(cluster)) {
                            writer.writeStartElement(Element.STATIC_CONNECTORS.getLocalName());
                            ClusterConnectionDefinition.ALLOW_DIRECT_CONNECTIONS_ONLY.marshallAsAttribute(cluster, (XMLStreamWriter)writer);
                            ClusterConnectionDefinition.CONNECTOR_REFS.marshallAsElement(cluster, (XMLStreamWriter)writer);
                            writer.writeEndElement();
                            continue;
                        }
                        if (!ClusterConnectionDefinition.ALLOW_DIRECT_CONNECTIONS_ONLY.isMarshallable(cluster)) continue;
                        writer.writeEmptyElement(Element.STATIC_CONNECTORS.getLocalName());
                        ClusterConnectionDefinition.ALLOW_DIRECT_CONNECTIONS_ONLY.marshallAsAttribute(cluster, (XMLStreamWriter)writer);
                        continue;
                    }
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingXMLWriter.writeNewLine(writer);
        }
    }

    private static void writeGroupingHandler(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        boolean wroteHandler = false;
        for (Property handler : node.asPropertyList()) {
            if (wroteHandler) {
                throw MessagingLogger.ROOT_LOGGER.multipleChildrenFound("grouping-handler");
            }
            wroteHandler = true;
            writer.writeStartElement(Element.GROUPING_HANDLER.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), handler.getName());
            ModelNode resourceModel = handler.getValue();
            for (AttributeDefinition attr : GroupingHandlerDefinition.ATTRIBUTES) {
                attr.marshallAsElement(resourceModel, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
            MessagingXMLWriter.writeNewLine(writer);
        }
    }

    private static void writeFilter(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined(CommonAttributes.FILTER.getName())) {
            writer.writeEmptyElement(CommonAttributes.FILTER.getXmlName());
            writer.writeAttribute("string", node.get(CommonAttributes.FILTER.getName()).asString());
        }
    }

    private static void writeDirectory(XMLExtendedStreamWriter writer, Element element, ModelNode node) throws XMLStreamException {
        ModelNode localNode;
        String localName = element.getLocalName();
        if (node.hasDefined(localName) && (PathDefinition.RELATIVE_TO.isMarshallable(localNode = node.get(localName)) || PathDefinition.PATHS.get(localName).isMarshallable(localNode))) {
            writer.writeEmptyElement(localName);
            PathDefinition.PATHS.get(localName).marshallAsAttribute(node.get(localName), (XMLStreamWriter)writer);
            PathDefinition.RELATIVE_TO.marshallAsAttribute(node.get(localName), (XMLStreamWriter)writer);
        }
    }

    private static void writeSecuritySettings(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.SECURITY_SETTINGS.getLocalName());
            for (Property matchRoles : properties) {
                writer.writeStartElement(Element.SECURITY_SETTING.getLocalName());
                writer.writeAttribute(Attribute.MATCH.getLocalName(), matchRoles.getName());
                if (matchRoles.getValue().hasDefined("role")) {
                    ArrayList<String> send = new ArrayList<String>();
                    ArrayList<String> consume = new ArrayList<String>();
                    ArrayList<String> createDurableQueue = new ArrayList<String>();
                    ArrayList<String> deleteDurableQueue = new ArrayList<String>();
                    ArrayList<String> createNonDurableQueue = new ArrayList<String>();
                    ArrayList<String> deleteNonDurableQueue = new ArrayList<String>();
                    ArrayList<String> manageRoles = new ArrayList<String>();
                    for (Property rolePerms : matchRoles.getValue().get("role").asPropertyList()) {
                        String role = rolePerms.getName();
                        ModelNode perms = rolePerms.getValue();
                        if (perms.get(SecurityRoleDefinition.SEND.getName()).asBoolean(false)) {
                            send.add(role);
                        }
                        if (perms.get(SecurityRoleDefinition.CONSUME.getName()).asBoolean(false)) {
                            consume.add(role);
                        }
                        if (perms.get(SecurityRoleDefinition.CREATE_DURABLE_QUEUE.getName()).asBoolean(false)) {
                            createDurableQueue.add(role);
                        }
                        if (perms.get(SecurityRoleDefinition.DELETE_DURABLE_QUEUE.getName()).asBoolean(false)) {
                            deleteDurableQueue.add(role);
                        }
                        if (perms.get(SecurityRoleDefinition.CREATE_NON_DURABLE_QUEUE.getName()).asBoolean(false)) {
                            createNonDurableQueue.add(role);
                        }
                        if (perms.get(SecurityRoleDefinition.DELETE_NON_DURABLE_QUEUE.getName()).asBoolean(false)) {
                            deleteNonDurableQueue.add(role);
                        }
                        if (!perms.get(SecurityRoleDefinition.MANAGE.getName()).asBoolean(false)) continue;
                        manageRoles.add(role);
                    }
                    MessagingXMLWriter.writePermission(writer, SecurityRoleDefinition.SEND.getXmlName(), send);
                    MessagingXMLWriter.writePermission(writer, SecurityRoleDefinition.CONSUME.getXmlName(), consume);
                    MessagingXMLWriter.writePermission(writer, SecurityRoleDefinition.CREATE_DURABLE_QUEUE.getXmlName(), createDurableQueue);
                    MessagingXMLWriter.writePermission(writer, SecurityRoleDefinition.DELETE_DURABLE_QUEUE.getXmlName(), deleteDurableQueue);
                    MessagingXMLWriter.writePermission(writer, SecurityRoleDefinition.CREATE_NON_DURABLE_QUEUE.getXmlName(), createNonDurableQueue);
                    MessagingXMLWriter.writePermission(writer, SecurityRoleDefinition.DELETE_NON_DURABLE_QUEUE.getXmlName(), deleteNonDurableQueue);
                    MessagingXMLWriter.writePermission(writer, SecurityRoleDefinition.MANAGE.getXmlName(), manageRoles);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingXMLWriter.writeNewLine(writer);
        }
    }

    private static void writePermission(XMLExtendedStreamWriter writer, String type, List<String> roles) throws XMLStreamException {
        if (roles.size() == 0) {
            return;
        }
        writer.writeStartElement(Element.PERMISSION_ELEMENT_NAME.getLocalName());
        StringBuilder sb = new StringBuilder();
        for (String role : roles) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(role);
        }
        writer.writeAttribute(Attribute.TYPE_ATTR_NAME.getLocalName(), type);
        writer.writeAttribute(Attribute.ROLES_ATTR_NAME.getLocalName(), sb.toString());
        writer.writeEndElement();
    }

    private static void writeAddressSettings(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.ADDRESS_SETTINGS.getLocalName());
            for (Property matchSetting : properties) {
                writer.writeStartElement(Element.ADDRESS_SETTING.getLocalName());
                writer.writeAttribute(Attribute.MATCH.getLocalName(), matchSetting.getName());
                ModelNode setting = matchSetting.getValue();
                for (SimpleAttributeDefinition attribute : AddressSettingDefinition.ATTRIBUTES) {
                    attribute.marshallAsElement(setting, (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingXMLWriter.writeNewLine(writer);
        }
    }

    private static void writeConnectorServices(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.CONNECTOR_SERVICES.getLocalName());
            for (Property property : node.asPropertyList()) {
                writer.writeStartElement(Element.CONNECTOR_SERVICE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                ModelNode service = property.getValue();
                for (AttributeDefinition attribute : ConnectorServiceDefinition.ATTRIBUTES) {
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                if (service.hasDefined("param")) {
                    for (Property param : service.get("param").asPropertyList()) {
                        writer.writeEmptyElement(Element.PARAM.getLocalName());
                        writer.writeAttribute(Attribute.KEY.getLocalName(), param.getName());
                        writer.writeAttribute(Attribute.VALUE.getLocalName(), param.getValue().get(ConnectorServiceParamDefinition.VALUE.getName()).asString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingXMLWriter.writeNewLine(writer);
        }
    }

    private static void writeConnectionFactories(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        if (node.asInt() > 0) {
            for (String name : node.keys()) {
                ModelNode factory = node.get(name);
                if (!factory.isDefined()) continue;
                writer.writeStartElement(Element.CONNECTION_FACTORY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                for (AttributeDefinition attribute : ConnectionFactoryDefinition.ATTRIBUTES) {
                    attribute.marshallAsElement(factory, (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
        }
    }

    private static void writePooledConnectionFactories(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        if (node.asInt() > 0) {
            for (String name : node.keys()) {
                ModelNode factory = node.get(name);
                if (!factory.isDefined()) continue;
                writer.writeStartElement(Element.POOLED_CONNECTION_FACTORY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                if (MessagingXMLWriter.hasDefinedInboundConfigAttributes(factory)) {
                    writer.writeStartElement(Element.INBOUND_CONFIG.getLocalName());
                    for (ConnectionFactoryAttribute attribute : PooledConnectionFactoryDefinition.ATTRIBUTES) {
                        if (!attribute.isInboundConfig()) continue;
                        attribute.getDefinition().marshallAsElement(factory, (XMLStreamWriter)writer);
                    }
                    writer.writeEndElement();
                }
                for (ConnectionFactoryAttribute attribute : PooledConnectionFactoryDefinition.ATTRIBUTES) {
                    if (attribute.isInboundConfig()) continue;
                    attribute.getDefinition().marshallAsElement(factory, (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
        }
    }

    private static boolean hasDefinedInboundConfigAttributes(ModelNode pcf) {
        for (ConnectionFactoryAttribute attribute : PooledConnectionFactoryDefinition.ATTRIBUTES) {
            if (!attribute.isInboundConfig() || !pcf.hasDefined(attribute.getDefinition().getName())) continue;
            return true;
        }
        return false;
    }

    private static void writeJmsQueues(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        if (node.asInt() > 0) {
            for (String name : node.keys()) {
                ModelNode queue = node.get(name);
                if (!queue.isDefined()) continue;
                writer.writeStartElement(Element.JMS_QUEUE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                for (AttributeDefinition attribute : JMSQueueDefinition.ATTRIBUTES) {
                    attribute.marshallAsElement(queue, (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
        }
    }

    private static void writeTopics(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (!node.isDefined()) {
            return;
        }
        if (node.asInt() > 0) {
            for (String name : node.keys()) {
                ModelNode topic = node.get(name);
                if (!topic.isDefined()) continue;
                writer.writeStartElement(Element.JMS_TOPIC.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                for (AttributeDefinition attribute : JMSTopicDefinition.ATTRIBUTES) {
                    attribute.marshallAsElement(topic, (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
        }
    }

    private void writeJmsBridge(XMLExtendedStreamWriter writer, String bridgeName, ModelNode value) throws XMLStreamException {
        writer.writeStartElement(Element.JMS_BRIDGE.getLocalName());
        if (!"default".equals(bridgeName)) {
            writer.writeAttribute(Attribute.NAME.getLocalName(), bridgeName);
        }
        JMSBridgeDefinition.MODULE.marshallAsAttribute(value, (XMLStreamWriter)writer);
        writer.writeStartElement(Element.SOURCE.getLocalName());
        for (AttributeDefinition attr : JMSBridgeDefinition.JMS_SOURCE_ATTRIBUTES) {
            attr.marshallAsElement(value, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
        writer.writeStartElement(Element.TARGET.getLocalName());
        for (AttributeDefinition attr : JMSBridgeDefinition.JMS_TARGET_ATTRIBUTES) {
            attr.marshallAsElement(value, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
        for (AttributeDefinition attr : JMSBridgeDefinition.JMS_BRIDGE_ATTRIBUTES) {
            if (attr == JMSBridgeDefinition.MODULE) continue;
            attr.marshallAsElement(value, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    private static void writeNewLine(XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(NEW_LINE, 0, 1);
    }
}

