/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.apis.autoscaling.models;

import com.openshift.internal.restclient.api.models.TypeMeta;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.apis.autoscaling.models.IScale;
import java.util.Collections;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class Scale
extends TypeMeta
implements IScale {
    private static final String SPEC_REPLICAS = "spec.replicas";

    public Scale() {
        super(new ModelNode(), Collections.emptyMap());
    }

    public Scale(ModelNode node, Map<String, String[]> propertyKeys) {
        super(node, propertyKeys);
    }

    @Override
    public int getSpecReplicas() {
        return JBossDmrExtentions.asInt(this.getNode(), this.getPropertyKeys(), SPEC_REPLICAS);
    }

    @Override
    public void setSpecReplicas(int replicas) {
        JBossDmrExtentions.set(this.getNode(), this.getPropertyKeys(), SPEC_REPLICAS, replicas);
    }

    @Override
    public String getName() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "metadata.name");
    }

    @Override
    public void setName(String name) {
        JBossDmrExtentions.set(this.getNode(), this.getPropertyKeys(), "metadata.name", name);
    }

    @Override
    public String getCreationTimeStamp() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "metadata.creationTimestamp");
    }

    @Override
    public String getNamespace() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "metadata.namespace");
    }

    @Override
    public void setNamespace(String namespace) {
        JBossDmrExtentions.set(this.getNode(), this.getPropertyKeys(), "metadata.namespace", namespace);
    }

    @Override
    public String getResourceVersion() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "metadata.resourceVersion");
    }

    @Override
    public Map<String, String> getLabels() {
        return JBossDmrExtentions.asMap(this.getNode(), this.getPropertyKeys(), "metadata.labels");
    }

    @Override
    public void addLabel(String key, String value) {
        ModelNode labels = this.getNode().get(JBossDmrExtentions.getPath("metadata.labels"));
        labels.get(key).set(value);
    }

    @Override
    public Map<String, String> getAnnotations() {
        return JBossDmrExtentions.asMap(this.getNode(), this.getPropertyKeys(), "metadata.annotations");
    }

    @Override
    public String getAnnotation(String key) {
        return this.getAnnotations().get(key);
    }

    @Override
    public void setAnnotation(String name, String value) {
        if (value == null) {
            return;
        }
        ModelNode annotations = JBossDmrExtentions.get(this.getNode(), this.getPropertyKeys(), "metadata.annotations");
        annotations.get(name).set(value);
    }

    @Override
    public boolean isAnnotatedWith(String key) {
        Map<String, String> annotations = this.getAnnotations();
        return annotations.containsKey(key);
    }
}

