/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.remoting.transport.Address;

public class DistributedExecutionCompletionService<V>
implements CompletionService<V> {
    protected final DistributedExecutorService executor;
    protected final BlockingQueue<CompletableFuture<V>> completionQueue;

    public DistributedExecutionCompletionService(DistributedExecutorService executor) {
        this(executor, null);
    }

    public DistributedExecutionCompletionService(DistributedExecutorService executor, BlockingQueue<CompletableFuture<V>> completionQueue) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = completionQueue == null ? new LinkedBlockingQueue<CompletableFuture<V>>() : completionQueue;
    }

    @Override
    public CompletableFuture<V> submit(Callable<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        CompletableFuture f = (CompletableFuture)this.executor.submit(task);
        return f.whenComplete((v, t) -> this.completionQueue.add(f));
    }

    @Override
    public CompletableFuture<V> submit(Runnable task, V result) {
        if (task == null) {
            throw new NullPointerException();
        }
        CompletableFuture f = (CompletableFuture)this.executor.submit(task, result);
        return f.whenComplete((v, t) -> this.completionQueue.add(f));
    }

    @Override
    public CompletableFuture<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    @Override
    public CompletableFuture<V> poll() {
        return (CompletableFuture)this.completionQueue.poll();
    }

    @Override
    public CompletableFuture<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completionQueue.poll(timeout, unit);
    }

    public <K> Future<V> submit(Callable<V> task, K ... input) {
        CompletableFuture<V> f = this.executor.submit(task, input);
        return f.whenComplete((v, t) -> this.completionQueue.add(f));
    }

    public List<CompletableFuture<V>> submitEverywhere(Callable<V> task) {
        List<CompletableFuture<V>> fl = this.executor.submitEverywhere(task);
        for (Future future : fl) {
            ((CompletableFuture)future).whenComplete((v, t) -> this.completionQueue.add((CompletableFuture)f));
        }
        return fl;
    }

    public <K> List<CompletableFuture<V>> submitEverywhere(Callable<V> task, K ... input) {
        List<CompletableFuture<V>> fl = this.executor.submitEverywhere(task, input);
        for (CompletableFuture<V> f : fl) {
            f.whenComplete((v, t) -> this.completionQueue.add(f));
        }
        return fl;
    }

    public <K> CompletableFuture<V> submit(Address target, Callable<V> task) {
        CompletableFuture<V> f = this.executor.submit(target, task);
        return f.whenComplete((v, t) -> this.completionQueue.add(f));
    }
}

