/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.UserCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class UserUpdatedEvent
extends InvalidationEvent
implements UserCacheInvalidationEvent {
    private String userId;
    private String username;
    private String email;
    private String realmId;

    public static UserUpdatedEvent create(String userId, String username, String email, String realmId) {
        UserUpdatedEvent event = new UserUpdatedEvent();
        event.userId = userId;
        event.username = username;
        event.email = email;
        event.realmId = realmId;
        return event;
    }

    @Override
    public String getId() {
        return this.userId;
    }

    public String toString() {
        return String.format("UserUpdatedEvent [ userId=%s, username=%s, email=%s ]", this.userId, this.username, this.email);
    }

    @Override
    public void addInvalidations(UserCacheManager userCache, Set<String> invalidations) {
        userCache.userUpdatedInvalidations(this.userId, this.username, this.email, this.realmId, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<UserUpdatedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, UserUpdatedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.userId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.username, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.email, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
        }

        public UserUpdatedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public UserUpdatedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            UserUpdatedEvent res = new UserUpdatedEvent();
            res.userId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.username = MarshallUtil.unmarshallString((ObjectInput)input);
            res.email = MarshallUtil.unmarshallString((ObjectInput)input);
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

