"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBridgeVersion = exports.setBridgeVersion = void 0;
const path_1 = require("path");
let BridgeVersion;
/**
 * Forcibly set the version of the bridge, for use by other components.
 * This will override `getBridgeVersion`s default behaviour of fetching the
 * version from package.json.
 * @param version A version string e.g. `v1.0.0`
 */
function setBridgeVersion(version) {
    BridgeVersion = version;
}
exports.setBridgeVersion = setBridgeVersion;
/**
 * Get the current version of the bridge from the package.json file.
 * @param packageJsonPath The path to the package.json of the bridge.
 * @returns Either the version number, or unknown.
 */
function getBridgeVersion(packageJsonPath = "./package.json") {
    if (BridgeVersion) {
        return BridgeVersion;
    }
    packageJsonPath = (0, path_1.join)((0, path_1.resolve)(packageJsonPath));
    try {
        // eslint-disable-next-line @typescript-eslint/no-var-requires
        const nodePackage = require(packageJsonPath);
        BridgeVersion = nodePackage.version;
    }
    catch (err) {
        BridgeVersion = "unknown";
    }
    return BridgeVersion;
}
exports.getBridgeVersion = getBridgeVersion;
//# sourceMappingURL=package-info.js.map