/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.chart;

import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.TreeNodeEvent;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.TreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ObservableList;
import javafx.event.WeakEventHandler;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="children")
public class SunburstChart
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 2048.0;
    private static final double MAXIMUM_HEIGHT = 2048.0;
    private static final Color BRIGHT_TEXT_COLOR = Color.WHITE;
    private static final Color DARK_TEXT_COLOR = Color.BLACK;
    private double size;
    private double width;
    private double height;
    private double centerX;
    private double centerY;
    private Pane segmentPane;
    private Canvas chartCanvas;
    private GraphicsContext chartCtx;
    private Pane pane;
    private Paint backgroundPaint = Color.TRANSPARENT;
    private Paint borderPaint = Color.TRANSPARENT;
    private double borderWidth = 0.0;
    private List<Path> segments = new ArrayList<Path>(64);
    private VisibleData _visibleData = VisibleData.NAME;
    private ObjectProperty<VisibleData> visibleData;
    private TextOrientation _textOrientation = TextOrientation.TANGENT;
    private ObjectProperty<TextOrientation> textOrientation;
    private Color _backgroundColor = Color.WHITE;
    private ObjectProperty<Color> backgroundColor;
    private Color _textColor = Color.BLACK;
    private ObjectProperty<Color> textColor;
    private boolean _useColorFromParent = false;
    private BooleanProperty useColorFromParent;
    private int _decimals = 0;
    private IntegerProperty decimals;
    private boolean _interactive = false;
    private BooleanProperty interactive;
    private boolean _autoTextColor = true;
    private BooleanProperty autoTextColor;
    private Color _brightTextColor = BRIGHT_TEXT_COLOR;
    private ObjectProperty<Color> brightTextColor;
    private Color _darkTextColor = DARK_TEXT_COLOR;
    private ObjectProperty<Color> darkTextColor;
    private boolean _useChartDataTextColor = false;
    private BooleanProperty useChartDataTextColor;
    private String formatString = "%.0f";
    private ObjectProperty<TreeNode<ChartData>> tree;
    private TreeNode<ChartData> root;
    private int maxLevel;
    private Map<Integer, List<TreeNode<ChartData>>> levelMap;
    private InvalidationListener sizeListener;

    public SunburstChart() {
        this(new TreeNode<ChartData>(new ChartData()));
    }

    public SunburstChart(TreeNode TREE) {
        this.tree = new ObjectPropertyBase<TreeNode<ChartData>>(TREE){

            @Override
            protected void invalidated() {
                if (null != this.get()) {
                    ((TreeNode)this.get()).flattened().forEach(node -> node.removeAllTreeNodeEventListeners());
                }
                ((TreeNode)this.get()).flattened().forEach(node -> node.setOnTreeNodeEvent(e -> SunburstChart.this.redraw()));
                SunburstChart.this.prepareData();
                if (SunburstChart.this.isAutoTextColor()) {
                    SunburstChart.this.adjustTextColors();
                }
                SunburstChart.this.drawChart();
            }

            @Override
            public Object getBean() {
                return SunburstChart.this;
            }

            @Override
            public String getName() {
                return "tree";
            }
        };
        this.levelMap = new HashMap<Integer, List<TreeNode<ChartData>>>(8);
        this.sizeListener = o -> this.resize();
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.segmentPane = new Pane();
        this.chartCanvas = new Canvas(250.0, 250.0);
        this.chartCanvas.setMouseTransparent(true);
        this.chartCtx = this.chartCanvas.getGraphicsContext2D();
        this.pane = new Pane(this.segmentPane, this.chartCanvas);
        this.pane.setBackground(new Background(new BackgroundFill(this.backgroundPaint, CornerRadii.EMPTY, Insets.EMPTY)));
        this.pane.setBorder(new Border(new BorderStroke(this.borderPaint, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.borderWidth))));
        this.getChildren().setAll((Node[])new Node[]{this.pane});
        this.prepareData();
    }

    private void registerListeners() {
        this.widthProperty().addListener(this.sizeListener);
        this.heightProperty().addListener(this.sizeListener);
        ((TreeNode)this.tree.get()).setOnTreeNodeEvent(e -> this.redraw());
    }

    @Override
    public void layoutChildren() {
        super.layoutChildren();
    }

    @Override
    protected double computeMinWidth(double HEIGHT) {
        return 50.0;
    }

    @Override
    protected double computeMinHeight(double WIDTH) {
        return 50.0;
    }

    @Override
    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    @Override
    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    @Override
    protected double computeMaxWidth(double HEIGHT) {
        return 2048.0;
    }

    @Override
    protected double computeMaxHeight(double WIDTH) {
        return 2048.0;
    }

    @Override
    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public void dispose() {
        this.widthProperty().removeListener(this.sizeListener);
        this.heightProperty().removeListener(this.sizeListener);
        ((TreeNode)this.tree.get()).removeAllTreeNodeEventListeners();
    }

    public VisibleData getVisibleData() {
        return null == this.visibleData ? this._visibleData : (VisibleData)((Object)this.visibleData.get());
    }

    public void setVisibleData(VisibleData VISIBLE_DATA) {
        if (null == this.visibleData) {
            this._visibleData = VISIBLE_DATA;
            this.redraw();
        } else {
            this.visibleData.set(VISIBLE_DATA);
        }
    }

    public ObjectProperty<VisibleData> visibleDataProperty() {
        if (null == this.visibleData) {
            this.visibleData = new ObjectPropertyBase<VisibleData>(this._visibleData){

                @Override
                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                @Override
                public Object getBean() {
                    return SunburstChart.this;
                }

                @Override
                public String getName() {
                    return "visibleData";
                }
            };
            this._visibleData = null;
        }
        return this.visibleData;
    }

    public TextOrientation getTextOrientation() {
        return null == this.textOrientation ? this._textOrientation : (TextOrientation)((Object)this.textOrientation.get());
    }

    public void setTextOrientation(TextOrientation ORIENTATION) {
        if (null == this.textOrientation) {
            this._textOrientation = ORIENTATION;
            this.redraw();
        } else {
            this.textOrientation.set(ORIENTATION);
        }
    }

    public ObjectProperty<TextOrientation> textOrientationProperty() {
        if (null == this.textOrientation) {
            this.textOrientation = new ObjectPropertyBase<TextOrientation>(this._textOrientation){

                @Override
                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                @Override
                public Object getBean() {
                    return SunburstChart.this;
                }

                @Override
                public String getName() {
                    return "textOrientation";
                }
            };
            this._textOrientation = null;
        }
        return this.textOrientation;
    }

    public Color getBackgroundColor() {
        return null == this.backgroundColor ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color COLOR) {
        if (null == this.backgroundColor) {
            this._backgroundColor = COLOR;
            this.redraw();
        } else {
            this.backgroundColor.set(COLOR);
        }
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        if (null == this.backgroundColor) {
            this.backgroundColor = new ObjectPropertyBase<Color>(this._backgroundColor){

                @Override
                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                @Override
                public Object getBean() {
                    return SunburstChart.this;
                }

                @Override
                public String getName() {
                    return "backgroundColor";
                }
            };
            this._backgroundColor = null;
        }
        return this.backgroundColor;
    }

    public Color getTextColor() {
        return null == this.textColor ? this._textColor : (Color)this.textColor.get();
    }

    public void setTextColor(Color COLOR) {
        if (null == this.textColor) {
            this._textColor = COLOR;
            this.redraw();
        } else {
            this.textColor.set(COLOR);
        }
    }

    public ObjectProperty<Color> textColorProperty() {
        if (null == this.textColor) {
            this.textColor = new ObjectPropertyBase<Color>(this._textColor){

                @Override
                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                @Override
                public Object getBean() {
                    return SunburstChart.this;
                }

                @Override
                public String getName() {
                    return "textColor";
                }
            };
            this._textColor = null;
        }
        return this.textColor;
    }

    public boolean getUseColorFromParent() {
        return null == this.useColorFromParent ? this._useColorFromParent : this.useColorFromParent.get();
    }

    public void setUseColorFromParent(boolean USE) {
        if (null == this.useColorFromParent) {
            this._useColorFromParent = USE;
            this.redraw();
        } else {
            this.useColorFromParent.set(USE);
        }
    }

    public BooleanProperty useColorFromParentProperty() {
        if (null == this.useColorFromParent) {
            this.useColorFromParent = new BooleanPropertyBase(this._useColorFromParent){

                @Override
                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                @Override
                public Object getBean() {
                    return SunburstChart.this;
                }

                @Override
                public String getName() {
                    return "useColorFromParent";
                }
            };
        }
        return this.useColorFromParent;
    }

    public int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = Helper.clamp(0, 5, DECIMALS);
            this.formatString = "%." + this._decimals + "f";
            this.redraw();
        } else {
            this.decimals.set(DECIMALS);
        }
    }

    public IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new IntegerPropertyBase(this._decimals){

                @Override
                protected void invalidated() {
                    this.set(Helper.clamp(0, 5, this.get()));
                    SunburstChart.this.formatString = "%." + this.get() + "f";
                    SunburstChart.this.redraw();
                }

                @Override
                public Object getBean() {
                    return SunburstChart.this;
                }

                @Override
                public String getName() {
                    return "decimals";
                }
            };
        }
        return this.decimals;
    }

    public boolean isInteractive() {
        return null == this.interactive ? this._interactive : this.interactive.get();
    }

    public void setInteractive(boolean INTERACTIVE) {
        if (null == this.interactive) {
            this._interactive = INTERACTIVE;
            this.redraw();
        } else {
            this.interactive.set(INTERACTIVE);
        }
    }

    public BooleanProperty interactiveProperty() {
        if (null == this.interactive) {
            this.interactive = new BooleanPropertyBase(this._interactive){

                @Override
                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                @Override
                public Object getBean() {
                    return SunburstChart.this;
                }

                @Override
                public String getName() {
                    return "interactive";
                }
            };
        }
        return this.interactive;
    }

    public boolean isAutoTextColor() {
        return null == this.autoTextColor ? this._autoTextColor : this.autoTextColor.get();
    }

    public void setAutoTextColor(boolean AUTOMATIC) {
        if (null == this.autoTextColor) {
            this._autoTextColor = AUTOMATIC;
            this.adjustTextColors();
            this.redraw();
        } else {
            this.autoTextColor.set(AUTOMATIC);
        }
    }

    public BooleanProperty autoTextColorProperty() {
        if (null == this.autoTextColor) {
            this.autoTextColor = new BooleanPropertyBase(this._autoTextColor){

                @Override
                protected void invalidated() {
                    SunburstChart.this.adjustTextColors();
                    SunburstChart.this.redraw();
                }

                @Override
                public Object getBean() {
                    return SunburstChart.this;
                }

                @Override
                public String getName() {
                    return "autoTextColor";
                }
            };
        }
        return this.autoTextColor;
    }

    public Color getBrightTextColor() {
        return null == this.brightTextColor ? this._brightTextColor : (Color)this.brightTextColor.get();
    }

    public void setBrightTextColor(Color COLOR) {
        if (null == this.brightTextColor) {
            this._brightTextColor = COLOR;
            if (this.isAutoTextColor()) {
                this.adjustTextColors();
                this.redraw();
            }
        } else {
            this.brightTextColor.set(COLOR);
        }
    }

    public ObjectProperty<Color> brightTextColorProperty() {
        if (null == this.brightTextColor) {
            this.brightTextColor = new ObjectPropertyBase<Color>(this._brightTextColor){

                @Override
                protected void invalidated() {
                    if (SunburstChart.this.isAutoTextColor()) {
                        SunburstChart.this.adjustTextColors();
                        SunburstChart.this.redraw();
                    }
                }

                @Override
                public Object getBean() {
                    return SunburstChart.this;
                }

                @Override
                public String getName() {
                    return "brightTextColor";
                }
            };
            this._brightTextColor = null;
        }
        return this.brightTextColor;
    }

    public Color getDarkTextColor() {
        return null == this.darkTextColor ? this._darkTextColor : (Color)this.darkTextColor.get();
    }

    public void setDarkTextColor(Color COLOR) {
        if (null == this.darkTextColor) {
            this._darkTextColor = COLOR;
            if (this.isAutoTextColor()) {
                this.adjustTextColors();
                this.redraw();
            }
        } else {
            this.darkTextColor.set(COLOR);
        }
    }

    public ObjectProperty<Color> darkTextColorProperty() {
        if (null == this.darkTextColor) {
            this.darkTextColor = new ObjectPropertyBase<Color>(this._darkTextColor){

                @Override
                protected void invalidated() {
                    if (SunburstChart.this.isAutoTextColor()) {
                        SunburstChart.this.adjustTextColors();
                        SunburstChart.this.redraw();
                    }
                }

                @Override
                public Object getBean() {
                    return SunburstChart.this;
                }

                @Override
                public String getName() {
                    return "darkTextColor";
                }
            };
            this._darkTextColor = null;
        }
        return this.darkTextColor;
    }

    public boolean getUseChartDataTextColor() {
        return null == this.useChartDataTextColor ? this._useChartDataTextColor : this.useChartDataTextColor.get();
    }

    public void setUseChartDataTextColor(boolean USE) {
        if (null == this.useChartDataTextColor) {
            this._useChartDataTextColor = USE;
            this.redraw();
        } else {
            this.useChartDataTextColor.set(USE);
        }
    }

    public BooleanProperty useChartDataTextColor() {
        if (null == this.useChartDataTextColor) {
            this.useChartDataTextColor = new BooleanPropertyBase(this._useChartDataTextColor){

                @Override
                protected void invalidated() {
                    SunburstChart.this.redraw();
                }

                @Override
                public Object getBean() {
                    return SunburstChart.this;
                }

                @Override
                public String getName() {
                    return "useChartDataTextColor";
                }
            };
        }
        return this.useChartDataTextColor;
    }

    public TreeNode<ChartData> getTreeNode() {
        return (TreeNode)this.tree.get();
    }

    public void setTree(TreeNode<ChartData> TREE) {
        if (null != this.tree) {
            this.getTreeNode().flattened().forEach(node -> node.removeAllTreeNodeEventListeners());
        }
        this.tree.set(TREE);
        this.getTreeNode().flattened().forEach(node -> node.setOnTreeNodeEvent(e -> this.redraw()));
        this.prepareData();
        if (this.isAutoTextColor()) {
            this.adjustTextColors();
        }
        this.drawChart();
    }

    public ObjectProperty<TreeNode<ChartData>> treeNodeProperty() {
        return this.tree;
    }

    private void adjustTextColors() {
        Color brightColor = this.getBrightTextColor();
        Color darkColor = this.getDarkTextColor();
        this.root.stream().forEach(node -> {
            ChartData data = (ChartData)node.getItem();
            boolean darkFillColor = Helper.isDark(data.getFillColor());
            boolean darkTextColor = Helper.isDark(data.getTextColor());
            if (darkFillColor && darkTextColor) {
                data.setTextColor(brightColor);
            }
            if (!darkFillColor && !darkTextColor) {
                data.setTextColor(darkColor);
            }
        });
    }

    private void prepareData() {
        this.root = this.getTreeNode().getTreeRoot();
        this.maxLevel = this.root.getMaxLevel();
        this.levelMap.clear();
        for (int i = 0; i <= this.maxLevel; ++i) {
            this.levelMap.put(i, new ArrayList());
        }
        this.root.stream().forEach(node -> this.levelMap.get(node.getDepth()).add((TreeNode<ChartData>)node));
        for (int level = 1; level < this.maxLevel; ++level) {
            List<TreeNode<ChartData>> treeNodeList = this.levelMap.get(level);
            treeNodeList.stream().filter(node -> node.getChildren().isEmpty()).forEach(node -> node.addNode(new TreeNode<ChartData>(new ChartData("", 0.0, Color.TRANSPARENT), (TreeNode<ChartData>)node)));
        }
    }

    private void drawChart() {
        this.levelMap.clear();
        for (int i = 0; i <= this.maxLevel; ++i) {
            this.levelMap.put(i, new ArrayList());
        }
        this.root.stream().forEach(node -> this.levelMap.get(node.getDepth()).add((TreeNode<ChartData>)node));
        boolean isInteractive = this.isInteractive();
        double ringStepSize = this.size * 0.8 / (double)this.maxLevel;
        double ringRadiusStep = ringStepSize * 0.5;
        double barWidth = isInteractive ? ringStepSize * 0.5 : ringStepSize * 0.49;
        double textRadiusStep = this.size * 0.4 / (double)this.maxLevel;
        double segmentStrokeWidth = ringStepSize * 0.01;
        Color bkgColor = this.getBackgroundColor();
        Color textColor = this.getTextColor();
        TextOrientation textOrientation = this.getTextOrientation();
        double maxTextWidth = barWidth * 0.9;
        this.chartCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.chartCtx.setFill(isInteractive ? Color.TRANSPARENT : bkgColor);
        this.chartCtx.fillRect(0.0, 0.0, this.size, this.size);
        this.chartCtx.setFont(Fonts.latoRegular(barWidth * 0.2));
        this.chartCtx.setTextBaseline(VPos.CENTER);
        this.chartCtx.setTextAlign(TextAlignment.CENTER);
        this.chartCtx.setLineCap(StrokeLineCap.BUTT);
        this.segments.clear();
        for (int level = 1; level <= this.maxLevel; ++level) {
            List<TreeNode<ChartData>> nodesAtLevel = this.levelMap.get(level);
            double xy = this.centerX - ringStepSize * (double)level * 0.5;
            double wh = ringStepSize * (double)level;
            double outerRadius = ringRadiusStep * (double)level + barWidth * 0.5;
            double innerRadius = outerRadius - barWidth;
            double segmentEndAngle = 0.0;
            for (TreeNode<ChartData> node2 : nodesAtLevel) {
                ChartData segmentData = node2.getItem();
                double segmentAngle = this.getParentAngle(node2) * this.getPercentage(node2);
                Color segmentColor = this.getUseColorFromParent() ? node2.getMyRoot().getItem().getFillColor() : segmentData.getFillColor();
                double segmentStartAngle = 90.0 + segmentEndAngle;
                segmentEndAngle -= segmentAngle;
                if (Color.TRANSPARENT.equals(segmentData.getFillColor())) continue;
                double value = segmentData.getValue();
                if (isInteractive) {
                    this.segments.add(this.createSegment(-segmentStartAngle, -segmentStartAngle + segmentAngle, innerRadius, outerRadius, segmentColor, bkgColor, node2));
                } else {
                    this.chartCtx.setLineWidth(barWidth);
                    this.chartCtx.setStroke(segmentColor);
                    this.chartCtx.strokeArc(xy, xy, wh, wh, segmentStartAngle, -segmentAngle, ArcType.OPEN);
                    double radStart = Math.toRadians(segmentStartAngle);
                    double cosStart = Math.cos(radStart);
                    double sinStart = Math.sin(radStart);
                    double x1 = this.centerX + innerRadius * cosStart;
                    double y1 = this.centerY - innerRadius * sinStart;
                    double x2 = this.centerX + outerRadius * cosStart;
                    double y2 = this.centerY - outerRadius * sinStart;
                    this.chartCtx.setLineWidth(segmentStrokeWidth);
                    this.chartCtx.setStroke(bkgColor);
                    this.chartCtx.strokeLine(x1, y1, x2, y2);
                }
                if (this.getVisibleData() == VisibleData.NONE || !(segmentAngle > textOrientation.getMaxAngle())) continue;
                double radText = Math.toRadians(segmentStartAngle - segmentAngle * 0.5);
                double cosText = Math.cos(radText);
                double sinText = Math.sin(radText);
                double textRadius = textRadiusStep * (double)level;
                double textX = this.centerX + textRadius * cosText;
                double textY = this.centerY - textRadius * sinText;
                this.chartCtx.setFill(this.getUseChartDataTextColor() ? segmentData.getTextColor() : textColor);
                this.chartCtx.save();
                this.chartCtx.translate(textX, textY);
                SunburstChart.rotateContextForText(this.chartCtx, segmentStartAngle, -(segmentAngle * 0.5), textOrientation);
                switch (this.getVisibleData()) {
                    case VALUE: {
                        this.chartCtx.fillText(String.format(Locale.US, this.formatString, value), 0.0, 0.0, maxTextWidth);
                        break;
                    }
                    case NAME: {
                        this.chartCtx.fillText(segmentData.getName(), 0.0, 0.0, maxTextWidth);
                        break;
                    }
                    case NAME_VALUE: {
                        this.chartCtx.fillText(String.join((CharSequence)"", segmentData.getName(), " (", String.format(Locale.US, this.formatString, value), ")"), 0.0, 0.0, maxTextWidth);
                    }
                }
                this.chartCtx.restore();
            }
        }
        this.segmentPane.getChildren().setAll((Collection<Node>)this.segments);
    }

    public double getParentAngle(TreeNode<ChartData> NODE) {
        ArrayList<TreeNode<ChartData>> parentList = new ArrayList<TreeNode<ChartData>>();
        TreeNode<ChartData> node = NODE;
        while (!node.getParent().isRoot()) {
            node = node.getParent();
            parentList.add(node);
        }
        Collections.reverse(parentList);
        double parentAngle = 360.0;
        for (TreeNode treeNode : parentList) {
            parentAngle *= this.getPercentage(treeNode);
        }
        return parentAngle;
    }

    private double getPercentage(TreeNode<ChartData> NODE) {
        List<TreeNode<ChartData>> siblings = NODE.getSiblings();
        double sum = siblings.stream().map(node -> (ChartData)node.getItem()).mapToDouble(ChartData::getValue).sum();
        return Double.compare(sum, 0.0) == 0 ? 1.0 : NODE.getItem().getValue() / sum;
    }

    private Path createSegment(double START_ANGLE, double END_ANGLE, double INNER_RADIUS, double OUTER_RADIUS, Color FILL, Color STROKE, TreeNode<ChartData> NODE) {
        double startAngleRad = Math.toRadians(START_ANGLE + 90.0);
        double endAngleRad = Math.toRadians(END_ANGLE + 90.0);
        boolean largeAngle = Math.abs(END_ANGLE - START_ANGLE) > 180.0;
        double x1 = this.centerX + INNER_RADIUS * Math.sin(startAngleRad);
        double y1 = this.centerY - INNER_RADIUS * Math.cos(startAngleRad);
        double x2 = this.centerX + OUTER_RADIUS * Math.sin(startAngleRad);
        double y2 = this.centerY - OUTER_RADIUS * Math.cos(startAngleRad);
        double x3 = this.centerX + OUTER_RADIUS * Math.sin(endAngleRad);
        double y3 = this.centerY - OUTER_RADIUS * Math.cos(endAngleRad);
        double x4 = this.centerX + INNER_RADIUS * Math.sin(endAngleRad);
        double y4 = this.centerY - INNER_RADIUS * Math.cos(endAngleRad);
        MoveTo moveTo1 = new MoveTo(x1, y1);
        LineTo lineTo2 = new LineTo(x2, y2);
        ArcTo arcTo3 = new ArcTo(OUTER_RADIUS, OUTER_RADIUS, 0.0, x3, y3, largeAngle, true);
        LineTo lineTo4 = new LineTo(x4, y4);
        ArcTo arcTo1 = new ArcTo(INNER_RADIUS, INNER_RADIUS, 0.0, x1, y1, largeAngle, false);
        Path path = new Path(moveTo1, lineTo2, arcTo3, lineTo4, arcTo1);
        path.setFill(FILL);
        path.setStroke(STROKE);
        String tooltipText = NODE.getItem().getName() + "\n" + String.format(Locale.US, this.formatString, NODE.getItem().getValue());
        Tooltip.install(path, new Tooltip(tooltipText));
        path.setOnMousePressed(new WeakEventHandler<MouseEvent>(e -> NODE.getTreeRoot().fireTreeNodeEvent(new TreeNodeEvent(NODE, TreeNodeEvent.EventType.NODE_SELECTED))));
        return path;
    }

    private static void rotateContextForText(GraphicsContext CTX, double START_ANGLE, double ANGLE, TextOrientation ORIENTATION) {
        switch (ORIENTATION) {
            case TANGENT: {
                if ((360.0 - START_ANGLE - ANGLE) % 360.0 > 90.0 && (360.0 - START_ANGLE - ANGLE) % 360.0 < 270.0) {
                    CTX.rotate((180.0 - START_ANGLE - ANGLE) % 360.0);
                    break;
                }
                CTX.rotate((360.0 - START_ANGLE - ANGLE) % 360.0);
                break;
            }
            case ORTHOGONAL: {
                if ((360.0 - START_ANGLE - ANGLE - 90.0) % 360.0 > 90.0 && (360.0 - START_ANGLE - ANGLE - 90.0) % 360.0 < 270.0) {
                    CTX.rotate((90.0 - START_ANGLE - ANGLE) % 360.0);
                    break;
                }
                CTX.rotate((270.0 - START_ANGLE - ANGLE) % 360.0);
                break;
            }
        }
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.setPrefSize(this.size, this.size);
            this.pane.relocate((this.getWidth() - this.size) * 0.5, (this.getHeight() - this.size) * 0.5);
            this.segmentPane.setPrefSize(this.size, this.size);
            this.chartCanvas.setWidth(this.size);
            this.chartCanvas.setHeight(this.size);
            this.centerY = this.centerX = this.size * 0.5;
            this.redraw();
        }
    }

    public void redraw() {
        this.pane.setBackground(new Background(new BackgroundFill(this.backgroundPaint, CornerRadii.EMPTY, Insets.EMPTY)));
        this.pane.setBorder(new Border(new BorderStroke(this.borderPaint, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, new BorderWidths(this.borderWidth / 250.0 * this.size))));
        this.segmentPane.setBackground(new Background(new BackgroundFill(this.getBackgroundColor(), CornerRadii.EMPTY, Insets.EMPTY)));
        this.segmentPane.setManaged(this.isInteractive());
        this.segmentPane.setVisible(this.isInteractive());
        this.drawChart();
    }

    public static enum TextOrientation {
        HORIZONTAL(12.0),
        TANGENT(8.0),
        ORTHOGONAL(12.0);

        private double maxAngle;

        private TextOrientation(double MAX_ANGLE) {
            this.maxAngle = MAX_ANGLE;
        }

        public double getMaxAngle() {
            return this.maxAngle;
        }
    }

    public static enum VisibleData {
        NONE,
        NAME,
        VALUE,
        NAME_VALUE;

    }
}

