/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.selector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ui.list.RemovableObjectList;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.selector.OWLAnnotationPropertySelectorPanel;
import org.protege.editor.owl.ui.selector.OWLClassSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLDataPropertySelectorPanel;
import org.protege.editor.owl.ui.selector.OWLDataTypeSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLIndividualSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLObjectPropertySelectorPanel;
import org.protege.editor.owl.ui.selector.OWLObjectSelector;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class OWLEntitySelectorPanel
extends JPanel
implements OWLObjectSelector<OWLEntity>,
Disposable {
    private static final long serialVersionUID = -1671448634230595527L;
    private OWLClassSelectorPanel classSelectorPanel;
    private OWLObjectPropertySelectorPanel objectPropertySelectorPanel;
    private OWLDataPropertySelectorPanel dataPropertySelectorPanel;
    private OWLIndividualSelectorPanel individualSelectorPanel;
    private OWLDataTypeSelectorPanel datatypeSelectorPanel;
    private OWLAnnotationPropertySelectorPanel annotationPropertySelectorPanel;
    private JTabbedPane tabbedPane;
    private RemovableObjectList<OWLEntity> entityList;
    private JButton button;
    private JScrollPane sp;
    private OWLEntityVisitor selectionSetter = new OWLEntityVisitor(){

        public void visit(OWLClass owlClass) {
            OWLEntitySelectorPanel.this.tabbedPane.setSelectedComponent(OWLEntitySelectorPanel.this.classSelectorPanel);
            OWLEntitySelectorPanel.this.classSelectorPanel.setSelection(owlClass);
        }

        public void visit(OWLObjectProperty owlObjectProperty) {
            OWLEntitySelectorPanel.this.tabbedPane.setSelectedComponent(OWLEntitySelectorPanel.this.objectPropertySelectorPanel);
            OWLEntitySelectorPanel.this.objectPropertySelectorPanel.setSelection(owlObjectProperty);
        }

        public void visit(OWLDataProperty owlDataProperty) {
            OWLEntitySelectorPanel.this.tabbedPane.setSelectedComponent(OWLEntitySelectorPanel.this.dataPropertySelectorPanel);
            OWLEntitySelectorPanel.this.dataPropertySelectorPanel.setSelection(owlDataProperty);
        }

        public void visit(OWLNamedIndividual owlNamedIndividual) {
            OWLEntitySelectorPanel.this.tabbedPane.setSelectedComponent(OWLEntitySelectorPanel.this.individualSelectorPanel);
            OWLEntitySelectorPanel.this.individualSelectorPanel.setSelection(owlNamedIndividual);
        }

        public void visit(OWLDatatype owlDatatype) {
            OWLEntitySelectorPanel.this.tabbedPane.setSelectedComponent(OWLEntitySelectorPanel.this.datatypeSelectorPanel);
            OWLEntitySelectorPanel.this.datatypeSelectorPanel.setSelection(owlDatatype);
        }

        public void visit(OWLAnnotationProperty owlAnnotationProperty) {
            OWLEntitySelectorPanel.this.tabbedPane.setSelectedComponent(OWLEntitySelectorPanel.this.annotationPropertySelectorPanel);
            OWLEntitySelectorPanel.this.annotationPropertySelectorPanel.setSelection(owlAnnotationProperty);
        }
    };

    public OWLEntitySelectorPanel(OWLEditorKit owlEditorKit) {
        this(owlEditorKit, true);
    }

    public OWLEntitySelectorPanel(OWLEditorKit owlEditorKit, boolean multiselect) {
        this.classSelectorPanel = new OWLClassSelectorPanel(owlEditorKit, false);
        this.classSelectorPanel.setBorder(null);
        this.objectPropertySelectorPanel = new OWLObjectPropertySelectorPanel(owlEditorKit, false);
        this.objectPropertySelectorPanel.setBorder(null);
        this.dataPropertySelectorPanel = new OWLDataPropertySelectorPanel(owlEditorKit, false);
        this.dataPropertySelectorPanel.setBorder(null);
        this.individualSelectorPanel = new OWLIndividualSelectorPanel(owlEditorKit, false, owlEditorKit.getOWLModelManager().getOntologies(), 2);
        this.individualSelectorPanel.setBorder(null);
        this.datatypeSelectorPanel = new OWLDataTypeSelectorPanel(owlEditorKit, false);
        this.datatypeSelectorPanel.setBorder(null);
        this.annotationPropertySelectorPanel = new OWLAnnotationPropertySelectorPanel(owlEditorKit, false);
        this.annotationPropertySelectorPanel.setBorder(null);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add("Classes", this.classSelectorPanel);
        this.tabbedPane.add("Object properties", this.objectPropertySelectorPanel);
        this.tabbedPane.add("Data properties", this.dataPropertySelectorPanel);
        this.tabbedPane.add("Individuals", this.individualSelectorPanel);
        this.tabbedPane.add("Datatypes", this.datatypeSelectorPanel);
        this.tabbedPane.add("Annotation Properties", this.annotationPropertySelectorPanel);
        if (!multiselect) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.tabbedPane, "Center");
        } else {
            this.setLayout(new EntitySelectorPanelLayoutManager());
            this.add(this.tabbedPane);
            this.entityList = new RemovableObjectList();
            this.entityList.setCellRenderer((ListCellRenderer)new OWLCellRenderer(owlEditorKit));
            this.entityList.addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting()) {
                    this.transmitSelectionFromList();
                }
            });
            this.button = new JButton(new AbstractAction(">>"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OWLEntitySelectorPanel.this.addSelectedItems();
                }
            });
            this.add(this.button);
            this.sp = new JScrollPane((Component)this.entityList);
            this.add(this.sp);
        }
    }

    private boolean isMultiSelect() {
        return this.entityList != null;
    }

    public void transmitSelectionFromList() {
        if (this.isMultiSelect()) {
            OWLEntity ent = (OWLEntity)this.entityList.getSelectedObject();
            this.setTreeSelection(ent);
        }
    }

    @Override
    public OWLEntity getSelectedObject() {
        if (this.isMultiSelect()) {
            return (OWLEntity)this.entityList.getSelectedObject();
        }
        Set<OWLEntity> sel = this.getCurrentSelection();
        if (!sel.isEmpty()) {
            return sel.iterator().next();
        }
        return null;
    }

    @Override
    public Set<OWLEntity> getSelectedObjects() {
        if (this.isMultiSelect()) {
            return new HashSet<OWLEntity>(this.entityList.getListItems());
        }
        return new HashSet<OWLEntity>(this.getCurrentSelection());
    }

    public void setSelection(Set<? extends OWLEntity> entities) {
        if (this.isMultiSelect()) {
            this.entityList.setListData(entities.toArray());
        } else if (entities.size() == 1) {
            this.setSelection(entities.iterator().next());
        }
    }

    public void setSelection(OWLEntity entity) {
        if (this.isMultiSelect()) {
            Object[] objectArray;
            if (entity != null) {
                OWLEntity[] oWLEntityArray = new OWLEntity[1];
                objectArray = oWLEntityArray;
                oWLEntityArray[0] = entity;
            } else {
                objectArray = new OWLEntity[]{};
            }
            this.entityList.setListData(objectArray);
        } else {
            this.setTreeSelection(entity);
        }
    }

    private void setTreeSelection(OWLEntity ent) {
        if (ent != null) {
            ent.accept(this.selectionSetter);
        }
    }

    public void dispose() {
        this.classSelectorPanel.dispose();
        this.objectPropertySelectorPanel.dispose();
        this.dataPropertySelectorPanel.dispose();
        this.individualSelectorPanel.dispose();
        this.datatypeSelectorPanel.dispose();
        this.annotationPropertySelectorPanel.dispose();
    }

    public String getID() {
        return "modularity.selectsignature";
    }

    public String getTitle() {
        return "Select signature";
    }

    public void addSelectedItems() {
        this.entityList.addObject(this.getCurrentSelection());
    }

    public Set<OWLEntity> getCurrentSelection() {
        Component selComponent = this.tabbedPane.getSelectedComponent();
        return ((OWLObjectSelector)((Object)selComponent)).getSelectedObjects();
    }

    public void addSelectionListener(ChangeListener l) {
        this.classSelectorPanel.addSelectionListener(l);
        this.objectPropertySelectorPanel.addSelectionListener(l);
        this.dataPropertySelectorPanel.addSelectionListener(l);
        this.individualSelectorPanel.addSelectionListener(l);
        this.datatypeSelectorPanel.addSelectionListener(l);
        this.annotationPropertySelectorPanel.addSelectionListener(l);
        this.tabbedPane.addChangeListener(l);
    }

    public void removeSelectionListener(ChangeListener l) {
        this.classSelectorPanel.removeSelectionListener(l);
        this.objectPropertySelectorPanel.removeSelectionListener(l);
        this.dataPropertySelectorPanel.removeSelectionListener(l);
        this.individualSelectorPanel.removeSelectionListener(l);
        this.datatypeSelectorPanel.removeSelectionListener(l);
        this.annotationPropertySelectorPanel.removeSelectionListener(l);
        this.tabbedPane.removeChangeListener(l);
    }

    private class EntitySelectorPanelLayoutManager
    implements LayoutManager {
        private EntitySelectorPanelLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            Dimension dim = OWLEntitySelectorPanel.this.tabbedPane.getPreferredSize();
            int totalWidth = insets.left + insets.right + 2 * dim.width + ((OWLEntitySelectorPanel)OWLEntitySelectorPanel.this).button.getPreferredSize().width;
            int totalHeight = insets.top + insets.bottom + dim.height;
            return new Dimension(totalWidth, totalHeight);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int xOffset = insets.left;
            int yOffset = insets.top;
            int availWidth = parent.getWidth() - insets.left - insets.right;
            int availHeight = parent.getHeight() - insets.top - insets.bottom;
            Dimension buttonPrefDim = OWLEntitySelectorPanel.this.button.getPreferredSize();
            int leftAndRightColWidth = (availWidth - buttonPrefDim.width) / 2;
            OWLEntitySelectorPanel.this.tabbedPane.setBounds(xOffset, yOffset, leftAndRightColWidth, availHeight);
            Component tabComponent = OWLEntitySelectorPanel.this.tabbedPane.getComponentAt(0);
            int listYOffset = tabComponent.getBounds().y;
            OWLEntitySelectorPanel.this.sp.setBounds(xOffset + leftAndRightColWidth + buttonPrefDim.width, yOffset + listYOffset, tabComponent.getWidth(), tabComponent.getHeight());
            OWLEntitySelectorPanel.this.button.setBounds(xOffset + leftAndRightColWidth, yOffset + availHeight / 2, buttonPrefDim.width, buttonPrefDim.height);
        }
    }
}

