/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.preferences.node;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.protege.editor.core.ui.preferences.node.PreferenceNode;
import org.protege.editor.core.ui.preferences.node.PreferenceNodeGroup;

public class PreferenceNodePanel
extends JPanel {
    private static final long serialVersionUID = -7132664017712650993L;
    private List<JLabel> labels = new ArrayList<JLabel>();

    public PreferenceNodePanel(PreferenceNodeGroup group) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(group.getLabel()), BorderFactory.createEmptyBorder(10, 30, 20, 10)));
        List<PreferenceNode> prefNodes = group.getNodes();
        Box box = new Box(1);
        for (PreferenceNode node : prefNodes) {
            JPanel holder = new JPanel(new FlowLayout(0));
            JComponent component = node.getComponent();
            String labelText = "";
            if (!(component instanceof JCheckBox)) {
                labelText = node.getLabel();
            }
            holder.add(this.createComponentLabel(labelText));
            holder.add(component);
            box.add(holder);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)box, "North");
        Dimension dim = new Dimension();
        for (JLabel label : this.labels) {
            if (label.getPreferredSize().width <= dim.width) continue;
            dim = label.getPreferredSize();
        }
        for (JLabel label : this.labels) {
            label.setPreferredSize(dim);
        }
    }

    protected JLabel createComponentLabel(String text) {
        JLabel label = new JLabel(text);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 7));
        this.labels.add(label);
        label.setHorizontalAlignment(4);
        return label;
    }
}

