/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.toolbox.Substring;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCodeStyleDocString
extends SectionBasedDocString {
    public static final Pattern SECTION_HEADER = Pattern.compile("^[ \t]*([\\w \t]+):[ \t]*$", 8);
    private static final Pattern FIELD_NAME_AND_TYPE = Pattern.compile("^[ \t]*(.+?)[ \t]*\\([ \t]*(.*?)[ \t]*\\)?[ \t]*$", 8);
    public static final List<String> PREFERRED_SECTION_HEADERS = ImmutableList.of((Object)"Args", (Object)"Keyword Args", (Object)"Returns", (Object)"Yields", (Object)"Raises", (Object)"Attributes", (Object)"See Also", (Object)"Methods", (Object)"References", (Object)"Examples", (Object)"Notes", (Object)"Warnings", (Object[])new String[0]);
    private static final ImmutableMap<String, SectionBasedDocString.FieldType> ourSectionFieldMapping = ImmutableMap.builder().put((Object)"returns", (Object)SectionBasedDocString.FieldType.OPTIONAL_TYPE).put((Object)"yields", (Object)SectionBasedDocString.FieldType.OPTIONAL_TYPE).put((Object)"raises", (Object)SectionBasedDocString.FieldType.ONLY_TYPE).put((Object)"methods", (Object)SectionBasedDocString.FieldType.ONLY_NAME).put((Object)"keyword arguments", (Object)SectionBasedDocString.FieldType.NAME_WITH_OPTIONAL_TYPE).put((Object)"parameters", (Object)SectionBasedDocString.FieldType.NAME_WITH_OPTIONAL_TYPE).put((Object)"attributes", (Object)SectionBasedDocString.FieldType.NAME_WITH_OPTIONAL_TYPE).put((Object)"other parameters", (Object)SectionBasedDocString.FieldType.NAME_WITH_OPTIONAL_TYPE).build();

    public GoogleCodeStyleDocString(@NotNull Substring text2) {
        if (text2 == null) {
            GoogleCodeStyleDocString.$$$reportNull$$$0(0);
        }
        super(text2);
    }

    @Override
    @Nullable
    protected SectionBasedDocString.FieldType getFieldType(@NotNull String title) {
        if (title == null) {
            GoogleCodeStyleDocString.$$$reportNull$$$0(1);
        }
        return (SectionBasedDocString.FieldType)((Object)ourSectionFieldMapping.get((Object)title));
    }

    @Override
    protected Pair<SectionBasedDocString.SectionField, Integer> parseSectionField(int lineNum, int sectionIndent, @NotNull SectionBasedDocString.FieldType fieldType) {
        Substring description;
        if (fieldType == null) {
            GoogleCodeStyleDocString.$$$reportNull$$$0(2);
        }
        Substring line = this.getLine(lineNum);
        Substring name = null;
        Substring type = null;
        List<Substring> colonSeparatedParts = GoogleCodeStyleDocString.splitByFirstColon(line);
        assert (colonSeparatedParts.size() <= 2);
        Substring textBeforeColon = colonSeparatedParts.get(0);
        if (colonSeparatedParts.size() == 2 || !fieldType.canHaveOnlyDescription) {
            Matcher matcher;
            description = colonSeparatedParts.size() == 2 ? colonSeparatedParts.get(1) : null;
            name = textBeforeColon.trim();
            if (fieldType.canHaveBothNameAndType && (matcher = FIELD_NAME_AND_TYPE.matcher(textBeforeColon)).matches()) {
                name = textBeforeColon.getMatcherGroup(matcher, 1).trim();
                type = textBeforeColon.getMatcherGroup(matcher, 2).trim();
            }
            if (fieldType.preferType && type == null) {
                type = name;
                name = null;
            }
            if (name != null) {
                name = GoogleCodeStyleDocString.cleanUpName(name);
            }
            if (name != null ? !this.isValidName(name.toString()) : !this.isValidType(type.toString())) {
                return Pair.create(null, (Object)lineNum);
            }
        } else {
            description = textBeforeColon;
        }
        if (description != null) {
            Pair<List<Substring>, Integer> pair = this.parseIndentedBlock(lineNum + 1, this.getLineIndentSize(lineNum));
            List nestedBlock = (List)pair.getFirst();
            if (!nestedBlock.isEmpty()) {
                description = description.union((Substring)ContainerUtil.getLastItem((List)nestedBlock));
            }
            description = description.trim();
            return Pair.create((Object)new SectionBasedDocString.SectionField(name, type, description), (Object)pair.getSecond());
        }
        return Pair.create((Object)new SectionBasedDocString.SectionField(name, type, null), (Object)(lineNum + 1));
    }

    @Override
    @NotNull
    protected Pair<Substring, Integer> parseSectionHeader(int lineNum) {
        Substring title;
        Substring line = this.getLine(lineNum);
        Matcher matcher = SECTION_HEADER.matcher(line);
        if (matcher.matches() && GoogleCodeStyleDocString.isValidSectionTitle((title = line.getMatcherGroup(matcher, 1).trim()).toString())) {
            Pair pair = Pair.create((Object)title, (Object)(lineNum + 1));
            if (pair == null) {
                GoogleCodeStyleDocString.$$$reportNull$$$0(3);
            }
            return pair;
        }
        Pair pair = Pair.create(null, (Object)lineNum);
        if (pair == null) {
            GoogleCodeStyleDocString.$$$reportNull$$$0(4);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/GoogleCodeStyleDocString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/GoogleCodeStyleDocString";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSectionHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFieldType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseSectionField";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

