/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.move;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.move.PyBaseMoveDialog;
import com.jetbrains.python.refactoring.move.makeFunctionTopLevel.PyMakeFunctionTopLevelDialog;
import com.jetbrains.python.refactoring.move.makeFunctionTopLevel.PyMakeLocalFunctionTopLevelProcessor;
import com.jetbrains.python.refactoring.move.makeFunctionTopLevel.PyMakeMethodTopLevelProcessor;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveModuleMembersDialog;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveModuleMembersHelper;
import com.jetbrains.python.refactoring.move.moduleMembers.PyMoveModuleMembersProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMoveSymbolDelegate
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        if (targetContainer != null && !super.canMove(elements, targetContainer)) {
            return false;
        }
        if (PyMoveSymbolDelegate.isMovableLocalFunctionOrMethod(elements[0])) {
            return true;
        }
        for (PsiElement element : elements) {
            if (PyMoveModuleMembersHelper.isMovableModuleMember(element)) continue;
            return false;
        }
        return true;
    }

    public void doMove(@NotNull Project project, @NotNull List<PyElement> elements) {
        BaseRefactoringProcessor processor;
        if (project == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(1);
        }
        PsiElement firstElement = (PsiElement)elements.get(0);
        String initialPath = StringUtil.notNullize((String)PyPsiUtils.getContainingFilePath(firstElement));
        if (PyMoveSymbolDelegate.isMovableLocalFunctionOrMethod(firstElement)) {
            PyFunction function = (PyFunction)firstElement;
            PyMakeFunctionTopLevelDialog dialog = new PyMakeFunctionTopLevelDialog(project, function, initialPath, initialPath);
            if (!dialog.showAndGet()) {
                return;
            }
            processor = function.getContainingClass() != null ? new PyMakeMethodTopLevelProcessor(function, dialog.getTargetPath()) : new PyMakeLocalFunctionTopLevelProcessor(function, dialog.getTargetPath());
            processor.setPreviewUsages(dialog.isPreviewUsages());
        } else {
            ArrayList initialElements = Lists.newArrayList();
            for (PsiElement psiElement : elements) {
                PsiNamedElement e = PyMoveModuleMembersHelper.extractNamedElement(psiElement);
                if (e == null) {
                    return;
                }
                initialElements.add(e);
            }
            Object dialog = new PyMoveModuleMembersDialog(project, initialElements, initialPath, initialPath);
            if (!dialog.showAndGet()) {
                return;
            }
            PsiNamedElement[] psiNamedElementArray = (PsiNamedElement[])ContainerUtil.findAllAsArray(((PyMoveModuleMembersDialog)((Object)dialog)).getSelectedTopLevelSymbols(), PsiNamedElement.class);
            processor = new PyMoveModuleMembersProcessor(psiNamedElementArray, ((PyBaseMoveDialog)((Object)dialog)).getTargetPath());
            processor.setPreviewUsages(dialog.isPreviewUsages());
        }
        try {
            processor.run();
        }
        catch (IncorrectOperationException e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw e;
            }
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), null, (Project)project);
        }
    }

    public boolean tryToMove(@NotNull PsiElement element, @NotNull Project project, @Nullable DataContext dataContext, @Nullable PsiReference reference, @Nullable Editor editor) {
        if (element == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(3);
        }
        PsiFile currentFile = element.getContainingFile();
        if (editor != null && currentFile instanceof PyFile && PyMoveSymbolDelegate.selectionSpansMultipleLines(editor)) {
            List<PyElement> moduleMembers = PyMoveSymbolDelegate.collectAllMovableElementsInSelection(editor, (PyFile)currentFile);
            if (moduleMembers.isEmpty()) {
                PyMoveSymbolDelegate.showBadSelectionErrorHint(project, editor);
            } else {
                this.doMove(project, moduleMembers);
            }
            return true;
        }
        PsiNamedElement e = PyMoveModuleMembersHelper.extractNamedElement(element);
        if (e != null && PyMoveModuleMembersHelper.hasMovableElementType((PsiElement)e)) {
            if (PyMoveModuleMembersHelper.isMovableModuleMember((PsiElement)e) || PyMoveSymbolDelegate.isMovableLocalFunctionOrMethod((PsiElement)e)) {
                this.doMove(project, Collections.singletonList((PyElement)e));
            } else {
                PyMoveSymbolDelegate.showBadSelectionErrorHint(project, editor);
            }
            return true;
        }
        return false;
    }

    private static void showBadSelectionErrorHint(@NotNull Project project, @Nullable Editor editor) {
        if (project == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(4);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyBundle.message("refactoring.move.module.members.error.selection", new Object[0]), (String)RefactoringBundle.message((String)"error.title"), null);
    }

    private static boolean selectionSpansMultipleLines(@NotNull Editor editor) {
        if (editor == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(5);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        Document document = editor.getDocument();
        return document.getLineNumber(selectionModel.getSelectionStart()) != document.getLineNumber(selectionModel.getSelectionEnd());
    }

    @NotNull
    private static List<PyElement> collectAllMovableElementsInSelection(@NotNull Editor editor, @NotNull PyFile pyFile) {
        if (editor == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(6);
        }
        if (pyFile == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(7);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        TextRange selectionRange = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
        List<PyElement> members = PyMoveModuleMembersHelper.getTopLevelModuleMembers(pyFile);
        List list = ContainerUtil.filter(members, member -> {
            PsiElement body = PyMoveModuleMembersHelper.expandNamedElementBody((PsiNamedElement)member);
            return body != null && selectionRange.contains(body.getTextRange());
        });
        if (list == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(8);
        }
        return list;
    }

    @VisibleForTesting
    public static boolean isMovableLocalFunctionOrMethod(@NotNull PsiElement element) {
        if (element == null) {
            PyMoveSymbolDelegate.$$$reportNull$$$0(9);
        }
        return PyMoveSymbolDelegate.isLocalFunction(element) || PyMoveSymbolDelegate.isSuitableInstanceMethod(element);
    }

    private static boolean isSuitableInstanceMethod(@Nullable PsiElement element) {
        PyFunction function = PyUtil.as(element, PyFunction.class);
        if (function == null || function.getContainingClass() == null) {
            return false;
        }
        String funcName = function.getName();
        if (funcName == null || PyUtil.isSpecialName(funcName)) {
            return false;
        }
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(function.getProject(), function.getContainingFile());
        if (PySuperMethodsSearch.search(function, typeEvalContext).findFirst() != null) {
            return false;
        }
        if (PyOverridingMethodsSearch.search(function, true).findFirst() != null) {
            return false;
        }
        if (function.getDecoratorList() != null || function.getModifier() != null) {
            return false;
        }
        return function.getContainingClass().findPropertyByCallable(function) == null;
    }

    private static boolean isLocalFunction(@Nullable PsiElement resolved) {
        return resolved instanceof PyFunction && PsiTreeUtil.getParentOfType((PsiElement)resolved, ScopeOwner.class, (boolean)true) instanceof PyFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/move/PyMoveSymbolDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/move/PyMoveSymbolDelegate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllMovableElementsInSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doMove";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryToMove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showBadSelectionErrorHint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectionSpansMultipleLines";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectAllMovableElementsInSelection";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMovableLocalFunctionOrMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

