/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.functionTypeComments.psi.PyParameterTypeList;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.validation.PyAnnotator;
import org.jetbrains.annotations.NotNull;

public class StarAnnotator
extends PyAnnotator {
    @Override
    public void visitPyStarExpression(PyStarExpression node) {
        super.visitPyStarExpression(node);
        if (!(node.isAssignmentTarget() || StarAnnotator.allowedUnpacking(node) || node.getParent() instanceof PyParameterTypeList)) {
            this.getHolder().createErrorAnnotation((PsiElement)node, "Can't use starred expression here");
        }
    }

    private static boolean allowedUnpacking(@NotNull PyStarExpression starExpression) {
        if (starExpression == null) {
            StarAnnotator.$$$reportNull$$$0(0);
        }
        if (!starExpression.isUnpacking()) {
            return false;
        }
        PsiElement parent = starExpression.getParent();
        return !(parent instanceof PyTupleExpression) || !(parent.getParent() instanceof PyReturnStatement) && !(parent.getParent() instanceof PyYieldExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "starExpression", "com/jetbrains/python/validation/StarAnnotator", "allowedUnpacking"));
    }
}

