/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipUtil;
import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.GotoNextErrorHandler;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.daemon.impl.PsiChangeHandler;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSettingListener;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.TogglePopupHintsPanel;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.RefResolveService;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonListeners
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.DaemonListeners");
    private final Project myProject;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    @NotNull
    private final PsiDocumentManager myPsiDocumentManager;
    private final FileEditorManager myFileEditorManager;
    private final UndoManager myUndoManager;
    private final ProjectLevelVcsManager myProjectLevelVcsManager;
    private final VcsDirtyScopeManager myVcsDirtyScopeManager;
    private final FileStatusManager myFileStatusManager;
    @NotNull
    private final ActionManager myActionManager;
    private final TooltipController myTooltipController;
    private final ErrorStripeUpdateManager myErrorStripeUpdateManager;
    private boolean myEscPressed;
    private volatile boolean cutOperationJustHappened;
    private final DaemonCodeAnalyzer.DaemonListener myDaemonEventPublisher;
    private static final Key<Boolean> DAEMON_INITIALIZED = Key.create((String)"DAEMON_INITIALIZED");
    private TogglePopupHintsPanel myTogglePopupHintsPanel;

    public static DaemonListeners getInstance(Project project) {
        return (DaemonListeners)project.getComponent(DaemonListeners.class);
    }

    public DaemonListeners(@NotNull Project project, @NotNull DaemonCodeAnalyzerImpl daemonCodeAnalyzer, final @NotNull EditorTracker editorTracker, @NotNull EditorFactory editorFactory, @NotNull PsiDocumentManager psiDocumentManager, @NotNull CommandProcessor commandProcessor, final @NotNull Application application, @NotNull ProjectInspectionProfileManager inspectionProjectProfileManager, @NotNull TodoConfiguration todoConfiguration, @NotNull ActionManagerEx actionManagerEx, @NotNull VirtualFileManager virtualFileManager, @NotNull NamedScopeManager namedScopeManager, @NotNull DependencyValidationManager dependencyValidationManager, final @NotNull FileDocumentManager fileDocumentManager, final @NotNull PsiManager psiManager, @NotNull FileEditorManager fileEditorManager, @NotNull TooltipController tooltipController, @NotNull UndoManager undoManager, @NotNull ProjectLevelVcsManager projectLevelVcsManager, @NotNull VcsDirtyScopeManager vcsDirtyScopeManager, @NotNull FileStatusManager fileStatusManager, @NotNull ErrorStripeUpdateManager stripeUpdateManager) {
        if (project == null) {
            DaemonListeners.$$$reportNull$$$0(0);
        }
        if (daemonCodeAnalyzer == null) {
            DaemonListeners.$$$reportNull$$$0(1);
        }
        if (editorTracker == null) {
            DaemonListeners.$$$reportNull$$$0(2);
        }
        if (editorFactory == null) {
            DaemonListeners.$$$reportNull$$$0(3);
        }
        if (psiDocumentManager == null) {
            DaemonListeners.$$$reportNull$$$0(4);
        }
        if (commandProcessor == null) {
            DaemonListeners.$$$reportNull$$$0(5);
        }
        if (application == null) {
            DaemonListeners.$$$reportNull$$$0(6);
        }
        if (inspectionProjectProfileManager == null) {
            DaemonListeners.$$$reportNull$$$0(7);
        }
        if (todoConfiguration == null) {
            DaemonListeners.$$$reportNull$$$0(8);
        }
        if (actionManagerEx == null) {
            DaemonListeners.$$$reportNull$$$0(9);
        }
        if (virtualFileManager == null) {
            DaemonListeners.$$$reportNull$$$0(10);
        }
        if (namedScopeManager == null) {
            DaemonListeners.$$$reportNull$$$0(11);
        }
        if (dependencyValidationManager == null) {
            DaemonListeners.$$$reportNull$$$0(12);
        }
        if (fileDocumentManager == null) {
            DaemonListeners.$$$reportNull$$$0(13);
        }
        if (psiManager == null) {
            DaemonListeners.$$$reportNull$$$0(14);
        }
        if (fileEditorManager == null) {
            DaemonListeners.$$$reportNull$$$0(15);
        }
        if (tooltipController == null) {
            DaemonListeners.$$$reportNull$$$0(16);
        }
        if (undoManager == null) {
            DaemonListeners.$$$reportNull$$$0(17);
        }
        if (projectLevelVcsManager == null) {
            DaemonListeners.$$$reportNull$$$0(18);
        }
        if (vcsDirtyScopeManager == null) {
            DaemonListeners.$$$reportNull$$$0(19);
        }
        if (fileStatusManager == null) {
            DaemonListeners.$$$reportNull$$$0(20);
        }
        if (stripeUpdateManager == null) {
            DaemonListeners.$$$reportNull$$$0(21);
        }
        this.myProject = project;
        this.myDaemonCodeAnalyzer = daemonCodeAnalyzer;
        this.myPsiDocumentManager = psiDocumentManager;
        this.myFileEditorManager = fileEditorManager;
        this.myUndoManager = undoManager;
        this.myProjectLevelVcsManager = projectLevelVcsManager;
        this.myVcsDirtyScopeManager = vcsDirtyScopeManager;
        this.myFileStatusManager = fileStatusManager;
        this.myActionManager = actionManagerEx;
        this.myTooltipController = tooltipController;
        this.myErrorStripeUpdateManager = stripeUpdateManager;
        boolean replaced = ((UserDataHolderEx)this.myProject).replace(DAEMON_INITIALIZED, null, (Object)Boolean.TRUE);
        if (!replaced) {
            LOG.error("Daemon listeners already initialized for the project " + this.myProject);
        }
        MessageBus messageBus = this.myProject.getMessageBus();
        this.myDaemonEventPublisher = (DaemonCodeAnalyzer.DaemonListener)messageBus.syncPublisher(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC);
        if (project.isDefault()) {
            return;
        }
        MessageBusConnection connection = messageBus.connect((Disposable)this);
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appClosing() {
                DaemonListeners.this.stopDaemon(false, "App closing");
            }
        });
        EditorEventMulticaster eventMulticaster = editorFactory.getEventMulticaster();
        eventMulticaster.addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(@NotNull DocumentEvent e) {
                Document document;
                VirtualFile virtualFile;
                Project project;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                Project project2 = project = (virtualFile = fileDocumentManager.getFile(document = e.getDocument())) == null ? null : ProjectUtil.guessProjectForFile((VirtualFile)virtualFile);
                if (DaemonListeners.this.worthBothering(document, project) && application.isDispatchThread()) {
                    DaemonListeners.this.stopDaemon(true, "Document change");
                    UpdateHighlightersUtil.updateHighlightersByTyping(DaemonListeners.this.myProject, e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/DaemonListeners$2", "beforeDocumentChange"));
            }
        }, (Disposable)this);
        eventMulticaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                Editor editor;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (((editor = e.getEditor()).getComponent().isShowing() || application.isHeadlessEnvironment()) && DaemonListeners.this.worthBothering(editor.getDocument(), editor.getProject()) && !application.isUnitTestMode()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if ((editor.getComponent().isShowing() || application.isHeadlessEnvironment()) && !DaemonListeners.this.myProject.isDisposed()) {
                            IntentionsUI.getInstance(DaemonListeners.this.myProject).invalidate();
                        }
                    }, ModalityState.current());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/DaemonListeners$3", "caretPositionChanged"));
            }
        }, (Disposable)this);
        eventMulticaster.addEditorMouseMotionListener((EditorMouseMotionListener)new MyEditorMouseMotionListener(), (Disposable)this);
        eventMulticaster.addEditorMouseListener((EditorMouseListener)new MyEditorMouseListener(this.myTooltipController), (Disposable)this);
        EditorTrackerListener editorTrackerListener = new EditorTrackerListener(){
            private List<Editor> myActiveEditors = Collections.emptyList();

            @Override
            public void activeEditorsChanged(@NotNull List<Editor> editors) {
                List<Editor> activeEditors;
                if (editors == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (this.myActiveEditors.equals(activeEditors = editorTracker.getActiveEditors())) {
                    return;
                }
                this.myActiveEditors = activeEditors;
                DaemonListeners.this.stopDaemon(true, "Active editor change");
                if (ApplicationManager.getApplication().isDispatchThread() && LaterInvocator.isInModalContext()) {
                    DaemonListeners.this.myDaemonCodeAnalyzer.setUpdateByTimerEnabled(true);
                }
                for (Editor editor : activeEditors) {
                    DaemonListeners.this.myErrorStripeUpdateManager.repaintErrorStripePanel(editor);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/codeInsight/daemon/impl/DaemonListeners$4", "activeEditorsChanged"));
            }
        };
        editorTracker.addEditorTrackerListener(editorTrackerListener, this);
        EditorFactoryListener editorFactoryListener = new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                Editor editor = event.getEditor();
                Document document = editor.getDocument();
                Project editorProject = editor.getProject();
                PsiFile file2 = editorProject == null ? null : PsiDocumentManager.getInstance((Project)editorProject).getPsiFile(document);
                boolean showing = editor.getComponent().isShowing();
                boolean worthBothering = DaemonListeners.this.worthBothering(document, editorProject);
                if (!showing || !worthBothering) {
                    LOG.debug("Not worth bothering about editor created for : " + file2 + " because editor isShowing(): " + showing + "; project is open and file is mine: " + worthBothering);
                    return;
                }
                DaemonListeners.this.myErrorStripeUpdateManager.repaintErrorStripePanel(editor);
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(1);
                }
                UIUtil.invokeLaterIfNeeded(IntentionsUI.getInstance(DaemonListeners.this.myProject)::invalidate);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "editorCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "editorReleased";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        editorFactory.addEditorFactoryListener(editorFactoryListener, (Disposable)this);
        PsiDocumentManagerImpl documentManager = (PsiDocumentManagerImpl)psiDocumentManager;
        PsiChangeHandler changeHandler = new PsiChangeHandler(this.myProject, documentManager, editorFactory, connection, daemonCodeAnalyzer.getFileStatusMap());
        Disposer.register((Disposable)this, (Disposable)changeHandler);
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)changeHandler, (Disposable)changeHandler);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Project roots changed");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/DaemonListeners$6", "rootsChanged"));
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Dumb mode started");
            }

            public void exitDumbMode() {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Dumb mode finished");
            }
        });
        connection.subscribe(PowerSaveMode.TOPIC, () -> this.stopDaemon(true, "Power save mode change"));
        connection.subscribe(EditorColorsManager.TOPIC, scheme2 -> this.stopDaemonAndRestartAllFiles("Editor color scheme changed"));
        connection.subscribe(CommandListener.TOPIC, (Object)new MyCommandListener());
        application.addApplicationListener((ApplicationListener)new MyApplicationListener(), (Disposable)this);
        inspectionProjectProfileManager.addProfileChangeListener(new MyProfileChangeListener(), this);
        todoConfiguration.addPropertyChangeListener(new MyTodoListener(), this);
        todoConfiguration.colorSettingsChanged();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(AnActionListener.TOPIC, (Object)new MyAnActionListener());
        virtualFileManager.addVirtualFileListener(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                String propertyName;
                if (event == null) {
                    8.$$$reportNull$$$0(0);
                }
                if ("name".equals(propertyName = event.getPropertyName())) {
                    Document document;
                    PsiFile psiFile;
                    DaemonListeners.this.stopDaemonAndRestartAllFiles("Virtual file name changed");
                    VirtualFile virtualFile = event.getFile();
                    PsiFile psiFile2 = psiFile = !virtualFile.isValid() ? null : ((PsiManagerEx)psiManager).getFileManager().getCachedPsiFile(virtualFile);
                    if (psiFile != null && !DaemonListeners.this.myDaemonCodeAnalyzer.isHighlightingAvailable(psiFile) && (document = fileDocumentManager.getCachedDocument(virtualFile)) != null) {
                        EditorColorsScheme editorColorScheme = null;
                        UpdateHighlightersUtil.setHighlightersToEditor(DaemonListeners.this.myProject, document, 0, document.getTextLength(), Collections.emptyList(), editorColorScheme, 4);
                    }
                }
                if (!propertyName.equals("writable")) {
                    DaemonListeners.this.stopDaemon(true, "Virtual file property change");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/DaemonListeners$8", "propertyChanged"));
            }
        }, (Disposable)this);
        ((EditorEventMulticasterEx)eventMulticaster).addErrorStripeListener(e -> {
            RangeHighlighter highlighter = e.getHighlighter();
            if (!highlighter.isValid()) {
                return;
            }
            HighlightInfo info = HighlightInfo.fromRangeHighlighter(highlighter);
            if (info != null) {
                GotoNextErrorHandler.navigateToError(this.myProject, e.getEditor(), info);
            }
        }, this);
        ModalityStateListener modalityStateListener = entering -> {
            boolean inModalContext = Registry.is((String)"ide.perProjectModality") || LaterInvocator.isInModalContext();
            this.stopDaemon(inModalContext, "Modality change. Was modal: " + inModalContext);
            this.myDaemonCodeAnalyzer.setUpdateByTimerEnabled(inModalContext);
        };
        LaterInvocator.addModalityStateListener(modalityStateListener, this);
        messageBus.connect().subscribe(SeverityRegistrar.SEVERITIES_CHANGED_TOPIC, () -> this.stopDaemonAndRestartAllFiles("Severities changed"));
        if (RefResolveService.ENABLED) {
            RefResolveService resolveService = RefResolveService.getInstance((Project)project);
            resolveService.addListener((Disposable)this, new RefResolveService.Listener(){

                public void allFilesResolved() {
                    DaemonListeners.this.stopDaemon(true, "RefResolveService is up to date");
                }
            });
        }
        connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetRenamed(@NotNull Facet facet, @NotNull String oldName) {
                if (facet == null) {
                    10.$$$reportNull$$$0(0);
                }
                if (oldName == null) {
                    10.$$$reportNull$$$0(1);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet renamed: " + oldName + " -> " + facet.getName());
            }

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    10.$$$reportNull$$$0(2);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet added: " + facet.getName());
            }

            public void facetRemoved(@NotNull Facet facet) {
                if (facet == null) {
                    10.$$$reportNull$$$0(3);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet removed: " + facet.getName());
            }

            public void facetConfigurationChanged(@NotNull Facet facet) {
                if (facet == null) {
                    10.$$$reportNull$$$0(4);
                }
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet changed: " + facet.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "facet";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "oldName";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$10";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRenamed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetAdded";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetRemoved";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "facetConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileHighlightingSettingListener.SETTING_CHANGE, (root, setting) -> this.updateStatusBar());
    }

    private boolean worthBothering(Document document, Project project) {
        if (document == null) {
            return true;
        }
        if (project != null && project != this.myProject) {
            return false;
        }
        PsiFile psiFile = this.myPsiDocumentManager.getCachedPsiFile(document);
        return psiFile != null && psiFile.isPhysical() && psiFile.getOriginalFile() == psiFile;
    }

    public void dispose() {
        this.stopDaemonAndRestartAllFiles("Project closed");
        boolean replaced = ((UserDataHolderEx)this.myProject).replace(DAEMON_INITIALIZED, (Object)Boolean.TRUE, (Object)Boolean.FALSE);
        LOG.assertTrue(replaced, (Object)("Daemon listeners already disposed for the project " + this.myProject));
    }

    public static boolean canChangeFileSilently(@NotNull PsiFileSystemItem file2) {
        Project project;
        DaemonListeners listeners;
        if (file2 == null) {
            DaemonListeners.$$$reportNull$$$0(22);
        }
        if ((listeners = DaemonListeners.getInstance(project = file2.getProject())) == null) {
            return true;
        }
        if (listeners.cutOperationJustHappened) {
            return false;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (file2 instanceof PsiCodeFragment) {
            return true;
        }
        if (ScratchUtil.isScratch(virtualFile)) {
            return listeners.canUndo(virtualFile);
        }
        if (!ModuleUtilCore.projectContainsFile((Project)project, (VirtualFile)virtualFile, (boolean)false)) {
            return false;
        }
        Result vcs = listeners.vcsThinksItChanged(virtualFile);
        if (vcs == Result.CHANGED) {
            return true;
        }
        if (vcs == Result.UNCHANGED) {
            return false;
        }
        return listeners.canUndo(virtualFile);
    }

    private boolean canUndo(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            DaemonListeners.$$$reportNull$$$0(23);
        }
        for (FileEditor editor : this.myFileEditorManager.getEditors(virtualFile)) {
            if (!this.myUndoManager.isUndoAvailable(editor)) continue;
            return true;
        }
        return false;
    }

    private Result vcsThinksItChanged(VirtualFile virtualFile) {
        boolean vcsIsThinking;
        AbstractVcs activeVcs = this.myProjectLevelVcsManager.getVcsFor(virtualFile);
        if (activeVcs == null) {
            return Result.NOT_SURE;
        }
        FilePath path = VcsUtil.getFilePath((VirtualFile)virtualFile);
        boolean bl = vcsIsThinking = !this.myVcsDirtyScopeManager.whatFilesDirty(Collections.singletonList(path)).isEmpty();
        if (vcsIsThinking) {
            return Result.NOT_SURE;
        }
        FileStatus status = this.myFileStatusManager.getStatus(virtualFile);
        if (status == FileStatus.UNKNOWN) {
            return Result.NOT_SURE;
        }
        return status == FileStatus.MODIFIED || status == FileStatus.ADDED ? Result.CHANGED : Result.UNCHANGED;
    }

    void updateStatusBar() {
        if (this.myTogglePopupHintsPanel != null) {
            this.myTogglePopupHintsPanel.updateStatus();
        }
    }

    private void updateStatusBarLater() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.updateStatusBar();
        });
    }

    private void stopDaemon(boolean toRestartAlarm, @NonNls @NotNull String reason) {
        if (reason == null) {
            DaemonListeners.$$$reportNull$$$0(24);
        }
        if (this.myDaemonCodeAnalyzer.stopProcess(toRestartAlarm, reason)) {
            this.myDaemonEventPublisher.daemonCancelEventOccurred(reason);
        }
    }

    private void stopDaemonAndRestartAllFiles(@NotNull String reason) {
        if (reason == null) {
            DaemonListeners.$$$reportNull$$$0(25);
        }
        if (this.myDaemonCodeAnalyzer.doRestart()) {
            this.myDaemonEventPublisher.daemonCancelEventOccurred(reason);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "daemonCodeAnalyzer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorTracker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDocumentManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionProjectProfileManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "todoConfiguration";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManagerEx";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileManager";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedScopeManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyValidationManager";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileDocumentManager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltipController";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undoManager";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLevelVcsManager";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsDirtyScopeManager";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatusManager";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stripeUpdateManager";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "canChangeFileSilently";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "canUndo";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "stopDaemon";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "stopDaemonAndRestartAllFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyEditorMouseMotionListener
    implements EditorMouseMotionListener {
        private MyEditorMouseMotionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMoved(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseMotionListener.$$$reportNull$$$0(0);
            }
            if (Registry.is((String)"ide.disable.editor.tooltips")) {
                return;
            }
            Editor editor = e.getEditor();
            if (DaemonListeners.this.myProject != editor.getProject()) {
                return;
            }
            if (editor.getComponent().getClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING) != null) {
                return;
            }
            boolean shown = false;
            try {
                VisualPosition visual = editor.xyToVisualPosition(e.getMouseEvent().getPoint());
                if (editor.getSoftWrapModel().isInsideOrBeforeSoftWrap(visual)) {
                    return;
                }
                LogicalPosition logical = editor.visualToLogicalPosition(visual);
                if (e.getArea() == EditorMouseEventArea.EDITING_AREA && !UIUtil.isControlKeyDown((MouseEvent)e.getMouseEvent())) {
                    int offset = editor.logicalPositionToOffset(logical);
                    if (editor.offsetToLogicalPosition((int)offset).column != logical.column) {
                        return;
                    }
                    if (editor.getInlayModel().getElementAt(e.getMouseEvent().getPoint()) != null) {
                        return;
                    }
                    HighlightInfo info = DaemonListeners.this.myDaemonCodeAnalyzer.findHighlightByOffset(editor.getDocument(), offset, false);
                    if (info == null || info.getDescription() == null || info.getHighlighter() != null && FoldingUtil.isHighlighterFolded(editor, info.getHighlighter())) {
                        IdeTooltipManager.getInstance().hideCurrent(e.getMouseEvent());
                        return;
                    }
                    DaemonTooltipUtil.showInfoTooltip(info, editor, offset);
                    shown = true;
                }
            }
            finally {
                if (!shown && !DaemonListeners.this.myTooltipController.shouldSurvive(e.getMouseEvent())) {
                    DaemonTooltipUtil.cancelTooltips();
                }
            }
        }

        public void mouseDragged(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseMotionListener.$$$reportNull$$$0(1);
            }
            DaemonListeners.this.myTooltipController.cancelTooltips();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyEditorMouseMotionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseDragged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyEditorMouseListener
    implements EditorMouseListener {
        @NotNull
        private final TooltipController myTooltipController;

        MyEditorMouseListener(@NotNull TooltipController tooltipController) {
            if (tooltipController == null) {
                MyEditorMouseListener.$$$reportNull$$$0(0);
            }
            this.myTooltipController = tooltipController;
        }

        public void mouseExited(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseListener.$$$reportNull$$$0(1);
            }
            if (!this.myTooltipController.shouldSurvive(e.getMouseEvent())) {
                DaemonTooltipUtil.cancelTooltips();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tooltipController";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyEditorMouseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private final AnAction escapeAction;

        private MyAnActionListener() {
            this.escapeAction = DaemonListeners.this.myActionManager.getAction("EditorEscape");
        }

        public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, AnActionEvent event) {
            if (action == null) {
                MyAnActionListener.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(1);
            }
            DaemonListeners.this.myEscPressed = action == this.escapeAction;
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            Editor editor;
            if (dataContext == null) {
                MyAnActionListener.$$$reportNull$$$0(2);
            }
            if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) != null && !DaemonListeners.this.worthBothering(editor.getDocument(), editor.getProject())) {
                return;
            }
            DaemonListeners.this.stopDaemon(true, "Editor typing");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyAnActionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeActionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeEditorTyping";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyProfileChangeListener
    implements ProfileChangeAdapter {
        private MyProfileChangeListener() {
        }

        public void profileChanged(InspectionProfile profile2) {
            DaemonListeners.this.stopDaemonAndRestartAllFiles("Profile changed");
            DaemonListeners.this.updateStatusBarLater();
        }

        public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile2) {
            DaemonListeners.this.stopDaemonAndRestartAllFiles("Profile activated");
            DaemonListeners.this.updateStatusBarLater();
        }

        public void profilesInitialized() {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (DaemonListeners.this.myProject.isDisposed()) {
                    return;
                }
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(DaemonListeners.this.myProject);
                DaemonListeners.this.myTogglePopupHintsPanel = new TogglePopupHintsPanel(DaemonListeners.this.myProject);
                statusBar.addWidget((StatusBarWidget)DaemonListeners.this.myTogglePopupHintsPanel, (Disposable)DaemonListeners.this.myProject);
                DaemonListeners.this.updateStatusBar();
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Inspection profiles activated");
            });
        }
    }

    private class MyTodoListener
    implements PropertyChangeListener {
        private MyTodoListener() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent evt) {
            if (evt == null) {
                MyTodoListener.$$$reportNull$$$0(0);
            }
            if ("todoPatterns".equals(evt.getPropertyName())) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Todo patterns changed");
            } else if ("multiLine".equals(evt.getPropertyName())) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Todo multi-line detection changed");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyTodoListener", "propertyChange"));
        }
    }

    private class MyCommandListener
    implements CommandListener {
        private final String myCutActionName;

        private MyCommandListener() {
            this.myCutActionName = DaemonListeners.this.myActionManager.getAction("EditorCut").getTemplatePresentation().getText();
        }

        public void commandStarted(@NotNull CommandEvent event) {
            Document affectedDocument;
            if (event == null) {
                MyCommandListener.$$$reportNull$$$0(0);
            }
            if (!DaemonListeners.this.worthBothering(affectedDocument = this.extractDocumentFromCommand(event), event.getProject())) {
                return;
            }
            DaemonListeners.this.cutOperationJustHappened = this.myCutActionName.equals(event.getCommandName());
            if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("cancelling code highlighting by command:" + event.getCommand());
            }
            DaemonListeners.this.stopDaemon(false, "Command start");
        }

        @Nullable
        private Document extractDocumentFromCommand(@NotNull CommandEvent event) {
            Document affectedDocument;
            if (event == null) {
                MyCommandListener.$$$reportNull$$$0(1);
            }
            if ((affectedDocument = event.getDocument()) != null) {
                return affectedDocument;
            }
            Object id = event.getCommandGroupId();
            if (id instanceof Document) {
                affectedDocument = (Document)id;
            } else if (id instanceof DocCommandGroupId) {
                affectedDocument = ((DocCommandGroupId)id).getDocument();
            }
            return affectedDocument;
        }

        public void commandFinished(@NotNull CommandEvent event) {
            Document affectedDocument;
            if (event == null) {
                MyCommandListener.$$$reportNull$$$0(2);
            }
            if (!DaemonListeners.this.worthBothering(affectedDocument = this.extractDocumentFromCommand(event), event.getProject())) {
                return;
            }
            if (DaemonListeners.this.myEscPressed) {
                DaemonListeners.this.myEscPressed = false;
                if (affectedDocument != null && !DaemonListeners.this.myDaemonCodeAnalyzer.getFileStatusMap().allDirtyScopesAreNull(affectedDocument)) {
                    DaemonListeners.this.stopDaemon(true, "Command finish");
                }
            } else if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                DaemonListeners.this.stopDaemon(true, "Command finish");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyCommandListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commandStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "extractDocumentFromCommand";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commandFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyApplicationListener
    extends ApplicationAdapter {
        private boolean myDaemonWasRunning;

        private MyApplicationListener() {
        }

        public void beforeWriteActionStart(@NotNull Object action) {
            if (action == null) {
                MyApplicationListener.$$$reportNull$$$0(0);
            }
            this.myDaemonWasRunning = DaemonListeners.this.myDaemonCodeAnalyzer.isRunning();
            if (!this.myDaemonWasRunning) {
                return;
            }
            DaemonListeners.this.stopDaemon(true, "Write action start");
        }

        public void writeActionFinished(@NotNull Object action) {
            if (action == null) {
                MyApplicationListener.$$$reportNull$$$0(1);
            }
            DaemonListeners.this.stopDaemon(true, "Write action finish");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "action";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonListeners$MyApplicationListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeWriteActionStart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeActionFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum Result {
        CHANGED,
        UNCHANGED,
        NOT_SURE;

    }
}

