/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunLineMarkerContributor {
    public static final Function<PsiElement, String> RUN_TEST_TOOLTIP_PROVIDER = it -> "Run Test";
    static final LanguageExtension<RunLineMarkerContributor> EXTENSION = new LanguageExtension("com.intellij.runLineMarkerContributor");

    @Nullable
    public abstract Info getInfo(@NotNull PsiElement var1);

    @Nullable(value="null means disabled")
    protected static String getText(@NotNull AnAction action, @NotNull PsiElement element) {
        if (action == null) {
            RunLineMarkerContributor.$$$reportNull$$$0(0);
        }
        if (element == null) {
            RunLineMarkerContributor.$$$reportNull$$$0(1);
        }
        DataContext parent = DataManager.getInstance().getDataContext();
        DataContext dataContext = SimpleDataContext.getSimpleContext(CommonDataKeys.PSI_ELEMENT.getName(), element, parent);
        return action instanceof ExecutorAction ? ((ExecutorAction)action).getActionName(dataContext) : null;
    }

    protected static Icon getTestStateIcon(String url, Project project, boolean isClass) {
        TestStateStorage.Record state = TestStateStorage.getInstance(project).getState(url);
        return RunLineMarkerContributor.getTestStateIcon(state, isClass);
    }

    protected static Icon getTestStateIcon(@Nullable TestStateStorage.Record state, boolean isClass) {
        TestStateInfo.Magnitude magnitude;
        if (state != null && (magnitude = TestIconMapper.getMagnitude((int)state.magnitude)) != null) {
            switch (magnitude) {
                case ERROR_INDEX: 
                case FAILED_INDEX: {
                    return AllIcons.RunConfigurations.TestState.Red2;
                }
                case PASSED_INDEX: 
                case COMPLETE_INDEX: {
                    return AllIcons.RunConfigurations.TestState.Green2;
                }
            }
        }
        return isClass ? AllIcons.RunConfigurations.TestState.Run_run : AllIcons.RunConfigurations.TestState.Run;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "action";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/lineMarker/RunLineMarkerContributor";
        objectArray[2] = "getText";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Info {
        public final Icon icon;
        public final AnAction[] actions;
        public final Function<PsiElement, String> tooltipProvider;

        public Info(Icon icon, @NotNull AnAction[] actions, @Nullable Function<PsiElement, String> tooltipProvider) {
            if (actions == null) {
                Info.$$$reportNull$$$0(0);
            }
            this.icon = icon;
            this.actions = actions;
            this.tooltipProvider = tooltipProvider;
        }

        public Info(Icon icon, @Nullable com.intellij.util.Function<PsiElement, String> tooltipProvider, AnAction ... actions) {
            if (actions == null) {
                Info.$$$reportNull$$$0(1);
            }
            this.icon = icon;
            this.actions = actions;
            this.tooltipProvider = tooltipProvider == null ? null : it -> (String)tooltipProvider.fun(it);
        }

        public Info(@NotNull AnAction action) {
            if (action == null) {
                Info.$$$reportNull$$$0(2);
            }
            this(action.getTemplatePresentation().getIcon(), new AnAction[]{action}, (PsiElement element) -> RunLineMarkerContributor.getText(action, element));
        }

        public boolean shouldReplace(@NotNull Info other) {
            if (other == null) {
                Info.$$$reportNull$$$0(3);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/lineMarker/RunLineMarkerContributor$Info";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldReplace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

