/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.UsagesPreviewPanelProvider;
import com.intellij.find.actions.CompositeActiveComponent;
import com.intellij.find.actions.FindUsagesAction;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.actions.PingEDT;
import com.intellij.find.actions.ShowUsagesTable;
import com.intellij.find.actions.UsageListCellRenderer;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.ShowUsagesSettings;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.UsageGroupingRuleProviderImpl;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUsagesAction
extends AnAction
implements PopupAction {
    public static final String ID = "ShowUsages";
    private static final UsageNode MORE_USAGES_SEPARATOR_NODE = UsageViewImpl.NULL_NODE;
    private static final UsageNode USAGES_OUTSIDE_SCOPE_NODE = new UsageNode(null, ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR);
    private static final Comparator<UsageNode> USAGE_NODE_COMPARATOR = (c1, c2) -> {
        VirtualFile v2;
        String name2;
        int weight2;
        int weight1;
        if (c1 instanceof StringNode || c2 instanceof StringNode) {
            if (c1 instanceof StringNode && c2 instanceof StringNode) {
                return Comparing.compare((Comparable)((Object)c1.toString()), (Comparable)((Object)c2.toString()));
            }
            return c1 instanceof StringNode ? 1 : -1;
        }
        Usage o1 = c1.getUsage();
        Usage o2 = c2.getUsage();
        int n = o1 == ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight1 = o1 == ShowUsagesTable.MORE_USAGES_SEPARATOR ? 1 : 0);
        int n2 = o2 == ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight2 = o2 == ShowUsagesTable.MORE_USAGES_SEPARATOR ? 1 : 0);
        if (weight1 != weight2) {
            return weight1 - weight2;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        VirtualFile v1 = UsageListCellRenderer.getVirtualFile(o1);
        String name1 = v1 == null ? null : v1.getName();
        int i = Comparing.compare((Comparable)((Object)name1), (Comparable)((Object)(name2 = (v2 = UsageListCellRenderer.getVirtualFile(o2)) == null ? null : v2.getName())));
        if (i != 0) {
            return i;
        }
        if (Comparing.equal((Object)v1, (Object)v2)) {
            FileEditorLocation loc1 = o1.getLocation();
            FileEditorLocation loc2 = o2.getLocation();
            return Comparing.compare((Comparable)loc1, (Comparable)loc2);
        }
        String path1 = v1 == null ? null : v1.getPath();
        String path2 = v2 == null ? null : v2.getPath();
        return Comparing.compare((Comparable)((Object)path1), (Comparable)((Object)path2));
    };
    private final boolean myShowSettingsDialogBefore;
    private Runnable mySearchEverywhereRunnable;
    private int myWidth;

    public static int getUsagesPageSize() {
        return Math.max(1, Registry.intValue((String)"ide.usages.page.size", (int)100));
    }

    public ShowUsagesAction() {
        this(false);
    }

    private ShowUsagesAction(boolean showDialogBefore) {
        this.setInjectedContext(true);
        this.myShowSettingsDialogBefore = showDialogBefore;
    }

    public boolean startInTransaction() {
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        Object[] usageTargets;
        if (e == null) {
            ShowUsagesAction.$$$reportNull$$$0(0);
        }
        FindUsagesInFileAction.updateFindUsagesAction(e);
        if (e.getPresentation().isEnabled() && (usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY)) != null && !(ArrayUtil.getFirstElement((Object[])usageTargets) instanceof PsiElementUsageTarget)) {
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement element2;
        Project project;
        if (e == null) {
            ShowUsagesAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Runnable searchEverywhere = this.mySearchEverywhereRunnable;
        this.mySearchEverywhereRunnable = null;
        ShowUsagesAction.hideHints();
        if (searchEverywhere != null) {
            searchEverywhere.run();
            return;
        }
        RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.usages");
        Object[] usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (usageTargets == null) {
            FindUsagesAction.chooseAmbiguousTargetAndPerform(project, editor, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)element -> {
                this.startFindUsages(element, popupPosition, editor, ShowUsagesAction.getUsagesPageSize());
                return false;
            }));
        } else if (ArrayUtil.getFirstElement((Object[])usageTargets) instanceof PsiElementUsageTarget && (element2 = ((PsiElementUsageTarget)usageTargets[0]).getElement()) != null) {
            this.startFindUsages(element2, popupPosition, editor, ShowUsagesAction.getUsagesPageSize());
        }
    }

    private static void hideHints() {
        HintManager.getInstance().hideHints(2, false, false);
    }

    public void startFindUsages(@NotNull PsiElement element, @NotNull RelativePoint popupPosition, Editor editor, int maxUsages) {
        Project project;
        FindUsagesManager findUsagesManager;
        FindUsagesHandler handler2;
        if (element == null) {
            ShowUsagesAction.$$$reportNull$$$0(2);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(3);
        }
        if ((handler2 = (findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)(project = element.getProject()))).getFindUsagesManager()).getFindUsagesHandler(element, false)) == null) {
            return;
        }
        if (this.myShowSettingsDialogBefore) {
            this.showDialogAndFindUsages(handler2, popupPosition, editor, maxUsages);
            return;
        }
        this.showElementUsages(editor, popupPosition, handler2, maxUsages, handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext()));
    }

    void showElementUsages(Editor editor, @NotNull RelativePoint popupPosition, @NotNull FindUsagesHandler handler2, int maxUsages, @NotNull FindUsagesOptions options) {
        JBPopup popup2;
        PsiReference reference2;
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(4);
        }
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(5);
        }
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        UsageViewSettings usageViewSettings = UsageViewSettings.getInstance();
        ShowUsagesSettings showUsagesSettings = ShowUsagesSettings.getInstance();
        UsageViewSettings savedGlobalSettings = new UsageViewSettings();
        savedGlobalSettings.loadState(usageViewSettings);
        usageViewSettings.loadState((UsageViewSettings)showUsagesSettings.getState());
        Project project = handler2.getProject();
        UsageViewManager manager = UsageViewManager.getInstance((Project)project);
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
        UsageViewPresentation presentation = findUsagesManager.createPresentation(handler2, options);
        presentation.setDetachedMode(true);
        UsageViewImpl usageView = (UsageViewImpl)manager.createUsageView(UsageTarget.EMPTY_ARRAY, Usage.EMPTY_ARRAY, presentation, null);
        if (editor != null && (reference2 = TargetElementUtil.findReference(editor)) != null) {
            UsageInfo2UsageAdapter origin = new UsageInfo2UsageAdapter(new UsageInfo(reference2));
            usageView.setOriginUsage((Usage)origin);
        }
        Disposer.register((Disposable)usageView, () -> {
            showUsagesSettings.applyUsageViewSettings(usageViewSettings);
            usageViewSettings.loadState(savedGlobalSettings);
        });
        ShowUsagesTable table = new ShowUsagesTable();
        AsyncProcessIcon processIcon = new AsyncProcessIcon("xxx");
        ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, new ArrayList());
        ArrayList<Usage> usages = new ArrayList<Usage>();
        LinkedHashSet<UsageNode> visibleNodes = new LinkedHashSet<UsageNode>();
        List<UsageNode> data = ShowUsagesAction.collectData(usages, visibleNodes, usageView, presentation);
        AtomicInteger outOfScopeUsages = new AtomicInteger();
        table.setTableModel(usageView, data, outOfScopeUsages, options.searchScope);
        boolean isPreviewMode = Boolean.TRUE == PreviewManager.SERVICE.preview(handler2.getProject(), UsagesPreviewPanelProvider.ID, Pair.create((Object)usageView, (Object)((Object)table)), false);
        Runnable itemChosenCallback = table.prepareTable(editor, popupPosition, handler2, maxUsages, options, isPreviewMode, this);
        JBPopup jBPopup = popup2 = isPreviewMode ? null : this.createUsagePopup(usages, visibleNodes, handler2, editor, popupPosition, maxUsages, usageView, options, (JTable)((Object)table), itemChosenCallback, presentation, processIcon);
        if (popup2 != null) {
            Disposer.register(popup2, (Disposable)usageView);
            Alarm alarm = new Alarm((Disposable)usageView);
            alarm.addRequest(() -> ShowUsagesAction.showPopupIfNeedTo(popup2, popupPosition), 300);
        }
        PingEDT pingEDT = new PingEDT("Rebuild popup in EDT", o -> popup2 != null && popup2.isDisposed(), 100, () -> {
            ArrayList<Usage> copy;
            if (popup2 != null && popup2.isDisposed()) {
                return;
            }
            ArrayList<UsageNode> nodes = new ArrayList<UsageNode>(usages.size());
            List list2 = usages;
            synchronized (list2) {
                if (!(popup2 == null || popup2.isVisible() || !usages.isEmpty() && ShowUsagesAction.showPopupIfNeedTo(popup2, popupPosition))) {
                    return;
                }
                ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, nodes);
                copy = new ArrayList<Usage>(usages);
            }
            this.rebuildTable(usageView, copy, nodes, table, popup2, presentation, popupPosition, !processIcon.isDisposed(), outOfScopeUsages, options.searchScope);
        });
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)usageView);
        messageBusConnection.subscribe(UsageFilteringRuleProvider.RULES_CHANGED, pingEDT::ping);
        UsageTarget[] myUsageTarget = new UsageTarget[]{new PsiElement2UsageTargetAdapter(handler2.getPsiElement())};
        Processor collect = usage -> {
            if (!UsageViewManagerImpl.isInScope((Usage)usage, (SearchScope)options.searchScope)) {
                if (outOfScopeUsages.getAndIncrement() == 0) {
                    visibleNodes.add(USAGES_OUTSIDE_SCOPE_NODE);
                    usages.add(ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR);
                }
                return true;
            }
            List list2 = usages;
            synchronized (list2) {
                if (visibleNodes.size() >= maxUsages) {
                    return false;
                }
                if (UsageViewManager.isSelfUsage((Usage)usage, (UsageTarget[])myUsageTarget)) {
                    return true;
                }
                UsageNode node = (UsageNode)ReadAction.compute(() -> usageView.doAppendUsage(usage));
                usages.add((Usage)usage);
                if (node != null) {
                    visibleNodes.add(node);
                    boolean continueSearch = true;
                    if (visibleNodes.size() == maxUsages) {
                        visibleNodes.add(MORE_USAGES_SEPARATOR_NODE);
                        usages.add(ShowUsagesTable.MORE_USAGES_SEPARATOR);
                        continueSearch = false;
                    }
                    pingEDT.ping();
                    return continueSearch;
                }
            }
            return true;
        };
        ProgressIndicator indicator = FindUsagesManager.startProcessUsages(handler2, handler2.getPrimaryElements(), handler2.getSecondaryElements(), (Processor<Usage>)collect, options, () -> ApplicationManager.getApplication().invokeLater(() -> {
            Disposer.dispose((Disposable)processIcon);
            Container parent = processIcon.getParent();
            if (parent != null) {
                parent.remove((Component)processIcon);
                parent.repaint();
            }
            pingEDT.ping();
            List list2 = usages;
            synchronized (list2) {
                if (visibleNodes.isEmpty()) {
                    if (usages.isEmpty()) {
                        String text = UsageViewBundle.message((String)"no.usages.found.in", (Object[])new Object[]{ShowUsagesAction.searchScopePresentableName(options)});
                        this.hint(editor, text, handler2, popupPosition, maxUsages, options, false);
                        ShowUsagesAction.cancel(popup2);
                    }
                } else if (visibleNodes.size() == 1) {
                    if (usages.size() == 1) {
                        Usage usage = ((UsageNode)visibleNodes.iterator().next()).getUsage();
                        if (usage == ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                            this.hint(editor, UsageViewManagerImpl.outOfScopeMessage((int)outOfScopeUsages.get(), (SearchScope)options.searchScope), handler2, popupPosition, maxUsages, options, true);
                        } else {
                            String message = UsageViewBundle.message((String)"show.usages.only.usage", (Object[])new Object[]{ShowUsagesAction.searchScopePresentableName(options)});
                            this.navigateAndHint(usage, message, handler2, popupPosition, maxUsages, options);
                        }
                        ShowUsagesAction.cancel(popup2);
                    } else {
                        assert (usages.size() > 1) : usages;
                        Usage visibleUsage = ((UsageNode)visibleNodes.iterator().next()).getUsage();
                        if (ShowUsagesAction.areAllUsagesInOneLine(visibleUsage, usages)) {
                            String hint = UsageViewBundle.message((String)"all.usages.are.in.this.line", (Object[])new Object[]{usages.size(), ShowUsagesAction.searchScopePresentableName(options)});
                            this.navigateAndHint(visibleUsage, hint, handler2, popupPosition, maxUsages, options);
                            ShowUsagesAction.cancel(popup2);
                        }
                    }
                } else if (popup2 != null) {
                    String title = presentation.getTabText();
                    boolean shouldShowMoreSeparator = visibleNodes.contains(MORE_USAGES_SEPARATOR_NODE);
                    String fullTitle = ShowUsagesAction.getFullTitle(usages, title, shouldShowMoreSeparator, visibleNodes.size() - (shouldShowMoreSeparator ? 1 : 0), false);
                    popup2.setCaption(fullTitle);
                }
            }
        }, project.getDisposed()));
        if (popup2 != null) {
            Disposer.register((Disposable)popup2, () -> ((ProgressIndicator)indicator).cancel());
        }
    }

    @NotNull
    static UsageNode createStringNode(@NotNull Object string) {
        if (string == null) {
            ShowUsagesAction.$$$reportNull$$$0(7);
        }
        StringNode stringNode = new StringNode(string);
        if (stringNode == null) {
            ShowUsagesAction.$$$reportNull$$$0(8);
        }
        return stringNode;
    }

    private static boolean showPopupIfNeedTo(@NotNull JBPopup popup2, @NotNull RelativePoint popupPosition) {
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(9);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(10);
        }
        if (!popup2.isDisposed() && !popup2.isVisible()) {
            popup2.show(popupPosition);
            return true;
        }
        return false;
    }

    @NotNull
    private JComponent createHintComponent(@NotNull String text, final @NotNull FindUsagesHandler handler2, final @NotNull RelativePoint popupPosition, final Editor editor, @NotNull Runnable cancelAction, final int maxUsages, final @NotNull FindUsagesOptions options, boolean isWarning) {
        if (text == null) {
            ShowUsagesAction.$$$reportNull$$$0(11);
        }
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(12);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(13);
        }
        if (cancelAction == null) {
            ShowUsagesAction.$$$reportNull$$$0(14);
        }
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(15);
        }
        JComponent label2 = HintUtil.createInformationLabel(ShowUsagesAction.suggestSecondInvocation(options, handler2, text + "&nbsp;"));
        if (isWarning) {
            label2.setBackground(MessageType.WARNING.getPopupBackground());
        }
        InplaceButton button = this.createSettingsButton(handler2, popupPosition, editor, maxUsages, cancelAction);
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            public void addNotify() {
                ShowUsagesAction.this.mySearchEverywhereRunnable = () -> ShowUsagesAction.this.searchEverywhere(options, handler2, editor, popupPosition, maxUsages);
                super.addNotify();
            }

            @Override
            public void removeNotify() {
                ShowUsagesAction.this.mySearchEverywhereRunnable = null;
                super.removeNotify();
            }
        };
        button.setBackground(label2.getBackground());
        panel2.setBackground(label2.getBackground());
        label2.setOpaque(false);
        label2.setBorder(null);
        panel2.setBorder(HintUtil.createHintBorder());
        panel2.add((Component)label2, "Center");
        panel2.add((Component)button, "East");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ShowUsagesAction.$$$reportNull$$$0(16);
        }
        return jPanel;
    }

    @NotNull
    private InplaceButton createSettingsButton(@NotNull FindUsagesHandler handler2, @NotNull RelativePoint popupPosition, Editor editor, int maxUsages, @NotNull Runnable cancelAction) {
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(17);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(18);
        }
        if (cancelAction == null) {
            ShowUsagesAction.$$$reportNull$$$0(19);
        }
        String shortcutText = "";
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            shortcutText = "(" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")";
        }
        InplaceButton inplaceButton = new InplaceButton("Settings..." + shortcutText, AllIcons.General.Settings, e -> {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)handler2.getProject(), () -> this.showDialogAndFindUsages(handler2, popupPosition, editor, maxUsages));
            cancelAction.run();
        });
        if (inplaceButton == null) {
            ShowUsagesAction.$$$reportNull$$$0(20);
        }
        return inplaceButton;
    }

    private void showDialogAndFindUsages(@NotNull FindUsagesHandler handler2, @NotNull RelativePoint popupPosition, Editor editor, int maxUsages) {
        AbstractFindUsagesDialog dialog2;
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(21);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(22);
        }
        if ((dialog2 = handler2.getFindUsagesDialog(false, false, false)).showAndGet()) {
            dialog2.calcFindUsagesOptions();
            FindUsagesOptions options = handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext());
            this.showElementUsages(editor, popupPosition, handler2, maxUsages, options);
        }
    }

    @NotNull
    private static String searchScopePresentableName(@NotNull FindUsagesOptions options) {
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(23);
        }
        String string = options.searchScope.getDisplayName();
        if (string == null) {
            ShowUsagesAction.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private JBPopup createUsagePopup(@NotNull List<Usage> usages, @NotNull Set<UsageNode> visibleNodes, final @NotNull FindUsagesHandler handler2, final Editor editor, final @NotNull RelativePoint popupPosition, final int maxUsages, @NotNull UsageViewImpl usageView, final @NotNull FindUsagesOptions options, @NotNull JTable table, @NotNull Runnable itemChoseCallback, @NotNull UsageViewPresentation presentation, final @NotNull AsyncProcessIcon processIcon) {
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(25);
        }
        if (visibleNodes == null) {
            ShowUsagesAction.$$$reportNull$$$0(26);
        }
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(27);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(28);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(29);
        }
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(30);
        }
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(31);
        }
        if (itemChoseCallback == null) {
            ShowUsagesAction.$$$reportNull$$$0(32);
        }
        if (presentation == null) {
            ShowUsagesAction.$$$reportNull$$$0(33);
        }
        if (processIcon == null) {
            ShowUsagesAction.$$$reportNull$$$0(34);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(table);
        String title = presentation.getTabText();
        if (title != null) {
            String result2 = ShowUsagesAction.getFullTitle(usages, title, false, visibleNodes.size() - 1, true);
            builder2.setTitle(result2);
            builder2.setAdText(ShowUsagesAction.getSecondInvocationTitle(options, handler2));
        }
        builder2.setMovable(true).setResizable(true);
        builder2.setMovable(true).setResizable(true);
        builder2.setItemChoosenCallback(itemChoseCallback);
        final JBPopup[] popup2 = new JBPopup[1];
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ShowUsagesAction.cancel(popup2[0]);
                    ShowUsagesAction.this.showDialogAndFindUsages(handler2, popupPosition, editor, maxUsages);
                }

                public boolean startInTransaction() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$2", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        if ((shortcut = ShowUsagesAction.getShowUsagesShortcut()) != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ShowUsagesAction.cancel(popup2[0]);
                    ShowUsagesAction.this.searchEverywhere(options, handler2, editor, popupPosition, maxUsages);
                }

                public boolean startInTransaction() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$3", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        InplaceButton settingsButton2 = this.createSettingsButton(handler2, popupPosition, editor, maxUsages, () -> ShowUsagesAction.cancel(popup2[0]));
        ActiveComponent.Adapter spinningProgress = new ActiveComponent.Adapter(){

            public JComponent getComponent() {
                return processIcon;
            }
        };
        DefaultActionGroup pinGroup = new DefaultActionGroup();
        ActiveComponent pin = this.createPinButton(handler2, usageView, options, popup2, pinGroup);
        builder2.setCommandButton((ActiveComponent)new CompositeActiveComponent(new ActiveComponent[]{spinningProgress, settingsButton2, pin}));
        DefaultActionGroup toolbar = new DefaultActionGroup();
        usageView.addFilteringActions(toolbar);
        toolbar.add((AnAction)UsageGroupingRuleProviderImpl.createGroupByFileStructureAction((UsageViewImpl)usageView));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", (ActionGroup)toolbar, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        JComponent toolBar = actionToolbar.getComponent();
        toolBar.setOpaque(false);
        builder2.setSettingButton((Component)toolBar);
        builder2.setCancelKeyEnabled(false);
        PopupUpdateProcessor processor2 = new PopupUpdateProcessor(usageView.getProject()){

            public void updatePopup(Object lookupItemObject) {
            }
        };
        builder2.addListener((JBPopupListener)processor2);
        popup2[0] = builder2.createPopup();
        JComponent content = popup2[0].getContent();
        this.myWidth = (int)(toolBar.getPreferredSize().getWidth() + new JLabel(ShowUsagesAction.getFullTitle(usages, title, false, visibleNodes.size() - 1, true)).getPreferredSize().getWidth() + settingsButton2.getPreferredSize().getWidth());
        this.myWidth = -1;
        for (AnAction action : toolbar.getChildren(null)) {
            action.unregisterCustomShortcutSet(usageView.getComponent());
            action.registerCustomShortcutSet(action.getShortcutSet(), content);
        }
        for (AnAction action : pinGroup.getChildren(null)) {
            action.unregisterCustomShortcutSet(usageView.getComponent());
            action.registerCustomShortcutSet(action.getShortcutSet(), content);
        }
        JBPopup jBPopup = popup2[0];
        if (jBPopup == null) {
            ShowUsagesAction.$$$reportNull$$$0(35);
        }
        return jBPopup;
    }

    private ActiveComponent createPinButton(final @NotNull FindUsagesHandler handler2, final @NotNull UsageViewImpl usageView, final @NotNull FindUsagesOptions options, final @NotNull JBPopup[] popup2, @NotNull DefaultActionGroup pinGroup) {
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(36);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(37);
        }
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(38);
        }
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(39);
        }
        if (pinGroup == null) {
            ShowUsagesAction.$$$reportNull$$$0(40);
        }
        AnAction pinAction = new AnAction("Open Find Usages Toolwindow", "Show all usages in a separate toolwindow", AllIcons.General.Pin_tab){
            {
                super(arg0, arg1, arg2);
                AnAction action = ActionManager.getInstance().getAction("FindUsages");
                this.setShortcutSet(action.getShortcutSet());
            }

            public boolean startInTransaction() {
                return true;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                ShowUsagesAction.hideHints();
                ShowUsagesAction.cancel(popup2[0]);
                FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)usageView.getProject())).getFindUsagesManager();
                findUsagesManager.findUsages(handler2.getPrimaryElements(), handler2.getSecondaryElements(), handler2, options, FindSettings.getInstance().isSkipResultsWithOneUsage());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$6", "actionPerformed"));
            }
        };
        pinGroup.add(pinAction);
        ActionToolbar pinToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", (ActionGroup)pinGroup, true);
        pinToolbar.setReservePlaceAutoPopupIcon(false);
        final JComponent pinToolBar = pinToolbar.getComponent();
        pinToolBar.setBorder(null);
        pinToolBar.setOpaque(false);
        return new ActiveComponent.Adapter(){

            public JComponent getComponent() {
                return pinToolBar;
            }
        };
    }

    private static void cancel(@Nullable JBPopup popup2) {
        if (popup2 != null) {
            popup2.cancel();
        }
    }

    @NotNull
    private static String getFullTitle(@NotNull List<Usage> usages, @NotNull String title, boolean hadMoreSeparator, int visibleNodesCount, boolean findUsagesInProgress) {
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(41);
        }
        if (title == null) {
            ShowUsagesAction.$$$reportNull$$$0(42);
        }
        String soFarSuffix = findUsagesInProgress ? " so far" : "";
        String s = hadMoreSeparator ? "<b>Some</b> " + title + " <b>(Only " + visibleNodesCount + " usages shown" + soFarSuffix + ")</b>" : title + " (" + UsageViewBundle.message((String)"usages.n", (Object[])new Object[]{usages.size()}) + soFarSuffix + ")";
        String string = "<html><nobr>" + s + "</nobr></html>";
        if (string == null) {
            ShowUsagesAction.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    private static String suggestSecondInvocation(@NotNull FindUsagesOptions options, @NotNull FindUsagesHandler handler2, @NotNull String text) {
        String title;
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(44);
        }
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(45);
        }
        if (text == null) {
            ShowUsagesAction.$$$reportNull$$$0(46);
        }
        if ((title = ShowUsagesAction.getSecondInvocationTitle(options, handler2)) != null) {
            text = text + "<br><small> " + title + "</small>";
        }
        String string = XmlStringUtil.wrapInHtml((CharSequence)UIUtil.convertSpace2Nbsp((String)text));
        if (string == null) {
            ShowUsagesAction.$$$reportNull$$$0(47);
        }
        return string;
    }

    @Nullable
    private static String getSecondInvocationTitle(@NotNull FindUsagesOptions options, @NotNull FindUsagesHandler handler2) {
        GlobalSearchScope maximalScope;
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(48);
        }
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(49);
        }
        if (ShowUsagesAction.getShowUsagesShortcut() != null && !options.searchScope.equals(maximalScope = FindUsagesManager.getMaximalScope(handler2))) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)ShowUsagesAction.getShowUsagesShortcut()) + " again to search in " + maximalScope.getDisplayName();
        }
        return null;
    }

    private void searchEverywhere(@NotNull FindUsagesOptions options, @NotNull FindUsagesHandler handler2, Editor editor, @NotNull RelativePoint popupPosition, int maxUsages) {
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(50);
        }
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(51);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(52);
        }
        FindUsagesOptions cloned = options.clone();
        cloned.searchScope = FindUsagesManager.getMaximalScope(handler2);
        this.showElementUsages(editor, popupPosition, handler2, maxUsages, cloned);
    }

    @Nullable
    private static KeyboardShortcut getShowUsagesShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut(ID);
    }

    private static int filtered(@NotNull List<? extends Usage> usages, @NotNull UsageViewImpl usageView) {
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(53);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(54);
        }
        return (int)usages.stream().filter(usage -> !usageView.isVisible(usage)).count();
    }

    private static int getUsageOffset(@NotNull Usage usage) {
        if (usage == null) {
            ShowUsagesAction.$$$reportNull$$$0(55);
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return -1;
        }
        PsiElement element = ((UsageInfo2UsageAdapter)usage).getElement();
        if (element == null) {
            return -1;
        }
        return element.getTextRange().getStartOffset();
    }

    private static boolean areAllUsagesInOneLine(@NotNull Usage visibleUsage, @NotNull List<? extends Usage> usages) {
        Editor editor;
        if (visibleUsage == null) {
            ShowUsagesAction.$$$reportNull$$$0(56);
        }
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(57);
        }
        if ((editor = ShowUsagesAction.getEditorFor(visibleUsage)) == null) {
            return false;
        }
        int offset = ShowUsagesAction.getUsageOffset(visibleUsage);
        if (offset == -1) {
            return false;
        }
        int lineNumber = editor.getDocument().getLineNumber(offset);
        for (Usage usage : usages) {
            Editor otherEditor = ShowUsagesAction.getEditorFor(usage);
            if (otherEditor != editor) {
                return false;
            }
            int otherOffset = ShowUsagesAction.getUsageOffset(usage);
            if (otherOffset == -1) {
                return false;
            }
            int otherLine = otherEditor.getDocument().getLineNumber(otherOffset);
            if (otherLine == lineNumber) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<UsageNode> collectData(@NotNull List<? extends Usage> usages, @NotNull Collection<? extends UsageNode> visibleNodes, @NotNull UsageViewImpl usageView, @NotNull UsageViewPresentation presentation) {
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(58);
        }
        if (visibleNodes == null) {
            ShowUsagesAction.$$$reportNull$$$0(59);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(60);
        }
        if (presentation == null) {
            ShowUsagesAction.$$$reportNull$$$0(61);
        }
        ArrayList<UsageNode> data = new ArrayList<UsageNode>();
        int filtered = ShowUsagesAction.filtered(usages, usageView);
        if (filtered != 0) {
            data.add(ShowUsagesAction.createStringNode(UsageViewBundle.message((String)"usages.were.filtered.out", (Object[])new Object[]{filtered})));
        }
        data.addAll(visibleNodes);
        if (data.isEmpty()) {
            String progressText = StringUtil.escapeXml((String)UsageViewManagerImpl.getProgressTitle((UsageViewPresentation)presentation));
            data.add(ShowUsagesAction.createStringNode(progressText));
        }
        Collections.sort(data, USAGE_NODE_COMPARATOR);
        ArrayList<UsageNode> arrayList = data;
        if (arrayList == null) {
            ShowUsagesAction.$$$reportNull$$$0(62);
        }
        return arrayList;
    }

    private static int calcMaxWidth(JTable table) {
        int colsNum = table.getColumnModel().getColumnCount();
        int totalWidth = 0;
        for (int col = 0; col < colsNum - 1; ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            int preferred = column.getPreferredWidth();
            int width = Math.max(preferred, ShowUsagesAction.columnMaxWidth(table, col));
            totalWidth += width;
            column.setMinWidth(width);
            column.setMaxWidth(width);
            column.setWidth(width);
            column.setPreferredWidth(width);
        }
        return totalWidth += ShowUsagesAction.columnMaxWidth(table, colsNum - 1);
    }

    private static int columnMaxWidth(@NotNull JTable table, int col) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(63);
        }
        TableColumn column = table.getColumnModel().getColumn(col);
        int width = 0;
        for (int row2 = 0; row2 < table.getRowCount(); ++row2) {
            Component component = table.prepareRenderer(column.getCellRenderer(), row2, col);
            int rendererWidth = component.getPreferredSize().width;
            width = Math.max(width, rendererWidth + table.getIntercellSpacing().width);
        }
        return width;
    }

    private void rebuildTable(@NotNull UsageViewImpl usageView, @NotNull List<Usage> usages, @NotNull List<UsageNode> nodes, @NotNull ShowUsagesTable table, @Nullable JBPopup popup2, @NotNull UsageViewPresentation presentation, @NotNull RelativePoint popupPosition, boolean findUsagesInProgress, @NotNull AtomicInteger outOfScopeUsages, @NotNull SearchScope searchScope) {
        int row2;
        List existingData;
        List<UsageNode> data;
        ShowUsagesTable.MyModel tableModel;
        int newSelection;
        boolean hasOutsideScopeUsages;
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(64);
        }
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(65);
        }
        if (nodes == null) {
            ShowUsagesAction.$$$reportNull$$$0(66);
        }
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(67);
        }
        if (presentation == null) {
            ShowUsagesAction.$$$reportNull$$$0(68);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(69);
        }
        if (outOfScopeUsages == null) {
            ShowUsagesAction.$$$reportNull$$$0(70);
        }
        if (searchScope == null) {
            ShowUsagesAction.$$$reportNull$$$0(71);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean shouldShowMoreSeparator = usages.contains(ShowUsagesTable.MORE_USAGES_SEPARATOR);
        if (shouldShowMoreSeparator) {
            nodes.add(MORE_USAGES_SEPARATOR_NODE);
        }
        if ((hasOutsideScopeUsages = usages.contains(ShowUsagesTable.USAGES_OUTSIDE_SCOPE_SEPARATOR)) && !shouldShowMoreSeparator) {
            nodes.add(USAGES_OUTSIDE_SCOPE_NODE);
        }
        String title = presentation.getTabText();
        String fullTitle = ShowUsagesAction.getFullTitle(usages, title, shouldShowMoreSeparator || hasOutsideScopeUsages, nodes.size() - (shouldShowMoreSeparator || hasOutsideScopeUsages ? 1 : 0), findUsagesInProgress);
        if (popup2 != null) {
            popup2.setCaption(fullTitle);
        }
        if ((newSelection = ShowUsagesAction.updateModel(tableModel = table.setTableModel(usageView, data = ShowUsagesAction.collectData(usages, nodes, usageView, presentation), outOfScopeUsages, searchScope), existingData = tableModel.getItems(), data, (row2 = table.getSelectedRow()) == -1 ? 0 : row2)) < 0 || newSelection >= tableModel.getRowCount()) {
            ScrollingUtil.ensureSelectionExists((JTable)((Object)table));
            newSelection = table.getSelectedRow();
        } else {
            Object valueInTopRow;
            if (newSelection == 0 && table.getModel().getRowCount() > 1 && (valueInTopRow = table.getModel().getValueAt(0, 0)) instanceof UsageNode && usageView.isOriginUsage(((UsageNode)valueInTopRow).getUsage())) {
                ++newSelection;
            }
            table.getSelectionModel().setSelectionInterval(newSelection, newSelection);
        }
        ScrollingUtil.ensureIndexIsVisible((JTable)((Object)table), (int)newSelection, (int)0);
        if (popup2 != null) {
            this.setSizeAndDimensions((JTable)((Object)table), popup2, popupPosition, data);
        }
    }

    private static int updateModel(@NotNull ShowUsagesTable.MyModel tableModel, @NotNull List<UsageNode> listOld, @NotNull List<UsageNode> listNew, int oldSelection) {
        if (tableModel == null) {
            ShowUsagesAction.$$$reportNull$$$0(72);
        }
        if (listOld == null) {
            ShowUsagesAction.$$$reportNull$$$0(73);
        }
        if (listNew == null) {
            ShowUsagesAction.$$$reportNull$$$0(74);
        }
        Object[] oa = listOld.toArray(new UsageNode[0]);
        Object[] na = listNew.toArray(new UsageNode[0]);
        List<ModelDiff.Cmd> cmds = ModelDiff.createDiffCmds(tableModel, oa, na);
        int selection = oldSelection;
        if (cmds != null) {
            for (ModelDiff.Cmd cmd : cmds) {
                selection = cmd.translateSelection(selection);
                cmd.apply();
            }
        }
        return selection;
    }

    private void setSizeAndDimensions(@NotNull JTable table, @NotNull JBPopup popup2, @NotNull RelativePoint popupPosition, @NotNull List<UsageNode> data) {
        int newWidth;
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(75);
        }
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(76);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(77);
        }
        if (data == null) {
            ShowUsagesAction.$$$reportNull$$$0(78);
        }
        JComponent content = popup2.getContent();
        Window window = SwingUtilities.windowForComponent(content);
        Dimension d = window.getSize();
        int width = ShowUsagesAction.calcMaxWidth(table);
        width = (int)Math.max(d.getWidth(), (double)width);
        Dimension headerSize = ((AbstractPopup)popup2).getHeaderPreferredSize();
        width = Math.max((int)headerSize.getWidth(), width);
        width = Math.max(this.myWidth, width);
        if (this.myWidth == -1) {
            this.myWidth = width;
        }
        this.myWidth = newWidth = Math.max(width, d.width + width - this.myWidth);
        Dimension footerSize = ((AbstractPopup)popup2).getFooterPreferredSize();
        int footer = footerSize.height;
        int footerBorder = footer == 0 ? 0 : 1;
        Insets insets = ((AbstractPopup)popup2).getPopupBorder().getBorderInsets((Component)content);
        int minHeight = headerSize.height + footer + footerBorder + insets.top + insets.bottom;
        Rectangle rectangle = ShowUsagesAction.getPreferredBounds(table, popupPosition.getScreenPoint(), newWidth, minHeight, data.size());
        table.setSize(rectangle.width, rectangle.height - minHeight);
        if (!data.isEmpty()) {
            ScrollingUtil.ensureSelectionExists((JTable)table);
        }
        Dimension newDim = rectangle.getSize();
        window.setBounds(rectangle);
        window.setMinimumSize(newDim);
        window.setMaximumSize(newDim);
        window.validate();
        window.repaint();
    }

    private static Rectangle getPreferredBounds(@NotNull JTable table, @NotNull Point point, int width, int minHeight, int modelRows) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(79);
        }
        if (point == null) {
            ShowUsagesAction.$$$reportNull$$$0(80);
        }
        boolean addExtraSpace = Registry.is((String)"ide.preferred.scrollable.viewport.extra.space");
        int visibleRows = Math.min(30, modelRows);
        int rowHeight = table.getRowHeight();
        int space = addExtraSpace && visibleRows < modelRows ? rowHeight / 2 : 0;
        int height = visibleRows * rowHeight + minHeight + space;
        Rectangle bounds2 = new Rectangle(point.x, point.y, width, height);
        ScreenUtil.fitToScreen((Rectangle)bounds2);
        if (bounds2.height != height) {
            bounds2.height = Math.max(1, (bounds2.height - (minHeight += addExtraSpace && space == 0 ? rowHeight / 2 : space)) / rowHeight) * rowHeight + minHeight;
        }
        return bounds2;
    }

    void appendMoreUsages(Editor editor, @NotNull RelativePoint popupPosition, @NotNull FindUsagesHandler handler2, int maxUsages, @NotNull FindUsagesOptions options) {
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(81);
        }
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(82);
        }
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(83);
        }
        TransactionGuard.submitTransaction((Disposable)handler2.getProject(), () -> this.showElementUsages(editor, popupPosition, handler2, maxUsages + ShowUsagesAction.getUsagesPageSize(), options));
    }

    private static void addUsageNodes(@NotNull GroupNode root, @NotNull UsageViewImpl usageView, @NotNull List<? super UsageNode> outNodes) {
        if (root == null) {
            ShowUsagesAction.$$$reportNull$$$0(84);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(85);
        }
        if (outNodes == null) {
            ShowUsagesAction.$$$reportNull$$$0(86);
        }
        for (UsageNode node : root.getUsageNodes()) {
            Usage usage = node.getUsage();
            if (!usageView.isVisible(usage)) continue;
            node.setParent((MutableTreeNode)root);
            outNodes.add((UsageNode)node);
        }
        for (GroupNode groupNode : root.getSubGroups()) {
            groupNode.setParent((MutableTreeNode)root);
            ShowUsagesAction.addUsageNodes(groupNode, usageView, outNodes);
        }
    }

    private void navigateAndHint(@NotNull Usage usage, @Nullable String hint, @NotNull FindUsagesHandler handler2, @NotNull RelativePoint popupPosition, int maxUsages, @NotNull FindUsagesOptions options) {
        if (usage == null) {
            ShowUsagesAction.$$$reportNull$$$0(87);
        }
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(88);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(89);
        }
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(90);
        }
        usage.navigate(true);
        if (hint == null) {
            return;
        }
        Editor newEditor = ShowUsagesAction.getEditorFor(usage);
        if (newEditor == null) {
            return;
        }
        this.hint(newEditor, hint, handler2, popupPosition, maxUsages, options, false);
    }

    private void showHint(@Nullable Editor editor, @NotNull String hint, @NotNull FindUsagesHandler handler2, @NotNull RelativePoint popupPosition, int maxUsages, @NotNull FindUsagesOptions options, boolean isWarning) {
        if (hint == null) {
            ShowUsagesAction.$$$reportNull$$$0(91);
        }
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(92);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(93);
        }
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(94);
        }
        Runnable runnable2 = () -> {
            if (!handler2.getPsiElement().isValid()) {
                return;
            }
            JComponent label2 = this.createHintComponent(hint, handler2, popupPosition, editor, ShowUsagesAction::hideHints, maxUsages, options, isWarning);
            if (editor == null || editor.isDisposed() || !editor.getComponent().isShowing()) {
                HintManager.getInstance().showHint(label2, popupPosition, 42, 0);
            } else {
                HintManager.getInstance().showInformationHint(editor, label2);
            }
        };
        if (editor == null) {
            runnable2.run();
        } else {
            AsyncEditorLoader.performWhenLoaded(editor, runnable2);
        }
    }

    private void hint(@Nullable Editor editor, @NotNull String hint, @NotNull FindUsagesHandler handler2, @NotNull RelativePoint popupPosition, int maxUsages, @NotNull FindUsagesOptions options, boolean isWarning) {
        if (hint == null) {
            ShowUsagesAction.$$$reportNull$$$0(95);
        }
        if (handler2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(96);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(97);
        }
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(98);
        }
        Project project = handler2.getProject();
        IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> {
            Runnable runnable2 = () -> IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> this.showHint(editor, hint, handler2, popupPosition, maxUsages, options, isWarning));
            if (editor == null) {
                runnable2.run();
            } else {
                editor.getScrollingModel().runActionOnScrollingFinished(runnable2);
            }
        });
    }

    @Nullable
    private static Editor getEditorFor(@NotNull Usage usage) {
        FileEditorLocation location;
        if (usage == null) {
            ShowUsagesAction.$$$reportNull$$$0(99);
        }
        FileEditor newFileEditor = (location = usage.getLocation()) == null ? null : location.getEditor();
        return newFileEditor instanceof TextEditor ? ((TextEditor)newFileEditor).getEditor() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 16: 
            case 20: 
            case 24: 
            case 35: 
            case 43: 
            case 47: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 16: 
            case 20: 
            case 24: 
            case 35: 
            case 43: 
            case 47: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 13: 
            case 18: 
            case 22: 
            case 28: 
            case 52: 
            case 69: 
            case 77: 
            case 81: 
            case 89: 
            case 93: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupPosition";
                break;
            }
            case 5: 
            case 12: 
            case 17: 
            case 21: 
            case 27: 
            case 36: 
            case 45: 
            case 49: 
            case 51: 
            case 82: 
            case 88: 
            case 92: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: 
            case 15: 
            case 23: 
            case 30: 
            case 38: 
            case 44: 
            case 48: 
            case 50: 
            case 83: 
            case 90: 
            case 94: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 8: 
            case 16: 
            case 20: 
            case 24: 
            case 35: 
            case 43: 
            case 47: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction";
                break;
            }
            case 9: 
            case 39: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 11: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelAction";
                break;
            }
            case 25: 
            case 41: 
            case 53: 
            case 57: 
            case 58: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 26: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleNodes";
                break;
            }
            case 29: 
            case 37: 
            case 54: 
            case 60: 
            case 64: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 31: 
            case 63: 
            case 67: 
            case 75: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemChoseCallback";
                break;
            }
            case 33: 
            case 61: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processIcon";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pinGroup";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 55: 
            case 87: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleUsage";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outOfScopeUsages";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableModel";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOld";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listNew";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outNodes";
                break;
            }
            case 91: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createStringNode";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createHintComponent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsButton";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "searchScopePresentableName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsagePopup";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullTitle";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSecondInvocation";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "collectData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startFindUsages";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showElementUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createStringNode";
                break;
            }
            case 8: 
            case 16: 
            case 20: 
            case 24: 
            case 35: 
            case 43: 
            case 47: 
            case 62: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showPopupIfNeedTo";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createHintComponent";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsButton";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndFindUsages";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "searchScopePresentableName";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createUsagePopup";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createPinButton";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFullTitle";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "suggestSecondInvocation";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getSecondInvocationTitle";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "searchEverywhere";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "filtered";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getUsageOffset";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "areAllUsagesInOneLine";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "collectData";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "columnMaxWidth";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "rebuildTable";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "setSizeAndDimensions";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredBounds";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "appendMoreUsages";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "addUsageNodes";
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "navigateAndHint";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "hint";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getEditorFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 16: 
            case 20: 
            case 24: 
            case 35: 
            case 43: 
            case 47: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class StringNode
    extends UsageNode {
        @NotNull
        private final Object myString;

        StringNode(@NotNull Object string) {
            if (string == null) {
                StringNode.$$$reportNull$$$0(0);
            }
            super(null, (Usage)NullUsage.INSTANCE);
            this.myString = string;
        }

        public String toString() {
            return this.myString.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/find/actions/ShowUsagesAction$StringNode", "<init>"));
        }
    }
}

