/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginReplacement;
import com.intellij.ide.plugins.PluginStateListener;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginInstaller {
    private static final Logger LOG = Logger.getInstance(PluginInstaller.class);
    public static final String UNKNOWN_HOST_MARKER = "__unknown_repository__";
    private static final Object ourLock = new Object();
    private static List<PluginStateListener> myStateListeners;

    private PluginInstaller() {
    }

    public static boolean prepareToInstall(List<PluginNode> pluginsToInstall, List<? extends IdeaPluginDescriptor> allPlugins, PluginManagerMain.PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            PluginInstaller.$$$reportNull$$$0(0);
        }
        PluginInstaller.updateUrls(pluginsToInstall, indicator);
        THashSet dependant = new THashSet();
        boolean install = PluginInstaller.prepareToInstall(pluginsToInstall, allPlugins, (Set<PluginNode>)dependant, pluginEnabler, indicator);
        for (PluginNode node : dependant) {
            if (pluginsToInstall.contains(node)) continue;
            pluginsToInstall.add(node);
        }
        return install;
    }

    private static void updateUrls(List<? extends PluginNode> pluginsToInstall, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            PluginInstaller.$$$reportNull$$$0(1);
        }
        boolean unknownNodes = false;
        for (PluginNode pluginNode : pluginsToInstall) {
            if (pluginNode.getRepositoryName() != UNKNOWN_HOST_MARKER) continue;
            unknownNodes = true;
            break;
        }
        if (!unknownNodes) {
            return;
        }
        List hosts = ContainerUtil.newSmartList();
        ContainerUtil.addIfNotNull((Collection)hosts, (Object)ApplicationInfoEx.getInstanceEx().getBuiltinPluginsUrl());
        hosts.addAll(UpdateSettings.getInstance().getPluginHosts());
        HashMap hashMap = ContainerUtil.newHashMap();
        for (String string : hosts) {
            try {
                List<IdeaPluginDescriptor> descriptors = RepositoryHelper.loadPlugins(string, indicator);
                for (IdeaPluginDescriptor descriptor : descriptors) {
                    hashMap.put(descriptor.getPluginId(), descriptor);
                }
            }
            catch (IOException descriptors) {
            }
        }
        for (PluginNode pluginNode : pluginsToInstall) {
            if (pluginNode.getRepositoryName() != UNKNOWN_HOST_MARKER) continue;
            IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)hashMap.get(pluginNode.getPluginId());
            if (descriptor != null) {
                pluginNode.setRepositoryName(((PluginNode)descriptor).getRepositoryName());
                pluginNode.setDownloadUrl(((PluginNode)descriptor).getDownloadUrl());
                continue;
            }
            pluginNode.setRepositoryName(null);
        }
    }

    private static boolean prepareToInstall(List<? extends PluginNode> pluginsToInstall, List<? extends IdeaPluginDescriptor> allPlugins, Set<PluginNode> installedDependant, PluginManagerMain.PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            PluginInstaller.$$$reportNull$$$0(2);
        }
        SmartList pluginIds = new SmartList();
        for (PluginNode pluginNode : pluginsToInstall) {
            pluginIds.add(pluginNode.getPluginId());
        }
        boolean result2 = false;
        for (PluginNode pluginNode : pluginsToInstall) {
            indicator.setText(pluginNode.getName());
            try {
                result2 |= PluginInstaller.prepareToInstall(pluginNode, (List<? extends PluginId>)pluginIds, allPlugins, installedDependant, pluginEnabler, indicator);
            }
            catch (IOException e) {
                String title = IdeBundle.message((String)"title.plugin.error", (Object[])new Object[0]);
                Notifications.Bus.notify((Notification)new Notification(title, title, pluginNode.getName() + ": " + e.getMessage(), NotificationType.ERROR));
                return false;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean prepareToInstall(PluginNode pluginNode, List<? extends PluginId> pluginIds, List<? extends IdeaPluginDescriptor> allPlugins, Set<PluginNode> installedDependant, PluginManagerMain.PluginEnabler pluginEnabler, @NotNull ProgressIndicator indicator) throws IOException {
        PluginDownloader downloader;
        if (indicator == null) {
            PluginInstaller.$$$reportNull$$$0(3);
        }
        installedDependant.add(pluginNode);
        if (pluginNode.getDepends() != null && pluginNode.getDepends().size() > 0) {
            Object[] optionalDependentPluginIds = pluginNode.getOptionalDependentPluginIds();
            ArrayList<PluginNode> depends = new ArrayList<PluginNode>();
            ArrayList<PluginNode> optionalDeps = new ArrayList<PluginNode>();
            for (int i = 0; i < pluginNode.getDepends().size(); ++i) {
                PluginId depPluginId = pluginNode.getDepends().get(i);
                if (PluginManager.isPluginInstalled(depPluginId) || PluginManagerCore.isModuleDependency(depPluginId) || InstalledPluginsState.getInstance().wasInstalled(depPluginId) || pluginIds != null && pluginIds.contains(depPluginId)) continue;
                IdeaPluginDescriptor depPluginDescriptor = PluginInstaller.findPluginInRepo(depPluginId, allPlugins);
                PluginNode depPlugin = depPluginDescriptor instanceof PluginNode ? (PluginNode)depPluginDescriptor : new PluginNode(depPluginId, depPluginId.getIdString(), "-1");
                if (depPluginDescriptor == null) continue;
                if (ArrayUtil.indexOf((Object[])optionalDependentPluginIds, (Object)depPluginId) != -1) {
                    optionalDeps.add(depPlugin);
                    continue;
                }
                depends.add(depPlugin);
            }
            if (depends.size() > 0) {
                boolean[] proceed = new boolean[1];
                try {
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        String title = IdeBundle.message((String)"plugin.manager.dependencies.detected.title", (Object[])new Object[0]);
                        String deps = StringUtil.join((Collection)depends, node -> node.getName(), (String)", ");
                        String message = IdeBundle.message((String)"plugin.manager.dependencies.detected.message", (Object[])new Object[]{depends.size(), deps});
                        proceed[0] = Messages.showYesNoDialog((String)message, (String)title, (Icon)Messages.getWarningIcon()) == 0;
                    }, ModalityState.any());
                }
                catch (Exception e) {
                    return false;
                }
                if (!proceed[0] || !PluginInstaller.prepareToInstall(depends, allPlugins, installedDependant, pluginEnabler, indicator)) {
                    return false;
                }
            }
            if (optionalDeps.size() > 0) {
                boolean[] proceed = new boolean[1];
                try {
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        String title = IdeBundle.message((String)"plugin.manager.dependencies.detected.title", (Object[])new Object[0]);
                        String deps = StringUtil.join((Collection)optionalDeps, node -> node.getName(), (String)", ");
                        String message = IdeBundle.message((String)"plugin.manager.optional.dependencies.detected.message", (Object[])new Object[]{optionalDeps.size(), deps});
                        proceed[0] = Messages.showYesNoDialog((String)message, (String)title, (Icon)Messages.getWarningIcon()) == 0;
                    }, ModalityState.any());
                }
                catch (Exception e) {
                    return false;
                }
                if (proceed[0] && !PluginInstaller.prepareToInstall(optionalDeps, allPlugins, installedDependant, pluginEnabler, indicator)) {
                    return false;
                }
            }
        }
        Ref toDisable = Ref.create(null);
        Optional replacement = StreamEx.of((Object[])PluginReplacement.EP_NAME.getExtensions()).findFirst(r -> r.getNewPluginId().equals(pluginNode.getPluginId().getIdString()));
        if (replacement.isPresent()) {
            PluginReplacement pluginReplacement = (PluginReplacement)replacement.get();
            IdeaPluginDescriptor oldPlugin = PluginManager.getPlugin(pluginReplacement.getOldPluginDescriptor().getPluginId());
            if (oldPlugin == null) {
                LOG.warn("Plugin with id '" + pluginReplacement.getOldPluginDescriptor().getPluginId() + "' not found");
            } else if (!pluginEnabler.isDisabled(oldPlugin.getPluginId())) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    String title = IdeBundle.message((String)"plugin.manager.obsolete.plugins.detected.title", (Object[])new Object[0]);
                    String message = pluginReplacement.getReplacementMessage(oldPlugin, (IdeaPluginDescriptor)pluginNode);
                    if (Messages.showYesNoDialog((String)message, (String)title, (Icon)Messages.getWarningIcon()) == 0) {
                        toDisable.set((Object)oldPlugin);
                    }
                });
            }
        }
        if ((downloader = PluginDownloader.createDownloader(pluginNode, pluginNode.getRepositoryName(), null)).prepareToInstall(indicator)) {
            Object object = ourLock;
            synchronized (object) {
                downloader.install();
            }
            pluginNode.setStatus(5);
            if (!toDisable.isNull()) {
                pluginEnabler.disablePlugins(Collections.singleton(toDisable.get()));
            }
        } else {
            return false;
        }
        return true;
    }

    @Nullable
    private static IdeaPluginDescriptor findPluginInRepo(PluginId depPluginId, List<? extends IdeaPluginDescriptor> allPlugins) {
        return ((Stream)allPlugins.stream().parallel()).filter(p -> p.getPluginId().equals(depPluginId)).findAny().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareToUninstall(PluginId pluginId) throws IOException {
        Object object = ourLock;
        synchronized (object) {
            if (PluginManager.isPluginInstalled(pluginId)) {
                IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin(pluginId);
                if (pluginDescriptor == null) {
                    PluginManagerMain.LOG.error("Plugin not found: " + pluginId);
                } else if (pluginDescriptor.isBundled()) {
                    PluginManagerMain.LOG.error("Plugin is bundled: " + pluginId);
                } else {
                    StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)new StartupActionScriptManager.DeleteCommand(pluginDescriptor.getPath()));
                    PluginInstaller.fireState(pluginDescriptor, false);
                }
            }
        }
    }

    public static void install(@NotNull File sourceFile, boolean deleteSourceFile, @Nullable File existingPlugin, @NotNull IdeaPluginDescriptor descriptor) throws IOException {
        if (sourceFile == null) {
            PluginInstaller.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            PluginInstaller.$$$reportNull$$$0(5);
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        if (existingPlugin != null) {
            commands.add(new StartupActionScriptManager.DeleteCommand(existingPlugin));
        }
        String pluginsPath = PathManager.getPluginsPath();
        if (sourceFile.getName().endsWith(".jar")) {
            commands.add(new StartupActionScriptManager.CopyCommand(sourceFile, new File(pluginsPath, sourceFile.getName())));
        } else {
            commands.add(new StartupActionScriptManager.DeleteCommand(new File(pluginsPath, PluginInstaller.rootEntryName(sourceFile))));
            commands.add(new StartupActionScriptManager.UnzipCommand(sourceFile, new File(pluginsPath)));
        }
        if (deleteSourceFile) {
            commands.add(new StartupActionScriptManager.DeleteCommand(sourceFile));
        }
        StartupActionScriptManager.addActionCommands(commands);
        PluginInstaller.fireState(descriptor, true);
    }

    private static String rootEntryName(File zip) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries2 = zipFile.entries();
            while (entries2.hasMoreElements()) {
                ZipEntry zipEntry = entries2.nextElement();
                String name = zipEntry.getName();
                int i = name.indexOf(47);
                if (i <= 0) continue;
                String string = name.substring(0, i);
                return string;
            }
        }
        throw new IOException("Corrupted archive (no file entries): " + zip);
    }

    public static void addStateListener(@NotNull PluginStateListener listener2) {
        if (listener2 == null) {
            PluginInstaller.$$$reportNull$$$0(6);
        }
        (myStateListeners != null ? myStateListeners : (myStateListeners = new ArrayList<PluginStateListener>())).add(listener2);
    }

    public static void removeStateListener(@NotNull PluginStateListener listener2) {
        if (listener2 == null) {
            PluginInstaller.$$$reportNull$$$0(7);
        }
        if (myStateListeners != null) {
            myStateListeners.remove(listener2);
        }
    }

    private static void fireState(@NotNull IdeaPluginDescriptor descriptor, boolean install) {
        if (descriptor == null) {
            PluginInstaller.$$$reportNull$$$0(8);
        }
        if (myStateListeners != null) {
            UIUtil.invokeLaterIfNeeded(() -> {
                for (PluginStateListener listener2 : myStateListeners) {
                    if (install) {
                        listener2.install(descriptor);
                        continue;
                    }
                    listener2.uninstall(descriptor);
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/PluginInstaller";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareToInstall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUrls";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addStateListener";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "removeStateListener";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fireState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

