/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyClipboardOwner;
import gnu.trove.TIntArrayList;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretModelImpl
implements CaretModel,
PrioritizedDocumentListener,
Disposable,
Dumpable,
InlayModel.Listener {
    private final EditorImpl myEditor;
    private final EventDispatcher<CaretListener> myCaretListeners = EventDispatcher.create(CaretListener.class);
    private TextAttributes myTextAttributes;
    boolean myIsInUpdate;
    final RangeMarkerTree<CaretImpl.PositionMarker> myPositionMarkerTree;
    final RangeMarkerTree<CaretImpl.SelectionMarker> mySelectionMarkerTree;
    private final LinkedList<CaretImpl> myCarets = new LinkedList();
    private CaretImpl myCurrentCaret;
    private boolean myPerformCaretMergingAfterCurrentOperation;
    int myDocumentUpdateCounter;

    public CaretModelImpl(EditorImpl editor) {
        this.myEditor = editor;
        this.myEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("columnMode".equals(evt.getPropertyName()) && !CaretModelImpl.this.myEditor.isColumnMode()) {
                    for (CaretImpl caret : CaretModelImpl.this.myCarets) {
                        caret.resetVirtualSelection();
                    }
                }
            }
        }, this);
        this.myPositionMarkerTree = new RangeMarkerTree(this.myEditor.getDocument());
        this.mySelectionMarkerTree = new RangeMarkerTree(this.myEditor.getDocument());
    }

    void initCarets() {
        this.myCarets.add(new CaretImpl(this.myEditor));
    }

    void onBulkDocumentUpdateStarted() {
    }

    void onBulkDocumentUpdateFinished() {
        this.doWithCaretMerging(() -> {});
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            CaretModelImpl.$$$reportNull$$$0(0);
        }
        this.myIsInUpdate = false;
        ++this.myDocumentUpdateCounter;
        if (!this.myEditor.getDocument().isInBulkUpdate()) {
            this.doWithCaretMerging(() -> {});
        }
    }

    public void beforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            CaretModelImpl.$$$reportNull$$$0(1);
        }
        this.myIsInUpdate = true;
        if (!this.myEditor.getDocument().isInBulkUpdate() && e.isWholeTextReplaced()) {
            for (CaretImpl caret : this.myCarets) {
                caret.updateCachedStateIfNeeded();
            }
        }
    }

    @Override
    public int getPriority() {
        return 120;
    }

    public void dispose() {
        for (CaretImpl caret : this.myCarets) {
            Disposer.dispose((Disposable)caret);
        }
        this.mySelectionMarkerTree.dispose(this.myEditor.getDocument());
        this.myPositionMarkerTree.dispose(this.myEditor.getDocument());
    }

    public void updateVisualPosition() {
        for (CaretImpl caret : this.myCarets) {
            caret.updateVisualPosition();
        }
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        this.getCurrentCaret().moveCaretRelatively(columnShift, lineShift, withSelection, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        if (pos == null) {
            CaretModelImpl.$$$reportNull$$$0(2);
        }
        this.getCurrentCaret().moveToLogicalPosition(pos);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            CaretModelImpl.$$$reportNull$$$0(3);
        }
        this.getCurrentCaret().moveToVisualPosition(pos);
    }

    public void moveToOffset(int offset) {
        this.getCurrentCaret().moveToOffset(offset);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        this.getCurrentCaret().moveToOffset(offset, locateBeforeSoftWrap);
    }

    public boolean isUpToDate() {
        return this.getCurrentCaret().isUpToDate();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        LogicalPosition logicalPosition = this.getCurrentCaret().getLogicalPosition();
        if (logicalPosition == null) {
            CaretModelImpl.$$$reportNull$$$0(4);
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        VisualPosition visualPosition = this.getCurrentCaret().getVisualPosition();
        if (visualPosition == null) {
            CaretModelImpl.$$$reportNull$$$0(5);
        }
        return visualPosition;
    }

    public int getOffset() {
        return this.getCurrentCaret().getOffset();
    }

    public int getVisualLineStart() {
        return this.getCurrentCaret().getVisualLineStart();
    }

    public int getVisualLineEnd() {
        return this.getCurrentCaret().getVisualLineEnd();
    }

    int getWordAtCaretStart() {
        return this.getCurrentCaret().getWordAtCaretStart();
    }

    int getWordAtCaretEnd() {
        return this.getCurrentCaret().getWordAtCaretEnd();
    }

    public void addCaretListener(@NotNull CaretListener listener2) {
        if (listener2 == null) {
            CaretModelImpl.$$$reportNull$$$0(6);
        }
        this.myCaretListeners.addListener((EventListener)listener2);
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        if (listener2 == null) {
            CaretModelImpl.$$$reportNull$$$0(7);
        }
        this.myCaretListeners.removeListener((EventListener)listener2);
    }

    public TextAttributes getTextAttributes() {
        if (this.myTextAttributes == null) {
            this.myTextAttributes = new TextAttributes();
            if (this.myEditor.getSettings().isCaretRowShown()) {
                this.myTextAttributes.setBackgroundColor(this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR));
            }
        }
        return this.myTextAttributes;
    }

    public void reinitSettings() {
        this.myTextAttributes = null;
    }

    public boolean supportsMultipleCarets() {
        return true;
    }

    @NotNull
    public CaretImpl getCurrentCaret() {
        CaretImpl currentCaret = this.myCurrentCaret;
        CaretImpl caretImpl = ApplicationManager.getApplication().isDispatchThread() && currentCaret != null ? currentCaret : this.getPrimaryCaret();
        if (caretImpl == null) {
            CaretModelImpl.$$$reportNull$$$0(8);
        }
        return caretImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CaretImpl getPrimaryCaret() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        // MONITORENTER : linkedList
        CaretImpl caretImpl = this.myCarets.get(this.myCarets.size() - 1);
        // MONITOREXIT : linkedList
        if (caretImpl != null) return caretImpl;
        CaretModelImpl.$$$reportNull$$$0(9);
        return caretImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaretCount() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            return this.myCarets.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Caret> getAllCarets() {
        ArrayList<Caret> carets;
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            carets = new ArrayList<Caret>(this.myCarets);
        }
        Collections.sort(carets, CaretPositionComparator.INSTANCE);
        ArrayList<Caret> arrayList = carets;
        if (arrayList == null) {
            CaretModelImpl.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        if (pos == null) {
            CaretModelImpl.$$$reportNull$$$0(11);
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            for (CaretImpl caret : this.myCarets) {
                if (!caret.getVisualPosition().equals((Object)pos)) continue;
                return caret;
            }
            return null;
        }
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos) {
        if (pos == null) {
            CaretModelImpl.$$$reportNull$$$0(12);
        }
        return this.addCaret(pos, true);
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos, boolean makePrimary) {
        if (pos == null) {
            CaretModelImpl.$$$reportNull$$$0(13);
        }
        EditorImpl.assertIsDispatchThread();
        CaretImpl caret = new CaretImpl(this.myEditor);
        caret.doMoveToVisualPosition(pos, false);
        if (this.addCaret(caret, makePrimary)) {
            return caret;
        }
        Disposer.dispose((Disposable)caret);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addCaret(@NotNull CaretImpl caretToAdd, boolean makePrimary) {
        if (caretToAdd == null) {
            CaretModelImpl.$$$reportNull$$$0(14);
        }
        for (CaretImpl caret : this.myCarets) {
            if (!CaretModelImpl.caretsOverlap(caret, caretToAdd)) continue;
            return false;
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            if (makePrimary) {
                this.myCarets.addLast(caretToAdd);
            } else {
                this.myCarets.addFirst(caretToAdd);
            }
        }
        this.fireCaretAdded(caretToAdd);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCaret(@NotNull Caret caret) {
        if (caret == null) {
            CaretModelImpl.$$$reportNull$$$0(15);
        }
        EditorImpl.assertIsDispatchThread();
        if (this.myCarets.size() <= 1 || !(caret instanceof CaretImpl)) {
            return false;
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            if (!this.myCarets.remove(caret)) {
                return false;
            }
        }
        this.fireCaretRemoved(caret);
        Disposer.dispose((Disposable)caret);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecondaryCarets() {
        EditorImpl.assertIsDispatchThread();
        ListIterator<CaretImpl> caretIterator = this.myCarets.listIterator(this.myCarets.size() - 1);
        while (caretIterator.hasPrevious()) {
            CaretImpl caret = caretIterator.previous();
            LinkedList<CaretImpl> linkedList = this.myCarets;
            synchronized (linkedList) {
                caretIterator.remove();
            }
            this.fireCaretRemoved(caret);
            Disposer.dispose((Disposable)caret);
        }
    }

    public void runForEachCaret(@NotNull CaretAction action) {
        if (action == null) {
            CaretModelImpl.$$$reportNull$$$0(16);
        }
        this.runForEachCaret(action, false);
    }

    public void runForEachCaret(@NotNull CaretAction action, boolean reverseOrder) {
        if (action == null) {
            CaretModelImpl.$$$reportNull$$$0(17);
        }
        EditorImpl.assertIsDispatchThread();
        if (this.myCurrentCaret != null) {
            throw new IllegalStateException("Recursive runForEachCaret invocations are not allowed");
        }
        this.doWithCaretMerging(() -> {
            try {
                List<Caret> sortedCarets = this.getAllCarets();
                if (reverseOrder) {
                    Collections.reverse(sortedCarets);
                }
                for (Caret caret : sortedCarets) {
                    this.myCurrentCaret = (CaretImpl)caret;
                    action.perform(caret);
                }
            }
            finally {
                this.myCurrentCaret = null;
            }
        });
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            CaretModelImpl.$$$reportNull$$$0(18);
        }
        EditorImpl.assertIsDispatchThread();
        this.doWithCaretMerging(runnable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeOverlappingCaretsAndSelections() {
        if (this.myCarets.size() <= 1) {
            return;
        }
        LinkedList<CaretImpl> carets = new LinkedList<CaretImpl>(this.myCarets);
        Collections.sort(carets, CaretPositionComparator.INSTANCE);
        ListIterator it = carets.listIterator();
        CaretImpl keepPrimary = this.getPrimaryCaret();
        while (it.hasNext()) {
            CaretImpl toRemove2;
            CaretImpl toRetain;
            CaretImpl prevCaret = null;
            if (it.hasPrevious()) {
                prevCaret = (CaretImpl)((Object)it.previous());
                it.next();
            }
            CaretImpl currCaret = (CaretImpl)((Object)it.next());
            if (prevCaret == null || !CaretModelImpl.caretsOverlap(currCaret, prevCaret)) continue;
            int newSelectionStart = Math.min(currCaret.getSelectionStart(), prevCaret.getSelectionStart());
            int newSelectionEnd = Math.max(currCaret.getSelectionEnd(), prevCaret.getSelectionEnd());
            if (currCaret.getOffset() >= prevCaret.getSelectionStart() && currCaret.getOffset() <= prevCaret.getSelectionEnd()) {
                toRetain = prevCaret;
                toRemove2 = currCaret;
                it.remove();
                it.previous();
            } else {
                toRetain = currCaret;
                toRemove2 = prevCaret;
                it.previous();
                it.previous();
                it.remove();
            }
            if (toRemove2 == keepPrimary) {
                keepPrimary = toRetain;
            }
            this.removeCaret(toRemove2);
            if (newSelectionStart >= newSelectionEnd) continue;
            toRetain.setSelection(newSelectionStart, newSelectionEnd);
        }
        if (keepPrimary != this.getPrimaryCaret()) {
            LinkedList<CaretImpl> linkedList = this.myCarets;
            synchronized (linkedList) {
                this.myCarets.remove((Object)keepPrimary);
                this.myCarets.add(keepPrimary);
            }
        }
    }

    private static boolean caretsOverlap(@NotNull CaretImpl firstCaret, @NotNull CaretImpl secondCaret) {
        if (firstCaret == null) {
            CaretModelImpl.$$$reportNull$$$0(19);
        }
        if (secondCaret == null) {
            CaretModelImpl.$$$reportNull$$$0(20);
        }
        if (firstCaret.getVisualPosition().equals((Object)secondCaret.getVisualPosition())) {
            return true;
        }
        int firstStart = firstCaret.getSelectionStart();
        int secondStart = secondCaret.getSelectionStart();
        int firstEnd = firstCaret.getSelectionEnd();
        int secondEnd = secondCaret.getSelectionEnd();
        return firstStart < secondStart && firstEnd > secondStart || firstStart > secondStart && firstStart < secondEnd || firstStart == secondStart && secondEnd != secondStart && firstEnd > firstStart || (CaretModelImpl.hasPureVirtualSelection(firstCaret) || CaretModelImpl.hasPureVirtualSelection(secondCaret)) && (firstStart == secondStart || firstEnd == secondEnd);
    }

    private static boolean hasPureVirtualSelection(CaretImpl firstCaret) {
        return firstCaret.getSelectionStart() == firstCaret.getSelectionEnd() && firstCaret.hasVirtualSelection();
    }

    void doWithCaretMerging(Runnable runnable2) {
        if (this.myPerformCaretMergingAfterCurrentOperation) {
            runnable2.run();
        } else {
            this.myPerformCaretMergingAfterCurrentOperation = true;
            try {
                runnable2.run();
                this.mergeOverlappingCaretsAndSelections();
            }
            finally {
                this.myPerformCaretMergingAfterCurrentOperation = false;
            }
        }
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates) {
        if (caretStates == null) {
            CaretModelImpl.$$$reportNull$$$0(21);
        }
        this.setCaretsAndSelections(caretStates, true);
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates, boolean updateSystemSelection) {
        if (caretStates == null) {
            CaretModelImpl.$$$reportNull$$$0(22);
        }
        EditorImpl.assertIsDispatchThread();
        if (caretStates.isEmpty()) {
            throw new IllegalArgumentException("At least one caret should exist");
        }
        this.doWithCaretMerging(() -> {
            CaretImpl caret;
            int index = 0;
            int oldCaretCount = this.myCarets.size();
            Iterator caretIterator = this.myCarets.iterator();
            TIntArrayList selectionStartsBefore = null;
            TIntArrayList selectionStartsAfter = null;
            TIntArrayList selectionEndsBefore = null;
            TIntArrayList selectionEndsAfter = null;
            for (CaretState caretState : caretStates) {
                if (index++ < oldCaretCount) {
                    caret = (CaretImpl)((Object)((Object)caretIterator.next()));
                    if (caretState != null && caretState.getCaretPosition() != null) {
                        caret.moveToLogicalPosition(caretState.getCaretPosition());
                    }
                } else {
                    caret = new CaretImpl(this.myEditor);
                    if (caretState != null && caretState.getCaretPosition() != null) {
                        caret.moveToLogicalPosition(caretState.getCaretPosition(), false, null, false, false);
                    }
                    LinkedList<CaretImpl> linkedList = this.myCarets;
                    synchronized (linkedList) {
                        this.myCarets.add(caret);
                    }
                    this.fireCaretAdded(caret);
                }
                if (caretState != null && caretState.getCaretPosition() != null && caretState.getVisualColumnAdjustment() != 0) {
                    caret.myVisualColumnAdjustment = caretState.getVisualColumnAdjustment();
                    caret.updateVisualPosition();
                }
                if (caretState == null || caretState.getSelectionStart() == null || caretState.getSelectionEnd() == null) continue;
                if (selectionStartsBefore == null) {
                    int capacity = caretStates.size();
                    selectionStartsBefore = new TIntArrayList(capacity);
                    selectionStartsAfter = new TIntArrayList(capacity);
                    selectionEndsBefore = new TIntArrayList(capacity);
                    selectionEndsAfter = new TIntArrayList(capacity);
                }
                selectionStartsBefore.add(caret.getSelectionStart());
                selectionEndsBefore.add(caret.getSelectionEnd());
                caret.doSetSelection(this.myEditor.logicalToVisualPosition(caretState.getSelectionStart()), this.myEditor.logicalPositionToOffset(caretState.getSelectionStart()), this.myEditor.logicalToVisualPosition(caretState.getSelectionEnd()), this.myEditor.logicalPositionToOffset(caretState.getSelectionEnd()), true, false, false);
                selectionStartsAfter.add(caret.getSelectionStart());
                selectionEndsAfter.add(caret.getSelectionEnd());
            }
            int caretsToRemove = this.myCarets.size() - caretStates.size();
            for (int i = 0; i < caretsToRemove; ++i) {
                LinkedList<CaretImpl> linkedList = this.myCarets;
                synchronized (linkedList) {
                    caret = this.myCarets.removeLast();
                }
                this.fireCaretRemoved(caret);
                Disposer.dispose((Disposable)caret);
            }
            if (updateSystemSelection) {
                this.updateSystemSelection();
            }
            if (selectionStartsBefore != null) {
                SelectionEvent event = new SelectionEvent((Editor)this.myEditor, selectionStartsBefore.toNativeArray(), selectionEndsBefore.toNativeArray(), selectionStartsAfter.toNativeArray(), selectionEndsAfter.toNativeArray());
                this.myEditor.getSelectionModel().fireSelectionChanged(event);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        // MONITORENTER : linkedList
        ArrayList<CaretState> states = new ArrayList<CaretState>(this.myCarets.size());
        Iterator iterator = this.myCarets.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                ArrayList<CaretState> arrayList = states;
                // MONITOREXIT : linkedList
                if (arrayList != null) return arrayList;
                CaretModelImpl.$$$reportNull$$$0(23);
                return arrayList;
            }
            CaretImpl caret = (CaretImpl)((Object)iterator.next());
            states.add(new CaretState(caret.getLogicalPosition(), caret.myVisualColumnAdjustment, caret.getSelectionStartLogicalPosition(), caret.getSelectionEndLogicalPosition()));
        }
    }

    void updateSystemSelection() {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        Clipboard clip = this.myEditor.getComponent().getToolkit().getSystemSelection();
        if (clip != null) {
            clip.setContents(new StringSelection(this.myEditor.getSelectionModel().getSelectedText(true)), (ClipboardOwner)EmptyClipboardOwner.INSTANCE);
        }
    }

    void fireCaretPositionChanged(CaretEvent caretEvent) {
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretPositionChanged(caretEvent);
    }

    void fireCaretAdded(@NotNull Caret caret) {
        if (caret == null) {
            CaretModelImpl.$$$reportNull$$$0(24);
        }
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretAdded(new CaretEvent((Editor)this.myEditor, caret, caret.getLogicalPosition(), caret.getLogicalPosition()));
    }

    void fireCaretRemoved(@NotNull Caret caret) {
        if (caret == null) {
            CaretModelImpl.$$$reportNull$$$0(25);
        }
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretRemoved(new CaretEvent((Editor)this.myEditor, caret, caret.getLogicalPosition(), caret.getLogicalPosition()));
    }

    public boolean isIteratingOverCarets() {
        return this.myCurrentCaret != null;
    }

    @NotNull
    public String dumpState() {
        String string = "[in update: " + this.myIsInUpdate + ", update counter: " + this.myDocumentUpdateCounter + ", perform caret merging: " + this.myPerformCaretMergingAfterCurrentOperation + ", current caret: " + (Object)((Object)this.myCurrentCaret) + ", all carets: " + ContainerUtil.map(this.myCarets, CaretImpl::dumpState) + "]";
        if (string == null) {
            CaretModelImpl.$$$reportNull$$$0(26);
        }
        return string;
    }

    public void onAdded(@NotNull Inlay inlay) {
        if (inlay == null) {
            CaretModelImpl.$$$reportNull$$$0(27);
        }
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        if (inlay.getVerticalAlignment() == Inlay.VerticalAlignment.INLINE) {
            int offset = inlay.getOffset();
            for (CaretImpl caret : this.myCarets) {
                caret.onInlayAdded(offset);
            }
        } else {
            this.updateVisualPosition();
        }
    }

    public void onRemoved(@NotNull Inlay inlay) {
        if (inlay == null) {
            CaretModelImpl.$$$reportNull$$$0(28);
        }
        if (this.myEditor.getDocument().isInEventsHandling() || this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        if (inlay.getVerticalAlignment() == Inlay.VerticalAlignment.INLINE) {
            this.doWithCaretMerging(() -> {
                for (CaretImpl caret : this.myCarets) {
                    caret.onInlayRemoved(inlay.getOffset(), ((InlayImpl)inlay).getOrder());
                }
            });
        } else {
            this.updateVisualPosition();
        }
    }

    public void onUpdated(@NotNull Inlay inlay) {
        if (inlay == null) {
            CaretModelImpl.$$$reportNull$$$0(29);
        }
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        this.updateVisualPosition();
    }

    public void validateState() {
        for (CaretImpl caret : this.myCarets) {
            caret.validateState();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 23: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 23: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/CaretModelImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretToAdd";
                break;
            }
            case 15: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstCaret";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondCaret";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretStates";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/CaretModelImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalPosition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCaret";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryCaret";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCarets";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretsAndSelections";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "beforeDocumentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "moveToLogicalPosition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveToVisualPosition";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 23: 
            case 26: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCaretListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeCaretListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCaretAt";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addCaret";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeCaret";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runForEachCaret";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "runBatchCaretOperation";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "caretsOverlap";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setCaretsAndSelections";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fireCaretAdded";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fireCaretRemoved";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "onAdded";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "onRemoved";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "onUpdated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 23: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CaretPositionComparator
    implements Comparator<Caret> {
        private static final CaretPositionComparator INSTANCE = new CaretPositionComparator();

        private CaretPositionComparator() {
        }

        @Override
        public int compare(Caret o1, Caret o2) {
            return VisualPositionComparator.INSTANCE.compare(o1.getVisualPosition(), o2.getVisualPosition());
        }
    }

    private static class VisualPositionComparator
    implements Comparator<VisualPosition> {
        private static final VisualPositionComparator INSTANCE = new VisualPositionComparator();

        private VisualPositionComparator() {
        }

        @Override
        public int compare(VisualPosition o1, VisualPosition o2) {
            if (o1.line != o2.line) {
                return o1.line - o2.line;
            }
            return o1.column - o2.column;
        }
    }
}

