/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.storage;

import com.intellij.ProjectTopics;
import com.intellij.application.options.PathMacrosCollector;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.configurationStore.StorageManagerListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClasspathStorage
extends StateStorageBase<Boolean> {
    private static final Key<Boolean> ERROR_NOTIFIED_KEY = Key.create((String)"ClasspathStorage.ERROR_NOTIFIED_KEY");
    private static final Logger LOG = Logger.getInstance(ClasspathStorage.class);
    private final ClasspathStorageProvider.ClasspathConverter myConverter;
    private final PathMacroSubstitutor myPathMacroSubstitutor;

    public ClasspathStorage(final @NotNull Module module, @NotNull StateStorageManager storageManager2) {
        if (module == null) {
            ClasspathStorage.$$$reportNull$$$0(0);
        }
        if (storageManager2 == null) {
            ClasspathStorage.$$$reportNull$$$0(1);
        }
        String storageType = module.getOptionValue("classpath");
        if (storageType == null) {
            throw new IllegalStateException("Classpath storage requires non-default storage type");
        }
        ClasspathStorageProvider provider = ClasspathStorage.getProvider(storageType);
        if (provider == null) {
            if (module.getUserData(ERROR_NOTIFIED_KEY) == null) {
                Notification n = new Notification("Load Error", "Cannot load module '" + module.getName() + "'", "Support for " + storageType + " format is not installed.", NotificationType.ERROR);
                n.notify(module.getProject());
                module.putUserData(ERROR_NOTIFIED_KEY, (Object)Boolean.TRUE);
                LOG.info("Classpath storage provider " + storageType + " not found");
            }
            this.myConverter = new MissingClasspathConverter();
        } else {
            this.myConverter = provider.createConverter(module);
        }
        this.myPathMacroSubstitutor = storageManager2.getMacroSubstitutor();
        final List<String> paths = this.myConverter.getFilePaths();
        MessageBusConnection busConnection = module.getMessageBus().connect();
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (paths.isEmpty()) {
                    return;
                }
                for (VFileEvent vFileEvent : events) {
                    if (!vFileEvent.isFromRefresh() || !(vFileEvent instanceof VFileContentChangeEvent)) continue;
                    String eventPath = vFileEvent.getPath();
                    for (String path : paths) {
                        if (!path.equals(eventPath)) continue;
                        ((StorageManagerListener)module.getMessageBus().syncPublisher(StateStorageManagerKt.getSTORAGE_TOPIC())).storageFileChanged(vFileEvent, ClasspathStorage.this, (ComponentManager)module);
                        return;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/roots/impl/storage/ClasspathStorage$1", "after"));
            }
        });
        busConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (modules == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (oldNameProvider == null) {
                    2.$$$reportNull$$$0(2);
                }
                for (Module renamedModule : modules) {
                    ClasspathStorageProvider provider;
                    if (!renamedModule.equals(module) || (provider = ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module))) == null) continue;
                    provider.moduleRenamed(module, (String)oldNameProvider.fun((Object)module), module.getName());
                    provider.modulePathChanged(module);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "modules";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/roots/impl/storage/ClasspathStorage$2";
                objectArray[2] = "modulesRenamed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    @Nullable
    public <S> S deserializeState(@Nullable Element serializedState, @NotNull Class<S> stateClass, @Nullable S mergeInto) {
        if (stateClass == null) {
            ClasspathStorage.$$$reportNull$$$0(2);
        }
        if (serializedState == null) {
            return null;
        }
        ModuleRootManagerImpl.ModuleRootManagerState state = new ModuleRootManagerImpl.ModuleRootManagerState();
        state.readExternal(serializedState);
        return (S)state;
    }

    @Override
    protected boolean hasState(@NotNull Boolean storageData, @NotNull String componentName) {
        if (storageData == null) {
            ClasspathStorage.$$$reportNull$$$0(3);
        }
        if (componentName == null) {
            ClasspathStorage.$$$reportNull$$$0(4);
        }
        return storageData == false;
    }

    @Override
    @Nullable
    public Element getSerializedState(@NotNull Boolean storageData, Object component, @NotNull String componentName, boolean archive) {
        if (storageData == null) {
            ClasspathStorage.$$$reportNull$$$0(5);
        }
        if (componentName == null) {
            ClasspathStorage.$$$reportNull$$$0(6);
        }
        if (storageData.booleanValue()) {
            return null;
        }
        Element element = new Element("component");
        ApplicationManager.getApplication().runReadAction(() -> {
            ModifiableRootModel model = null;
            try {
                model = ((ModuleRootManagerImpl)((Object)((Object)component))).getModifiableModel();
                model.clear();
                try {
                    this.myConverter.readClasspath(model);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ((RootModelImpl)model).writeExternal(element);
            }
            catch (WriteExternalException e) {
                LOG.error((Throwable)e);
            }
            finally {
                if (model != null) {
                    model.dispose();
                }
            }
        });
        if (this.myPathMacroSubstitutor != null) {
            this.myPathMacroSubstitutor.expandPaths(element);
            if (this.myPathMacroSubstitutor instanceof TrackingPathMacroSubstitutor) {
                ((TrackingPathMacroSubstitutor)this.myPathMacroSubstitutor).addUnknownMacros("NewModuleRootManager", PathMacrosCollector.getMacroNames(element));
            }
        }
        this.getStorageDataRef().set(true);
        return element;
    }

    @Override
    @NotNull
    protected Boolean loadData() {
        Boolean bl = false;
        if (bl == null) {
            ClasspathStorage.$$$reportNull$$$0(7);
        }
        return bl;
    }

    @Nullable
    public StateStorage.SaveSessionProducer createSaveSessionProducer() {
        return this.myConverter.startExternalization();
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Set<? super String> componentNames) {
        if (componentNames == null) {
            ClasspathStorage.$$$reportNull$$$0(8);
        }
        componentNames.add("NewModuleRootManager");
        this.getStorageDataRef().set(false);
    }

    @Nullable
    public static ClasspathStorageProvider getProvider(@NotNull String type) {
        if (type == null) {
            ClasspathStorage.$$$reportNull$$$0(9);
        }
        if (type.equals("default")) {
            return null;
        }
        for (ClasspathStorageProvider provider : (ClasspathStorageProvider[])ClasspathStorageProvider.EXTENSION_POINT_NAME.getExtensions()) {
            if (!type.equals(provider.getID())) continue;
            return provider;
        }
        return null;
    }

    @NotNull
    public static String getStorageRootFromOptions(@NotNull Module module) {
        if (module == null) {
            ClasspathStorage.$$$reportNull$$$0(10);
        }
        String moduleRoot = ModuleUtilCore.getModuleDirPath((Module)module);
        String storageRef = module.getOptionValue("classpath-dir");
        if (storageRef == null) {
            String string = moduleRoot;
            if (string == null) {
                ClasspathStorage.$$$reportNull$$$0(11);
            }
            return string;
        }
        storageRef = FileUtil.toSystemIndependentName((String)storageRef);
        if (SystemInfo.isWindows ? FileUtil.isAbsolutePlatformIndependent((String)storageRef) : FileUtil.isUnixAbsolutePath((String)storageRef)) {
            String string = storageRef;
            if (string == null) {
                ClasspathStorage.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = moduleRoot + '/' + storageRef;
        if (string == null) {
            ClasspathStorage.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static void setStorageType(@NotNull ModuleRootModel model, @NotNull String storageId) {
        Module module;
        String oldStorageType;
        if (model == null) {
            ClasspathStorage.$$$reportNull$$$0(14);
        }
        if (storageId == null) {
            ClasspathStorage.$$$reportNull$$$0(15);
        }
        if ((oldStorageType = ClassPathStorageUtil.getStorageType(module = model.getModule())).equals(storageId)) {
            return;
        }
        ClasspathStorageProvider provider = ClasspathStorage.getProvider(oldStorageType);
        if (provider != null) {
            provider.detach(module);
        }
        module.setOption("classpath", (provider = ClasspathStorage.getProvider(storageId)) == null ? null : storageId);
        module.setOption("classpath-dir", provider == null ? null : provider.getContentRoot(model));
    }

    public static void modulePathChanged(@NotNull Module module) {
        ClasspathStorageProvider provider;
        if (module == null) {
            ClasspathStorage.$$$reportNull$$$0(16);
        }
        if ((provider = ClasspathStorage.getProvider(ClassPathStorageUtil.getStorageType(module))) != null) {
            provider.modulePathChanged(module);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateClass";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageData";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/storage/ClasspathStorage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentNames";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/storage/ClasspathStorage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadData";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageRootFromOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deserializeState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasState";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSerializedState";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "analyzeExternalChangesAndUpdateIfNeed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStorageRootFromOptions";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setStorageType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "modulePathChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MissingClasspathConverter
    implements ClasspathStorageProvider.ClasspathConverter {
        private MissingClasspathConverter() {
        }

        @Override
        @NotNull
        public List<String> getFilePaths() {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                MissingClasspathConverter.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        public void readClasspath(@NotNull ModifiableRootModel model) {
            if (model == null) {
                MissingClasspathConverter.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/impl/storage/ClasspathStorage$MissingClasspathConverter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePaths";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/impl/storage/ClasspathStorage$MissingClasspathConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "readClasspath";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

