/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.ChangesViewRefresher;
import com.intellij.openapi.vcs.changes.FileHolder;
import com.intellij.openapi.vcs.changes.VcsIgnoredFilesHolder;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.provider.HgLocalIgnoredHolder;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgIgnoredFileHolder
implements VcsIgnoredFilesHolder {
    private final Project myProject;
    private final Map<HgRepository, HgLocalIgnoredHolder> myVcsIgnoredHolderMap;

    public HgIgnoredFileHolder(Project project) {
        this.myProject = project;
        this.myVcsIgnoredHolderMap = ContainerUtil.newHashMap();
        for (HgRepository repository : HgUtil.getRepositoryManager(this.myProject).getRepositories()) {
            this.myVcsIgnoredHolderMap.put(repository, repository.getLocalIgnoredHolder());
        }
    }

    public void addFile(@NotNull VirtualFile file) {
        if (file == null) {
            HgIgnoredFileHolder.$$$reportNull$$$0(0);
        }
    }

    public boolean containsFile(@NotNull VirtualFile file) {
        HgRepository repositoryForFile;
        if (file == null) {
            HgIgnoredFileHolder.$$$reportNull$$$0(1);
        }
        if ((repositoryForFile = HgUtil.getRepositoryForFile(this.myProject, file)) == null) {
            return false;
        }
        HgLocalIgnoredHolder localIgnoredHolder = this.myVcsIgnoredHolderMap.get(repositoryForFile);
        return localIgnoredHolder != null && localIgnoredHolder.contains(file);
    }

    @NotNull
    public Collection<VirtualFile> values() {
        Collection collection = this.myVcsIgnoredHolderMap.values().stream().map(HgLocalIgnoredHolder::getIgnoredFiles).flatMap(Collection::stream).collect(Collectors.toSet());
        if (collection == null) {
            HgIgnoredFileHolder.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public void cleanAndAdjustScope(@NotNull VcsModifiableDirtyScope scope) {
        if (scope == null) {
            HgIgnoredFileHolder.$$$reportNull$$$0(3);
        }
    }

    public void cleanAll() {
        this.myVcsIgnoredHolderMap.clear();
    }

    public FileHolder copy() {
        return new HgIgnoredFileHolder(this.myProject);
    }

    public FileHolder.HolderType getType() {
        return FileHolder.HolderType.IGNORED;
    }

    public void notifyVcsStarted(AbstractVcs scope) {
    }

    public boolean isInUpdatingMode() {
        return this.myVcsIgnoredHolderMap.values().stream().anyMatch(HgLocalIgnoredHolder::isInUpdateMode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/provider/HgIgnoredFileHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/provider/HgIgnoredFileHolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cleanAndAdjustScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Provider
    implements VcsIgnoredFilesHolder.Provider,
    ChangesViewRefresher {
        private final Project myProject;
        private final HgVcs myVcs;

        public Provider(Project project) {
            this.myProject = project;
            this.myVcs = HgVcs.getInstance(this.myProject);
        }

        @NotNull
        public AbstractVcs getVcs() {
            HgVcs hgVcs = this.myVcs;
            if (hgVcs == null) {
                Provider.$$$reportNull$$$0(0);
            }
            return hgVcs;
        }

        @NotNull
        public VcsIgnoredFilesHolder createHolder() {
            HgIgnoredFileHolder hgIgnoredFileHolder = new HgIgnoredFileHolder(this.myProject);
            if (hgIgnoredFileHolder == null) {
                Provider.$$$reportNull$$$0(1);
            }
            return hgIgnoredFileHolder;
        }

        public void refresh(Project project) {
            HgUtil.getRepositoryManager(project).getRepositories().forEach(r -> r.getLocalIgnoredHolder().startRescan());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/zmlx/hg4idea/provider/HgIgnoredFileHolder$Provider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVcs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHolder";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

