# C64 SID instrument editor

the C64 instrument editor consists of two tabs: "C64" to control various parameters of sound channels, and "Macros" containing several macros.

## C64

- **Waveform**: allows selecting a waveform.
  - more than one waveform can be selected at once. in that case logical AND mix of waves will occur.
  - noise is an exception. it cannot be used with any of the other waveforms.
- **Attack**: determines the rising time for the sound. the bigger the value, the slower the attack. (0 to 15).
- **Decay**: determines the diminishing time for the sound. the higher the value, the longer the decay (0 to 15).
- **Sustain**: sets the volume level at which the sound stops decaying and holds steady (0 to 15).
- **Release**: determines the rate at which the sound fades out after note off. the higher the value, the longer the release (0 to 15).

- **Duty**: specifies the width of a pulse wave (0 to 4095).

- **Ring Modulation**: when enabled, the channel's output will be multiplied with the previous channel's.
- **Oscillator Sync**: enables oscillator hard sync. as the previous channel's oscillator finishes a cycle, it resets the period of the channel's oscillator, forcing the latter to have the same base frequency. this can produce a harmonically rich sound, the timbre of which can be altered by varying the synchronized oscillator's frequency.

- **Enable filter**: when enabled, this instrument will go through the filter.
- **Initialize filter**: initializes the filter with the specified parameters:
  - **Cutoff**: the filter's point in where frequencies are cut off (0 to 2047).
  - **Resonance**: amplifies or focuses on the cutoff frequency, creating a secondary peak forms and colors the original pitch (0 to 15).
  - **Filter mode**: sets the filter mode. you may pick one or more of the following:
    - **low**: a low-pass filter. the lower the cutoff, the darker the sound.
    - **high**: a high-pass filter. higher cutoff values result in a less "bassy" sound.
    - **band**: a band-pass filter. cutoff determines which part of the sound is heard (from bass to treble).
    - **ch3off**: mutes channel 3 when enabled. not sure why is this part of the chip's design, but it is.

- **Volume Macro is Cutoff Macro**: turns the volume macro in the Macros tab into a filter cutoff macro.
  - volume control is global (affects entire chip output), hence the option.
- **Absolute Cutoff Macro**: when enabled, the cutoff macro will go from 0 to 2047, and it will be absolute (in other words, control the cutoff directly rather than being relative).
- **Absolute Duty Macro**: when enabled, the duty macro will go from 0 to 4095.
- **Don't test before new note**: this option disables the one-tick hard reset and test bit before a new note.

## Macros

- **Volume**: volume sequence.
  - warning: volume sequence is global! this means it controls the chip's volume and therefore affects all channels.
  - this macro becomes **Cutoff** when the **Volume Macro is Cutoff Macro** option is enabled in the C64 tab.
- **Arpeggio**: pitch sequence.
- **Duty**: pulse width sequence.
- **Waveform**: select the waveform used by instrument.
- **Pitch**: fine pitch.
- **Filter mode**: select the filter mode.
- **Resonance**: filter resonance sequence.
- **Special**: ring and oscillator sync selector.
- **Test/Gate**: when on, the test bit is set, which mutes the channel.
