/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceSSL;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.PluginInitializationException;
import com.zeroc.Ice.Properties;
import com.zeroc.IceSSL.ConnectionInfo;
import com.zeroc.IceSSL.RFC2253;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

class TrustManager {
    private Communicator _communicator;
    private int _traceLevel;
    private List<List<RFC2253.RDNPair>> _rejectAll = new LinkedList<List<RFC2253.RDNPair>>();
    private List<List<RFC2253.RDNPair>> _rejectClient = new LinkedList<List<RFC2253.RDNPair>>();
    private List<List<RFC2253.RDNPair>> _rejectAllServer = new LinkedList<List<RFC2253.RDNPair>>();
    private Map<String, List<List<RFC2253.RDNPair>>> _rejectServer = new HashMap<String, List<List<RFC2253.RDNPair>>>();
    private List<List<RFC2253.RDNPair>> _acceptAll = new LinkedList<List<RFC2253.RDNPair>>();
    private List<List<RFC2253.RDNPair>> _acceptClient = new LinkedList<List<RFC2253.RDNPair>>();
    private List<List<RFC2253.RDNPair>> _acceptAllServer = new LinkedList<List<RFC2253.RDNPair>>();
    private Map<String, List<List<RFC2253.RDNPair>>> _acceptServer = new HashMap<String, List<List<RFC2253.RDNPair>>>();

    TrustManager(Communicator communicator) {
        assert (communicator != null);
        this._communicator = communicator;
        Properties properties = communicator.getProperties();
        this._traceLevel = properties.getPropertyAsInt("IceSSL.Trace.Security");
        String key = null;
        try {
            key = "IceSSL.TrustOnly";
            this.parse(properties.getProperty(key), this._rejectAll, this._acceptAll);
            key = "IceSSL.TrustOnly.Client";
            this.parse(properties.getProperty(key), this._rejectClient, this._acceptClient);
            key = "IceSSL.TrustOnly.Server";
            this.parse(properties.getProperty(key), this._rejectAllServer, this._acceptAllServer);
            Map<String, String> dict = properties.getPropertiesForPrefix("IceSSL.TrustOnly.Server.");
            for (Map.Entry<String, String> p : dict.entrySet()) {
                key = p.getKey();
                String name = key.substring("IceSSL.TrustOnly.Server.".length());
                LinkedList<List<RFC2253.RDNPair>> reject = new LinkedList<List<RFC2253.RDNPair>>();
                LinkedList<List<RFC2253.RDNPair>> accept = new LinkedList<List<RFC2253.RDNPair>>();
                this.parse(p.getValue(), reject, accept);
                if (!reject.isEmpty()) {
                    this._rejectServer.put(name, reject);
                }
                if (accept.isEmpty()) continue;
                this._acceptServer.put(name, accept);
            }
        }
        catch (RFC2253.ParseException e) {
            PluginInitializationException ex = new PluginInitializationException();
            ex.reason = "IceSSL: invalid property " + key + ":\n" + e.reason;
            throw ex;
        }
    }

    boolean verify(ConnectionInfo info, String desc) {
        List<List<RFC2253.RDNPair>> p;
        LinkedList<List<List<RFC2253.RDNPair>>> reject = new LinkedList<List<List<RFC2253.RDNPair>>>();
        LinkedList<List<List<RFC2253.RDNPair>>> accept = new LinkedList<List<List<RFC2253.RDNPair>>>();
        if (!this._rejectAll.isEmpty()) {
            reject.add(this._rejectAll);
        }
        if (info.incoming) {
            if (!this._rejectAllServer.isEmpty()) {
                reject.add(this._rejectAllServer);
            }
            if (info.adapterName.length() > 0 && (p = this._rejectServer.get(info.adapterName)) != null) {
                reject.add(p);
            }
        } else if (!this._rejectClient.isEmpty()) {
            reject.add(this._rejectClient);
        }
        if (!this._acceptAll.isEmpty()) {
            accept.add(this._acceptAll);
        }
        if (info.incoming) {
            if (!this._acceptAllServer.isEmpty()) {
                accept.add(this._acceptAllServer);
            }
            if (info.adapterName.length() > 0 && (p = this._acceptServer.get(info.adapterName)) != null) {
                accept.add(p);
            }
        } else if (!this._acceptClient.isEmpty()) {
            accept.add(this._acceptClient);
        }
        if (reject.isEmpty() && accept.isEmpty()) {
            return true;
        }
        if (info.certs != null && info.certs.length > 0) {
            X500Principal subjectDN = ((X509Certificate)info.certs[0]).getSubjectX500Principal();
            String subjectName = subjectDN.getName("RFC2253");
            assert (subjectName != null);
            try {
                StringBuilder s;
                if (this._traceLevel > 0) {
                    if (info.incoming) {
                        this._communicator.getLogger().trace("Security", "trust manager evaluating client:\nsubject = " + subjectName + "\nadapter = " + info.adapterName + "\n" + desc);
                    } else {
                        this._communicator.getLogger().trace("Security", "trust manager evaluating server:\nsubject = " + subjectName + "\n" + desc);
                    }
                }
                List<RFC2253.RDNPair> dn = RFC2253.parseStrict(subjectName);
                for (List list : reject) {
                    if (this._traceLevel > 1) {
                        s = new StringBuilder("trust manager rejecting PDNs:\n");
                        TrustManager.stringify(list, s);
                        this._communicator.getLogger().trace("Security", s.toString());
                    }
                    if (!this.match(list, dn)) continue;
                    return false;
                }
                for (List list : accept) {
                    if (this._traceLevel > 1) {
                        s = new StringBuilder("trust manager accepting PDNs:\n");
                        TrustManager.stringify(list, s);
                        this._communicator.getLogger().trace("Security", s.toString());
                    }
                    if (!this.match(list, dn)) continue;
                    return true;
                }
            }
            catch (RFC2253.ParseException e) {
                this._communicator.getLogger().warning("IceSSL: unable to parse certificate DN `" + subjectName + "'\nreason: " + e.reason);
            }
            return accept.isEmpty();
        }
        return false;
    }

    private boolean match(List<List<RFC2253.RDNPair>> matchSet, List<RFC2253.RDNPair> subject) {
        for (List<RFC2253.RDNPair> r : matchSet) {
            if (!this.matchRDNs(r, subject)) continue;
            return true;
        }
        return false;
    }

    private boolean matchRDNs(List<RFC2253.RDNPair> match, List<RFC2253.RDNPair> subject) {
        for (RFC2253.RDNPair matchRDN : match) {
            boolean found = false;
            for (RFC2253.RDNPair subjectRDN : subject) {
                if (!matchRDN.key.equals(subjectRDN.key)) continue;
                found = true;
                if (matchRDN.value.equals(subjectRDN.value)) continue;
                return false;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    void parse(String value, List<List<RFC2253.RDNPair>> reject, List<List<RFC2253.RDNPair>> accept) throws RFC2253.ParseException {
        List<RFC2253.RDNEntry> l = RFC2253.parse(value);
        for (RFC2253.RDNEntry e : l) {
            StringBuilder v = new StringBuilder();
            boolean first = true;
            for (RFC2253.RDNPair pair : e.rdn) {
                if (!first) {
                    v.append(",");
                }
                first = false;
                v.append(pair.key);
                v.append("=");
                v.append(pair.value);
            }
            X500Principal princ = new X500Principal(v.toString());
            String subjectName = princ.getName("RFC2253");
            if (e.negate) {
                reject.add(RFC2253.parseStrict(subjectName));
                continue;
            }
            accept.add(RFC2253.parseStrict(subjectName));
        }
    }

    private static void stringify(List<List<RFC2253.RDNPair>> matchSet, StringBuilder s) {
        boolean addSemi = false;
        for (List<RFC2253.RDNPair> rdnSet : matchSet) {
            if (addSemi) {
                s.append(';');
            }
            addSemi = true;
            boolean addComma = false;
            for (RFC2253.RDNPair rdn : rdnSet) {
                if (addComma) {
                    s.append(',');
                }
                addComma = true;
                s.append(rdn.key);
                s.append('=');
                s.append(rdn.value);
            }
        }
    }
}

