/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.tools.DictCompile;
import morfologik.tools.FSACompile;
import morfologik.tools.SerializationFormat;
import org.jetbrains.annotations.Nullable;

class DictionaryBuilder {
    private final Properties props = new Properties();
    private static final int FREQ_RANGES_IN = 256;
    private static final int FREQ_RANGES_OUT = 26;
    private static final int FIRST_RANGE_CODE = 65;
    private static final SerializationFormat serializationFormat = SerializationFormat.CFSA2;
    private final Map<String, Integer> freqList = new HashMap<String, Integer>();
    private final Pattern pFreqEntry = Pattern.compile(".*<w f=\"(\\d+)\"(?: flags=\"(.*?)\")?>(.+)</w>.*");
    private final Pattern pTaggerEntry = Pattern.compile("^([^\t]+).*$");
    private String outputFilename;

    protected DictionaryBuilder(File infoFile) throws IOException {
        this.props.load(new FileInputStream(infoFile));
    }

    protected void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }

    protected String getOutputFilename() {
        return this.outputFilename;
    }

    protected File buildDict(File inputFile) throws Exception {
        File outputFile = new File(this.outputFilename);
        String infoPath = inputFile.toString().replaceAll("\\.txt$", ".info");
        File resultFile = new File(inputFile.toString().replaceAll("\\.txt$", ".dict"));
        File infoFile = new File(infoPath);
        this.props.store(new FileOutputStream(infoFile), "");
        Object[] buildOptions = new String[]{"--exit", "false", "-i", inputFile.toString(), "-f", serializationFormat.toString()};
        System.out.println("Running Morfologik DictCompile.main with these options: " + Arrays.toString(buildOptions));
        DictCompile.main((String[])buildOptions);
        Files.move(resultFile.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        System.out.println("Done. The binary dictionary has been written to " + outputFile.getAbsolutePath());
        return outputFile;
    }

    protected File buildFSA(File inputFile) throws Exception {
        File resultFile = new File(this.outputFilename);
        Object[] buildOptions = new String[]{"--exit", "false", "-i", inputFile.toString(), "-o", resultFile.toString(), "-f", serializationFormat.toString()};
        System.out.println("Running Morfologik FSACompile.main with these options: " + Arrays.toString(buildOptions));
        FSACompile.main((String[])buildOptions);
        System.out.println("Done. The binary dictionary has been written to " + resultFile.getAbsolutePath());
        return resultFile;
    }

    @Nullable
    protected String getOption(String option) {
        String property = this.props.getProperty(option);
        if (property == null) {
            return null;
        }
        return property.trim();
    }

    protected boolean hasOption(String option) {
        return this.props.getProperty(option) != null;
    }

    protected boolean isOptionTrue(String option) {
        return this.hasOption(option) && "true".equals(this.getOption(option));
    }

    protected void readFreqList(File freqListFile) {
        try (FileInputStream fis = new FileInputStream(freqListFile.getAbsoluteFile());
             InputStreamReader reader = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                Matcher m = this.pFreqEntry.matcher(line);
                if (!m.matches()) continue;
                this.freqList.put(m.group(3), Integer.parseInt(m.group(1)));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read file: " + freqListFile.getAbsolutePath());
        }
    }

    protected File addFreqData(File dictFile, boolean useSeparator) throws IOException {
        if (!this.isOptionTrue("fsa.dict.frequency-included")) {
            throw new IOException("In order to use frequency data add the line 'fsa.dict.frequency-included=true' to the dictionary info file.");
        }
        String separator = this.getOption("fsa.dict.separator");
        if (separator == null || separator.trim().isEmpty()) {
            throw new IOException("A separator character (fsa.dict.separator) must be defined in the dictionary info file.");
        }
        File tempFile = File.createTempFile(DictionaryBuilder.class.getSimpleName(), "WithFrequencies.txt");
        tempFile.deleteOnExit();
        String encoding = this.getOption("fsa.dict.encoding");
        int freqValuesApplied = 0;
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.getAbsoluteFile()), encoding));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dictFile.getAbsoluteFile()), encoding));){
            String line;
            int maxFreq = Collections.max(this.freqList.values());
            double maxFreqLog = Math.log(maxFreq);
            while ((line = br.readLine()) != null) {
                Matcher m = this.pTaggerEntry.matcher(line);
                if (!m.matches()) continue;
                int freq = 0;
                String key = m.group(1);
                if (this.freqList.containsKey(key)) {
                    freq = this.freqList.get(key);
                    ++freqValuesApplied;
                }
                int normalizedFreq = freq;
                if (freq > 0 && maxFreq > 255) {
                    double freqZeroToOne = Math.log(freq) / maxFreqLog;
                    normalizedFreq = (int)(freqZeroToOne * 255.0);
                }
                if (normalizedFreq < 0 || normalizedFreq > 255) {
                    throw new RuntimeException("Frequency out of range (0-255): " + normalizedFreq + " in word " + key);
                }
                String freqChar = Character.toString((char)(65 + normalizedFreq * 26 / 256));
                if (useSeparator) {
                    bw.write(line + separator + freqChar + "\n");
                    continue;
                }
                bw.write(line + freqChar + "\n");
            }
            System.out.println(this.freqList.size() + " frequency values applied to " + freqValuesApplied + " word forms.");
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read file: " + dictFile.getAbsolutePath());
        }
        return tempFile;
    }

    protected File convertTabToSeparator(File inputFile) throws RuntimeException, IOException {
        File outputFile = File.createTempFile(DictionaryBuilder.class.getSimpleName() + "_separator", ".txt");
        outputFile.deleteOnExit();
        String separator = this.getOption("fsa.dict.separator");
        if (separator == null || separator.trim().isEmpty()) {
            throw new IOException("A separator character (fsa.dict.separator) must be defined in the dictionary info file.");
        }
        String encoding = this.getOption("fsa.dict.encoding");
        try (Scanner scanner = new Scanner(inputFile, encoding);
             BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding));){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] parts = line.split("\t");
                if (parts.length == 3) {
                    out.write(parts[1] + separator + parts[0] + separator + parts[2]);
                    ((Writer)out).write(10);
                    continue;
                }
                System.err.println("Invalid input, expected three tab-separated columns in " + inputFile + ": " + line + " => ignoring");
            }
        }
        return outputFile;
    }
}

