﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/datazone/DataZone_EXPORTS.h>
#include <aws/datazone/model/FilterExpressionType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace DataZone {
namespace Model {

/**
 * <p>A filter expression in Amazon DataZone.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/datazone-2018-05-10/FilterExpression">AWS
 * API Reference</a></p>
 */
class FilterExpression {
 public:
  AWS_DATAZONE_API FilterExpression() = default;
  AWS_DATAZONE_API FilterExpression(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAZONE_API FilterExpression& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_DATAZONE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The search filter explresison type.</p>
   */
  inline FilterExpressionType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(FilterExpressionType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline FilterExpression& WithType(FilterExpressionType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The search filter expression.</p>
   */
  inline const Aws::String& GetExpression() const { return m_expression; }
  inline bool ExpressionHasBeenSet() const { return m_expressionHasBeenSet; }
  template <typename ExpressionT = Aws::String>
  void SetExpression(ExpressionT&& value) {
    m_expressionHasBeenSet = true;
    m_expression = std::forward<ExpressionT>(value);
  }
  template <typename ExpressionT = Aws::String>
  FilterExpression& WithExpression(ExpressionT&& value) {
    SetExpression(std::forward<ExpressionT>(value));
    return *this;
  }
  ///@}
 private:
  FilterExpressionType m_type{FilterExpressionType::NOT_SET};

  Aws::String m_expression;
  bool m_typeHasBeenSet = false;
  bool m_expressionHasBeenSet = false;
};

}  // namespace Model
}  // namespace DataZone
}  // namespace Aws
